/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector;

import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import utils.Products;

public class StrategySettingCardService {
    private static final List<String> DORADO_SUPPORT_16_CONTROLLERS = Arrays.asList("OCEANSTOR DORADO 5000 V6", "OCEANSTOR DORADO 6000 V6", "OCEANSTOR DORADO 5500 V6", "OCEANSTOR DORADO 5600 V6", "OCEANSTOR DORADO 5000", "OCEANSTOR DORADO 6000", "OCEANSTOR DORADO 5500", "OCEANSTOR DORADO 5600");
    private static final List<String> DORADO_HIGH_SUPPORT_16_CONTROLLERS = Arrays.asList("OCEANSTOR DORADO 6800 V6", "OCEANSTOR DORADO 6800", "OCEANSTOR DORADO 8000 V6", "OCEANSTOR DORADO 8000", "OCEANSTOR DORADO 18000 V6", "OCEANSTOR DORADO 18000", "OCEANSTOR DORADO 18500 V6", "OCEANSTOR DORADO 18500", "OCEANSTOR DORADO 18800 V6", "OCEANSTOR DORADO 18800");
    private static final List<String> OCEAN_PROTECT_SUPPORT_16_CONTROLLERS = Collections.singletonList("OCEANPROTECT E8000");

    public int getMaxPoolSize(DevInfo4Exp devInfo) {
        String productModel = devInfo.getDevType().toUpperCase(Locale.ENGLISH);
        String internalModel = devInfo.getInternalModel();
        if (ConstantField.MICRO_DEV.contains(productModel)) {
            return ConstantField.MICRO_FLASHING_INTER_MODEL.contains(internalModel) ? 4 : 1;
        }
        if (ConstantField.INTERNAL_MODE_POOL_LIMIT.containsKey(productModel) && ConstantField.INTERNAL_MODE_POOL_LIMIT.get(productModel).containsKey(internalModel)) {
            return ConstantField.INTERNAL_MODE_POOL_LIMIT.get(productModel).get(internalModel);
        }
        if (ConstantField.DORADO_32_CTRL_POOL_LIMIT.containsKey(productModel) && Products.compareVersion((String)devInfo.getProductVersion(), (String)"V700R001C00") >= 0) {
            return ConstantField.DORADO_32_CTRL_POOL_LIMIT.get(productModel);
        }
        return ConstantField.getPoolLimit4DoradoV6().getOrDefault(productModel, 2);
    }

    public int getSupportMaxEngNum(DevInfo4Exp devInfo) {
        String productVersion;
        String deviceType = devInfo.getDevType();
        if (this.isSupportPoolCross8Engines(deviceType, productVersion = devInfo.getProductVersion())) {
            return 8;
        }
        if (DORADO_HIGH_SUPPORT_16_CONTROLLERS.contains(deviceType.toUpperCase(Locale.ROOT)) && Products.compareVersion((String)productVersion, (String)"V700R001C00") >= 0) {
            return 4;
        }
        return 2;
    }

    private boolean isSupportPoolCross8Engines(String deviceType, String productVersion) {
        return this.isDoradoSupportPoolCross8Engines(deviceType, productVersion) || this.isOceanProtectSupportPoolCross8Engines(deviceType);
    }

    private boolean isOceanProtectSupportPoolCross8Engines(String deviceType) {
        return OCEAN_PROTECT_SUPPORT_16_CONTROLLERS.contains(deviceType.toUpperCase(Locale.ROOT));
    }

    private boolean isDoradoSupportPoolCross8Engines(String deviceType, String productVersion) {
        return DORADO_SUPPORT_16_CONTROLLERS.contains(deviceType.toUpperCase(Locale.ROOT)) && Products.compareVersion((String)productVersion, (String)"6.1.7RC1") >= 0;
    }

    @Generated
    public StrategySettingCardService() {
    }
}

