/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector.checkmodel;

import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.service.VerSpcGainer;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.CommonValue;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.ManualCheckItem;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.debug.CalcPasswordDebugModel;
import com.huawei.ism.tool.inspect.logic.debug.DeveloperDebugModel;
import com.huawei.ism.tool.inspect.logic.debug.IDebugModel;
import com.huawei.ism.tool.inspect.logic.inspector.CheckResultParser;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.SshManager;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelConstants;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.ICheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.UploadException;
import com.huawei.ism.tool.inspect.logic.result.IResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.NormalResultBuilder;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.ParseInspectResultException;
import com.huawei.ism.tool.inspect.utils.SshJudgeFor9000;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import org.slf4j.Logger;
import utils.FilesUtil;

public class NormalCheckModel
implements ICheckModel {
    private static final String PYTHON_ENV = "py_java_env";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(NormalCheckModel.class);
    private static final String SPH_VER_REGEX = "(?i)SPH\\w{1,3}";
    private Map<Object, Object> objMap = new HashMap<Object, Object>();
    private JythonExecuter jythonExecuter = new JythonExecuter();
    private ICliConnection cliConnection;
    private CheckDevNode checkDevNode;
    private IUiObserver uiObserver;
    private CheckResultParser resultParser;
    private String devInspectPath = "";
    private SftpTransporter sftpTransporter = null;
    private String createPathInDev = "";
    private String addDirChmod = "";
    private String clearDeviceRemainFilCmd = "";
    private Map<String, Object> env = new HashMap<String, Object>();
    private List<String> dos2UnixCmdList = new ArrayList<String>();
    private String addPermission = "";

    public NormalCheckModel(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        this.objMap.put("lang", language);
        this.checkDevNode = checkDevNode;
        this.resultParser = new CheckResultParser(checkDevNode.isErrorRedView());
        this.uiObserver = uiObserver;
        this.devInspectPath = this.getSftpPath(checkDevNode);
        this.createPathInDev = "mkdir " + this.devInspectPath + " -p";
        this.clearDeviceRemainFilCmd = "rm -rf " + this.devInspectPath;
        this.dos2UnixCmdList.add("dos2unix " + this.devInspectPath + "*.sh");
        this.dos2UnixCmdList.add("dos2unix " + this.devInspectPath + "*.py");
        this.addPermission = "chmod +x " + this.devInspectPath + "*";
        UiUpdatePair ui = new UiUpdatePair();
        ui.setFinished(false);
        ui.setCheckDevNode(checkDevNode);
        DefaultListModel model = new DefaultListModel();
        ui.setListMode(model);
        ui.setProgress(0);
        ui.setInspectStatus(InspectStatus.EXECUTING);
        InspectContext.getInstance().addUiUpdatePair(checkDevNode, ui);
        if (this.checkNoRealTimeAndTimedInspect() || this.needPyJavaEnvCheck()) {
            this.initEnv();
        }
    }

    private String getSftpPath(CheckDevNode ccheckDevNode) {
        if (ccheckDevNode != null && ccheckDevNode.getProduct() != null && ccheckDevNode.getProduct().getCheckModelInfo() != null && !"".equals(ccheckDevNode.getProduct().getCheckModelInfo().getSftpPath())) {
            return ccheckDevNode.getProduct().getCheckModelInfo().getSftpPath() + "inspect" + System.nanoTime() + "/";
        }
        return "/tmp/inspect" + System.nanoTime() + "/";
    }

    public Map<Object, Object> getParaMap() {
        return this.objMap;
    }

    private void initScript() {
        LOGGER.error("start inspect shell script transport.");
        this.verifyScripts();
        this.uploadScripts();
    }

    private void verifyScripts() throws SignException {
        String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.startverify");
        this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
        boolean verifyResult = false;
        try {
            verifyResult = SHAAndRSAVerifyUtils.getInstance().verify(this.checkDevNode.getScriptDir());
        }
        catch (Exception e) {
            LOGGER.error("verify error.", (Throwable)e);
        }
        if (!verifyResult) {
            throw new SignException();
        }
        msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.verifysuccess");
        this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
    }

    private void uploadScripts() {
        String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.startupload");
        this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
        try {
            this.createDirOnDevice();
            this.upload();
        }
        catch (UploadException et) {
            LOGGER.error("execute uploadScripts error . ", (Throwable)et);
            throw et;
        }
        catch (ToolException ex) {
            LOGGER.error("execute uploadScripts error . ", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            LOGGER.error("execute uploadScripts error . ", (Throwable)ex);
        }
        msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.uploadsuccess");
        this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
    }

    private void createDirOnDevice() throws ToolException {
        this.cliConnection.execCmd(this.clearDeviceRemainFilCmd);
        String createPathResult = this.cliConnection.execCmd(this.createPathInDev);
        if (CheckModelConstants.checkExistCreateDirError(createPathResult)) {
            String detailInfo = CheckModelConstants.getCreateDirFailedErrorInfo(createPathResult);
            throw new UploadException(detailInfo);
        }
        this.cliConnection.execCmd(this.addDirChmod);
    }

    private void upload() throws UploadException {
        File scriptDir = this.checkDevNode.getScriptDir();
        File[] scripts = scriptDir.listFiles();
        try (SftpTransporter sftpTransporte = null;){
            sftpTransporte = new SftpTransporter(this.cliConnection);
            if (scripts == null) {
                throw new IllegalArgumentException("scripts is null.");
            }
            for (File file : scripts) {
                if (file.isDirectory()) continue;
                sftpTransporte.putFile(file, this.devInspectPath, null);
            }
            for (String cmd : this.dos2UnixCmdList) {
                this.cliConnection.execCmd(cmd);
            }
            this.cliConnection.execCmd(this.addPermission);
        }
    }

    @Override
    public boolean initConnection() throws ToolException {
        try {
            Calendar startTime = Calendar.getInstance();
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.logining", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg, 1, startTime);
            this.checkDevNode.setStartTime(startTime);
            this.cliConnection = SshConnectionManager.getSshConnection((DevNode)this.checkDevNode.getDevNode(), (ISshJudge)new SshJudgeFor9000(), (boolean)true, (boolean)false);
            this.objMap.put("ssh", this.cliConnection);
            msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginsuc", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            String fileName = "preinspect.py";
            File pyScFile = new File(this.checkDevNode.getScriptDir(), fileName);
            if (this.checkUiObserver(pyScFile)) {
                return false;
            }
            if (this.checkRealTimeAndTimedInspect()) {
                Product currentProduct = this.checkDevNode.getProduct();
                IDebugModel debugModel = currentProduct.getDebugModel();
                debugModel.openDebugModel(this.cliConnection, this.checkDevNode.getDevNode(), this.checkDevNode.getProduct().getConfigDir());
            }
        }
        catch (ToolException e) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            LOGGER.error("open debug model error.", (Throwable)e);
            throw e;
        }
        catch (PwdException e) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg + " " + e.getErrorMsg(), 1, Calendar.getInstance());
            LOGGER.error("open debug model error.", (Throwable)e);
            throw e;
        }
        this.initScriptsOpr();
        return true;
    }

    boolean checkUiObserver(File pyScFile) throws ToolException {
        if (pyScFile.exists()) {
            try {
                this.sftpTransporter = new SftpTransporter(this.cliConnection);
                this.jythonExecuter.compileScript(pyScFile);
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("preinspect not found,pyScFile:{}", (Object)pyScFile.getName());
            }
            catch (ToolException e) {
                LOGGER.error("create connection error- ", (Throwable)e);
            }
            catch (RuntimeException e) {
                LOGGER.error("create connection error- ", (Throwable)e);
            }
            this.objMap.put("sftp", this.sftpTransporter);
            List ret = this.jythonExecuter.invokeFunction("execute", new Object[]{this.objMap});
            Map params = (Map)ret.get(1);
            String sphVersion = String.valueOf(params.getOrDefault("sphVer", ""));
            if (!StringUtils.isNULLStr((String)sphVersion)) {
                this.checkDevNode.getDevNode().setHotPatchVersion(sphVersion);
            }
            if (!Boolean.valueOf(String.valueOf(params.get("flag"))).booleanValue()) {
                String msgs = String.valueOf(params.get("des"));
                this.uiObserver.update(this.checkDevNode, null, msgs, 1, Calendar.getInstance());
                ToolLoggerFactory.getLogger(this.getClass());
                this.releaseConnection();
                return true;
            }
        }
        return false;
    }

    private void initScriptsOpr() {
        try {
            this.initScript();
        }
        catch (SignException e) {
            String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.verifyfailed");
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            throw e;
        }
        catch (UploadException e) {
            String msg = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.uploadfailed");
            String errorMsg = e.getErrorMsg();
            if (!StringUtils.isNULLStr((String)errorMsg)) {
                msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.uploadfailed1", (Object[])new Object[]{errorMsg});
            }
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            throw e;
        }
    }

    private boolean checkRealTimeAndTimedInspect() {
        String inspectType = InspectContext.getInstance().getSelectInspectType();
        return "".equals(inspectType) || "realTimed_check".equals(inspectType) || "timed_check".equals(inspectType);
    }

    @Override
    public void releaseConnection() {
        String fileName = "postinspect.py";
        File postPyScFile = new File(this.checkDevNode.getScriptDir(), fileName);
        if (postPyScFile.exists()) {
            try {
                this.jythonExecuter.compileScript(postPyScFile);
                List ret = this.jythonExecuter.invokeFunction("execute", new Object[]{this.objMap});
                this.updateOceanStor9000SphVersion(ret);
            }
            catch (SignException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("execute postinspect error, file not signed,", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("execute postinspect error, file not found,fileName:{}", (Object)fileName);
            }
            catch (ToolException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("execute postinspect error.", (Throwable)e);
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("execute postinspect error.", (Throwable)e);
            }
        }
        if (null != this.objMap.get("sftp")) {
            this.sftpTransporter.close();
        }
        SshConnectionManager.releaseConnection((ICliConnection)this.cliConnection);
    }

    private void updateOceanStor9000SphVersion(List<Object> ret) {
        Map params;
        String sphVersion;
        if (!ret.isEmpty() && this.checkDevNode.getProduct().getProductName().contains("OceanStor 9000") && !StringUtils.isNULLStr((String)(sphVersion = String.valueOf((params = (Map)ret.get(1)).getOrDefault("sphVer", "")))) && StringUtils.hasMatchStr((String)sphVersion, (String)SPH_VER_REGEX)) {
            this.checkDevNode.getDevNode().setHotPatchVersion(sphVersion);
        }
    }

    @Override
    public ResultItem check(CheckItem checkItem) throws ToolException {
        ResultItem resultItem = new ResultItem();
        if (null == checkItem) {
            return resultItem;
        }
        checkItem.setSingleElement(false);
        String normalCheckCmdResult = "";
        try {
            boolean judgeModelInfo;
            boolean condition;
            boolean bl = condition = TagCondition.hasTag(checkItem.getTag(), "NATIVE") && TagCondition.hasTag(checkItem.getTag(), "BUREAU_CHECK");
            if (condition) {
                return this.buildBureauCheckResult(checkItem, resultItem);
            }
            CheckModelInfo modelInfo = this.checkDevNode.getProduct().getCheckModelInfo();
            boolean bl2 = judgeModelInfo = null != modelInfo && !modelInfo.getModelType().equals("sh");
            if ((judgeModelInfo || null == modelInfo) && this.checkNoRealTimeAndTimedInspect()) {
                LOGGER.info("start compass disk inspect....");
                return this.compassDisk(checkItem);
            }
            IDebugModel debugModel = this.checkDevNode.getProduct().getDebugModel();
            String productName = this.checkDevNode.getProduct().getProductName();
            boolean isS8000 = productName.contains("S8100") || productName.contains("VIS");
            String cmdLine = this.checkCmdLine(checkItem, debugModel, productName);
            normalCheckCmdResult = isS8000 || productName.contains("S8000-I") ? this.cliConnection.execCmdNoLogTimout(cmdLine, checkItem.getTimeouts()) : this.cliConnection.execCmdWithTimout(cmdLine, checkItem.getTimeouts());
            if (normalCheckCmdResult != null && normalCheckCmdResult.trim().equals(cmdLine.trim()) || "TOOLKIT_SEND_CMD_TIME_OUT".equals(normalCheckCmdResult)) {
                this.timeOutHandle(checkItem, resultItem);
                return resultItem;
            }
            normalCheckCmdResult = normalCheckCmdResult == null ? "" : normalCheckCmdResult;
            resultItem = this.resultParser.parser(normalCheckCmdResult, checkItem);
        }
        catch (ToolException el) {
            LOGGER.error("Normal check item error.", (Throwable)el);
            throw el;
        }
        catch (ParseInspectResultException e) {
            resultItem.setNoCheck(true);
            resultItem.setCheckItem(checkItem);
            String mesg = "Query sourceInfo faild";
            checkItem.setSourceInfo(normalCheckCmdResult, this.checkDevNode);
            checkItem.setErrorInfo(mesg);
            return resultItem;
        }
        catch (RuntimeException e) {
            LOGGER.error("Normal check item error.", (Throwable)e);
        }
        return resultItem;
    }

    private ResultItem buildBureauCheckResult(CheckItem checkItem, ResultItem resultItem) {
        String sn = this.checkDevNode.getDevNode().getDeviceSerialNumber();
        String type = this.checkDevNode.getDevNode().getDeviceType().toString();
        HashMap<String, ArrayList<ManualCheckItem>> manualCheckItemsMap = BureauDocuService.INS.getManualCheckItems();
        HashMap<String, ArrayList<String>> checkRsMap = BureauDocuService.INS.getCheckRSMap();
        List items = manualCheckItemsMap.get(type);
        List checkRs = checkRsMap.get(sn);
        ArrayList<CommonValue> valus = new ArrayList<CommonValue>();
        for (int i = 0; i < items.size(); ++i) {
            CommonValue itemValue = new CommonValue();
            itemValue.setVal(ResourceUtil.getString((String)"inspect.bureau.result.title.0") + ":" + ((ManualCheckItem)items.get(i)).getName() + "||" + ResourceUtil.getString((String)"inspect.bureau.result.title.1") + ":" + (String)checkRs.get(i));
            valus.add(itemValue);
        }
        String passRate = BureauDocuService.INS.getPassRateMap().getOrDefault(sn, "0%");
        RItem item = new RItem();
        item.setCommonValues(valus);
        item.setJudge("100%".equals(passRate) ? "0" : "1");
        item.setItemId("0");
        checkItem.setErrorInfo("100%".equals(passRate) ? "" : ResourceUtil.getStringWithParams((String)"inspect.bureau.result.remind", (Object[])new Object[]{passRate}));
        resultItem.setCheckItem(checkItem);
        resultItem.addItem(item);
        return resultItem;
    }

    private void timeOutHandle(CheckItem checkItem, ResultItem resultItem) {
        resultItem.setNoCheck(true);
        resultItem.setCheckItem(checkItem);
        String mesg = ResourceUtil.getString((String)"inspect.undetected.timeout.msg");
        checkItem.setSourceInfo(mesg, this.checkDevNode);
        checkItem.setErrorInfo(mesg);
        List<Item> items = checkItem.getItems();
        for (Item item : items) {
            RItem ret = new RItem();
            ret.setItemId(item.getId());
            ret.setJudge("2");
            ret.setCli(mesg);
            resultItem.addItem(ret);
        }
    }

    private boolean checkNoRealTimeAndTimedInspect() {
        String inspectType = InspectContext.getInstance().getSelectInspectType();
        return !"".equals(inspectType) && !"realTimed_check".equals(inspectType) && !"timed_check".equals(inspectType) && !inspectType.contains("T3000") && !inspectType.contains("UltraPath");
    }

    private boolean needPyJavaEnvCheck() {
        Product product = null;
        try {
            product = InspectContext.getInstance().getProductByDevNode(this.checkDevNode.getDevNode());
        }
        catch (ToolException e) {
            LOGGER.error("get product error", (Throwable)e);
        }
        return product != null && product.isNeedPyJavaEnv();
    }

    private String checkCmdLine(CheckItem checkItem, IDebugModel debugModel, String productName) {
        User user = this.checkDevNode.getDevNode().getLoginUser();
        String username = user.getUserName();
        String password = user.getPassword();
        boolean isS8000 = productName.contains("S8100") || productName.contains("VIS");
        String cmdLine = "";
        cmdLine = isS8000 ? this.devInspectPath + "inspect.sh -c " + checkItem.getItemId() + " -u " + username + " -p " + "'" + password + "'" : (productName.contains("S8000-I") ? this.devInspectPath + "inspect.sh -c " + checkItem.getItemId() + " " + username + " " + this.dealPassword(password) : (debugModel instanceof CalcPasswordDebugModel || debugModel instanceof DeveloperDebugModel ? this.devInspectPath + "inspect.sh -c " + checkItem.getItemId() + " " + username : this.devInspectPath + "inspect.sh -c " + checkItem.getItemId()));
        return cmdLine;
    }

    private ResultItem compassDisk(CheckItem checkItem) throws ToolException {
        checkItem.setSingleElement(true);
        ResultItem resultItem = new ResultItem();
        resultItem.setCheckItem(checkItem);
        String fileName = "check_item_" + checkItem.getItemId() + ".py";
        File pyScFile = new File(this.checkDevNode.getScriptDir(), fileName);
        try {
            this.jythonExecuter.compileScript(pyScFile);
            List ret = this.jythonExecuter.invokeFunction("execute", new Object[]{this.cliConnection});
            boolean isPass = Boolean.valueOf(ret.get(0).toString());
            checkItem.setSourceInfo(ret.get(1).toString(), this.checkDevNode);
            if (ret.size() == 3 && !ret.get(2).toString().equals("")) {
                checkItem.setErrorInfo(ret.get(2).toString());
            }
            resultItem.setNormal(isPass);
        }
        catch (SignException e) {
            resultItem.setNoCheck(true);
            checkItem.setSourceInfo(e.getErrorMsg(), this.checkDevNode);
            checkItem.setErrorInfo(e.getErrorMsg());
            ToolLoggerFactory.getLogger(this.getClass()).error("execute py script :" + pyScFile + " error", (Throwable)e);
        }
        catch (ToolException el) {
            LOGGER.error("execute py script error.", (Throwable)el);
            throw el;
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("execute py script :{} error, file not found", (Object)pyScFile.getName());
        }
        catch (RuntimeException e) {
            LOGGER.error("execute py script error.", (Throwable)e);
        }
        return resultItem;
    }

    private void initEnv() {
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        this.env.put("lang", language);
        this.env.put("path", FilesUtil.getCanonicalPath((File)this.checkDevNode.getProduct().getConfigDir()));
        this.objMap.put("lang", language);
        this.env.put("sshManager", SshManager.INS);
        this.env.put("devInfo", this.checkDevNode.getDevNode());
        this.jythonExecuter.set(PYTHON_ENV, this.env);
    }

    private String dealPassword(String password) {
        return "\"" + password.replace("\"", "\\\"") + "\"";
    }

    @Override
    public void clearDeviceRemainsFile() {
        try {
            this.cliConnection.execCmd(this.clearDeviceRemainFilCmd);
        }
        catch (ToolException e) {
            LOGGER.error("clear normalcheckmodel device remain file error.", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error("clear normalcheckmodel device remain file error.", (Throwable)e);
        }
    }

    @Override
    public IResultBuilder getResultBuilder() {
        return new NormalResultBuilder();
    }

    @Override
    public boolean isVersionSavewithDevice() {
        String spcVersion;
        if (this.checkDevNode.getDevNode().getItDeviceType().equals((Object)ItDeviceType.UltraPath)) {
            return true;
        }
        VerSpcGainer verSpc = new VerSpcGainer();
        String devVersion = this.checkDevNode.getDevNode().getProductVersion();
        if (devVersion.equals(spcVersion = verSpc.query(this.cliConnection))) {
            return true;
        }
        for (String cmd : ShowSysConstans.getShowSysCmds()) {
            try {
                String cliRet = this.cliConnection.execCmd(cmd);
                String productVersion = CliResolverUtils.getDeviceInfo((String)cliRet, (String)"Product Version");
                if (StringUtils.isNULLStr((String)productVersion) || this.checkDevNode.getDevNode().getProductVersion().equals(productVersion)) continue;
                return false;
            }
            catch (ToolException e) {
                LOGGER.error("Parse showsys cmd error.", (Throwable)e);
            }
        }
        return true;
    }
}

