/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector.checkmodel;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DpaInfoQryServiceImpl;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.inspect.entity.A800ExpansionDiskInfo;
import com.huawei.ism.tool.inspect.entity.BureauFile;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DiskDomain;
import com.huawei.ism.tool.inspect.entity.Enclosure;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.ManualCheckItem;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.config.CheckItemPlatformAdapterInInspect;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.SshManager;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.ICheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.InnerISshJudge;
import com.huawei.ism.tool.inspect.logic.result.IResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.NativeResultBuilder;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.utils.DebugInfoContext;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.PackageUtils;
import com.huawei.ism.tool.obase.connection.FileConnection;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.factory.ConnectorFactory;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonContextAdapter;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.json.JSONObject;
import com.huawei.json.JSONUtils;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.DefaultListModel;
import org.python.core.Py;
import org.slf4j.Logger;
import utils.FilesUtil;

public class PyScriptCheckModel
implements ICheckModel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PyScriptCheckModel.class);
    private static final String SFTP = "sftp";
    private static final String SSH = "ssh";
    private static final String DPA_REST = "dpaRest";
    private static final String CYBER_REST = "cyberRest";
    private static final String WMIC = "wmic";
    private static final String PYTHON_ENV = "py_java_env";
    private static final String REORD_TEMP_PATH = InspectUtils.getItemDumpTempPath();
    private static final String CHECK_ITEM_REPAIR_STORAGE = "check_item_repair_storage.py";
    private CheckModelInfo modelInfo;
    private ICliConnection cliConnection;
    private RestConnection restConnection;
    private CheckDevNode checkDevNode;
    private IUiObserver uiObserver;
    private JythonExecuter jythonExecuter;
    private SftpTransporter sftpTransporter;
    private boolean isRepairScene;
    private Map<String, Object> env = new HashMap<String, Object>();
    private Map<Object, Object> objMap = new HashMap<Object, Object>();
    private String dumpPath = "";
    private static Set<String> defaultPackage = new HashSet<String>();
    private static Set<String> packageWithHis = new HashSet<String>();

    public PyScriptCheckModel(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        this.init(checkDevNode, uiObserver);
        this.initEnv();
    }

    public PyScriptCheckModel(CheckDevNode checkDevNode, IUiObserver uiObserver, boolean isRepairScene) {
        this.isRepairScene = isRepairScene;
        this.init(checkDevNode, uiObserver);
        this.initEnv();
    }

    private void init(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        this.checkDevNode = checkDevNode;
        this.uiObserver = uiObserver;
        ArrayList<File> pyClassPths = new ArrayList<File>();
        String baseScriptPath = FilesUtil.getCanonicalPath((File)checkDevNode.getScriptDir().getParentFile().getParentFile());
        String pyFramePth = baseScriptPath + File.separator + "pyframe";
        pyClassPths.add(checkDevNode.getScriptDir());
        pyClassPths.add(new File(pyFramePth));
        String expinfoPth = baseScriptPath + File.separator + "expinfo";
        pyClassPths.add(new File(expinfoPth));
        String name = checkDevNode.getScriptDir().getParentFile().getName();
        this.jythonExecuter = InspectUtils.isPreExpEvaluation() == false && defaultPackage.contains(name.toUpperCase(Locale.ROOT)) ? new JythonExecuter(pyClassPths, Py.defaultSystemState) : new JythonExecuter(pyClassPths);
        this.modelInfo = checkDevNode.getProduct().getCheckModelInfo();
    }

    private void initEnv() {
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        HashMap<String, String> devinfo = new HashMap<String, String>();
        devinfo.put("ip", this.checkDevNode.getDevNode().getIp());
        devinfo.put("userName", this.getUserName());
        String pwd = this.checkDevNode.getDevNode().getLoginUser().getPassword();
        devinfo.put("password", pwd);
        ArrayList selectDevs = (ArrayList)InspectContext.getInstance().getInspectWorktaker().get("select_dev_nodes");
        Object hyperMetroDevNodes = InspectContext.getInstance().getInspectWorktaker().get("scene_hyper_metro_nodes");
        if (hyperMetroDevNodes != null) {
            selectDevs = new ArrayList(selectDevs);
            selectDevs.addAll((List)hyperMetroDevNodes);
        }
        if (InspectUtils.isDpaInspectScene()) {
            this.env.put("dpaRelationshipHost", DpaInfoQryServiceImpl.getDPA_RELATIONSHIP_HOST());
            this.env.put("isSelectBureauCheck", InspectContext.getInstance().getIsScenesInspect().get("bureau_check"));
        }
        this.env.put("selectDevs", selectDevs);
        this.putManuallyCheckResultsIfIsSwitch();
        PackageUtils packageUtils = this.getPackageUtils(language, devinfo);
        this.objMap.put("extraMap", packageUtils);
        this.objMap.put("lang", language);
        this.objMap.put("isA800Inspect", SceneUtils.isA800SceneInTool());
        DevNode node = this.checkDevNode.getDevNode();
        this.dumpPath = REORD_TEMP_PATH + File.separator + node.getIp().replace(":", "_") + "_" + node.getDeviceSerialNumber();
        File recordFile = new File(this.dumpPath);
        if (recordFile.exists()) {
            FileUtils.deleteAllInFolder((String)this.dumpPath);
        }
        this.initEnvNext();
    }

    private String getUserName() {
        String userName = this.checkDevNode.getDevNode().getLoginUser().getUserName();
        return userName.startsWith("domain/") ? userName.replace("domain/", "") : userName;
    }

    private PackageUtils getPackageUtils(String language, Map<String, String> devinfo) {
        this.env.put("pid", InspectUtils.getCurrentPid());
        this.env.put("devInfoMap", devinfo);
        this.env.put("devInfo", this.checkDevNode.getDevNode());
        this.env.put("checkDevNode", this.checkDevNode);
        this.env.put("devPwd", DebugInfoContext.getDevInfo(this.checkDevNode.getDevNode().getIp()));
        this.env.put("hostLauncherWwnList", InspectContext.getInstance().getHostLauncherWwnList());
        this.env.put("lang", language);
        this.env.put("path", FilesUtil.getCanonicalPath((File)this.checkDevNode.getProduct().getConfigDir()));
        this.env.put("patchWarningDevs", InspectContext.getInstance().getHotPatchVersionWarningDevs());
        PackageUtils packageUtils = new PackageUtils();
        this.env.put("extraMap", packageUtils);
        this.env.put("checkItems", this.checkDevNode.getCheckItems());
        this.env.put("hyperMetroLockMap", InspectContext.getInstance().getHyperMetroLockMap());
        this.env.put("isInSvp", LocalHostUtil.isRunInSvp());
        this.env.put("allStrgHyprMtrLns", InspectContext.getInstance().getAllStrgHyprMtrLns());
        InspectContext.getInstance();
        this.env.put("fileReadLock", InspectContext.fileReadLock);
        this.env.put("passRateMap", InspectContext.getInstance().getPassRateMap());
        this.env.put("objectForPy", InspectContext.getInstance().getObjectForPy());
        this.initExpEnv();
        JythonContextAdapter jca = new JythonContextAdapter(this.checkDevNode.getDevNode());
        this.env.put("context", jca.getContextMap());
        this.env.put("sceneResPath", InspectContext.getInstance().getSceneCollectDir());
        this.env.put("connectorFactory", ConnectorFactory.getInstance());
        this.env.put("SFTP", ConnectorFactory.getInstance().createSftpConnector(this.checkDevNode.getDevNode()));
        this.env.put("isBureau", InspectContext.getInstance().isBureauCheck());
        this.env.put("bureauCheckSelected", InspectContext.getInstance().isBureauCheckSelected());
        return packageUtils;
    }

    private void initExpEnv() {
        if (SceneUtils.isA800SceneInTool()) {
            this.initA800ExpEnv();
            return;
        }
        this.env.put("expCtrlOri", InspectContext.getInstance().getExpCtrlOri());
        this.env.put("expCtrl", InspectContext.getInstance().getExpCtrlEnv());
        this.env.put("expDiskList", InspectContext.getInstance().getExpDiskListEnv());
        this.env.put("expMode", InspectContext.getInstance().getExpMode());
        this.env.put("checkVeritas", InspectContext.getInstance().isCheckVeritasEnv());
        this.env.put("requireInnerMetro", InspectContext.getInstance().isRequireInnerMetro());
        this.env.put("expInfo", InspectContext.getInstance().getDevInfo());
        JythonContextAdapter jca = new JythonContextAdapter(this.checkDevNode.getDevNode());
        this.env.put("context", jca.getContextMap());
        this.env.put("newCtrlBom", InspectContext.getInstance().getCtrlBom());
        this.env.put("newEncBom", InspectContext.getInstance().getEncBom());
        if (StringUtils.isNULLStr((String)InspectContext.getInstance().getInterfaceBom())) {
            this.env.put("newInterfaceBom", InspectContext.getInstance().getInterfaceCardBom());
        } else {
            this.env.put("newInterfaceBom", InspectContext.getInstance().getInterfaceBom());
        }
        this.env.put("newDiskEnclosureBom", InspectContext.getInstance().getDiskEnclosureBom());
        this.env.put("include12HighEnclosure", InspectContext.getInstance().getInclude12HighEnclosure());
        this.env.put("scmExpInfo", InspectContext.getInstance().getScmExpInfo());
    }

    private void initA800ExpEnv() {
        if (this.checkDevNode.getDevInfo4Exp() == null) {
            return;
        }
        this.env.put("expCtrlOri", this.checkDevNode.getDevInfo4Exp().getDevCtrlsNum());
        this.env.put("expCtrl", this.checkDevNode.getDevInfo4Exp().getExpCtrlsNum());
        this.env.put("expDiskList", A800ExpansionDiskInfo.getTargetZoneDiskList4PyScript(this.checkDevNode, InspectContext.getInstance().getExpansionA800DiskInfos()));
        this.env.put("expMode", InspectContext.getInstance().getExpMode());
        this.env.put("expInfo", this.checkDevNode.getDevInfo4Exp());
        this.env.put("newCtrlBom", InspectContext.getInstance().getCtrlBom());
        this.env.put("newInterfaceBom", InspectContext.getInstance().getInterfaceBom());
        this.env.put("newEncBom", InspectContext.getInstance().getEncBom());
        this.env.put("newDiskEnclosureBom", InspectContext.getInstance().getDiskEnclosureBom());
    }

    private void putManuallyCheckResultsIfIsSwitch() {
        HashMap<String, ArrayList<String>> checkRSMap;
        ArrayList<String> checkRSList;
        if (null != this.checkDevNode.getDevNode().getDevTypeLevel2() && this.checkDevNode.getDevNode().getDevTypeLevel2().toString().equals("OceanStor SNS") && null != (checkRSList = (checkRSMap = BureauDocuService.INS.getCheckRSMap()).get(this.checkDevNode.getDevNode().getDeviceSerialNumber()))) {
            this.env.put("switchIsLongRangeCascade", checkRSList.get(0).equals(ResourceUtil.getString((String)"inspect.wizard.manuly.check.result.yes")));
        }
    }

    private void initEnvNext() {
        if (!this.isRepairScene) {
            UiUpdatePair ui = new UiUpdatePair();
            ui.setFinished(false);
            ui.setCheckDevNode(this.checkDevNode);
            DefaultListModel model = new DefaultListModel();
            ui.setListMode(model);
            ui.setProgress(0);
            ui.setInspectStatus(InspectStatus.EXECUTING);
            InspectContext.getInstance().addUiUpdatePair(this.checkDevNode, ui);
        }
        this.env.put("progressObserver", InspectContext.getInstance().getUiUpdatePair(this.checkDevNode));
        this.env.put("uiObserver", this.uiObserver);
        BureauFile bureauFile = InspectContext.getInstance().getBureauFile(this.checkDevNode.getDevNode());
        this.env.put("bureauScore", bureauFile == null ? -1 : bureauFile.getScore());
        String sn = this.checkDevNode.getDevNode().getDeviceSerialNumber();
        String devType = String.valueOf(this.checkDevNode.getDevNode().getDeviceType());
        HashMap<String, String> passRateMap = BureauDocuService.INS.getPassRateMap();
        this.putManualChkPassRateToMap(sn, passRateMap);
        HashMap<String, ArrayList<ManualCheckItem>> manualCheckItemsMap = BureauDocuService.INS.getManualCheckItems();
        HashMap<String, ArrayList<String>> checkRsMap = BureauDocuService.INS.getCheckRSMap();
        this.env.put("manualChkItems", new ArrayList());
        this.env.put("manualChkRs", new ArrayList());
        if (checkRsMap.containsKey(sn) && manualCheckItemsMap.containsKey(devType)) {
            ArrayList<String> checkNameList = new ArrayList<String>();
            for (ManualCheckItem checkItem : manualCheckItemsMap.get(devType)) {
                checkNameList.add(checkItem.getName());
            }
            this.env.put("manualChkItems", checkNameList);
            this.env.put("manualChkRs", checkRsMap.get(sn));
        }
        this.initSceneDatatoEnv();
    }

    private void initSceneDatatoEnv() {
        if (SceneUtils.isScene() || !StringUtils.isNULLStr((String)System.getProperty("jsonScene"))) {
            try {
                String jsonScene = System.getProperty("jsonScene");
                String jsonSceneArgsList = System.getProperty("jsonSceneArgsList");
                if (StringUtils.isNULLStr((String)jsonScene)) {
                    jsonScene = System.getenv("jsonScene");
                    jsonSceneArgsList = System.getenv("jsonSceneArgsList");
                }
                JSONObject jsonSceneObj = new JSONObject(jsonScene);
                JSONObject jsonSceneArgsListObj = new JSONObject(jsonSceneArgsList);
                HashMap<String, String> sceneData = new HashMap<String, String>();
                this.jsonToMap(sceneData, jsonSceneObj);
                this.jsonToMap(sceneData, jsonSceneArgsListObj);
                this.env.put("sceneData", sceneData);
            }
            catch (Exception e) {
                LOGGER.error("prase scene data failed.");
            }
        }
    }

    private void putManualChkPassRateToMap(String sn, HashMap<String, String> passRateMap) {
        if (passRateMap.containsKey(sn)) {
            this.env.put("manualChkPassRate", passRateMap.get(sn));
        } else {
            this.env.put("manualChkPassRate", "0%");
        }
    }

    private void jsonToMap(Map<String, String> sceneData, JSONObject jsonObj) {
        Set jsonObjKyes = jsonObj.keySet();
        for (String jsonObjKye : jsonObjKyes) {
            sceneData.put(jsonObjKye, String.valueOf(jsonObj.get(jsonObjKye)));
        }
    }

    @Override
    public ResultItem check(CheckItem checkItem) throws ToolException {
        ResultItem resultItem = new ResultItem();
        if (checkItem.getConfigItem() != null) {
            return CheckItemPlatformAdapterInInspect.getInstance().runConfigItem(this.checkDevNode, checkItem);
        }
        resultItem.setCheckItem(checkItem);
        try {
            this.prepare(checkItem);
            List<Object> ret = this.invokeScript(2, true);
            this.handleResult(checkItem, resultItem, ret);
        }
        catch (SignException e) {
            resultItem.setNoCheck(true);
            checkItem.setSourceInfo(e.getErrorMsg(), this.checkDevNode);
            checkItem.setErrorInfo(e.getErrorMsg());
            LOGGER.error("prepare check item error.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("execute py script error,script file not found.");
        }
        catch (ToolException e) {
            resultItem.setNoCheck(true);
            checkItem.setSourceInfo(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execfaild"), this.checkDevNode);
            checkItem.setErrorInfo(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execfaild"));
            LOGGER.error("execute py script  error", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("execute py script. " + checkItem.getItemId(), (Throwable)e);
        }
        return resultItem;
    }

    public ResultItem executeRepairScript(CheckItem checkItem) {
        ResultItem resultItem = new ResultItem();
        try {
            File repairScriptFile = this.getRepairScript();
            String checkType = InspectContext.getInstance().getCheckType(checkItem.getItemId());
            if (StringUtils.isNULLStr((String)checkType)) {
                LOGGER.warn("get check type failed.check_type is null");
                resultItem.setNormal(false);
                resultItem.setErrMsg(ResourceUtil.getStringWithParams((String)"inspect.wizard.inspectDetailDialog.repair.failed", (Object[])new Object[0]));
                return resultItem;
            }
            this.env.put("check_type", checkType);
            this.jythonExecuter.set(PYTHON_ENV, this.env);
            this.jythonExecuter.compileScript(repairScriptFile);
            this.buildConnection(this.modelInfo.getConType());
            List<Object> ret = this.invokeScript(2, true);
            LOGGER.info("result ret:{}", (Object)JSONUtils.toJson(ret));
            String executeRet = ret.get(0).toString();
            if ("NOCHECK".equals(executeRet)) {
                resultItem.setNoCheck(true);
                resultItem.setErrMsg(String.valueOf(ret.get(2)));
                return resultItem;
            }
            boolean flag = Boolean.valueOf(ret.get(0).toString());
            resultItem.setNormal(flag);
            resultItem.setErrMsg(String.valueOf(ret.get(2)));
            return resultItem;
        }
        catch (SignException e) {
            LOGGER.error("prepare check item error.", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("execute py script error,script file not found.");
        }
        catch (ToolException e) {
            LOGGER.error("execute py script  error", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("execute py script. ", (Throwable)e);
        }
        return resultItem;
    }

    protected void prepare(CheckItem checkItem) throws SignException, FileNotFoundException {
        File pyScFile = this.getPyFileName(checkItem);
        checkItem.setDumpDir(this.dumpPath);
        if (TagCondition.hasTag(checkItem.getTag(), "ANNEX")) {
            checkItem.setAnnex(BureauDocuService.INS.getAnnex(this.checkDevNode.getDevNode()));
        }
        this.jythonExecuter.compileScript(pyScFile);
    }

    protected List<Object> invokeScript(int retryTimes, boolean firstTime) throws ToolException, InterruptedException {
        try {
            if (!firstTime) {
                LOGGER.info("catch connection exception ,retry invoke.");
                Thread.sleep(30000L);
                this.uiObserver.updateCurrentStatus(this.checkDevNode, RecordStatus.RETRY);
                InspectContext.getInstance().getUiUpdatePair(this.checkDevNode).updateProgress(0);
                this.buildConnection(this.modelInfo.getConType());
            }
            if (DPA_REST.equals(this.modelInfo.getConType()) || CYBER_REST.equals(this.modelInfo.getConType())) {
                if (!this.restConnection.isLogin()) {
                    this.restConnection.reLogin();
                }
                return this.jythonExecuter.invokeFunction("execute", new Object[]{this.restConnection});
            }
            return this.jythonExecuter.invokeFunction("execute", new Object[]{this.cliConnection});
        }
        catch (ToolException e) {
            LOGGER.error("execute script error", (Throwable)e);
            if (retryTimes > 0 && this.cliConnection != null && !this.cliConnection.isConnected() && SSH.equals(this.modelInfo.getConType())) {
                return this.invokeScript(--retryTimes, false);
            }
            throw e;
        }
    }

    protected void handleResult(CheckItem checkItem, ResultItem resultItem, List<Object> ret) {
        String cmdResult = ret.get(1).toString();
        checkItem.setSourceInfo(cmdResult, this.checkDevNode);
        String executeRet = ret.get(0).toString();
        if (4 <= ret.size()) {
            String cmdResult3 = ret.get(3).toString();
            LOGGER.error("The suggest from decive is " + cmdResult3);
            if (!StringUtils.isNULLStr((String)cmdResult3)) {
                checkItem.setSuggestionInfo(cmdResult3);
            }
        }
        if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(cmdResult)) {
            resultItem.setNoCheck(true);
            checkItem.setSourceInfo(ResourceUtil.getString((String)"inspect.undetected.timeout.msg"), this.checkDevNode);
            checkItem.setErrorInfo(ResourceUtil.getString((String)"inspect.undetected.timeout.msg"));
            return;
        }
        this.perfectResultItem(checkItem, resultItem, ret, executeRet);
    }

    private File getPyFileName(CheckItem checkItem) {
        StringBuilder scriptFileName = new StringBuilder();
        scriptFileName.append("check_item_");
        if (!StringUtils.isNULLStr((String)checkItem.getScript())) {
            scriptFileName.append(checkItem.getScript());
        } else {
            scriptFileName.append(checkItem.getItemId());
        }
        scriptFileName.append(".py");
        String fileName = scriptFileName.toString();
        LOGGER.info("execute py script :{},id:{}", (Object)checkItem.getScript(), (Object)checkItem.getItemId());
        File pyScFile = new File(this.checkDevNode.getScriptDir(), fileName);
        return pyScFile;
    }

    private File getRepairScript() {
        return new File(this.checkDevNode.getScriptDir(), CHECK_ITEM_REPAIR_STORAGE);
    }

    private void perfectResultItem(CheckItem checkItem, ResultItem resultItem, List<Object> ret, String executeRet) {
        if ("NOSUPPORT".equals(executeRet)) {
            resultItem.setNoSupport(true);
        } else if ("NOCHECK".equals(executeRet)) {
            resultItem.setNoCheck(true);
        } else if ("WARNING".equals(executeRet)) {
            resultItem.setWarning(true);
        } else {
            boolean isPass = Boolean.valueOf(ret.get(0).toString());
            resultItem.setNormal(isPass);
        }
        if (ret.size() >= 3 && !"".equals(ret.get(2).toString())) {
            checkItem.setErrorInfo(ret.get(2).toString());
        }
    }

    @Override
    public void clearDeviceRemainsFile() {
    }

    @Override
    public IResultBuilder getResultBuilder() {
        return new NativeResultBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initConnection() throws ToolException {
        String updateMsg = null;
        this.checkDevNodeExcep();
        try {
            if (InspectContext.getInstance().isInMemoryInspectionSence()) {
                boolean bl = true;
                return bl;
            }
            String fileName = "preinspect.py";
            File pythonScFile = new File(this.checkDevNode.getScriptDir(), fileName);
            if (pythonScFile.exists()) {
                updateMsg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.preInspect", (Object[])new Object[0]);
                this.uiObserver.update(this.checkDevNode, null, updateMsg, 2, Calendar.getInstance(), RecordStatus.RUNNING);
                this.jythonExecuter.compileScript(pythonScFile);
                List retList = this.jythonExecuter.invokeFunction("execute", new Object[]{this.objMap});
                ArrayList statisticEncloureList = (ArrayList)this.objMap.get("statisticEncloureList");
                ArrayList statisticDDList = (ArrayList)this.objMap.get("statisticDDList");
                ArrayList smartPoolShowDiskList = (ArrayList)this.objMap.get("smartPoolDisks");
                this.syncExpansionOriginalInfo2Context(statisticEncloureList, statisticDDList, smartPoolShowDiskList);
                Map params = (Map)retList.get(1);
                if (!Boolean.valueOf(String.valueOf(params.get("flag"))).booleanValue()) {
                    String messages = String.valueOf(params.get("des"));
                    this.uiObserver.update(this.checkDevNode, null, messages, 2, Calendar.getInstance());
                    this.releaseConnection();
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (ToolException et) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.execfaild.message", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg, 2, Calendar.getInstance());
            LOGGER.error("preinspect execute error", (Throwable)et);
            throw et;
        }
        catch (SignException ex) {
            this.uiObserver.update(this.checkDevNode, null, ex.getErrorMsg(), 2, Calendar.getInstance());
            LOGGER.error("verify file error.", (Throwable)ex);
            throw ex;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("preinspect not found");
        }
        finally {
            this.uiObserver.updateCurrentStatus(this.checkDevNode, RecordStatus.NORMAL);
        }
        return true;
    }

    private void syncExpansionOriginalInfo2Context(ArrayList<Enclosure> statisticEncloureList, ArrayList<DiskDomain> statisticDDList, ArrayList<DiskDomain> smartPoolShowDiskList) {
        if (SceneUtils.isA800SceneInTool()) {
            String zoneId = this.checkDevNode.getDevNodeSafe().getUuid();
            if (statisticEncloureList != null) {
                statisticEncloureList.forEach(enclosure -> enclosure.setZoneId(zoneId));
                this.checkDevNode.setStatisticEncloureList(statisticEncloureList);
            }
            if (smartPoolShowDiskList != null) {
                smartPoolShowDiskList.forEach(diskDomain -> diskDomain.setZoneId(zoneId));
                this.checkDevNode.setSmartPoolShowDiskList(smartPoolShowDiskList);
            }
            return;
        }
        if (statisticDDList != null || statisticEncloureList != null) {
            InspectContext.getInstance().setStatisticEncloureList(statisticEncloureList);
            InspectContext.getInstance().setStatisticDDList(statisticDDList);
        }
        if (smartPoolShowDiskList != null) {
            InspectContext.getInstance().setSmartPoolDisks(smartPoolShowDiskList);
        }
    }

    void checkDevNodeExcep() throws ToolException {
        try {
            String conType = this.modelInfo.getConType();
            Calendar startTime = Calendar.getInstance();
            String updateMsg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.logining", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, updateMsg, 1, startTime);
            this.checkDevNode.setStartTime(startTime);
            this.buildConnection(conType);
            if (DPA_REST.equals(conType) || CYBER_REST.equals(conType)) {
                this.restConnection = RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
                this.restConnection.reLogin();
                if (!this.restConnection.isLogin()) {
                    LOGGER.error("rest login error.");
                    throw new ToolException("rest login error");
                }
            }
            this.jythonExecuter.set(PYTHON_ENV, this.env);
            updateMsg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginsuc", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, updateMsg, 1, Calendar.getInstance());
        }
        catch (ToolException et) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            LOGGER.error("open debug model error.", (Throwable)et);
            throw new ToolException("login failed :", (Throwable)et);
        }
        catch (PwdException ex) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg + " " + ex.getErrorMsg(), 1, Calendar.getInstance());
            LOGGER.error("open debug model error.", (Throwable)ex);
            throw ex;
        }
    }

    private void buildConnection(String conType) throws ToolException {
        boolean isPaConnected = true;
        if (this.checkDevNode.getDevNode().isFileNode()) {
            this.cliConnection = new FileConnection(EntityUtils.toNewDev((DevNode)this.checkDevNode.getDevNode()));
        } else if (SSH.equals(conType)) {
            this.initSSHAndSFTP();
        } else if (WMIC.equals(conType)) {
            WmicConnection wmicConnection = (WmicConnection)WmicConnectionManager.getWmicConnection((DevNode)this.checkDevNode.getDevNode());
            Future paConnFuture = wmicConnection.getPaexecConnection().getConnectResult();
            this.cliConnection = wmicConnection;
            try {
                isPaConnected = paConnFuture == null ? false : (Boolean)paConnFuture.get();
            }
            catch (Exception e) {
                LOGGER.error("get paexec connection result failed!");
                isPaConnected = false;
            }
        } else if (DPA_REST.equals(conType)) {
            this.restConnection = RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
            this.objMap.put("dpaRestConnection", this.restConnection);
            this.env.put("dpaRestConnection", this.restConnection);
        } else if (CYBER_REST.equals(conType)) {
            this.restConnection = RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
            this.objMap.put("cyberEngineConnection", this.restConnection);
            this.env.put("cyberEngineConnection", this.restConnection);
        }
        this.objMap.put(SSH, this.cliConnection);
        this.env.put("sshManager", SshManager.INS);
        this.env.put(SSH, this.cliConnection);
        this.env.put("SSH", this.cliConnection);
        if (null != this.sftpTransporter) {
            this.env.put(SFTP, this.sftpTransporter);
            this.objMap.put(SFTP, this.sftpTransporter);
        }
        if (!isPaConnected) {
            LOGGER.info("init paexec connection failed!");
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg + ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execfaild.message.windows.pafailed"), 1, Calendar.getInstance());
            throw new ToolException("");
        }
    }

    private void initSSHAndSFTP() throws ToolException {
        InnerISshJudge ender = new InnerISshJudge();
        this.cliConnection = SshConnectionManager.getSshConnection((DevNode)this.checkDevNode.getDevNode(), (ISshJudge)ender, (boolean)true, (boolean)false);
        if (SFTP.equals(this.modelInfo.getTransType())) {
            this.sftpTransporter = new SftpTransporter(this.cliConnection);
            if (this.cliConnection instanceof SshConnection && !this.cliConnection.isConnected()) {
                SshConnection reCliConnection = (SshConnection)this.cliConnection;
                reCliConnection.reConnect();
            }
        }
    }

    public Map<String, Object> getEnv() {
        return this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection() {
        try {
            String pacakgeName;
            if (this.checkDevNode.getDevNode().isDsStorage()) {
                return;
            }
            this.refreshPassRateMap();
            String fileName = "postinspect.py";
            File pyScFile = new File(this.checkDevNode.getScriptDir(), fileName);
            if (pyScFile.exists()) {
                this.jythonExecuter.compileScript(pyScFile);
                List retList = this.jythonExecuter.invokeFunction("execute", new Object[]{this.objMap});
                this.dealReleaseResult(retList);
                if (this.objMap.containsKey("enclo_max_depth")) {
                    String encloMaxDepth = (String)this.objMap.get("enclo_max_depth");
                    LOGGER.info("Current maximum cascading depth: {}", (Object)encloMaxDepth);
                    InspectContext.getInstance().setEncloMaxDepth(encloMaxDepth);
                }
            }
            if (this.isNeedPerformInspect(pacakgeName = this.checkDevNode.getScriptDir().getParentFile().getName())) {
                this.uiObserver.update(this.checkDevNode, null, ResourceUtil.getString((String)"inspsctor.wizard.performinspect.notice.his"), 1, Calendar.getInstance(), RecordStatus.INFO);
            }
        }
        catch (Exception e) {
            LOGGER.error("release connection failed.", (Throwable)e);
        }
        finally {
            if (null != this.sftpTransporter) {
                this.sftpTransporter.close();
            }
            if (this.cliConnection instanceof WmicConnection) {
                WmicConnectionManager.releaseConn((DevNode)this.checkDevNode.getDevNode());
            } else {
                SshConnectionManager.releaseConnection((ICliConnection)this.cliConnection);
            }
        }
    }

    private boolean isNeedPerformInspect(String pacakgeName) {
        return InspectUtils.isPreExpEvaluation() == false && !InspectUtils.isDpaInspectScene() && !InspectUtils.isCyberEngineDev(this.checkDevNode) && !InspectContext.getInstance().isOemOutTool() && packageWithHis.contains(pacakgeName) && this.checkDevNode.isExecuteSuc() && InspectUtils.checkFaultItemNum(this.checkDevNode) != 0 && !InspectUtils.isEClient();
    }

    private void refreshPassRateMap() {
        HashMap<String, Float> refreshMap = new HashMap<String, Float>();
        if (!InspectContext.getInstance().isBureauCheckSelected()) {
            refreshMap.put("PassRate", Float.valueOf(this.checkDevNode.getPassRate()));
        } else {
            refreshMap.put("PassRate", Float.valueOf(this.checkDevNode.getOpenDeliveryPassRate()));
        }
        InspectContext.getInstance().setPassRateMap(refreshMap);
    }

    @Override
    public boolean isVersionSavewithDevice() {
        return true;
    }

    public Map<Object, Object> getParaMap() {
        return this.objMap;
    }

    private void dealReleaseResult(List<Object> retList) {
        Map params;
        if (null != retList && retList.size() >= 2 && !Boolean.valueOf(String.valueOf((params = (Map)retList.get(1)).get("flag"))).booleanValue() && "ERROR".equals(String.valueOf(retList.get(0)))) {
            String des = String.valueOf(params.get("des"));
            this.uiObserver.update(this.checkDevNode, null, des, 1, Calendar.getInstance(), RecordStatus.FAILED);
        }
    }

    static {
        defaultPackage.add("V3V300R001C10");
        defaultPackage.add("V3V300R002C10");
        defaultPackage.add("V3V300R003C00");
        defaultPackage.add("V3V300R005C00");
        defaultPackage.add("V3V300R006C00");
        defaultPackage.add("18000V3V300R003C00");
        defaultPackage.add("18000V3V300R006C00");
        packageWithHis.add("V3V300R001C10");
        packageWithHis.add("V3V300R002C00");
        packageWithHis.add("V3V300R002C10");
        packageWithHis.add("V3V300R003C00");
        packageWithHis.add("V3V300R005C00");
        packageWithHis.add("V3V300R006C00");
        packageWithHis.add("18000V3V300R006C00");
        packageWithHis.add("18000V3V300R003C00");
        packageWithHis.add("S5000TV200R002C20");
        packageWithHis.add("S5000TV200R002C10");
        packageWithHis.add("S5000TV200R002");
        packageWithHis.add("S5000TV200R001");
    }
}

