/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector.checkmodel;

import com.huawei.ism.tool.inspect.bmcconn.redfish.BmcRedfishConnManagement;
import com.huawei.ism.tool.inspect.bmcconn.ssh.BmcShellConnectionManagement;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.ICheckModel;
import com.huawei.ism.tool.inspect.logic.result.IResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.NativeResultBuilder;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import org.slf4j.Logger;

public class RestCheckModel
implements ICheckModel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RestCheckModel.class);
    private CheckDevNode checkDevNode;
    private IUiObserver uiObserver;
    private String tmpDir;

    public RestCheckModel(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        this.checkDevNode = checkDevNode;
        this.uiObserver = uiObserver;
        this.initEnv();
    }

    private void initEnv() {
        UiUpdatePair ui = new UiUpdatePair();
        ui.setFinished(false);
        ui.setCheckDevNode(this.checkDevNode);
        DefaultListModel model = new DefaultListModel();
        ui.setListMode(model);
        ui.setProgress(0);
        ui.setInspectStatus(InspectStatus.EXECUTING);
        InspectContext.getInstance().addUiUpdatePair(this.checkDevNode, ui);
    }

    @Override
    public ResultItem check(CheckItem checkItem) {
        return null;
    }

    @Override
    public void clearDeviceRemainsFile() {
    }

    @Override
    public boolean initConnection() throws ToolException {
        String updateMsg = null;
        try {
            Calendar startTime = Calendar.getInstance();
            updateMsg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.logining", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, updateMsg, 1, startTime);
            this.checkDevNode.setStartTime(startTime);
            RestConnectionManager.getRestConnection((DevNode)this.checkDevNode.getDevNode());
            updateMsg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginsuc", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, updateMsg, 1, Calendar.getInstance());
            return true;
        }
        catch (ToolException e) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, msg, 1, Calendar.getInstance());
            throw e;
        }
    }

    @Override
    public void releaseConnection() {
        RestConnectionManager.releaseConn((DevNode)this.checkDevNode.getDevNode());
        BmcRedfishConnManagement.releaseConnection(this.checkDevNode.getDevNode());
        BmcShellConnectionManagement.releaseConnection((DevNode)this.checkDevNode.getDevNode());
    }

    @Override
    public IResultBuilder getResultBuilder() {
        return new NativeResultBuilder();
    }

    @Override
    public boolean isVersionSavewithDevice() {
        return true;
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }
}

