/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.inspector.checkmodel;

import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.logic.inspector.CheckResultParser;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.ICheckModel;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.NormalCheckModel;
import com.huawei.ism.tool.inspect.logic.result.IResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.NormalResultBuilder;
import com.huawei.ism.tool.inspect.utils.DefaultSshJudge;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.Calendar;
import javax.swing.DefaultListModel;
import org.slf4j.Logger;

public class WindowsCheckModel
implements ICheckModel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(NormalCheckModel.class);
    private ICliConnection cliConnection;
    private CheckDevNode checkDevNode;
    private IUiObserver uiObserver;
    private CheckResultParser resultParser;
    private String devInspectPath = "";
    private String createPathInDev = "";
    private String sftpPathCmd = "";
    private String inspectPath = "";
    private String clearDeviceRemain = "";

    public WindowsCheckModel(CheckDevNode checkDevNode, IUiObserver uiObserver) {
        this.checkDevNode = checkDevNode;
        this.resultParser = new CheckResultParser(checkDevNode.isErrorRedView());
        this.uiObserver = uiObserver;
        this.sftpPathCmd = "cd ../ism_host_agent";
        this.devInspectPath = "inspect\\" + System.nanoTime() + "\\";
        this.createPathInDev = "md " + this.devInspectPath;
        this.inspectPath = this.devInspectPath;
        this.clearDeviceRemain = "rmdir /s/q " + checkDevNode.getDevNode().getLoginUser().getUserName();
        UiUpdatePair ui = new UiUpdatePair();
        ui.setFinished(false);
        ui.setCheckDevNode(checkDevNode);
        DefaultListModel model = new DefaultListModel();
        ui.setListMode(model);
        ui.setProgress(0);
        ui.setInspectStatus(InspectStatus.EXECUTING);
        InspectContext.getInstance().addUiUpdatePair(checkDevNode, ui);
    }

    @Override
    public ResultItem check(CheckItem checkItem) throws ToolException {
        ResultItem resultItem = new ResultItem();
        if (checkItem == null) {
            return resultItem;
        }
        checkItem.setSingleElement(false);
        try {
            String cmdLine = this.inspectPath + "inspect -c " + checkItem.getItemId();
            String cmdResult = this.cliConnection.execCmdWithTimout(cmdLine, checkItem.getTimeouts());
            if (cmdResult.trim().equals(cmdLine.trim()) || cmdResult.equals("TOOLKIT_SEND_CMD_TIME_OUT")) {
                resultItem.setNoCheck(true);
                checkItem.setSourceInfo(ResourceUtil.getString((String)"inspect.undetected.timeout.msg"), this.checkDevNode);
                checkItem.setErrorInfo(ResourceUtil.getString((String)"inspect.undetected.timeout.msg"));
                return resultItem;
            }
            resultItem = this.resultParser.parser(cmdResult, checkItem);
        }
        catch (ToolException el) {
            LOGGER.error("check item error.", (Throwable)el);
            throw el;
        }
        catch (RuntimeException el) {
            LOGGER.error("check item error.", (Throwable)el);
            throw el;
        }
        return resultItem;
    }

    @Override
    public void clearDeviceRemainsFile() {
        try {
            this.cliConnection.execCmd(this.clearDeviceRemain);
        }
        catch (ToolException e) {
            LOGGER.error("clear device remain file error.", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error("clear device remain file error.", (Throwable)e);
        }
    }

    @Override
    public IResultBuilder getResultBuilder() {
        return new NormalResultBuilder();
    }

    @Override
    public boolean initConnection() throws ToolException {
        try {
            Calendar startTime = Calendar.getInstance();
            String message = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.logining", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, message, 1, startTime);
            this.checkDevNode.setStartTime(startTime);
            this.cliConnection = SshConnectionManager.getSshConnection((DevNode)this.checkDevNode.getDevNode(), (ISshJudge)new DefaultSshJudge(), (boolean)true, (boolean)false);
            message = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginsuc", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, message, 1, Calendar.getInstance());
            this.initScript();
        }
        catch (ToolException et) {
            String message = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, message, 1, Calendar.getInstance());
            LOGGER.error("open debug model error.", (Throwable)et);
            throw et;
        }
        catch (PwdException ex) {
            String message = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.performinspect.loginfaild", (Object[])new Object[]{this.checkDevNode.getDevNode().getIp()});
            this.uiObserver.update(this.checkDevNode, null, message + " " + ex.getErrorMsg(), 1, Calendar.getInstance());
            LOGGER.error("open debug model error.", (Throwable)ex);
            throw ex;
        }
        return true;
    }

    @Override
    public boolean isVersionSavewithDevice() {
        for (String cmd : ShowSysConstans.getShowSysCmds()) {
            try {
                String cliRet = this.cliConnection.execCmd(cmd);
                String productVer = CliResolverUtils.getDeviceInfo((String)cliRet, (String)"Product Version");
                if (StringUtils.isNULLStr((String)productVer) || this.checkDevNode.getDevNode().getProductVersion().equals(productVer)) continue;
                return false;
            }
            catch (ToolException et) {
                LOGGER.error("Parse showsys cmd error.", (Throwable)et);
            }
        }
        return true;
    }

    @Override
    public void releaseConnection() {
        SshConnectionManager.releaseConnection((ICliConnection)this.cliConnection);
    }

    private void initScript() {
        LOGGER.error("start inspect shell script transport.");
        try {
            this.cliConnection.execCmd(this.sftpPathCmd);
            this.cliConnection.execCmd(this.clearDeviceRemain);
            this.cliConnection.execCmd(this.createPathInDev);
            this.uploadScripts();
        }
        catch (ToolException e) {
            LOGGER.error("execute prepar command error . ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadScripts() {
        File scriptDir = this.checkDevNode.getScriptDir();
        File[] scriptFiles = scriptDir.listFiles();
        SftpTransporter sftpTransporter = null;
        User user = this.checkDevNode.getDevNode().getLoginUser();
        String username = user.getUserName();
        String password = user.getPassword();
        try {
            User fileTransUser = new User(username, password);
            try {
                sftpTransporter = new SftpTransporter(this.cliConnection, fileTransUser);
            }
            catch (ToolException e) {
                LOGGER.error("retry create sftp error", (Throwable)e);
            }
            catch (RuntimeException e) {
                LOGGER.error("retry create sftp error", (Throwable)e);
            }
            if (sftpTransporter == null || scriptFiles == null) {
                throw new NullPointerException();
            }
            for (File f : scriptFiles) {
                if (f.isDirectory()) continue;
                sftpTransporter.putFile(f, this.devInspectPath, null);
            }
        }
        catch (ToolException e) {
            LOGGER.error("Execute uploadScripts error . ", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error("Execute uploadScripts error . ", (Throwable)e);
        }
        finally {
            password = null;
            if (sftpTransporter != null) {
                sftpTransporter.close();
            }
        }
    }
}

