/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class CheckRuleBuiler {
    private static final String XLS_HEADER = " <?xml-stylesheet type=\"text/xsl\" href=\"check.xsl\"?>";
    private static final String CHECK_LIST = "checklist";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String METHOD = "method";
    private static final String SUGGESTION = "suggestion";
    private static final String CRITERION = "criterion";
    private static final String ITEM = "item";
    private static final String RES = "res";
    private static final String CHECKRULE = "checkrule";
    private ResourceBundle bundle;
    private CheckDevNode checkNode;

    public CheckRuleBuiler(CheckDevNode checkNode) {
        this.bundle = checkNode.getResourceBundle();
        this.checkNode = checkNode;
    }

    private String createTag(String tagName, Object value, KeyValue ... attributes) {
        StringBuilder buffer = new StringBuilder(ToolConstants.ENTER);
        buffer.append("<").append(tagName).append(this.buildAttr(attributes)).append(">");
        buffer.append(value);
        buffer.append("<").append("/").append(tagName).append(">").append(ToolConstants.ENTER);
        return buffer.toString();
    }

    private String buildAttr(KeyValue ... attributes) {
        StringBuilder buffer = new StringBuilder();
        for (KeyValue kv : attributes) {
            buffer.append(" ");
            buffer.append(kv.getKey());
            buffer.append("=");
            buffer.append("\"");
            buffer.append(kv.getValue());
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private static String repXmlInvalidChars(String source) {
        HashMap<String, String> invalidMap = new HashMap<String, String>();
        invalidMap.put("<", "&lt;");
        invalidMap.put(">", "&gt;");
        invalidMap.put("'", "&apos;");
        invalidMap.put("\"", "&quot;");
        String actualSource = source.replaceAll("&", "&amp;");
        Set entrys = invalidMap.entrySet();
        for (Map.Entry entry : entrys) {
            actualSource = actualSource.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        StringBuilder builder = new StringBuilder();
        String[] lines = actualSource.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            builder.append(lines[i]);
            if (i >= lines.length - 1) continue;
            builder.append(ToolConstants.ENTER);
        }
        return builder.toString();
    }

    public String builderXml() {
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        builder.append(ToolConstants.ENTER);
        builder.append(XLS_HEADER);
        builder.append(ToolConstants.ENTER);
        StringBuffer items = new StringBuffer();
        StringBuffer res = new StringBuffer();
        res.append(this.createTag(CHECKRULE, ResourceUtil.getString((String)"inspsctor.inspectresult.htmlresult.checkrule"), new KeyValue[0]));
        res.append(this.createTag(ID, ResourceUtil.getString((String)"inspsctor.inspectresult.htmlresult.id"), new KeyValue[0]));
        res.append(this.createTag(NAME, ResourceUtil.getString((String)"inspsctor.inspectresult.htmlresult.name"), new KeyValue[0]));
        res.append(this.createTag(METHOD, ResourceUtil.getString((String)"inspsctor.inspectresult.htmlresult.method"), new KeyValue[0]));
        res.append(this.createTag(CRITERION, ResourceUtil.getString((String)"inspsctor.inspectresult.htmlresult.criterion"), new KeyValue[0]));
        res.append(this.createTag(SUGGESTION, ResourceUtil.getString((String)"inspsctor.inspectresult.htmlresult.suggestion"), new KeyValue[0]));
        items.append(this.createTag(RES, res, new KeyValue[0]));
        Map<String, List<CheckItem>> checkItems = this.checkNode.getCheckItems();
        int index = 0;
        for (Map.Entry<String, List<CheckItem>> checkItemsEntry : checkItems.entrySet()) {
            String key = checkItemsEntry.getKey();
            List<CheckItem> checklist = checkItemsEntry.getValue();
            String typeTag = this.createTag(ITEM, this.createTag(NAME, key, new KeyValue[0]), new KeyValue((Object)"type", (Object)"type"));
            items.append(typeTag);
            for (CheckItem item : checklist) {
                if ("baseinfo".equals(item.getItemId())) continue;
                List<Item> moreItems = item.getItems();
                index = this.setRepXmlInvalid(items, index, item, moreItems);
            }
        }
        builder.append(this.createTag(CHECK_LIST, items, new KeyValue[0]));
        return builder.toString();
    }

    int setRepXmlInvalid(StringBuffer items, int index, CheckItem item, List<Item> moreItems) {
        int iterIndex = index;
        for (Item i : moreItems) {
            ++iterIndex;
            String name = this.getString(this.bundle, this.getItemResKey(item, i, NAME));
            String method = this.getString(this.bundle, this.getItemResKey(item, i, METHOD));
            String suggestion = this.getString(this.bundle, this.getItemResKey(item, i, SUGGESTION));
            String criterion = this.getString(this.bundle, this.getItemResKey(item, i, CRITERION));
            ResourceBundle expansionBundle = this.checkNode.getExpansionResource();
            if (expansionBundle != null) {
                if (name.equals("--")) {
                    name = this.getString(expansionBundle, this.getItemResKey(item, i, NAME));
                }
                if (method.equals("--")) {
                    method = this.getString(expansionBundle, this.getItemResKey(item, i, NAME));
                }
                if (suggestion.equals("--")) {
                    suggestion = this.getString(expansionBundle, this.getItemResKey(item, i, NAME));
                }
                if (criterion.equals("--")) {
                    criterion = this.getString(expansionBundle, this.getItemResKey(item, i, NAME));
                }
            }
            String nameTag = this.createTag(NAME, CheckRuleBuiler.repXmlInvalidChars(name), new KeyValue[0]);
            String methodTag = this.createTag(METHOD, CheckRuleBuiler.repXmlInvalidChars(method), new KeyValue[0]);
            String suggestionTag = this.createTag(SUGGESTION, CheckRuleBuiler.repXmlInvalidChars(suggestion), new KeyValue[0]);
            String criterionTag = this.createTag(CRITERION, CheckRuleBuiler.repXmlInvalidChars(criterion), new KeyValue[0]);
            StringBuilder content = new StringBuilder(ToolConstants.ENTER);
            content.append(nameTag).append(ToolConstants.ENTER);
            content.append(methodTag).append(ToolConstants.ENTER);
            content.append(suggestionTag).append(ToolConstants.ENTER);
            content.append(criterionTag).append(ToolConstants.ENTER);
            String itemTag = this.createTag(ITEM, content, new KeyValue((Object)"index", (Object)(iterIndex + "")), new KeyValue((Object)ID, (Object)item.getItemId()));
            items.append(itemTag).append(ToolConstants.ENTER);
        }
        return iterIndex;
    }

    private String getItemResKey(CheckItem check, Item item, String key) {
        return check.getItemId() + "." + item.getId() + "." + key;
    }

    private String getString(ResourceBundle bund, String key) {
        String ret = "--";
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        try {
            ret = ResourceUtil.getString((ResourceBundle)bund, (ResourceBundle)dftResBundle, (String)key);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
        }
        return ret;
    }

    public void transfor2Stream(OutputStream outputStream) {
        try {
            outputStream.write(this.builderXml().getBytes(ApplicationContext.APP_CHARSET));
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream((OutputStream)outputStream, null);
        }
    }
}

