/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.ConfigurationResultEntity;
import com.huawei.ism.tool.inspect.entity.FsNodeExpansionConfig;
import com.huawei.ism.tool.inspect.logic.result.ExcelResultBuilder;
import com.huawei.ism.tool.inspect.utils.FsExpansionUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelConfigurationResultBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelResultBuilder.class);
    private static final int NEED_MERGED_COLUMN_NUM = 5;
    private Workbook workbook;
    private CellStyle tableHeadCellStyle;
    private List<String> tableTitles = Arrays.asList(ResourceUtil.getString((String)"inspect.disk.excel.title.cluster.name"), ResourceUtil.getString((String)"inspect.disk.excel.title.cluster.management.ip"), ResourceUtil.getString((String)"inspect.disk.excel.title.storage.name"), ResourceUtil.getString((String)"inspect.disk.excel.title.disk.name"), ResourceUtil.getString((String)"inspect.disk.excel.title.storage.Capacity"), ResourceUtil.getString((String)"inspect.disk.excel.title.node.name"), ResourceUtil.getString((String)"inspect.disk.excel.title.node.management.ip"), ResourceUtil.getString((String)"inspect.disk.excel.title.node.attribute"), ResourceUtil.getString((String)"inspect.disk.excel.title.main.disk.type"), ResourceUtil.getString((String)"inspect.disk.excel.title.main.disk.number.before.expansion"), ResourceUtil.getString((String)"inspect.disk.excel.title.main.disk.number.after.expansion"), ResourceUtil.getString((String)"inspect.disk.excel.title.cache.disk.type"), ResourceUtil.getString((String)"inspect.disk.excel.title.cache.disk.number.before.expansion"), ResourceUtil.getString((String)"inspect.disk.excel.title.cache.disk.number.after.expansion"));

    public ExcelConfigurationResultBuilder() {
        this.workbook = new XSSFWorkbook();
        this.tableHeadCellStyle = this.workbook.createCellStyle();
        this.tableHeadCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        Font font = this.workbook.createFont();
        font.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.tableHeadCellStyle.setFont(font);
        this.tableHeadCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.tableHeadCellStyle.setDataFormat(this.workbook.createDataFormat().getFormat("@"));
    }

    public void injectData(List<CheckDevNode> connectedDevNode) {
        for (CheckDevNode checkDevNode : connectedDevNode) {
            DevNode devNode = checkDevNode.getDevNode();
            Sheet sheet = this.initTableHead();
            List<ConfigurationResultEntity> configurationResultEntities = this.generateStorageData(devNode);
            this.generateExcelData(configurationResultEntities, sheet);
            this.mergeSameCellData(sheet, configurationResultEntities.size());
        }
    }

    private Sheet initTableHead() {
        Sheet sheet = this.workbook.createSheet();
        Row row = sheet.createRow(0);
        for (int i = 0; i < this.tableTitles.size(); ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 2);
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.tableHeadCellStyle);
            cell.setCellValue(this.tableTitles.get(i));
        }
        return sheet;
    }

    private void mergeSameCellData(Sheet sheet, int rows) {
        if (rows == 0 || rows == 1) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            this.mergeEachRow(sheet, rows, i);
        }
    }

    private void mergeEachRow(Sheet sheet, int rows, int i) {
        int startPos = 1;
        String startPosValue = this.getCellValue(sheet.getRow(1).getCell(i));
        int mergeLength = 0;
        for (int j = 2; j <= rows; ++j) {
            String currentPosValue = this.getCellValue(sheet.getRow(j).getCell(i));
            if (startPosValue.equals(currentPosValue)) {
                ++mergeLength;
                continue;
            }
            if (mergeLength != 0) {
                sheet.addMergedRegion(new CellRangeAddress(startPos, startPos + mergeLength, i, i));
            }
            startPos = j;
            mergeLength = 0;
            startPosValue = currentPosValue;
        }
        if (mergeLength != 0) {
            sheet.addMergedRegion(new CellRangeAddress(startPos, startPos + mergeLength, i, i));
        }
    }

    private void generateExcelData(List<ConfigurationResultEntity> configurationResultEntities, Sheet sheet) {
        for (int i = 0; i < configurationResultEntities.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            List<String> list = configurationResultEntities.get(i).toStringList();
            for (int j = 0; j < this.tableTitles.size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(list.get(j));
            }
        }
    }

    private List<ConfigurationResultEntity> generateStorageData(DevNode node) {
        ArrayList<ConfigurationResultEntity> configurationResultEntities = new ArrayList<ConfigurationResultEntity>();
        List storagePools = node.getStoragePools();
        storagePools.forEach(storagePool -> {
            if (storagePool.getDiskPools().isEmpty()) {
                this.buildEntities(node, (List<ConfigurationResultEntity>)configurationResultEntities, (FusionStorStoragePool)storagePool);
            } else {
                storagePool.getDiskPools().forEach(diskPool -> this.buildEntities(node, configurationResultEntities, (FusionStorStoragePool)diskPool));
            }
        });
        return configurationResultEntities;
    }

    private void buildEntities(DevNode node, List<ConfigurationResultEntity> configurationResultEntities, FusionStorStoragePool storagePool) {
        for (ClusterNode clusterNode : storagePool.getJoinedClusterNode()) {
            configurationResultEntities.add(this.initExistClusterDiskInfo(node, storagePool, clusterNode, false));
        }
        for (ClusterNode clusterNode : storagePool.getExpansionClusterNode()) {
            configurationResultEntities.add(this.initExistClusterDiskInfo(node, storagePool, clusterNode, true));
        }
        for (DevNode newNode : storagePool.getExpansionNodeList()) {
            configurationResultEntities.add(this.initNewClusterDiskInfo(node, storagePool, newNode));
        }
    }

    private ConfigurationResultEntity initNewClusterDiskInfo(DevNode node, FusionStorStoragePool storagePool, DevNode newNode) {
        ConfigurationResultEntity entity = new ConfigurationResultEntity();
        entity.setClusterName(node.getDeviceName());
        entity.setClusterManagementIp(node.getIp());
        this.buildPoolNameAndCapacity(storagePool, entity);
        entity.setNodeName(newNode.getDeviceName());
        entity.setNodeManagementIp(newNode.getIp());
        entity.setNewNode(true);
        entity.setMainDiskType(storagePool.getMainStorageDiskType());
        entity.setBeforeExpansionMainDiskNum(0);
        FsNodeExpansionConfig config = InspectContext.getInstance().getFsExpansionConfig(newNode);
        entity.setAfterExpansionMainDiskNum(config.getExpansionMainStorageDisk().values().stream().mapToInt(Integer::intValue).sum());
        entity.setCacheDiskType(storagePool.getCacheDiskType());
        entity.setBeforeExpansionCacheDiskNum(0);
        entity.setAfterExpansionCacheDiskNum(config.getExpansionCacheDisk().values().stream().mapToInt(Integer::intValue).sum());
        return entity;
    }

    private void buildPoolNameAndCapacity(FusionStorStoragePool storagePool, ConfigurationResultEntity entity) {
        if (storagePool.isDiskPool()) {
            entity.setPoolName(storagePool.getParentPool().getName());
            entity.setDiskPoolName(storagePool.getName());
            entity.setFreeCapacity(FsExpansionUtils.getFreeCapacityByString(storagePool.getParentPool()));
            entity.setTotalCapacity(FsExpansionUtils.getTotalCapacityByString(storagePool.getParentPool()));
        } else {
            entity.setPoolName(storagePool.getName());
            entity.setFreeCapacity(FsExpansionUtils.getFreeCapacityByString(storagePool));
            entity.setTotalCapacity(FsExpansionUtils.getTotalCapacityByString(storagePool));
        }
    }

    private ConfigurationResultEntity initExistClusterDiskInfo(DevNode node, FusionStorStoragePool storagePool, ClusterNode clusterNode, boolean isNewNode) {
        ConfigurationResultEntity entity = new ConfigurationResultEntity();
        entity.setClusterName(node.getDeviceName());
        entity.setClusterManagementIp(node.getIp());
        this.buildPoolNameAndCapacity(storagePool, entity);
        entity.setNodeName(clusterNode.getName());
        entity.setNodeManagementIp(clusterNode.getManagementIp());
        entity.setNewNode(isNewNode);
        entity.setMainDiskType(storagePool.getMainStorageDiskType());
        entity.setBeforeExpansionMainDiskNum(clusterNode.getMainStorageDisk().size());
        FsNodeExpansionConfig config = InspectContext.getInstance().getFsExpansionConfig(clusterNode);
        entity.setAfterExpansionMainDiskNum(clusterNode.getMainStorageDisk().size() + config.getExpansionMainStorageDisk().values().stream().mapToInt(Integer::intValue).sum());
        entity.setCacheDiskType(storagePool.getCacheDiskType());
        entity.setBeforeExpansionCacheDiskNum(clusterNode.getCacheDisk().size());
        entity.setAfterExpansionCacheDiskNum(clusterNode.getCacheDisk().size() + config.getExpansionCacheDisk().values().stream().mapToInt(Integer::intValue).sum());
        return entity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveExcel(String saveFilePath) {
        try (FileOutputStream fos = new FileOutputStream(saveFilePath);){
            this.workbook.write((OutputStream)fos);
            boolean bl = true;
            return bl;
        }
        catch (IOException exception) {
            LOGGER.error("save excel file error");
            return false;
        }
    }

    public String getCellValue(Cell cell) {
        DataFormatter formatter = new DataFormatter();
        return formatter.formatCellValue(cell);
    }
}

