/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.fusionstorage.entity.Product;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.entity.FusionExcelSummaryEntry;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.RetStatusEntry;
import com.huawei.ism.tool.inspect.entity.RiskIdPrefixEnum;
import com.huawei.ism.tool.inspect.entity.SummaryEntry;
import com.huawei.ism.tool.inspect.logic.inspector.InspectEventRecorder;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelResultBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelResultBuilder.class);
    private static final int MAX_STR_LEN_IN_SINGLE_CELL = 32000;
    private static final String MORE = "......";
    private static HSSFWorkbook workBook = new HSSFWorkbook();
    private static CellStyle defaultStyle = null;
    private static CellStyle notPass = null;
    private static CellStyle center = null;
    private static HSSFPalette palette = null;
    private static Font defFont = null;
    private static String fontName = "\u5b8b\u4f53";
    private static short fontSize = (short)10;
    private static final int INT153 = 153;
    private static final String NEWLINE = "\r\n";
    private static final int MAX_PASS_RATE = 100;
    private static String criticalTittle = "";
    private static String methodTittle = "";
    private static String suggestionTittle = "";
    private static ColumnModel[] tittleKeys = new ColumnModel[]{ColumnModel.PRODUCTNAME, ColumnModel.DEVIP, ColumnModel.DEVSN, ColumnModel.INSPECTTIME, ColumnModel.PASSRATE, ColumnModel.PARENTCHECKITEM, ColumnModel.CHECKITEM, ColumnModel.RESULT, ColumnModel.REMARK, ColumnModel.SUGGESTION, ColumnModel.RISKID};
    private static ColumnModel[] dcTitleKeys = new ColumnModel[]{ColumnModel.PRODUCTNAME, ColumnModel.DEVIP, ColumnModel.PARENTCHECKITEM, ColumnModel.CHECKITEM, ColumnModel.RESULT, ColumnModel.REMARK, ColumnModel.SUGGESTION};
    private static ColumnModel[] snTittleKeys = new ColumnModel[]{ColumnModel.PRODUCTMODEL, ColumnModel.PRODUCTVERSION, ColumnModel.DEVSN, ColumnModel.NODEIP, ColumnModel.NODEROLE, ColumnModel.NODESN};
    private Sheet storage = null;
    private Sheet serverNodesSheet;
    private ExcelModel model = ExcelModel.COMMON;

    public ExcelResultBuilder() {
        if ("toolkitDC".equalsIgnoreCase(InspectUtils.getEnv("callTool"))) {
            this.model = ExcelModel.TOOLKITDC;
        }
        try {
            int serverNodeSheetIndex;
            int storageIndex;
            String sheetName = ResourceUtil.getString((String)"inspect.excel.sheetname");
            if (SceneUtils.isSpecialScence((String)System.getenv("jsonScene"), (String[])new String[]{"Switch Inspector", "Switch Quality Checks"})) {
                sheetName = ResourceUtil.getString((String)"inspect.excel.sheetname.sns.switch");
            }
            if ((storageIndex = workBook.getSheetIndex(sheetName)) != -1) {
                workBook.removeSheetAt(storageIndex);
            }
            if ((serverNodeSheetIndex = workBook.getSheetIndex(ResourceUtil.getString((String)"inspect.excel.servernodelist"))) != -1) {
                workBook.removeSheetAt(serverNodeSheetIndex);
            }
            this.storage = workBook.createSheet(sheetName);
            this.createTitle(this.storage, this.model.getColumnModels());
        }
        catch (Exception e) {
            LOGGER.error("build excel error.", (Throwable)e);
        }
    }

    private static ExcelNodeSnSheetValue buildDevRowData(DevNode devNode, ClusterNode clusterNode) {
        return ExcelNodeSnSheetValue.builder().clusterProductModel(devNode.getProductModel()).clusterVersion(devNode.getProductVersionToShow()).clusterEsn(devNode.getDeviceSerialNumber()).clusterNodeSn(clusterNode.getSerialNumber()).clusterNodeIp(clusterNode.getManagementIp()).clusterNodeRoles(String.join((CharSequence)", ", clusterNode.getRoles())).build();
    }

    private static List<ExcelNodeSnSheetValue> buildOneClusterData(DevNode devNode) {
        return devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).map(clusterNode -> ExcelResultBuilder.buildDevRowData(devNode, clusterNode)).collect(Collectors.toList());
    }

    public boolean buildNodeSnSummary(Map<String, List<CheckDevNode>> checkDevs) {
        List<ExcelNodeSnSheetValue> values = checkDevs.values().stream().flatMap(Collection::stream).filter(this::isNeedServerNodeSheet).map(CheckDevNode::getDevNodeSafe).map(ExcelResultBuilder::buildOneClusterData).flatMap(Collection::stream).collect(Collectors.toList());
        if (values.isEmpty()) {
            return false;
        }
        this.addSheetServerNodeSheet();
        this.buildNodeSnExcel(values);
        return true;
    }

    boolean isNeedServerNodeSheet(CheckDevNode checkDevNode) {
        return checkDevNode.isDistributed() && !checkDevNode.getDevNodeSafe().isMetaVision() && !checkDevNode.getDevNodeSafe().isA3000();
    }

    private void buildNodeSnExcel(List<ExcelNodeSnSheetValue> values) {
        int rowNum = this.serverNodesSheet.getLastRowNum() + 1;
        IntStream.range(0, values.size()).forEach(idx -> this.buildNodeSnRow(this.serverNodesSheet.createRow(idx + rowNum), (ExcelNodeSnSheetValue)values.get(idx)));
    }

    private void buildNodeSnRow(Row curRow, ExcelNodeSnSheetValue nodeInfos) {
        curRow.createCell(0).setCellValue(nodeInfos.clusterProductModel);
        curRow.createCell(1).setCellValue(nodeInfos.clusterVersion);
        curRow.createCell(2).setCellValue(nodeInfos.clusterEsn);
        curRow.createCell(3).setCellValue(nodeInfos.clusterNodeIp);
        curRow.createCell(4).setCellValue(nodeInfos.clusterNodeRoles);
        curRow.createCell(5).setCellValue(nodeInfos.clusterNodeSn);
    }

    private void addSheetServerNodeSheet() {
        try {
            this.serverNodesSheet = workBook.createSheet(ResourceUtil.getString((String)"inspect.excel.servernodelist"));
            this.createTitle(this.serverNodesSheet, ExcelModel.NODESN.getColumnModels());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("add server node list sheet to excel error.", (Throwable)e);
        }
    }

    public void buildSummary(List<FusionExcelSummaryEntry> summarys) {
        try {
            this.createProductSummary(this.storage, summarys);
        }
        catch (Exception e) {
            LOGGER.error("build excel error.", (Throwable)e);
        }
    }

    private void createProductSummary(Sheet sheet, List<FusionExcelSummaryEntry> summarys) {
        int index;
        int startRowIndex = index = sheet.getLastRowNum() + 1;
        this.setParentCell(sheet, summarys, startRowIndex);
        this.commonMergedColumn(sheet, index, summarys.size() - 1, this.model.getAutoMergedColumnIndexs());
    }

    private String getProNamePrefix(Product product) {
        return product == null ? "" : product.getProductModel();
    }

    private Float calPassrate(List<FusionExcelSummaryEntry> summarys) {
        int failedCheckItem = 0;
        if (summarys.size() == 0) {
            return Float.valueOf(0.0f);
        }
        int allCheckItem = 0;
        for (FusionExcelSummaryEntry summaryEntry : summarys) {
            if (summaryEntry.getStatus().equals((Object)EvalStatus.NOT_INVOLVED)) continue;
            ++allCheckItem;
            if (summaryEntry.getStatus().equals((Object)EvalStatus.PASS)) continue;
            ++failedCheckItem;
        }
        if (allCheckItem == 0) {
            return Float.valueOf(0.0f);
        }
        Float percent = Float.valueOf((float)(allCheckItem - failedCheckItem) / (float)allCheckItem);
        return Float.valueOf((float)Math.floor(percent.floatValue() * 100.0f));
    }

    private void setParentCell(Sheet sheet, List<FusionExcelSummaryEntry> summarys, int startRowIndex) {
        int parentCheckItemColumnIndex = this.model.indexOfColumn(ColumnModel.PARENTCHECKITEM);
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        DevNode dev = taskInfo.getPrimaryNode();
        String proIP = taskInfo.getMode().toString() + "(" + taskInfo.getFloatIp() + ")";
        String proNamePrefix = this.getProNamePrefix(FusionStorageEvalContext.getInstance().getSupportPorduct().get(dev.getProductVersion()));
        String proName = proNamePrefix + " " + dev.getProductVersion();
        String sn = taskInfo.getFsmSerialNumber();
        Float passrate = this.calPassrate(summarys);
        Long inspectTime = summarys.get(0).getInspectTime() / 1000L;
        String parentNamStr = summarys.get(0).getParentName();
        int rowIndex = startRowIndex;
        for (int devRowIndex = 0; devRowIndex < summarys.size(); ++devRowIndex) {
            Cell parentCell;
            int mergedLength;
            int columnIndex = 0;
            Row rowData = sheet.createRow(sheet.getLastRowNum() + 1);
            FusionExcelSummaryEntry fusionExcelSummaryEntry = summarys.get(devRowIndex);
            columnIndex = ExcelModel.COMMON.equals((Object)this.model) ? this.createCellsWithStyle(rowData, columnIndex, defaultStyle, proName, proIP, sn, inspectTime, passrate, fusionExcelSummaryEntry.getParentName(), fusionExcelSummaryEntry.getCheckName()) : this.createCellsWithStyle(rowData, columnIndex, defaultStyle, proName, proIP, fusionExcelSummaryEntry.getParentName(), fusionExcelSummaryEntry.getCheckName());
            columnIndex = this.createResultWithStyle(rowData, columnIndex, defaultStyle, fusionExcelSummaryEntry);
            rowData.createCell(columnIndex++).setCellValue("");
            if (!fusionExcelSummaryEntry.getParentName().equals(parentNamStr)) {
                mergedLength = rowData.getRowNum() - rowIndex - 1;
                if (0 < mergedLength) {
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowData.getRowNum() - 1, parentCheckItemColumnIndex, parentCheckItemColumnIndex));
                }
                parentCell = sheet.getRow(rowIndex).getCell(parentCheckItemColumnIndex);
                parentCell.setCellStyle(center);
                parentNamStr = fusionExcelSummaryEntry.getParentName();
                rowIndex = rowData.getRowNum();
            }
            if (devRowIndex != summarys.size() - 1) continue;
            mergedLength = rowData.getRowNum() - rowIndex;
            if (0 < mergedLength) {
                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowData.getRowNum(), parentCheckItemColumnIndex, parentCheckItemColumnIndex));
            }
            parentCell = sheet.getRow(rowIndex).getCell(parentCheckItemColumnIndex);
            parentCell.setCellStyle(center);
        }
    }

    private int createResultWithStyle(Row row, int index, CellStyle style, FusionExcelSummaryEntry fusionExcelSummaryEntry) {
        int tempIndex = index;
        Cell cell = row.createCell(tempIndex++);
        cell.setCellStyle(style);
        cell.setCellValue(fusionExcelSummaryEntry.getStatus().toString());
        Cell resultCell = row.createCell(tempIndex++);
        this.setCellStyle(resultCell, fusionExcelSummaryEntry);
        this.setCellValue(resultCell, StringUtils.isNULLStr((String)fusionExcelSummaryEntry.getErrorInfo()) ? "" : fusionExcelSummaryEntry.getErrorInfo());
        Cell suggestionCell = row.createCell(tempIndex++);
        this.setCellStyle(suggestionCell, fusionExcelSummaryEntry);
        this.setSuggestInfo(suggestionCell, fusionExcelSummaryEntry);
        this.setRiskInfo(row, tempIndex++, fusionExcelSummaryEntry);
        return tempIndex;
    }

    private void setRiskInfo(Row row, int index, FusionExcelSummaryEntry fusionExcelSummaryEntry) {
        Cell riskCell = row.createCell(index);
        riskCell.setCellStyle(defaultStyle);
        String riskId = String.join((CharSequence)"_", RiskIdPrefixEnum.DISTRIBUTED.getPrefix(), fusionExcelSummaryEntry.getCheckItemID());
        riskCell.setCellValue(riskId);
    }

    private void setSuggestInfo(Cell cell, FusionExcelSummaryEntry fusionExcelSummaryEntry) {
        if (fusionExcelSummaryEntry.getStatus().equals((Object)EvalStatus.NOTPASS) || fusionExcelSummaryEntry.getStatus().equals((Object)EvalStatus.OPTIMIZATION)) {
            String checkItemID = fusionExcelSummaryEntry.getCheckItemID();
            String method = methodTittle + NEWLINE + EvalResourceUtil.getItemDes(checkItemID + ".method");
            String criterion = criticalTittle + NEWLINE + EvalResourceUtil.getItemDes(checkItemID + ".criterion");
            String suggestion = suggestionTittle + NEWLINE + EvalResourceUtil.getItemDes(checkItemID + ".suggestion");
            this.setCellValue(cell, method + NEWLINE + NEWLINE + criterion + NEWLINE + NEWLINE + suggestion);
        }
    }

    private void setCellStyle(Cell cell, FusionExcelSummaryEntry fusionExcelSummaryEntry) {
        cell.setCellStyle(fusionExcelSummaryEntry.isStatusNotPass() ? notPass : defaultStyle);
    }

    public void buildSummary(List<SummaryEntry> summarys, List<CheckDevNode> devs, String type) {
        try {
            this.createProductSummary(this.storage, summarys, type, devs);
        }
        catch (Exception e) {
            LOGGER.error("build excel error.", (Throwable)e);
        }
    }

    public String writeExcel(String summaryFile) {
        String excelFileName = ExcelResultBuilder.getExcelPrefixName() + StringUtils.formatDate((Object)new Date(), (String)"yyyyMMddHHmmss") + ".xls";
        String excelPaths = Paths.get(summaryFile, excelFileName).toString();
        try (FileOutputStream fos = new FileOutputStream(excelPaths);){
            workBook.write((OutputStream)fos);
            InspectEventRecorder.getInstance().createBizCloudReportExcel(workBook, excelFileName);
        }
        catch (Exception e) {
            LOGGER.error("Write Excel fialed!,FilePath : " + summaryFile, (Throwable)e);
        }
        return excelFileName;
    }

    private static String getExcelPrefixName() {
        if (InspectUtils.isStorageConfig()) {
            return "StorageConfigResult_";
        }
        return "InspectorResult_";
    }

    private void createProductSummary(Sheet sheet, List<SummaryEntry> summarys, String type, List<CheckDevNode> devs) {
        int productSize = summarys.get(0).getResults().size();
        int parentCheckItemColumnIndex = this.model.indexOfColumn(ColumnModel.PARENTCHECKITEM);
        for (int i = 0; i < productSize; ++i) {
            int index;
            CheckDevNode checkdev = devs.get(i);
            DevNode dev = checkdev.getDevNode();
            String proName = type + " " + dev.getDisplayProductVersion();
            if (type.contains("OceanStor 9000") && !StringUtils.isNULLStr((String)dev.getHotPatchVersion()) && !"--".equals(dev.getHotPatchVersion())) {
                proName = type + " " + dev.getHotPatchVersion();
            }
            String proIP = dev.getDeviceName() + "(" + dev.getIp() + ")";
            String sn = dev.getDeviceSerialNumber();
            Float passrate = Float.valueOf(checkdev.getPassRate());
            Long inspectTime = checkdev.getInspectTimeInMillis() / 1000L;
            String parentNamStr = summarys.get(0).getParentName();
            int startRowIndex = index = sheet.getLastRowNum() + 1;
            this.setParentCell(sheet, summarys, parentCheckItemColumnIndex, i, proIP, proName, sn, passrate, inspectTime, parentNamStr, startRowIndex);
            this.commonMergedColumn(sheet, index, summarys.size() - 1, this.model.getAutoMergedColumnIndexs());
        }
    }

    private void setParentCell(Sheet sheet, List<SummaryEntry> summarys, int parentCheckItemColumnIndex, int i, String proIP, String proName, String sn, Float passrate, Long inspectTime, String parentNamStr, int startRowIndex) {
        String parentNam = parentNamStr;
        int rowIndex = startRowIndex;
        for (int devRowIndex = 0; devRowIndex < summarys.size(); ++devRowIndex) {
            Cell parentCell;
            int mergedLength;
            int columnIndex = 0;
            Row rowData = sheet.createRow(sheet.getLastRowNum() + 1);
            SummaryEntry summaryEntry = summarys.get(devRowIndex);
            columnIndex = ExcelModel.COMMON.equals((Object)this.model) ? this.createCellsWithStyle(rowData, columnIndex, defaultStyle, proName, proIP, sn, inspectTime, passrate, summaryEntry.getParentName(), summaryEntry.getCheckName()) : this.createCellsWithStyle(rowData, columnIndex, defaultStyle, proName, proIP, summaryEntry.getParentName(), summaryEntry.getCheckName());
            List<RetStatusEntry> rets = summaryEntry.getResults();
            columnIndex = this.createResultWithStyle(rowData, columnIndex, defaultStyle, rets.get(i));
            rowData.createCell(columnIndex++).setCellValue("");
            if (!summaryEntry.getParentName().equals(parentNam)) {
                mergedLength = rowData.getRowNum() - rowIndex - 1;
                if (0 < mergedLength) {
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowData.getRowNum() - 1, parentCheckItemColumnIndex, parentCheckItemColumnIndex));
                }
                parentCell = sheet.getRow(rowIndex).getCell(parentCheckItemColumnIndex);
                parentCell.setCellStyle(center);
                parentNam = summaryEntry.getParentName();
                rowIndex = rowData.getRowNum();
            }
            if (devRowIndex != summarys.size() - 1) continue;
            mergedLength = rowData.getRowNum() - rowIndex;
            if (0 < mergedLength) {
                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowData.getRowNum(), parentCheckItemColumnIndex, parentCheckItemColumnIndex));
            }
            parentCell = sheet.getRow(rowIndex).getCell(parentCheckItemColumnIndex);
            parentCell.setCellStyle(center);
        }
    }

    public void commonMergedColumn(Sheet sheet, int startIndex, int mergedLength, List<Integer> columnIndexs) {
        CellStyle style = ExcelResultBuilder.newDefaultCellStyle();
        ExcelResultBuilder.setCenter(style);
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        for (int columnIndex : columnIndexs) {
            if (0 < mergedLength) {
                sheet.addMergedRegion(new CellRangeAddress(startIndex, startIndex + mergedLength, columnIndex, columnIndex));
            }
            Cell typeCell = sheet.getRow(startIndex).getCell(columnIndex);
            typeCell.setCellStyle(style);
        }
    }

    private Workbook createTitle(Sheet sheet, ColumnModel[] columnModels) {
        LOGGER.info("Start build Excel Date");
        Row titleRow = sheet.createRow(0);
        CellStyle cellStyle = ExcelResultBuilder.newDefaultCellStyle();
        cellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.TEAL.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFont(ExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.WHITE.getIndex()));
        ExcelResultBuilder.setCenter(cellStyle);
        for (int i = 0; i < columnModels.length; ++i) {
            Cell cell = titleRow.createCell(i);
            cell.setCellValue(ResourceUtil.getString((String)("inspect.excel.title." + columnModels[i].tittleKey)));
            cell.setCellStyle(cellStyle);
            sheet.setColumnWidth(i, columnModels[i].width);
        }
        return workBook;
    }

    private int createCellsWithStyle(Row row, int cellIndex, CellStyle style, Object ... values) {
        int index = cellIndex;
        for (Object value : values) {
            Cell cell = row.createCell(index++);
            cell.setCellStyle(style);
            cell.setCellValue(value.toString());
        }
        return index;
    }

    private int createResultWithStyle(Row row, int index, CellStyle style, RetStatusEntry ret) {
        int tempIndex = index;
        Cell cell = row.createCell(tempIndex++);
        switch (ret.getStaus()) {
            case 0: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execpass"));
                cell.setCellStyle(style);
                break;
            }
            case 1: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.execnotpass"));
                cell.setCellStyle(notPass);
                row.getCell(tempIndex - 2).setCellStyle(notPass);
                break;
            }
            case 2: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.nocheck"));
                cell.setCellStyle(notPass);
                row.getCell(tempIndex - 2).setCellStyle(notPass);
                break;
            }
            case 4: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.warning"));
                cell.setCellStyle(style);
                break;
            }
            case 5: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.manualconfirmation"));
                cell.setCellStyle(style);
                break;
            }
            case 6: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopped"));
                cell.setCellStyle(notPass);
                row.getCell(tempIndex - 2).setCellStyle(notPass);
                break;
            }
            default: {
                cell.setCellValue(ResourceUtil.getString((String)"inspsctor.wizard.performinspect.nosupport"));
                cell.setCellStyle(style);
            }
        }
        Cell resultCell = row.createCell(tempIndex++);
        this.setCellStyle(resultCell, ret);
        String errMsgInfo = this.getErrMsgInfo(ret);
        this.setCellValue(resultCell, errMsgInfo);
        this.setSuggestion(row, tempIndex++, ret, errMsgInfo);
        this.setRiskIdInfo(row, tempIndex++, ret);
        return tempIndex;
    }

    String getErrMsgInfo(RetStatusEntry ret) {
        int staus = ret.getStaus();
        if (staus == 1 || staus == 2 || staus == 4 || staus == 5) {
            return Objects.toString(ret.getErrorInfo(), "");
        }
        return "";
    }

    private void setSuggestion(Row row, int index, RetStatusEntry ret, String errMsgInfo) {
        Cell suggestionCell = row.createCell(index);
        this.setCellStyle(suggestionCell, ret);
        String suggestionKey = ResourceUtil.getString((String)"inspect.excel.title.suggestion.withColon");
        if (errMsgInfo.contains(suggestionKey)) {
            this.setCellValue(suggestionCell, suggestionKey + this.getSuggestionFromErrorMsg(errMsgInfo, suggestionKey));
        } else {
            this.setSuggestInfo(suggestionCell, ret);
        }
    }

    private void setRiskIdInfo(Row row, int index, RetStatusEntry ret) {
        Cell riskCell = row.createCell(index);
        this.setCellStyle(riskCell, ret);
        String riskIdPrefix = RiskIdPrefixEnum.getRiskPrefixByDevType(ret.getCheckDevNode().getDevNode());
        if (ret.getRetItem() != null) {
            this.setCellValue(riskCell, String.join((CharSequence)"_", riskIdPrefix, ret.getRetItem().getItemId()));
        }
    }

    private String getSuggestionFromErrorMsg(String errMsgInfo, String suggestionKey) {
        String[] splitRes = errMsgInfo.split("\\r?\\n");
        StringBuilder strBuilder = new StringBuilder();
        boolean isSuggInNewLine = false;
        for (String line : splitRes) {
            String[] dealLineList = line.split(suggestionKey);
            if (line.contains(suggestionKey)) {
                if (dealLineList.length >= 2) {
                    strBuilder.append(String.format(Locale.ROOT, "%s%s", System.lineSeparator(), dealLineList[1]));
                    continue;
                }
                isSuggInNewLine = true;
                continue;
            }
            if (!isSuggInNewLine || line.contains(suggestionKey)) continue;
            strBuilder.append(String.format(Locale.ROOT, "%s%s", System.lineSeparator(), line));
        }
        return strBuilder.toString();
    }

    private void setCellStyle(Cell cell, RetStatusEntry ret) {
        if (ret.getStaus() == 1 || ret.getStaus() == 2) {
            cell.setCellStyle(notPass);
        } else {
            cell.setCellStyle(defaultStyle);
        }
    }

    private void setSuggestInfo(Cell cell, RetStatusEntry ret) {
        try {
            ResourceBundle resBundle = ret.getCheckDevNode().getResourceBundle();
            CheckItem checkItem = ret.getRetItem();
            if (checkItem == null) {
                return;
            }
            String idPrefix = checkItem.getItemId() + "." + ret.getRitemID();
            String suggestStr = "";
            String method = "";
            String criterion = "";
            if (ret.getStaus() == 1 || ret.getStaus() == 4) {
                suggestStr = checkItem.getSuggestionInfo();
                ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
                ResourceBundle expansionBundle = ret.getCheckDevNode().getExpansionResource();
                if ("NA".equals(suggestStr)) {
                    ResourceBundle switchResource;
                    suggestStr = checkItem.getSuggestion(resBundle, dftResBundle, idPrefix);
                    if (null != expansionBundle && suggestStr.equals("--")) {
                        suggestStr = checkItem.getSuggestion(expansionBundle, dftResBundle, idPrefix);
                    }
                    if ((switchResource = ret.getCheckDevNode().getSwitchResource()) != null && "--".equals(suggestStr)) {
                        suggestStr = checkItem.getSuggestion(switchResource, dftResBundle, idPrefix);
                    }
                }
                String tempCriterion = checkItem.getCriterion(resBundle, dftResBundle, idPrefix);
                String tempMethod = checkItem.getMethod(resBundle, dftResBundle, idPrefix);
                if (null != expansionBundle) {
                    criterion = tempCriterion.equals("--") ? criticalTittle + NEWLINE + checkItem.getCriterion(expansionBundle, dftResBundle, idPrefix) : criticalTittle + NEWLINE + tempCriterion;
                    method = tempMethod.equals("--") ? methodTittle + NEWLINE + checkItem.getMethod(expansionBundle, dftResBundle, idPrefix) : methodTittle + NEWLINE + tempMethod;
                }
                if (this.isSwitchItem(checkItem.getItemId())) {
                    criterion = this.getSwitchCriterion(checkItem, ret.getCheckDevNode(), idPrefix);
                    method = this.getSwitchMethod(checkItem, ret.getCheckDevNode(), idPrefix);
                }
                suggestStr = suggestionTittle + NEWLINE + suggestStr;
                this.setCellValue(cell, method + NEWLINE + NEWLINE + criterion + NEWLINE + NEWLINE + suggestStr);
            }
        }
        catch (Exception e) {
            LOGGER.error("set suggestion failed. ", (Throwable)e);
        }
    }

    private boolean isSwitchItem(String itemId) {
        return "switch_check".equals(itemId);
    }

    private String getSwitchMethod(CheckItem checkItem, CheckDevNode checkDevNode, String idPrefix) {
        ResourceBundle switchResource = checkDevNode.getSwitchResource();
        if (switchResource == null) {
            return "--";
        }
        return methodTittle + NEWLINE + checkItem.getMethod(switchResource, switchResource, idPrefix);
    }

    private String getSwitchCriterion(CheckItem checkItem, CheckDevNode node, String idPrefix) {
        ResourceBundle switchResource = node.getSwitchResource();
        if (switchResource == null) {
            return "--";
        }
        return criticalTittle + NEWLINE + checkItem.getCriterion(switchResource, switchResource, idPrefix);
    }

    private void setCellValue(Cell cell, String value) {
        cell.setCellValue(value.length() > 32000 ? value.substring(0, 32000) + MORE : value);
    }

    private static void addBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static CellStyle newDefaultCellStyle() {
        HSSFCellStyle style = workBook.createCellStyle();
        ExcelResultBuilder.addBorder((CellStyle)style);
        style.setFont(defFont);
        style.setDataFormat(workBook.createDataFormat().getFormat("@"));
        return style;
    }

    private static void setCenter(CellStyle style) {
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private static Font createFont(String name, short fontSizez, short color) {
        HSSFFont font = workBook.createFont();
        font.setFontName(name);
        font.setFontHeightInPoints(fontSizez);
        font.setColor(color);
        return font;
    }

    static /* synthetic */ ColumnModel[] access$800() {
        return dcTitleKeys;
    }

    static /* synthetic */ ColumnModel[] access$900() {
        return tittleKeys;
    }

    static /* synthetic */ ColumnModel[] access$1000() {
        return snTittleKeys;
    }

    static {
        palette = workBook.getCustomPalette();
        palette.setColorAtIndex(HSSFColor.HSSFColorPredefined.YELLOW.getIndex(), (byte)-1, (byte)-1, (byte)-103);
        defFont = ExcelResultBuilder.createFont(fontName, (short)10, HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        defaultStyle = ExcelResultBuilder.newDefaultCellStyle();
        notPass = ExcelResultBuilder.newDefaultCellStyle();
        notPass.setFillForegroundColor(HSSFColor.HSSFColorPredefined.YELLOW.getIndex());
        notPass.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        notPass.setFont(ExcelResultBuilder.createFont(fontName, fontSize, HSSFColor.HSSFColorPredefined.RED.getIndex()));
        center = ExcelResultBuilder.newDefaultCellStyle();
        center.setAlignment(HorizontalAlignment.CENTER);
        center.setVerticalAlignment(VerticalAlignment.CENTER);
        criticalTittle = ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.critical");
        methodTittle = ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.method");
        suggestionTittle = ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.suggestion");
    }

    private static enum ColumnModel {
        PRODUCTNAME("productname", true, 5120),
        PRODUCTMODEL("productmodel", true, 5120),
        PRODUCTVERSION("productversion", true, 5120),
        DEVIP("devip", true, 6400),
        DEVSN("devsn", true, 6400),
        INSPECTTIME("inspecttime", true, 3072),
        PASSRATE("passrate", true, 2560),
        PARENTCHECKITEM("parentcheckitem", false, 3072),
        CHECKITEM("checkitem", false, 5120),
        RESULT("result", false, 5120),
        REMARK("remark", false, 10240),
        SUGGESTION("suggestion", false, 15360),
        RISKID("riskid", false, 15360),
        NODEIP("nodeip", true, 6400),
        NODESN("nodesn", true, 15360),
        NODEROLE("noderole", true, 6400);

        String tittleKey;
        boolean autoMerged;
        int width = 5120;

        private ColumnModel(String tittleKey, boolean autoMerged, int width) {
            this.tittleKey = tittleKey;
            this.autoMerged = autoMerged;
            this.width = width;
        }
    }

    private static enum ExcelModel {
        TOOLKITDC(ExcelResultBuilder.access$800()),
        COMMON(ExcelResultBuilder.access$900()),
        NODESN(ExcelResultBuilder.access$1000());

        ColumnModel[] columnModels;
        List<Integer> autoMergedIndex;

        private ExcelModel(ColumnModel[] tittlekeys) {
            this.columnModels = tittlekeys;
        }

        private ColumnModel[] getColumnModels() {
            return this.columnModels;
        }

        private List<Integer> getAutoMergedColumnIndexs() {
            if (null != this.autoMergedIndex) {
                return this.autoMergedIndex;
            }
            ArrayList<Integer> autoMergedIndexs = new ArrayList<Integer>();
            for (int i = 0; i < this.columnModels.length; ++i) {
                if (!this.columnModels[i].autoMerged) continue;
                autoMergedIndexs.add(i);
            }
            this.autoMergedIndex = autoMergedIndexs;
            return this.autoMergedIndex;
        }

        public int indexOfColumn(ColumnModel column) {
            for (int index = 0; index < this.columnModels.length; ++index) {
                if (!column.equals((Object)this.columnModels[index])) continue;
                return index;
            }
            return -1;
        }
    }

    public static class ExcelNodeSnSheetValue {
        private String clusterProductModel;
        private String clusterVersion;
        private String clusterEsn;
        private String clusterNodeIp;
        private String clusterNodeRoles;
        private String clusterNodeSn;

        @Generated
        ExcelNodeSnSheetValue(String clusterProductModel, String clusterVersion, String clusterEsn, String clusterNodeIp, String clusterNodeRoles, String clusterNodeSn) {
            this.clusterProductModel = clusterProductModel;
            this.clusterVersion = clusterVersion;
            this.clusterEsn = clusterEsn;
            this.clusterNodeIp = clusterNodeIp;
            this.clusterNodeRoles = clusterNodeRoles;
            this.clusterNodeSn = clusterNodeSn;
        }

        @Generated
        public static ExcelNodeSnSheetValueBuilder builder() {
            return new ExcelNodeSnSheetValueBuilder();
        }

        @Generated
        public static class ExcelNodeSnSheetValueBuilder {
            @Generated
            private String clusterProductModel;
            @Generated
            private String clusterVersion;
            @Generated
            private String clusterEsn;
            @Generated
            private String clusterNodeIp;
            @Generated
            private String clusterNodeRoles;
            @Generated
            private String clusterNodeSn;

            @Generated
            ExcelNodeSnSheetValueBuilder() {
            }

            @Generated
            public ExcelNodeSnSheetValueBuilder clusterProductModel(String clusterProductModel) {
                this.clusterProductModel = clusterProductModel;
                return this;
            }

            @Generated
            public ExcelNodeSnSheetValueBuilder clusterVersion(String clusterVersion) {
                this.clusterVersion = clusterVersion;
                return this;
            }

            @Generated
            public ExcelNodeSnSheetValueBuilder clusterEsn(String clusterEsn) {
                this.clusterEsn = clusterEsn;
                return this;
            }

            @Generated
            public ExcelNodeSnSheetValueBuilder clusterNodeIp(String clusterNodeIp) {
                this.clusterNodeIp = clusterNodeIp;
                return this;
            }

            @Generated
            public ExcelNodeSnSheetValueBuilder clusterNodeRoles(String clusterNodeRoles) {
                this.clusterNodeRoles = clusterNodeRoles;
                return this;
            }

            @Generated
            public ExcelNodeSnSheetValueBuilder clusterNodeSn(String clusterNodeSn) {
                this.clusterNodeSn = clusterNodeSn;
                return this;
            }

            @Generated
            public ExcelNodeSnSheetValue build() {
                return new ExcelNodeSnSheetValue(this.clusterProductModel, this.clusterVersion, this.clusterEsn, this.clusterNodeIp, this.clusterNodeRoles, this.clusterNodeSn);
            }

            @Generated
            public String toString() {
                return "ExcelResultBuilder.ExcelNodeSnSheetValue.ExcelNodeSnSheetValueBuilder(clusterProductModel=" + this.clusterProductModel + ", clusterVersion=" + this.clusterVersion + ", clusterEsn=" + this.clusterEsn + ", clusterNodeIp=" + this.clusterNodeIp + ", clusterNodeRoles=" + this.clusterNodeRoles + ", clusterNodeSn=" + this.clusterNodeSn + ")";
            }
        }
    }
}

