/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.HelpKey;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.result.DetailEntry;
import com.huawei.ism.tool.inspect.logic.result.NormalResultBuilder;
import com.huawei.ism.tool.inspect.utils.HtmlResUtils;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class NativeResultBuilder
extends NormalResultBuilder {
    private static final int STATUS_OK = 0;
    private static final int STATUS_NOTOK = 1;
    private static final int STATUS_NOCHECK = 2;
    private static final int STATUS_NOSUPPORT = 3;
    private static final int STATUS_WARNING = 4;
    private static final int STATUS_MANUAL_CONFIRMATION = 5;
    private static final int STATUS_STOPPED = 6;
    private String key = "";
    private int status;
    private String errorInfo = "";

    @Override
    protected List<DetailEntry> getDetails(List<CheckDevNode> allCheckDevNodes, CheckDevNode checkDevNode) {
        ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
        List<CheckItem> checkItems = InspectUtils.getAllCheckItem(checkDevNode);
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        boolean passedNotShowSuggest = checkDevNode.getProduct().isPassedNotShowSuggest();
        for (CheckItem cmdItem : checkItems) {
            ResourceBundle bundle = cmdItem.isUserExpansionRes() ? this.getUserExpanseBundle(checkDevNode, cmdItem) : checkDevNode.getResourceBundle();
            DetailEntry detailEntry = new DetailEntry();
            detailEntry.setPassedNotShowSuggest(passedNotShowSuggest);
            detailEntry.setCheckItemId(cmdItem.getItemId());
            if (!cmdItem.isEnable()) {
                detailEntry.setName(cmdItem.getName());
                detailEntry.setStatus(-1);
                details.add(detailEntry);
                continue;
            }
            detailEntry.setName(cmdItem.getName());
            detailEntry.setPass(cmdItem.isPassedNotShowSuggest());
            String idPrefix = cmdItem.getItemId() + ".0";
            detailEntry.setCriterion(ResourceUtil.replaceWrapLineToBr((String)cmdItem.getCriterion(bundle, dftResBundle, idPrefix)));
            Object annex = cmdItem.getAnnex();
            if (annex != null) {
                detailEntry.setHandled(true);
                detailEntry.setLink(String.valueOf(annex));
            }
            this.checkDetailEntry(checkDevNode, details, bundle, dftResBundle, cmdItem, detailEntry, idPrefix);
        }
        return details;
    }

    private ResourceBundle getUserExpanseBundle(CheckDevNode checkDevNode, CheckItem cmdItem) {
        if (this.isSwitchCheck(cmdItem)) {
            return checkDevNode.getSwitchResource();
        }
        return checkDevNode.getExpansionResource();
    }

    private boolean isSwitchCheck(CheckItem cmdItem) {
        return "switch_check".equals(cmdItem.getItemId());
    }

    private void checkDetailEntry(CheckDevNode checkDevNode, List<DetailEntry> details, ResourceBundle bundle, ResourceBundle dftResBundle, CheckItem cmdItem, DetailEntry detailEntry, String idPrefix) {
        if ("NA".equals(cmdItem.getSuggestionInfo()) && !"fcvcheck".equals(cmdItem.getItemType())) {
            String helpKey = ResourceUtil.getStringHandledNewline((ResourceBundle)bundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".helphref"));
            String suggestion = ResourceUtil.replaceWrapLineToBr((String)cmdItem.getSuggestion(bundle, dftResBundle, idPrefix));
            if (!"--".equals(helpKey)) {
                String pkgFolder = InspectUtils.getTypeFolderName(checkDevNode);
                helpKey = helpKey.replace("/helpCase", "/../" + pkgFolder + "/helpCase");
                Map<String, List<HelpKey>> helpKeys = InspectUtils.getHelpKeys(helpKey);
                suggestion = InspectUtils.replaceKeysByMap(suggestion.replaceAll("\n", "<br>"), "", helpKeys);
            }
            detailEntry.setSuggestion(suggestion);
        } else {
            detailEntry.setSuggestion(cmdItem.getSuggestionInfo());
        }
        this.buildImpactMsg(detailEntry, bundle, dftResBundle, checkDevNode, idPrefix);
        detailEntry.setCheckMethod(ResourceUtil.replaceWrapLineToBr((String)cmdItem.getMethod(bundle, dftResBundle, idPrefix)));
        detailEntry.setSourceInfo("<xmp>" + cmdItem.getSourceInfo() + ToolConstants.ENTER + "</xmp>");
        detailEntry.setHyperlinkPath(cmdItem.getSourceInfoPath());
        ResultItem reItem = cmdItem.getCheckResult();
        this.checkResultStatus(cmdItem, reItem);
        detailEntry.setPasstxt(HtmlResUtils.getString("detail.view.result." + this.key) + "<br/>" + this.errorInfo);
        detailEntry.setStatus(this.status);
        if (!this.isEmpty(reItem)) {
            detailEntry.setTimeTake(StringUtils.millls2FormatString((long)reItem.getTimeTake(), (Enum)StringUtils.TimeAccurateLevel.MS));
        }
        details.add(detailEntry);
    }

    private boolean isEmpty(Object obj) {
        return null == obj;
    }

    private void checkResultStatus(CheckItem cmdItem, ResultItem reItem) {
        if (reItem != null && reItem.isNormal()) {
            this.key = "passed";
            this.status = 0;
            this.errorInfo = "";
        } else if (reItem != null && reItem.isNoSupport()) {
            this.key = "nosupport";
            this.errorInfo = "<xmp>" + cmdItem.getErrorInfo() + ToolConstants.ENTER + "</xmp>";
            this.status = 3;
        } else if (reItem != null && reItem.isNoCheck()) {
            this.key = "nocheck";
            this.errorInfo = "<xmp>" + cmdItem.getErrorInfo() + ToolConstants.ENTER + "</xmp>";
            this.status = 2;
        } else if (reItem != null && reItem.isWarning()) {
            this.key = "warning";
            this.errorInfo = "<xmp>" + cmdItem.getErrorInfo() + ToolConstants.ENTER + "</xmp>";
            this.status = 4;
        } else if (reItem != null && reItem.isManualConfirmation()) {
            this.key = "manualconfirmation";
            this.errorInfo = "";
            this.status = 5;
        } else if (reItem != null && (reItem.isStop() || reItem.getRecordStatus() == RecordStatus.STOPPED)) {
            this.key = "stopped";
            this.errorInfo = "";
            this.status = 6;
        } else {
            this.key = "notPassed";
            this.errorInfo = "<xmp>" + cmdItem.getErrorInfo() + ToolConstants.ENTER + "</xmp>";
            this.status = 1;
        }
    }
}

