/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.inspect.entity.BaseInfoCheckResult;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.ResultReportFilterEntity;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.CheckModelInfo;
import com.huawei.ism.tool.inspect.logic.result.DetailEntry;
import com.huawei.ism.tool.inspect.logic.result.IResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.TemplateFactory;
import com.huawei.ism.tool.inspect.utils.ChannelWriteFile;
import com.huawei.ism.tool.inspect.utils.HtmlResUtils;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;

public class NormalResultBuilder
implements IResultBuilder {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(NormalResultBuilder.class);
    private static final String RESULT_HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"" + HtmlEnums.HTML_TRANSITIONAL.getResourceValue() + "\"><html><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/><link  href=\"css/table_inspector.css\" type=\"text/css\" rel=\"stylesheet\" /><head><title>Inspector Result</title><script type=\"text/javascript\" language=\"javascript\" src=\"../../js/jquery.min.js\"></script><script type=\"text/javascript\" language=\"javascript\" src=\"../../js/detail.js\"></script></head><body onload=\"init()\">";
    private static final String RESULT_FOOTER = "</body></html>";
    private static final String TABLE_START = "<table>";
    private static final String TABLE_END = "</table>";
    private static final String TR_START = "<tr>";
    private static final String TR_END = "</tr>";
    private static final String TD_START = "<td class='breakword_td'>";
    private static final String TD_END = "</td>";
    private static final String TH_START = "<th>";
    private static final String TH_END = "</th>";
    private static final int STATUS_OK = 0;
    private static final int STATUS_NOTOK = 1;
    private static final int STATUS_NOCHECK = 2;
    private static final int STATUS_NONSUPPORT = 3;
    private static final int STATUS_WARNING = 4;
    private static final int MANUAL_CONFIRMATION = 5;
    private String key = "";
    private int status = 1;
    private String errorInfo = "";
    private static final String TEMPLATE_1 = RESULT_HEADER + "<div class='title'><div class='txt' align='center'><h1 align='left' style='font-size:35px'>%s</h1></div></div><br/><br/>" + System.lineSeparator();
    private static final String TEMPLATE_2 = "<div align=left><select onchange='isSelected(this.value);' id='select'><option value=''>%s</option><option value='fail'>%s</option><option value='success'>%s</option><option value=''>%s</option></select></div><br/><br/>";
    private static final String TEMPLATE_3 = "<tr><th width='150'>%s</th><td class='breakword_td'>%s</td></tr>";
    private static final String TEMPLATE_4 = "<th>%s</th>";
    private static final String TEMPLATE_5 = "<td class='breakword_td'>%s</td>";

    protected List<DetailEntry> getDetails(List<CheckDevNode> allCheckDevNodes, CheckDevNode checkDevNode) {
        ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
        List<CheckItem> checkItems = InspectUtils.getAllCheckItem(checkDevNode);
        boolean isPassedNotShowSuggest = checkDevNode.getProduct().isPassedNotShowSuggest();
        CheckModelInfo modelInfo = checkDevNode.getProduct().getCheckModelInfo();
        if (!(modelInfo != null && "sh".equals(modelInfo.getModelType()) || InspectContext.getInstance().getSelectInspectType().equals(""))) {
            String string = InspectContext.getInstance().getSelectInspectType();
            SysConfiguration.getInstance();
            if (!string.equals("realTimed_check")) {
                String string2 = InspectContext.getInstance().getSelectInspectType();
                SysConfiguration.getInstance();
                if (!(string2.equals("timed_check") || InspectContext.getInstance().getSelectInspectType().contains("T3000") || InspectContext.getInstance().getSelectInspectType().contains("UltraPath"))) {
                    LOGGER.info("get compass disk inspector details...");
                    return this.getComPassDetails(checkDevNode, isPassedNotShowSuggest);
                }
            }
        }
        LOGGER.info("no compass disk inspector details...");
        for (CheckItem cmdItem : checkItems) {
            ResourceBundle bundle = cmdItem.isUserExpansionRes() ? checkDevNode.getExpansionResource() : checkDevNode.getResourceBundle();
            details.addAll(this.getDetailList(cmdItem, bundle, isPassedNotShowSuggest, checkDevNode));
        }
        return details;
    }

    private List<DetailEntry> getDetailList(CheckItem cmdItem, ResourceBundle bundle, boolean isPassedNotShowSuggest, CheckDevNode checkDevNode) {
        ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
        List<Item> items = cmdItem.getItems();
        if (!cmdItem.isEnable()) {
            for (Item item : items) {
                DetailEntry detailEntry = new DetailEntry();
                detailEntry.setCheckItemId(cmdItem.getItemId());
                detailEntry.setRitemId(item.getId());
                detailEntry.setName(item.getName());
                detailEntry.setStatus(-1);
                detailEntry.setPassedNotShowSuggest(isPassedNotShowSuggest);
                details.add(detailEntry);
            }
        } else {
            this.getItemsRes(cmdItem, bundle, isPassedNotShowSuggest, details, items, checkDevNode);
        }
        return details;
    }

    private void getItemsRes(CheckItem cmdItem, ResourceBundle bundle, boolean isPassedNotShowSuggest, List<DetailEntry> details, List<Item> items, CheckDevNode checkDevNode) {
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        for (Item item : items) {
            RItem ritem = this.getRitem(cmdItem, item);
            if (ritem == null) {
                LOGGER.warn("find a null ritem");
                continue;
            }
            DetailEntry detailEntry = new DetailEntry();
            detailEntry.setPassedNotShowSuggest(isPassedNotShowSuggest);
            detailEntry.setName(item.getName());
            detailEntry.setCheckItemId(cmdItem.getItemId());
            detailEntry.setRitemId(ritem.getItemId());
            detailEntry.setPass(ritem.isNormal() || ritem.isNoCheck() || ritem.isNoSupport());
            String idPrefix = cmdItem.getItemId() + "." + item.getId();
            detailEntry.setCriterion(ResourceUtil.replaceWrapLineToBr((String)cmdItem.getCriterion(bundle, dftResBundle, idPrefix)));
            detailEntry.setSuggestion(ResourceUtil.replaceWrapLineToBr((String)cmdItem.getSuggestion(bundle, dftResBundle, idPrefix)));
            detailEntry.setCheckMethod(ResourceUtil.replaceWrapLineToBr((String)cmdItem.getMethod(bundle, dftResBundle, idPrefix)));
            this.buildImpactMsg(detailEntry, bundle, dftResBundle, checkDevNode, idPrefix);
            this.buildSourceInfo(ritem, detailEntry, checkDevNode);
            this.buildStatus(ritem);
            detailEntry.setPasstxt(HtmlResUtils.getString("detail.view.result." + this.key));
            if (TagCondition.hasTag(cmdItem.getTag(), "NATIVE")) {
                detailEntry.setPasstxt(detailEntry.getPasstxt() + "<br/>" + cmdItem.getErrorInfo());
            }
            detailEntry.setStatus(this.status);
            details.add(detailEntry);
        }
    }

    private void buildStatus(RItem ritem) {
        RItemstatus rItemstatus = RItemstatus.getRItemstatus(ritem.getJudge());
        this.key = rItemstatus.getKey();
        this.status = rItemstatus.getStatus();
    }

    private void buildSourceInfo(RItem ritem, DetailEntry detailEntry, CheckDevNode checkDevNode) {
        String sourceInfo = ritem.getCommonString() + ToolConstants.ENTER;
        String errorInfoTemp = ritem.getErrorString();
        sourceInfo = this.buildErrorInfo(detailEntry, checkDevNode, sourceInfo, errorInfoTemp);
        sourceInfo = sourceInfo + ritem.getRawval();
        sourceInfo = this.infoIsNullGetCli(sourceInfo, errorInfoTemp, ritem);
        sourceInfo = "<xmp>" + sourceInfo + "</xmp>";
        detailEntry.setSourceInfo(sourceInfo);
    }

    private String buildErrorInfo(DetailEntry detailEntry, CheckDevNode checkDevNode, String sourceInfo, String errorInfoTemp) {
        if (!checkDevNode.isErrorRedView() || StringUtils.isNULLStr((String)errorInfoTemp)) {
            return sourceInfo + errorInfoTemp + ToolConstants.ENTER;
        }
        String sourceRedInfo = "<xmp>" + errorInfoTemp + ToolConstants.ENTER + "</xmp>";
        detailEntry.setSourceRedInfo(sourceRedInfo);
        return sourceInfo;
    }

    private String infoIsNullGetCli(String sourceInfo, String errorInfoTemp, RItem ritem) {
        return StringUtils.isNULLStr((String)sourceInfo) && StringUtils.isNULLStr((String)errorInfoTemp) ? ritem.getCli() : sourceInfo;
    }

    protected void buildImpactMsg(DetailEntry detailEntry, ResourceBundle bundle, ResourceBundle dftResBundle, CheckDevNode checkDevNode, String idPrefix) {
        String showImpact = checkDevNode.showImpact();
        if (showImpact == null) {
            return;
        }
        detailEntry.setImpactIgnore(ResourceUtil.getStringHandledNewline((ResourceBundle)bundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".impact.ignore")));
        detailEntry.setImpactBusiness(ResourceUtil.getStringHandledNewline((ResourceBundle)bundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".impact.business")));
        detailEntry.setImpactFix(ResourceUtil.getStringHandledNewline((ResourceBundle)bundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".impact.fix")));
    }

    private List<DetailEntry> getComPassDetails(CheckDevNode checkDevNode, boolean isPassedNotShowSuggest) {
        ArrayList<DetailEntry> detailList = new ArrayList<DetailEntry>();
        List<CheckItem> checkItemlist = InspectUtils.getAllCheckItem(checkDevNode);
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        for (CheckItem cmdItem : checkItemlist) {
            if (!cmdItem.isEnable()) continue;
            ResourceBundle resourceBundle = cmdItem.isUserExpansionRes() ? checkDevNode.getExpansionResource() : checkDevNode.getResourceBundle();
            DetailEntry detail = new DetailEntry();
            detail.setPass(isPassedNotShowSuggest);
            detail.setName(cmdItem.getName());
            detail.setCheckItemId(cmdItem.getItemId());
            detail.setPass(cmdItem.isPassed());
            String idPrefix = cmdItem.getItemId() + ".0";
            this.initDetailRes(detail, resourceBundle, dftResBundle, idPrefix, checkDevNode);
            detail.setSourceInfo("<xmp>" + cmdItem.getSourceInfo() + ToolConstants.ENTER + "</xmp>");
            if (cmdItem.isPassed()) {
                this.errorInfo = "";
                this.key = "passed";
                this.status = 0;
            } else {
                this.key = "notPassed";
                this.status = 1;
                this.errorInfo = "<xmp>" + cmdItem.getErrorInfo() + ToolConstants.ENTER + "</xmp>";
            }
            if (cmdItem.isNoSupport()) {
                this.key = "nosupport";
                this.status = 3;
                this.errorInfo = "<xmp>" + cmdItem.getErrorInfo() + ToolConstants.ENTER + "</xmp>";
            }
            if (cmdItem.isManualConfirmation()) {
                this.key = "manualconfirmation";
                this.status = 5;
                this.errorInfo = "";
            }
            detail.setPasstxt(HtmlResUtils.getString("detail.view.result." + this.key) + "<br/>" + this.errorInfo);
            detail.setStatus(this.status);
            detailList.add(detail);
        }
        return detailList;
    }

    private void initDetailRes(DetailEntry detail, ResourceBundle resourceBundle, ResourceBundle dftResBundle, String idPrefix, CheckDevNode checkDevNode) {
        detail.setCriterion(ResourceUtil.getStringHandledNewline((ResourceBundle)resourceBundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".criterion")));
        detail.setSuggestion(ResourceUtil.getStringHandledNewline((ResourceBundle)resourceBundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".suggestion")));
        detail.setCheckMethod(ResourceUtil.getStringHandledNewline((ResourceBundle)resourceBundle, (ResourceBundle)dftResBundle, (String)(idPrefix + ".method")));
        this.buildImpactMsg(detail, resourceBundle, dftResBundle, checkDevNode, idPrefix);
    }

    private RItem getRitem(CheckItem cmdItem, Item item) {
        ResultItem resultCmdItem;
        if (cmdItem != null && item != null && (resultCmdItem = cmdItem.getCheckResult()) != null) {
            List<RItem> itemResult = resultCmdItem.getItems();
            for (RItem ret : itemResult) {
                if (ret.getItemId() == null || !ret.getItemId().equals(item.getId())) continue;
                return ret;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResultFile(List<CheckDevNode> allCheckDevNodes, CheckDevNode checkDevNode, String resultFileName) {
        ChannelWriteFile file = null;
        try {
            file = new ChannelWriteFile(resultFileName, false);
            Map<String, List<CheckItem>> items = checkDevNode.getCheckItems();
            ArrayList<String> keys = new ArrayList<String>(items.keySet());
            file.write(String.format(Locale.ENGLISH, TEMPLATE_1, ResourceUtil.getStringWithParams((String)"inspsctor.inspectresult.htmlresult.inspectresult", (Object[])new Object[]{InspectUtils.getDevNodeIpInReport(checkDevNode) + "_" + checkDevNode.getDevNode().getDeviceSerialNumber(), checkDevNode.getCurrentSceneDesc()})));
            file.write(String.format(Locale.ENGLISH, TEMPLATE_2, ResourceUtil.getStringWithParams((String)"inspsctor.inspectresult.htmlresult.itemfilter", (Object[])new Object[0]), ResourceUtil.getStringWithParams((String)"inspsctor.inspectresult.htmlresult.showfail", (Object[])new Object[0]), ResourceUtil.getStringWithParams((String)"inspsctor.inspectresult.htmlresult.showsuccess", (Object[])new Object[0]), ResourceUtil.getStringWithParams((String)"inspsctor.inspectresult.htmlresult.showall", (Object[])new Object[0])));
            for (String type : keys) {
                List<CheckItem> checkItems = items.get(type);
                this.createTable(file, checkItems, checkDevNode);
            }
            InspectContext.getInstance().waitDecompressHelpCaseFinish();
            List<DetailEntry> oldDetails = this.getDetails(allCheckDevNodes, checkDevNode);
            ArrayList<DetailEntry> details = new ArrayList<DetailEntry>();
            for (DetailEntry oldDetail : oldDetails) {
                this.generateDetails(oldDetail);
                details.add(oldDetail);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("allitems", details);
            data.put("showImpact", checkDevNode.getProduct().getShowImpact());
            String detail = TemplateFactory.processorFtl("detailView.html", data);
            file.write(detail);
        }
        catch (Exception e) {
            LOGGER.error("build result file error.", (Throwable)e);
        }
        finally {
            if (null != file) {
                file.close();
            }
        }
    }

    private void generateDetails(DetailEntry detail) {
        String hyperlinkPath = detail.getHyperlinkPath();
        if (hyperlinkPath != "" && hyperlinkPath != null) {
            ResultReportFilterEntity resultReportFilterEntity = new ResultReportFilterEntity();
            String hrefPath = ".." + File.separator + ".." + File.separator + ".." + File.separator + detail.getHyperlinkPath();
            resultReportFilterEntity.setHrefPath(hrefPath);
            resultReportFilterEntity.setPath(detail.getHyperlinkPath());
            resultReportFilterEntity.setShow(true);
            detail.setResultReportFilterEntity(resultReportFilterEntity);
        }
    }

    private void createTable(ChannelWriteFile file, List<CheckItem> checkItems, CheckDevNode checkDevNode) {
        for (CheckItem check : checkItems) {
            if (!check.isEnable()) continue;
            ResourceBundle bundle = check.isUserExpansionRes() ? checkDevNode.getExpansionResource() : checkDevNode.getResourceBundle();
            String itemId = check.getItemId();
            if (!"baseinfo".equals(itemId) || check.getCheckResult() == null) continue;
            ResultItem resultItem = check.getCheckResult();
            List<RItem> ritems = resultItem.getItems();
            if (ritems.isEmpty()) break;
            this.parseSysInfo(file, (BaseInfoCheckResult)ritems.get(0), bundle);
            break;
        }
    }

    private void parseSysInfo(ChannelWriteFile file, BaseInfoCheckResult result, ResourceBundle resBundle) {
        if (null == result) {
            return;
        }
        if (!result.getSystemInfo().isEmpty()) {
            file.write(TABLE_START);
            for (KeyValue<String, String> kval : result.getSystemInfo()) {
                file.write(String.format(Locale.ENGLISH, TEMPLATE_3, this.getString(resBundle, (String)kval.getKey()), kval.getValue()));
            }
            file.write(TABLE_END);
        }
        if (!result.getCtrollerInfo().isEmpty()) {
            List<List<KeyValue<String, String>>> rows = result.getCtrollerInfo();
            file.write(TABLE_START);
            this.addHeaderAndTableRow(file, resBundle, rows);
            file.write(TABLE_END);
        }
    }

    private void addHeaderAndTableRow(ChannelWriteFile file, ResourceBundle resBundle, List<List<KeyValue<String, String>>> rows) {
        if (!rows.get(0).isEmpty()) {
            file.write(TR_START);
            for (KeyValue keyValue : rows.get(0)) {
                file.write(String.format(Locale.ENGLISH, TEMPLATE_4, this.getString(resBundle, (String)keyValue.getKey())));
            }
            file.write(TR_END);
        }
        for (List<KeyValue<String, String>> list : rows) {
            file.write(TR_START);
            for (KeyValue<String, String> kv : list) {
                file.write(String.format(Locale.ENGLISH, TEMPLATE_5, kv.getValue()));
            }
            file.write(TR_END);
        }
    }

    protected String getString(ResourceBundle bundle, String keyVal) {
        String value = null;
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        try {
            value = ResourceUtil.getString((ResourceBundle)bundle, (ResourceBundle)dftResBundle, (String)keyVal);
            value = value.replaceAll("\n", "<br/>");
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(NormalResultBuilder.class).error("", (Throwable)e);
        }
        return value == null ? "--" : value;
    }

    private static enum RItemstatus {
        OK("0", 0, "passed"),
        NOTOK("1", 1, "notPassed"),
        NOCHECK("2", 2, "2"),
        NONSUPPORT("3", 3, "nosupport"),
        WARNING("4", 4, "warning");

        private String rItemJuge;
        private int status;
        private String key;

        private RItemstatus(String rItemJuge, int status, String key) {
            this.rItemJuge = rItemJuge;
            this.status = status;
            this.key = key;
        }

        public String getrItemJuge() {
            return this.rItemJuge;
        }

        public int getStatus() {
            return this.status;
        }

        public String getKey() {
            return this.key;
        }

        public static RItemstatus getRItemstatus(String rItemJuge) {
            return Arrays.stream(RItemstatus.values()).filter(obj -> obj.getrItemJuge().equals(rItemJuge)).findAny().orElse(NOCHECK);
        }
    }
}

