/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.obase.entity.SwitchNode;
import com.huawei.ism.tool.obase.entity.SwitchPort;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchExcelBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchExcelBuilder.class);
    private static final byte UNDER_LINE_BOARD = 1;
    private static final int IP_COLUMN = 0;
    private static final int MODEL_COLUMN = 1;
    private static final int VERSION_COLUMN = 2;
    private static final int CLUSTER_COLUMN = 3;
    private static final int PORT_COLUMN = 4;
    private static final int PORT_NAME_COLUMN = 0;
    private static final int PORT_STATUS_COLUMN = 1;
    private static final int PORT_CHECK_COLUMN = 2;
    private final Workbook workbook = new XSSFWorkbook();

    public void exportSwitchNodes(String devIp, List<SwitchNode> switchNodes, File exportPath) {
        this.buildWorkBook(switchNodes);
        this.writeFile(devIp, exportPath);
    }

    private void buildWorkBook(List<SwitchNode> switchNodes) {
        Sheet switchSheet = this.workbook.createSheet(ResourceUtil.getString((String)"switch.info"));
        this.buildHead(switchSheet);
        int rowIndex = 1;
        for (SwitchNode switchNode : switchNodes) {
            this.writeSwitchInfo(switchSheet.createRow(rowIndex), switchNode);
            ++rowIndex;
        }
    }

    private void writeFile(String devIp, File exportPath) {
        File file = new File(exportPath, String.format(Locale.ROOT, "switch_info_%s.xlsx", FileUtils.formatIpForPath((String)devIp)));
        try {
            if (!file.exists() && !file.createNewFile()) {
                log.warn("create switch info file failed");
                return;
            }
            try (FileOutputStream fileInputStream = new FileOutputStream(file);){
                this.workbook.write((OutputStream)fileInputStream);
            }
        }
        catch (IOException e) {
            log.error("write switch info excel failed", (Throwable)e);
        }
    }

    private void writeSwitchInfo(Row row, SwitchNode switchInfo) {
        Cell ip = row.createCell(0);
        ip.setCellValue(switchInfo.getIp());
        Cell model = row.createCell(1);
        model.setCellValue(switchInfo.getModel());
        Cell version = row.createCell(2);
        version.setCellValue(switchInfo.getVersion());
        Cell cluster = row.createCell(3);
        cluster.setCellValue(switchInfo.getFloatIp());
        Cell port = row.createCell(4);
        port.setCellValue(ResourceUtil.getString((String)"switch.port"));
        port.setHyperlink(this.buildPortHyperlink(this.buildPortSheet(switchInfo)));
        this.setLinkStyle(port);
    }

    private void setLinkStyle(Cell port) {
        CellStyle cellStyle = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setUnderline((byte)1);
        font.setColor(HSSFColor.HSSFColorPredefined.BLUE.getIndex());
        cellStyle.setFont(font);
        port.setCellStyle(cellStyle);
    }

    @NotNull
    private Hyperlink buildPortHyperlink(String portSheet) {
        CreationHelper creationHelper = this.workbook.getCreationHelper();
        Hyperlink link = creationHelper.createHyperlink(HyperlinkType.DOCUMENT);
        link.setAddress(String.format(Locale.ROOT, "#%s!A1", portSheet));
        return link;
    }

    private String buildPortSheet(SwitchNode switchInfo) {
        Sheet sheet = this.workbook.createSheet(switchInfo.getIp());
        this.buildPortHead(sheet);
        int rowIndex = 1;
        for (SwitchPort port : switchInfo.getSwitchPort()) {
            this.writePortInfo(sheet.createRow(rowIndex), port);
            ++rowIndex;
        }
        return sheet.getSheetName();
    }

    private void writePortInfo(Row row, SwitchPort port) {
        Cell portName = row.createCell(0);
        portName.setCellValue(port.getPortName());
        Cell status = row.createCell(1);
        status.setCellValue(port.getStatus());
        Cell isCheck = row.createCell(2);
        isCheck.setCellValue(port.isSelected());
    }

    private void buildPortHead(Sheet sheet) {
        Row row = sheet.createRow(0);
        Cell portName = row.createCell(0);
        portName.setCellValue(ResourceUtil.getString((String)"switch.port.name"));
        Cell status = row.createCell(1);
        status.setCellValue(ResourceUtil.getString((String)"switch.port.status"));
        Cell isCheck = row.createCell(2);
        isCheck.setCellValue(ResourceUtil.getString((String)"switch.port.check"));
    }

    private void buildHead(Sheet switchInfos) {
        Row row = switchInfos.createRow(0);
        Cell ip = row.createCell(0);
        ip.setCellValue(ResourceUtil.getString((String)"switch.ip"));
        Cell model = row.createCell(1);
        model.setCellValue(ResourceUtil.getString((String)"switch.model"));
        Cell version = row.createCell(2);
        version.setCellValue(ResourceUtil.getString((String)"switch.version"));
        Cell cluster = row.createCell(3);
        cluster.setCellValue(ResourceUtil.getString((String)"switch.belong.cluster"));
        Cell portInfo = row.createCell(4);
        portInfo.setCellValue(ResourceUtil.getString((String)"switch.port"));
    }
}

