/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;

public final class TemplateFactory {
    private static final String UTF8ENCODE = "UTF-8";
    private static final String TEMPLATE_DICTIONARY = "/config/template/";
    private static final Configuration CONFIGURATION = new Configuration();
    private static final int MAX = 200;

    private TemplateFactory() {
    }

    public static String processorFtl(String ftlPath, Object data) {
        CharArrayWriter arrayWriter = new CharArrayWriter();
        try {
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)arrayWriter);
        }
        catch (TemplateException e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild. path is :" + ftlPath, (Throwable)e);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild. path is :" + ftlPath, (Throwable)e);
        }
        arrayWriter.flush();
        return arrayWriter.toString();
    }

    public static boolean processorFtl(String ftlPath, Object data, String outHtmlFilePath) {
        boolean flag = false;
        File file = new File(outHtmlFilePath);
        FileUtils.createDir((String)file.getParent());
        try (FileOutputStream fos = new FileOutputStream(outHtmlFilePath);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, ApplicationContext.APP_CHARSET);
             BufferedWriter writer = new BufferedWriter(osw);){
            Template template = CONFIGURATION.getTemplate(ftlPath, UTF8ENCODE);
            template.process(data, (Writer)writer);
            flag = true;
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild. path is :" + ftlPath, (Throwable)e);
        }
        catch (TemplateException e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("build freemarker template faild. path is :" + ftlPath, (Throwable)e);
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(TemplateFactory.class).error("the file path is null");
        }
        return flag;
    }

    static {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(TemplateFactory.class, TEMPLATE_DICTIONARY);
        MultiTemplateLoader loader = new MultiTemplateLoader(new TemplateLoader[]{classTemplateLoader});
        CONFIGURATION.setCacheStorage((CacheStorage)new MruCacheStorage(10, 200));
        CONFIGURATION.setLocale(Locale.getDefault());
        CONFIGURATION.clearEncodingMap();
        CONFIGURATION.setEncoding(Locale.CHINESE, UTF8ENCODE);
        CONFIGURATION.setTemplateLoader((TemplateLoader)loader);
    }
}

