/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.logic.result;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.inspect.entity.A800ExpansionDiskInfo;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Config;
import com.huawei.ism.tool.inspect.entity.ConstantField;
import com.huawei.ism.tool.inspect.entity.DiskDomain;
import com.huawei.ism.tool.inspect.entity.DstorageAfterCheckConfig;
import com.huawei.ism.tool.inspect.entity.DstoragePreCheckConfig;
import com.huawei.ism.tool.inspect.entity.Enclosure;
import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.entity.HyperHostResultEntry;
import com.huawei.ism.tool.inspect.entity.HyperQuoServerManualCheckItem;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.RetStatusEntry;
import com.huawei.ism.tool.inspect.entity.SummaryEntry;
import com.huawei.ism.tool.inspect.entity.SummaryResultEntry;
import com.huawei.ism.tool.inspect.entity.SummaryResultItem;
import com.huawei.ism.tool.inspect.entity.SummaryTotalResultEntry;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.logic.fusionstor.report.ReportDataManager;
import com.huawei.ism.tool.inspect.logic.result.AssortTypeEntry;
import com.huawei.ism.tool.inspect.logic.result.ExcelResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.ITreeViewResultBuilder;
import com.huawei.ism.tool.inspect.logic.result.TemplateFactory;
import com.huawei.ism.tool.inspect.logic.result.ZTreeNode;
import com.huawei.ism.tool.inspect.ui.logic.Strategy;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.inspect.utils.HtmlResUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.BarChartBuilder;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.OemUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class TreeViewResultBuilder
implements ITreeViewResultBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TreeViewResultBuilder.class);
    public static final int STATUS_DISABLE = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NOTOK = 1;
    public static final int STATUS_NOCHECK = 2;
    public static final int STATUS_NOSUPPORT = 3;
    public static final int STATUS_WARNING = 4;
    public static final int STATUS_MANUAL_CONFIRMATION = 5;
    public static final int STATUS_STOPPED = 6;
    public static final String STATUS_OK_STR = "success";
    public static final String STATUS_NOTOK_STR = "fail";
    public static final String STATUS_NOCHECK_STR = "nocheck";
    public static final String STATUS_NOSUPPORT_STR = "nosupport";
    public static final String STATUS_WARNING_STR = "warning";
    public static final String MANUAL_CONFIRMATION_STR = "manualconfirmation";
    private static final String LOG_COLLECT_FOLDER = File.separator + "log_collect" + File.separator;
    private static final String LOG_COLLECT_PATH = InspectContext.getInstance().getWorkPath() + LOG_COLLECT_FOLDER;
    private static final String DEST_FOLDER = File.separator + "dest";
    private static final String CONFIG_PATH = File.separator + "data" + File.separator + "config";
    private static final String MEMORY_INSPECT = "memory_inspect";
    private static final String UNDERLINE = "_";
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeViewResultBuilder.class);
    private InspectWorktaker workTaker;
    private String excelFileName = "";
    private boolean isDistribute;

    public TreeViewResultBuilder(InspectWorktaker workTaker) {
        this.workTaker = workTaker;
    }

    @Override
    public void buildLeftDeviceTree(Map<String, List<CheckDevNode>> checkDevs, File devTreeFile) {
        HashMap<String, String> data = new HashMap<String, String>();
        JSONArray zTreeNodes = new JSONArray();
        ZTreeNode coverNode = new ZTreeNode(HtmlResUtils.getString("lefttree.nodeone")).setUrl("head/cover.html").setOpen(true);
        ZTreeNode summaryNode = new ZTreeNode(HtmlResUtils.getString("lefttree.nodetwo")).setUrl("head/inspectCollect.html");
        ZTreeNode detailNode = new ZTreeNode(HtmlResUtils.getString("lefttree.nodef")).setParent(true);
        zTreeNodes.put((Object)coverNode).put((Object)summaryNode);
        this.buildTreeNodes(checkDevs, detailNode);
        zTreeNodes.put((Object)detailNode);
        if (InspectContext.getInstance().isFinishHyperManualCheck()) {
            zTreeNodes.put((Object)new ZTreeNode(HtmlResUtils.getString("collect.hypermanualcheck.nodetwo")).setUrl("summary/hyperHostResult.html"));
        }
        data.put("treeNodes", zTreeNodes.toString());
        TemplateFactory.processorFtl("devsTree.html", data, FilesUtil.getCanonicalPath((File)devTreeFile));
    }

    private static List<String> sortDevAndHost(Set<String> devSet) {
        ArrayList<String> keyList = new ArrayList<String>(devSet);
        Comparator compareByKey = String::compareTo;
        keyList.sort(compareByKey.reversed());
        ArrayList<String> resKeyList = new ArrayList<String>();
        for (String key : keyList) {
            if (key.toLowerCase(Locale.ENGLISH).startsWith("host")) {
                resKeyList.add(0, key);
                continue;
            }
            resKeyList.add(key);
        }
        return resKeyList;
    }

    private void buildTreeNodes(Map<String, List<CheckDevNode>> checkDevs, ZTreeNode detailNode) {
        List<String> keyList = TreeViewResultBuilder.sortDevAndHost(checkDevs.keySet());
        keyList.forEach(mapKey -> {
            List nodeList = (List)checkDevs.get(mapKey);
            if (null == nodeList || nodeList.isEmpty()) {
                return;
            }
            boolean integration = ((CheckDevNode)nodeList.get(0)).isIntegration();
            ZTreeNode typeNode = this.buildTypeNode((String)mapKey, integration);
            detailNode.addChildren(typeNode);
            nodeList.forEach(checkNode -> {
                if (!checkNode.isIntegration()) {
                    typeNode.addChildren(this.buildDevTreeNode((CheckDevNode)checkNode));
                    return;
                }
                ZTreeNode integrationTypeNode = this.buildIntegrationTypeNode((String)mapKey, (CheckDevNode)checkNode);
                typeNode.addChildren(integrationTypeNode);
                checkNode.getChildrens().forEach(childNode -> integrationTypeNode.addChildren(this.buildDevTreeNode((CheckDevNode)childNode)));
            });
        });
    }

    private ZTreeNode buildIntegrationTypeNode(String typeKey, CheckDevNode node) {
        return new ZTreeNode(typeKey).setUrl(String.format(Locale.ROOT, "summary/%s/%s.html", typeKey, node.getNodeName())).setParent(true);
    }

    private ZTreeNode buildTypeNode(String typeKey, boolean integration) {
        if (integration) {
            return new ZTreeNode(String.join((CharSequence)" ", typeKey, HtmlResUtils.getString("lefttree.nodetwo"))).setParent(true);
        }
        return new ZTreeNode(String.join((CharSequence)" ", typeKey, HtmlResUtils.getString("lefttree.nodetwo"))).setUrl(String.format(Locale.ROOT, "summary/%s.html", typeKey)).setParent(true);
    }

    private ZTreeNode buildDevTreeNode(CheckDevNode checkDevNode) {
        DevNode node = checkDevNode.getDevNode();
        String url = String.format(Locale.ENGLISH, "devs/%s/index.html", checkDevNode.getDevNode().getUuid());
        return new ZTreeNode(String.join((CharSequence)" ", InspectUtils.getDevNodeIpInReport(checkDevNode), node.getDeviceSerialNumber(), HtmlResUtils.getString("lefttree.nodethree"))).setUrl(url);
    }

    @Override
    public void buildCover(Map<String, List<CheckDevNode>> checkDevs, File coverFile) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("oemtool", InspectContext.getInstance().isOemOutTool());
        data.put("devs", checkDevs);
        data.put("logo", this.getLogoImageName());
        data.put("copyright", HtmlResUtils.getOEMString("cover.system.copyright"));
        data.put("company", HtmlResUtils.getOEMString("cover.company"));
        data.put("toolversion", UserOpDataSaveUtil.getViewVersion());
        data.put("date", UserOpDataSaveUtil.getToolIniProp((String)"date"));
        data.put("haveToolkitVersion", true);
        if (UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version") == null) {
            data.put("haveToolkitVersion", false);
            LOGGER.info("toolkitversion is null !");
        }
        data.put("toolkitversion", UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        data.put("releasedate", ApplicationContext.getInstance().getReleaseDate());
        String sceneInfo = System.getenv("jsonScene");
        if (SceneUtils.isSpecialScence((String)sceneInfo, (String[])new String[]{"Switch Inspector"})) {
            data.put("title", HtmlResUtils.getString("cover.highlighttitle.scene.switch"));
        } else if (SceneUtils.isSpecialScence((String)sceneInfo, (String[])new String[]{"Switch Quality Checks"})) {
            data.put("title", HtmlResUtils.getString("cover.highlighttitle.scene.switch.quality.checks"));
        } else {
            String string = InspectContext.getInstance().getSelectInspectType();
            SysConfiguration.getInstance();
            if (string.equals("timed_check") || InspectContext.getInstance().getSelectInspectType().equals("") || InspectContext.getInstance().getSelectInspectType().contains("T3000") || InspectContext.getInstance().getSelectInspectType().contains("UltraPath")) {
                data.put("title", HtmlResUtils.getString("cover.highlighttitle"));
            } else if (InspectUtils.isDistributedFrw()) {
                data.put("title", ResourceUtil.getString((String)"cover.pre.upgrade"));
            } else {
                data.put("title", HtmlResUtils.getString("cover.highlighttitle." + this.getInspectType()));
            }
        }
        data.put("genneratedate", this.dealDateStr(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss 'GMT'Z")));
        TemplateFactory.processorFtl("cover.html", data, FilesUtil.getCanonicalPath((File)coverFile));
    }

    private String dealDateStr(String dateStr) {
        String temp = ":" + dateStr.substring(dateStr.length() - 2, dateStr.length());
        StringBuffer str = new StringBuffer(dateStr);
        str.replace(dateStr.length() - 2, dateStr.length(), temp);
        return str.toString();
    }

    private String getLogoImageName() {
        String oem = OemUtils.getVender().toLowerCase(Locale.ENGLISH);
        if ("huawei".equals(oem)) {
            return "huaweilogo.jpg";
        }
        return "huaweisymanteclogo.gif";
    }

    @Override
    public void buildResult(Map<String, List<CheckDevNode>> checkDevs, File resultFolder, List<CheckDevNode> allCheckDevNode) {
        try {
            File devTreeFile = new File(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "device_tree.html");
            this.buildLeftDeviceTree(checkDevs, devTreeFile);
            File summaryFolder = new File(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "summary");
            FileUtils.createDir((File)summaryFolder);
            this.buildSummary(checkDevs, summaryFolder);
            File coverFile = new File(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "head" + File.separator + "cover.html");
            this.buildCover(checkDevs, coverFile);
            File inspectCollect = new File(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "head" + File.separator + "inspectCollect.html");
            this.buildColectResult(checkDevs, inspectCollect, allCheckDevNode);
            this.buildIndexPage(resultFolder);
            AbstractUserOpDataSev.copyLogInfo((File)resultFolder);
            if (InspectContext.getInstance().isInMemoryInspectionSence()) {
                List<String> snList = this.getSnList(allCheckDevNode);
                if (!Utils.isNullList(snList)) {
                    this.copyFileToReport(resultFolder, snList, allCheckDevNode);
                }
                this.deleteConfigDir(resultFolder);
            }
            String targetDir = resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "dsnodes";
            FileUtils.copyDir((String)ReportDataManager.DS_RESULT_PATH, (String)targetDir);
            this.buildItemTimeConsumptionFile(allCheckDevNode, targetDir + File.separator + "ItemTimeConsumption.json");
            FileUtils.copyDir((String)InspectUtils.getItemDumpTempPath(), (String)(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "record"));
            FileUtils.copyDir((String)ReportDataManager.DS_BUREAU_CHECK_RESULT_PATH, (String)(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "dsrecord"));
            this.copySwitchDetailInfo(resultFolder);
            FileUtils.deleteAllInFolder((String)ReportDataManager.DS_RESULT_PATH);
            FileUtils.deleteAllInFolder((String)ReportDataManager.DS_BUREAU_CHECK_RESULT_PATH);
        }
        catch (Throwable t) {
            LOGGER.error("build report failed,some thing is woring.", t);
        }
    }

    private void copySwitchDetailInfo(File resultFolder) throws IOException {
        File file = new File(ReportDataManager.DS_SWITCH_RESULT_PATH);
        if (!file.exists()) {
            return;
        }
        FileUtils.copyDir((String)ReportDataManager.DS_SWITCH_RESULT_PATH, (String)(resultFolder.getCanonicalPath() + File.separator + "data" + File.separator + "switch"));
    }

    private void deleteConfigDir(File resultFolder) {
        try {
            FileUtils.deleteFile((File)new File(resultFolder.getCanonicalPath() + CONFIG_PATH));
        }
        catch (IOException e) {
            log.error("Failed to delete the config folder. ", (Throwable)e);
        }
    }

    private void copyFileToReport(File resultFolder, List<String> snList, List<CheckDevNode> allCheckDevNode) {
        snList.forEach(sn -> {
            String resultDir = sn + UNDERLINE + System.currentTimeMillis();
            String sourceDir = this.getIp((String)sn, allCheckDevNode) + UNDERLINE + sn;
            try {
                FileUtils.copyDir((String)(LOG_COLLECT_PATH + sn), (String)(resultFolder.getCanonicalPath() + LOG_COLLECT_FOLDER + resultDir), (File[])((File[])Arrays.asList(new File(LOG_COLLECT_PATH + sn + DEST_FOLDER)).toArray()));
                FileUtils.copyDir((String)(resultFolder.getCanonicalPath() + CONFIG_PATH + File.separator + sourceDir), (String)(resultFolder.getCanonicalPath() + LOG_COLLECT_FOLDER + resultDir));
            }
            catch (IOException e) {
                log.error("Copy file to report failed. ", (Throwable)e);
            }
        });
    }

    private String getIp(String sn, List<CheckDevNode> allCheckDevNode) {
        return allCheckDevNode.stream().filter(checkDevNode -> checkDevNode.getDevNode().getDeviceSerialNumber().equals(sn)).map(checkDevNode -> checkDevNode.getDevNode().getIp()).findFirst().get();
    }

    private List<String> getSnList(List<CheckDevNode> allCheckDevNode) {
        SummaryEntry summaryEntry = this.createSummary(allCheckDevNode).stream().filter(this::isWarnOrErrorState).findFirst().orElse(new SummaryEntry());
        if (Utils.isNullList(summaryEntry.getResults())) {
            return new ArrayList<String>();
        }
        return summaryEntry.getResults().stream().filter(entry -> !entry.getErrorInfo().equals("")).map(entry -> entry.getCheckDevNode().getDevNode().getDeviceSerialNumber()).collect(Collectors.toList());
    }

    private boolean isWarnOrErrorState(SummaryEntry entry) {
        return entry.getResults().get(0).getRetItem().getItemId().equals(MEMORY_INSPECT) && (entry.getStat().contains(STATUS_WARNING_STR) || entry.getStat().contains(STATUS_NOTOK_STR));
    }

    private void buildItemTimeConsumptionFile(List<CheckDevNode> allCheckDevNode, String path) {
        JSONArray jsonArray = new JSONArray();
        allCheckDevNode.stream().filter(dev -> !VerifyUtil.isEmpty((Object)dev.getDevNode()) && dev.getDevNode().isDsStorage()).forEach(dev -> {
            JSONObject jsonObject = new JSONObject();
            JSONObject jsonItem = new JSONObject();
            String ip = dev.getDevNode().getIp();
            String deviceSerialNumber = dev.getDevNode().getDeviceSerialNumber();
            jsonObject.put(HtmlResUtils.getString("collect.devices.devip"), (Object)ip);
            jsonObject.put(HtmlResUtils.getString("collect.devices.devsn"), (Object)deviceSerialNumber);
            List<CheckItem> allCheckItem = InspectUtils.getAllCheckItem(dev);
            this.handleTimeTake(jsonItem, allCheckItem);
            jsonObject.put(HtmlResUtils.getString("detail.view.timeTake"), (Object)jsonItem);
            jsonArray.put((Object)jsonObject);
        });
        if (jsonArray.length() != 0) {
            StreamUtils.writeInfo2File((byte[])jsonArray.toString().getBytes(StandardCharsets.UTF_8), (String)path);
        }
    }

    private void handleTimeTake(JSONObject jsonItem, List<CheckItem> allCheckItem) {
        allCheckItem.forEach(item -> {
            long timeTake = 0L;
            ResultItem checkResult = item.getCheckResult();
            if (!VerifyUtil.isEmpty((Object)checkResult)) {
                timeTake = checkResult.getTimeTake();
            }
            jsonItem.put(item.getName(), timeTake);
        });
    }

    private List<SummaryResultEntry> buildSummaryResult(Map<String, List<CheckDevNode>> checkDevs) {
        HashMap<String, List<CheckDevNode>> checkDevsTable = new HashMap<String, List<CheckDevNode>>(checkDevs);
        ArrayList<String> keys = new ArrayList<String>(checkDevs.keySet());
        keys.forEach(key -> {
            List devs = (List)checkDevsTable.get(key);
            if (((CheckDevNode)devs.get(0)).isIntegration()) {
                checkDevsTable.remove(key);
                devs.forEach(dev -> checkDevsTable.put(key + "." + dev.getNodeName(), dev.getChildrens()));
            }
        });
        return checkDevsTable.entrySet().stream().map(this::buildSummaryResultEntry).collect(Collectors.toList());
    }

    private SummaryResultEntry buildSummaryResultEntry(Map.Entry<String, List<CheckDevNode>> entry) {
        List<CheckDevNode> devs = entry.getValue();
        String devType = "";
        if (!devs.isEmpty()) {
            devType = entry.getKey();
        }
        SummaryResultEntry summaryResultEntry = new SummaryResultEntry(devType);
        if (devs.stream().anyMatch(CheckDevNode::isDistributed)) {
            summaryResultEntry.setSummaryResultItems(this.buildSummaryResultItems(devs, TreeViewResultBuilder.collectDistributedItemParentNames(devs)));
            return summaryResultEntry;
        }
        summaryResultEntry.setSummaryResultItems(this.buildSummaryResultItems(devs, devs.get(0).getCheckItems().keySet()));
        return summaryResultEntry;
    }

    private static Set<String> collectDistributedItemParentNames(List<CheckDevNode> devs) {
        return devs.stream().map(CheckDevNode::getCheckItems).map(itemTable -> itemTable.entrySet().stream().filter(itemEntry -> !CheckItemUtils.isAllSubItemHidden((List)itemEntry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @NonNull
    private List<SummaryResultItem> buildSummaryResultItems(List<CheckDevNode> devs, Set<String> parentItemSet) {
        return parentItemSet.stream().map(parentItemName -> this.buildSummaryResultItem(devs, (String)parentItemName)).collect(Collectors.toList());
    }

    @NonNull
    private SummaryResultItem buildSummaryResultItem(List<CheckDevNode> devs, String parentItemName) {
        return new SummaryResultItem(parentItemName, this.calcTotalItemsNum(devs, parentItemName), this.calcTotalFailedItem(devs, parentItemName));
    }

    private int calcTotalItemsNum(List<CheckDevNode> devs, String parentCheckType) {
        return devs.stream().mapToInt(checkDevNode -> this.getParentCheckItemNum(parentCheckType, (CheckDevNode)checkDevNode)).sum();
    }

    private int calcTotalFailedItem(List<CheckDevNode> devs, String parentCheckType) {
        return devs.stream().mapToInt(checkDevNode -> this.getParentCheckItemFailedNum(parentCheckType, (CheckDevNode)checkDevNode)).sum();
    }

    private int getParentCheckItemFailedNum(String parentCheckType, CheckDevNode checkDevNode) {
        List<CheckItem> cItems = checkDevNode.getCheckItems().get(parentCheckType);
        int i = 0;
        if (null == cItems || cItems.isEmpty()) {
            return i;
        }
        for (CheckItem checkItem : cItems) {
            if (!checkItem.isEnable()) continue;
            if (checkItem.isSingleElement()) {
                i += null == checkItem.getCheckResult() || !checkItem.getCheckResult().isResultPass() ? 1 : 0;
                continue;
            }
            i += this.getItemFailedNum(checkItem);
        }
        return i;
    }

    private int getItemFailedNum(CheckItem checkItem) {
        ResultItem result = checkItem.getCheckResult();
        int i = 0;
        if (null == result) {
            ++i;
        } else {
            for (RItem ritem : result.getItems()) {
                i += ritem.isFailed() || ritem.isWarning() || ritem.isNoCheck() ? 1 : 0;
            }
        }
        return i;
    }

    private int getParentCheckItemNum(String parentCheckType, CheckDevNode checkDevNode) {
        List<CheckItem> cItems = checkDevNode.getCheckItems().get(parentCheckType);
        int i = 0;
        if (null == cItems || cItems.isEmpty()) {
            return i;
        }
        for (CheckItem checkItem : cItems) {
            if (!checkItem.isEnable()) continue;
            i += checkItem.getCheckSize();
        }
        return i;
    }

    private void buildIndexPage(File resultFolder) {
        File indexFile = new File(resultFolder, "index.html");
        TemplateFactory.processorFtl("index.html", new HashMap(0), FilesUtil.getCanonicalPath((File)indexFile));
    }

    @Override
    public void buildSummary(Map<String, List<CheckDevNode>> checkDevs, File summaryFileFolder) {
        ArrayList<String> types = new ArrayList<String>(checkDevs.keySet());
        ExcelResultBuilder exBuild = new ExcelResultBuilder();
        this.isDistribute = exBuild.buildNodeSnSummary(checkDevs);
        boolean expScene = InspectUtils.isPreExpEvaluation();
        for (String type : types) {
            List<CheckDevNode> typeDevs = checkDevs.get(type);
            if (null == typeDevs) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("expScene", expScene);
            data.put("title", HtmlResUtils.getString("summary.h1." + this.getInspectType()));
            CheckDevNode node = typeDevs.get(0);
            if (node.isIntegration()) {
                for (CheckDevNode typeDev : typeDevs) {
                    List<SummaryEntry> summarys = this.createSummary(typeDev.getChildrens());
                    data.put("summarys", summarys);
                    data.put("devs", typeDev.getChildrens());
                    data.put("type", typeDev.getNodeName());
                    data.put("title", HtmlResUtils.getString("summary.h1." + this.getInspectType()));
                    String resultPath = FilesUtil.getCanonicalPath((File)summaryFileFolder) + File.separator + type + File.separator + typeDev.getNodeName() + ".html";
                    TemplateFactory.processorFtl("collectByType4Integration.html", data, resultPath);
                }
                continue;
            }
            List<SummaryEntry> summarys = this.createSummary(typeDevs);
            data.put("summarys", summarys);
            data.put("devs", checkDevs.get(type));
            data.put("type", type);
            String resultPath = FilesUtil.getCanonicalPath((File)summaryFileFolder) + File.separator + type + ".html";
            exBuild.buildSummary(summarys, checkDevs.get(type), type);
            TemplateFactory.processorFtl("collectByType.html", data, resultPath);
        }
        this.hyperManualCheckSumamry(summaryFileFolder);
        try {
            String excelPath = summaryFileFolder.getParentFile().getParentFile().getCanonicalPath();
            if ("toolkitDC".equals(InspectUtils.getEnv("callTool"))) {
                excelPath = InspectContext.getInstance().getSilentWorkPath();
            }
            this.updateExcelFileName(excelPath);
            if (Objects.equals(this.excelFileName, "")) {
                this.excelFileName = exBuild.writeExcel(excelPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("get excelPath error.", (Throwable)e);
        }
    }

    void updateExcelFileName(String excelPath) {
        File[] files = new File(excelPath).listFiles();
        if (files == null) {
            return;
        }
        Arrays.stream(files).map(File::getName).filter(childName -> childName.contains("InspectorResult_") && childName.endsWith(".xls")).findFirst().ifPresent(name -> {
            this.excelFileName = name;
        });
    }

    private void hyperManualCheckSumamry(File summaryFileFolder) {
        if (InspectContext.getInstance().isFinishHyperManualCheck()) {
            List<HyperQuoServerManualCheckItem> hyperServerResultEntryList;
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
            List<HyperHostResultEntry> hyperHostResultEntryList = this.creatHyperHostResultEntryList();
            if (!hyperHostResultEntryList.isEmpty()) {
                data.put("hyperHostResultEntryList", hyperHostResultEntryList);
            }
            if (!(hyperServerResultEntryList = InspectContext.getServerItemListByContext()).isEmpty()) {
                data.put("hyperServerResultEntryList", hyperServerResultEntryList);
            }
            String resultPath = FilesUtil.getCanonicalPath((File)summaryFileFolder) + File.separator + "hyperHostResult.html";
            TemplateFactory.processorFtl("hyperHostResult.html", data, resultPath);
        }
    }

    private List<SummaryEntry> createSummary(List<CheckDevNode> list) {
        ArrayList<SummaryEntry> summarys = new ArrayList<SummaryEntry>();
        Product product = list.get(0).getProduct();
        boolean isold = product.isOld();
        int inspctCfgVer = product.getInspectCfgVersion();
        if (isold || inspctCfgVer > 1) {
            this.createOldSummary(list, summarys);
        } else {
            this.createSummary(list, summarys);
        }
        return summarys;
    }

    private void createSummary(List<CheckDevNode> list, List<SummaryEntry> summarys) {
        list.sort(Comparator.comparingInt(dev -> dev.getCheckItems().size()).reversed());
        Map<String, List<CheckItem>> checkItemTypes = list.get(0).getCheckItems();
        ArrayList<String> keyList = new ArrayList<String>(checkItemTypes.keySet());
        Map<String, List<CheckItem>> checkItemTypesNew = this.getNewCheckItems(checkItemTypes, keyList);
        this.conformCheckItems(list, keyList, checkItemTypesNew);
        int index = 1;
        for (String key : keyList) {
            List<CheckItem> checkItems = checkItemTypesNew.get(key);
            boolean rowSpaning = false;
            int rowSpan = (int)checkItems.stream().filter(checkItem -> !"HIDDEN".equals(checkItem.getTag()) && this.isItemNeedCount(list, (CheckItem)checkItem)).mapToLong(checkItem -> checkItem.getItems().size()).sum();
            for (CheckItem cmditem : checkItems) {
                if ("HIDDEN".equals(cmditem.getTag()) || !this.isItemNeedCount(list, cmditem)) continue;
                List<Item> items = cmditem.getItems();
                for (Item item : items) {
                    SummaryEntry summary = new SummaryEntry();
                    summary.setSerialNo(index++);
                    summary.setParentName(key);
                    summary.setRowSpaning(rowSpaning);
                    rowSpaning = true;
                    summary.setCheckName(item.getName());
                    if (InspectUtils.isPreExpEvaluation().booleanValue() && InspectContext.getInstance().getDevInfo().getWhiteItemList().contains(cmditem.getItemId())) {
                        summary.setImportance("high");
                    }
                    summary.setResults(this.calcResult(list, cmditem, item, key));
                    summary.setRowSpan(rowSpan);
                    summary.setLegalityPercents(this.getLegality(summary.getResults()));
                    summary.setFailedNum(this.getUnNormal(summary.getResults()));
                    summary.setStat(this.getStatusStr(summary.getResults()));
                    summarys.add(summary);
                }
            }
        }
    }

    private boolean isItemNeedCount(List<CheckDevNode> list, CheckItem checkItem) {
        return !this.isHiddenItem(checkItem, list.stream().findFirst().orElseGet(CheckDevNode::new));
    }

    private boolean isHiddenItem(CheckItem checkItem, CheckDevNode checkDevNode) {
        return this.isPreHiddenItem(checkItem, checkDevNode) || this.isAfterHiddenItem(checkItem, checkDevNode);
    }

    private boolean isAfterHiddenItem(CheckItem checkItem, CheckDevNode checkDevNode) {
        return DstorageAfterCheckConfig.INS.findMatchConfig(checkDevNode.getDevNode()).stream().flatMap(config -> config.getHiddenItemIds().stream()).anyMatch(itemId -> itemId.equals(checkItem.getItemId()));
    }

    private boolean isPreHiddenItem(CheckItem checkItem, CheckDevNode checkDevNode) {
        List<Config> matchConfigs = DstoragePreCheckConfig.INS.findMatchConfigs(checkDevNode.getDevNode());
        return matchConfigs.stream().anyMatch(config -> config.isHiddenCheckItem(checkItem));
    }

    private String getStatusStr(List<RetStatusEntry> results) {
        StringBuilder statusStrTmp = new StringBuilder();
        for (RetStatusEntry retStatusEntry : results) {
            String status = STATUS_NOCHECK_STR;
            switch (retStatusEntry.getStaus()) {
                case 0: {
                    status = STATUS_OK_STR;
                    break;
                }
                case 1: {
                    status = STATUS_NOTOK_STR;
                    break;
                }
                case 2: {
                    status = STATUS_NOCHECK_STR;
                    break;
                }
                case 3: {
                    status = STATUS_NOSUPPORT_STR;
                    break;
                }
                case 4: {
                    status = STATUS_WARNING_STR;
                    break;
                }
                case 5: {
                    status = MANUAL_CONFIRMATION_STR;
                    break;
                }
            }
            statusStrTmp.append(status);
        }
        return statusStrTmp.toString();
    }

    private void conformCheckItems(List<CheckDevNode> list, List<String> keyList, Map<String, List<CheckItem>> checkItemTypesNew) {
        for (int i = 1; i < list.size(); ++i) {
            Map<String, List<CheckItem>> checkItemTypesNextDev = list.get(i).getCheckItems();
            this.confirmSubCheckItems(keyList, checkItemTypesNew, checkItemTypesNextDev);
        }
    }

    private void confirmSubCheckItems(List<String> keyList, Map<String, List<CheckItem>> checkItemTypesNew, Map<String, List<CheckItem>> checkItemTypesNextDev) {
        for (String key : keyList) {
            List<CheckItem> checkItems = checkItemTypesNew.get(key);
            List<Object> checkItemsNew = new ArrayList();
            if (checkItemTypesNextDev.containsKey(key)) {
                checkItemsNew = checkItemTypesNextDev.get(key);
            }
            for (int j = 0; j < checkItemsNew.size(); ++j) {
                CheckItem checkItem = (CheckItem)checkItemsNew.get(j);
                String checkItemName = checkItem.getName();
                ArrayList<String> checkNamses = new ArrayList<String>();
                for (CheckItem check : checkItems) {
                    checkNamses.add(check.getName());
                }
                if (checkNamses.contains(checkItemName)) continue;
                checkItems.add(j, checkItem);
            }
        }
    }

    private Map<String, List<CheckItem>> getNewCheckItems(Map<String, List<CheckItem>> checkItemTypes, List<String> keyList) {
        LinkedHashMap<String, List<CheckItem>> checkItemTypess = new LinkedHashMap<String, List<CheckItem>>();
        for (String key : keyList) {
            ArrayList<CheckItem> value = new ArrayList<CheckItem>();
            List<CheckItem> checkItems = checkItemTypes.get(key);
            for (CheckItem checkItem : checkItems) {
                value.add(checkItem);
            }
            checkItemTypess.put(key, value);
        }
        return checkItemTypess;
    }

    List<RetStatusEntry> calcResult(List<CheckDevNode> list, CheckItem cmditem, Item item, String parentItemName) {
        ArrayList<RetStatusEntry> results = new ArrayList<RetStatusEntry>();
        for (CheckDevNode node : list) {
            CheckItem checkItem = InspectUtils.findCheckItem(node, cmditem, parentItemName);
            RetStatusEntry statusEntry = new RetStatusEntry();
            statusEntry.setCheckDevNode(node);
            statusEntry.setDevName(node.getNodeName());
            if (checkItem == null) {
                statusEntry.setStaus(-1);
                results.add(statusEntry);
                continue;
            }
            if (!checkItem.isEnable()) {
                statusEntry.setStaus(-1);
                results.add(statusEntry);
                statusEntry.setErrorInfo(checkItem.getErrorInfo());
                statusEntry.setRetItem(checkItem);
                continue;
            }
            ResultItem resultItem = checkItem.getCheckResult();
            if (node.isStop() || resultItem != null && resultItem.isStop()) {
                statusEntry.setStaus(6);
                results.add(statusEntry);
                statusEntry.setRetItem(checkItem);
                continue;
            }
            if (resultItem == null) {
                statusEntry.setStaus(2);
                results.add(statusEntry);
                continue;
            }
            if (this.checkStatusEntry(results, checkItem, statusEntry, resultItem)) continue;
            statusEntry.setErrorInfo(checkItem.getErrorInfo());
            statusEntry.setRetItem(checkItem);
            statusEntry.setCheckItemID(checkItem.getItemId());
            this.buildStatusEntry(statusEntry, resultItem, item);
            results.add(statusEntry);
        }
        return results;
    }

    private boolean checkStatusEntry(List<RetStatusEntry> results, CheckItem retItem, RetStatusEntry statusEntry, ResultItem ret) {
        if (retItem.isSingleElement()) {
            if (ret.isNoSupport()) {
                statusEntry.setStaus(3);
            } else if (ret.isNoCheck()) {
                statusEntry.setStaus(2);
            } else if (ret.isWarning()) {
                statusEntry.setStaus(4);
            } else if (ret.isManualConfirmation()) {
                statusEntry.setStaus(5);
            } else if (ret.getRecordStatus() == RecordStatus.STOPPED) {
                statusEntry.setStaus(6);
            } else if (ret.isNotPass()) {
                statusEntry.setStaus(1);
            } else {
                statusEntry.setStaus(0);
            }
            statusEntry.setErrorInfo(retItem.getErrorInfo());
            statusEntry.setRetItem(retItem);
            statusEntry.setCheckItemID(retItem.getItemId());
            results.add(statusEntry);
            return true;
        }
        return false;
    }

    private void buildStatusEntry(RetStatusEntry statusEntry, ResultItem ret, Item item) {
        RItem result = null;
        List<RItem> ritems = ret.getItems();
        if (ritems.isEmpty()) {
            statusEntry.setStaus(2);
            return;
        }
        for (RItem ritem : ritems) {
            if (!ritem.getItemId().equals(item.getId())) continue;
            result = ritem;
        }
        if (null == result) {
            statusEntry.setStaus(1);
        } else if (result.isNoSupport()) {
            statusEntry.setStaus(3);
        } else if (result.isFailed()) {
            statusEntry.setStaus(1);
        } else if (result.isNoCheck()) {
            statusEntry.setStaus(2);
        } else if (result.isWarning()) {
            statusEntry.setStaus(4);
        } else if (result.isManualConfirmation()) {
            statusEntry.setStaus(5);
        } else {
            statusEntry.setStaus(0);
        }
        if (result != null) {
            statusEntry.setRitemID(result.getItemId());
        }
    }

    private void createOldSummary(List<CheckDevNode> list, List<SummaryEntry> summarys) {
        if (null == list.get(0)) {
            LoggerFactory.getLogger(this.getClass()).error("Create old summary error. CheckDevNode is null! ");
            return;
        }
        Map<String, List<CheckItem>> checkItemTypes = list.get(0).getCheckItems();
        ArrayList<String> keyList = new ArrayList<String>(checkItemTypes.keySet());
        int serialNum = 1;
        for (String key : keyList) {
            List<CheckItem> checkItems = checkItemTypes.get(key);
            boolean rowSpaning = false;
            for (CheckItem item : checkItems) {
                SummaryEntry summary = new SummaryEntry();
                summary.setSerialNo(serialNum++);
                summary.setParentName(key);
                summary.setRowSpaning(rowSpaning);
                rowSpaning = true;
                summary.setCheckName(item.getName());
                if (InspectUtils.isPreExpEvaluation().booleanValue() && InspectContext.getInstance().getDevInfo().getWhiteItemList().contains(item.getItemId())) {
                    summary.setImportance("high");
                }
                summary.setResults(this.calcResult(list, item, key));
                summary.setRowSpan(checkItems.size());
                summary.setLegalityPercents(this.getLegality(summary.getResults()));
                summary.setFailedNum(this.getUnNormal(summary.getResults()));
                summary.setStat(this.getStatusStr(summary.getResults()));
                summarys.add(summary);
            }
        }
    }

    private String getLegality(List<RetStatusEntry> rets) {
        return rets.size() - this.getUnNormal(rets) + "/" + rets.size();
    }

    int getUnNormal(List<RetStatusEntry> rets) {
        return (int)rets.stream().filter(ret -> ret.getStaus() != 0 && ret.getStaus() != 3).count();
    }

    private List<RetStatusEntry> calcResult(List<CheckDevNode> list, CheckItem item, String parentItemName) {
        ArrayList<RetStatusEntry> results = new ArrayList<RetStatusEntry>();
        for (CheckDevNode node : list) {
            CheckItem retItem = InspectUtils.findCheckItem(node, item, parentItemName);
            ResultItem ret = retItem.getCheckResult();
            RetStatusEntry statusEntry = new RetStatusEntry();
            statusEntry.setCheckDevNode(node);
            statusEntry.setDevName(node.getNodeName());
            if (!retItem.isEnable()) {
                statusEntry.setStaus(-1);
            } else if (null == ret) {
                statusEntry.setStaus(1);
            } else if (ret.getRecordStatus() == RecordStatus.STOPPED) {
                statusEntry.setStaus(6);
            } else if (ret.isNormal()) {
                statusEntry.setStaus(0);
            } else if (ret.isNotPass()) {
                statusEntry.setStaus(1);
            } else if (ret.isNoCheck()) {
                statusEntry.setStaus(2);
            } else if (ret.isNoSupport()) {
                statusEntry.setStaus(3);
            } else if (ret.isManualConfirmation()) {
                statusEntry.setStaus(5);
            } else if (ret.isWarning()) {
                statusEntry.setStaus(4);
            }
            statusEntry.setErrorInfo(retItem.getErrorInfo());
            statusEntry.setRetItem(retItem);
            results.add(statusEntry);
        }
        return results;
    }

    @Override
    public void buildColectResult(Map<String, List<CheckDevNode>> checkDevs, File collectFile, List<CheckDevNode> allCheckDevNode) {
        checkDevs.values().forEach(this::escapeDeviceInfo);
        this.escapeDeviceInfo(allCheckDevNode);
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<CheckDevNode> devList = InspectUtils.getAllDevs(checkDevs);
        int specifaction = 10;
        List<CategoryDataset> categoryDatasets = this.createBarDataset(devList, 10);
        ArrayList<String> charFileNames = new ArrayList<String>();
        int i = 0;
        for (CategoryDataset dataSet : categoryDatasets) {
            String title = ResourceUtil.getString((String)"inspector.result.barchart.title") + (i + 1);
            JFreeChart chart = BarChartBuilder.createChart((CategoryDataset)dataSet, (String)title, (String)ResourceUtil.getString((String)"inspector.result.barchart.value"));
            String fileName = "chart " + i + ".gif";
            File chartFile = new File(FilesUtil.getCanonicalPath((File)collectFile.getParentFile()) + File.separator + "image" + File.separator + fileName);
            charFileNames.add(fileName);
            BarChartBuilder.writeChart2File((File)chartFile, (JFreeChart)chart);
            ++i;
        }
        ArrayList<CheckDevNode> checkedDevs = new ArrayList<CheckDevNode>();
        ArrayList<String> types = new ArrayList<String>(checkDevs.keySet());
        for (String type : types) {
            CheckDevNode typeDev = new CheckDevNode();
            typeDev.setNodeName(type);
            checkedDevs.add(typeDev);
            List<CheckDevNode> devs = checkDevs.get(type);
            for (CheckDevNode dev : devs) {
                checkedDevs.addAll(dev.getAllCheckNode());
            }
        }
        List<SummaryResultEntry> summaryResultEntries = this.buildSummaryResult(checkDevs);
        SummaryTotalResultEntry summaryTotalResultEntry = new SummaryTotalResultEntry(summaryResultEntries);
        data.put("summaryTotalResultEntry", summaryTotalResultEntry);
        data.put("summaryResultEntries", summaryResultEntries);
        data.put("devs1", InspectUtils.classifyDevsTypes(allCheckDevNode));
        data.put("devs", checkDevs);
        data.put("assortbytype", this.assortByType(checkDevs));
        data.put("chartfilenames", charFileNames);
        data.put("isBureau", this.isBureauCheck());
        data.put("title", HtmlResUtils.getString("collect.title." + this.getInspectType()));
        this.setToolLoggerFactory(collectFile, allCheckDevNode, data, checkedDevs);
    }

    private boolean isBureauCheck() {
        if (InspectUtils.isStartedByYingLong() && this.workTaker != null) {
            InspectScene inspectScene = this.workTaker.getInspectScene();
            return inspectScene == InspectScene.BUREAU_CHECK || inspectScene == InspectScene.BUREAU_CHECK_NFV;
        }
        return InspectContext.getInstance().isBureauCheck();
    }

    private String getInspectType() {
        if (InspectUtils.isStartedByYingLong() && this.workTaker != null) {
            return this.workTaker.getInspectScene().getReportScene();
        }
        return InspectContext.getInstance().getSelectInspectType().trim().split("[ ]")[0];
    }

    private void escapeDeviceInfo(List<CheckDevNode> allCheckDevNode) {
        if (Objects.isNull(allCheckDevNode)) {
            return;
        }
        allCheckDevNode.forEach(checkDevNode -> {
            checkDevNode.setNodeName(HtmlResUtils.escapeHtmlContent(checkDevNode.getNodeName()));
            if (Objects.isNull(checkDevNode.getDevNode())) {
                return;
            }
            checkDevNode.setComputeDev(ItDeviceType.COMPUTE_STORAGE.equals((Object)checkDevNode.getDevNode().getStorageDeviceType()));
            this.escapeDeviceInfo(checkDevNode.getDevNode());
        });
    }

    private void escapeDeviceInfo(DevNode devNode) {
        if (Objects.isNull(devNode)) {
            return;
        }
        devNode.setDeviceSerialNumber(HtmlResUtils.escapeHtmlContent(devNode.getDeviceSerialNumber()));
        devNode.setDeviceName(HtmlResUtils.escapeHtmlContent(devNode.getDeviceName()));
        devNode.setProductVersion(HtmlResUtils.escapeHtmlContent(devNode.getProductVersion()));
        devNode.setDeviceModel(HtmlResUtils.escapeHtmlContent(devNode.getDeviceModel()));
    }

    void setToolLoggerFactory(File collectFile, List<CheckDevNode> allCheckDevNode, Map<String, Object> data, List<CheckDevNode> checkedDevs) {
        this.initExpansionData(allCheckDevNode, data, checkedDevs);
        if (this.isMarkEnabled(checkedDevs)) {
            data.put("isMarkEnabled", "true");
            ToolLoggerFactory.getLogger(this.getClass()).info("orgin checkedDevs=" + checkedDevs);
            List<CheckDevNode> sortedCheckedDevs = this.getSortedNodes(checkedDevs);
            ToolLoggerFactory.getLogger(this.getClass()).info("sorted checkedDevs=" + sortedCheckedDevs);
            data.put("inspectDevices", sortedCheckedDevs);
        } else {
            data.put("inspectDevices", checkedDevs);
        }
        data.put("isDisturbite", String.valueOf(this.isDistribute));
        data.put("isFsExpansion", String.valueOf(InspectUtils.isFsExInspect()));
        data.put("excelFileName", this.excelFileName);
        data.put("inspectResult", ResourceUtil.getString((String)"collect.inspect.result"));
        TreeViewResultBuilder.writeSummaryDetailPage(collectFile, data);
    }

    private static void writeSummaryDetailPage(File collectFile, Map<String, Object> data) {
        try {
            if (SceneUtils.isA800SceneInTool() && InspectUtils.isPreExpEvaluation().booleanValue()) {
                TemplateFactory.processorFtl("A800ExpsionInfo.html", data, collectFile.getCanonicalPath());
                return;
            }
            TemplateFactory.processorFtl("inspectCollect.html", data, collectFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOGGER.error("get path error.", (Throwable)e);
        }
    }

    private void initExpansionData(List<CheckDevNode> allCheckDevNode, Map<String, Object> data, List<CheckDevNode> checkedDevs) {
        String jsonSceneArgsList = System.getenv("jsonSceneArgsList");
        if (jsonSceneArgsList == null) {
            return;
        }
        if (SceneUtils.isA800SceneInTool()) {
            this.initA800ExpansionData(data, checkedDevs, jsonSceneArgsList);
            return;
        }
        this.expExpResult(data, jsonSceneArgsList);
        this.expExpDoradoV6Result(data, allCheckDevNode);
    }

    private void initA800ExpansionData(Map<String, Object> data, List<CheckDevNode> checkedDevs, String sceneArgsListObj) {
        List<DiskDomain> poolDisks;
        List<Enclosure> enclosures;
        JSONObject sceneObj = new JSONObject(sceneArgsListObj);
        if (!"exInspect".equals(sceneObj.optString("effectiveScene"))) {
            return;
        }
        data.put("expModeOri", InspectContext.getInstance().getExpModeOri());
        List<A800ExpansionDiskInfo> a800ExpansionDiskInfosDiskInfos = InspectContext.getInstance().getExpansionA800DiskInfos();
        if (!a800ExpansionDiskInfosDiskInfos.isEmpty()) {
            data.put("expExpStrategyEnv", a800ExpansionDiskInfosDiskInfos);
        }
        if (!(enclosures = TreeViewResultBuilder.mergeA800EnclosureInfo(checkedDevs)).isEmpty()) {
            data.put("enclosures", enclosures);
        }
        if (!(poolDisks = TreeViewResultBuilder.mergeA800PoolInfos(checkedDevs)).isEmpty()) {
            data.put("poolDisks", poolDisks);
        }
        this.setNewHardwareBomInfo(data);
    }

    @NonNull
    private static List<DiskDomain> mergeA800PoolInfos(List<CheckDevNode> checkedDevs) {
        return checkedDevs.stream().map(CheckDevNode::getSmartPoolShowDiskList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @NonNull
    private static List<Enclosure> mergeA800EnclosureInfo(List<CheckDevNode> checkedDevs) {
        return checkedDevs.stream().map(CheckDevNode::getStatisticEncloureList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void expExpResult(Map<String, Object> data, String jsonSceneArgsList) {
        JSONObject jsonSceneArgsListObj = new JSONObject(jsonSceneArgsList);
        if ("exInspect".equals(jsonSceneArgsListObj.optString("effectiveScene"))) {
            ArrayList<DiskDomain> statisticDDList;
            ArrayList<Enclosure> statisticEncloureList;
            String encloMaxDepth;
            data.put("expModeOri", InspectContext.getInstance().getExpModeOri());
            int expCtrlOri = InspectContext.getInstance().getExpCtrlOri();
            if (expCtrlOri > 0) {
                data.put("expCtrlOri", expCtrlOri);
            }
            data.put("expCtrlEnv", InspectContext.getInstance().getExpCtrlEnv());
            ArrayList<Strategy> expStrategyList = InspectContext.getInstance().getExpStrategyList();
            if (expStrategyList != null && !expStrategyList.isEmpty()) {
                data.put("expExpStrategyEnv", expStrategyList);
            }
            if (!StringUtils.isNULLStr((String)(encloMaxDepth = InspectContext.getInstance().getEncloMaxDepth()))) {
                data.put("encloMaxDepth", encloMaxDepth);
            }
            if ((statisticEncloureList = InspectContext.getInstance().getStatisticEncloureList()) != null && !statisticEncloureList.isEmpty()) {
                data.put("statisticEncloureList", statisticEncloureList);
            }
            if ((statisticDDList = InspectContext.getInstance().getStatisticDDList()) != null && !statisticDDList.isEmpty()) {
                data.put("statisticDDList", statisticDDList);
            }
            this.setNewHardwareBomInfo(data);
            this.setSmartPoolDisk(data);
        }
    }

    private void setNewHardwareBomInfo(Map<String, Object> data) {
        if (!StringUtils.isNULLStr((String)InspectContext.getInstance().getCtrlBom())) {
            data.put("newCtrlBom", InspectContext.getInstance().getCtrlBom());
        }
        if (!StringUtils.isNULLStr((String)InspectContext.getInstance().getEncBom())) {
            data.put("newEncBom", InspectContext.getInstance().getEncBom());
        }
        if (!StringUtils.isNULLStr((String)InspectContext.getInstance().getInterfaceBom())) {
            data.put("newInterfaceBom", InspectContext.getInstance().getInterfaceBom());
        }
        if (!StringUtils.isNULLStr((String)InspectContext.getInstance().getInterfaceCardBom())) {
            data.put("newInterfaceBom", InspectContext.getInstance().getInterfaceCardBom());
        }
        if (!StringUtils.isNULLStr((String)InspectContext.getInstance().getDiskEnclosureBom())) {
            data.put("newDiskEnclosureBom", InspectContext.getInstance().getDiskEnclosureBom());
        }
    }

    private void setSmartPoolDisk(Map<String, Object> data) {
        ArrayList<DiskDomain> smartPoolShowDiskList = InspectContext.getInstance().getSmartPoolDisks();
        if (smartPoolShowDiskList != null && !smartPoolShowDiskList.isEmpty()) {
            data.put("smartPoolDisks", smartPoolShowDiskList);
        }
    }

    private void expExpDoradoV6Result(Map<String, Object> data, List<CheckDevNode> allCheckDevNode) {
        DeviceType deviceType;
        DevNode device = allCheckDevNode.get(0).getDevNode();
        if (device != null && device.getDeviceType() != null && ConstantField.DORADO_V6_DEV.contains((deviceType = device.getDeviceType()).toString().toUpperCase(Locale.ENGLISH))) {
            data.put("isDoradoV6", "true");
            LOGGER.info("is Dorado V6=true");
        }
    }

    private List<HyperHostResultEntry> creatHyperHostResultEntryList() {
        ArrayList<HyperHostResultEntry> hyperHostResultEntryList = new ArrayList<HyperHostResultEntry>();
        HashMap hostItemListMap = new HashMap();
        List<HyperHostManualCheckItem> hyperHostManualCheckItemList = InspectContext.getHostItemListByContext();
        for (HyperHostManualCheckItem hostItem : hyperHostManualCheckItemList) {
            String hostType = hostItem.getHostType();
            if (hostItemListMap.containsKey(hostType)) {
                ((List)hostItemListMap.get(hostType)).add(hostItem);
                continue;
            }
            ArrayList<HyperHostManualCheckItem> hostItemList = new ArrayList<HyperHostManualCheckItem>();
            hostItemList.add(hostItem);
            hostItemListMap.put(hostType, hostItemList);
        }
        if (null != hostItemListMap.keySet()) {
            for (String hostType : hostItemListMap.keySet()) {
                hyperHostResultEntryList.add(new HyperHostResultEntry(hostType, (List)hostItemListMap.get(hostType)));
            }
        }
        return hyperHostResultEntryList;
    }

    public boolean isMarkEnabled(List<CheckDevNode> checkedDevs) {
        for (CheckDevNode devNode : checkedDevs) {
            for (CheckItem item : InspectUtils.getAllCheckItem(devNode)) {
                if (!"true".equals(item.getEnableMark())) continue;
                return true;
            }
        }
        return false;
    }

    public List<CheckDevNode> getSortedNodes(List<CheckDevNode> checkDevs) {
        if (checkDevs == null || checkDevs.isEmpty()) {
            return checkDevs;
        }
        ArrayList<CheckDevNode> tempList = new ArrayList<CheckDevNode>();
        ArrayList<CheckDevNode> resultList = new ArrayList<CheckDevNode>();
        for (CheckDevNode node : checkDevs) {
            if (node.getDevNode() == null) {
                this.sortNode(tempList);
                resultList.addAll(tempList);
                tempList.clear();
                tempList.add(node);
                continue;
            }
            tempList.add(node);
        }
        this.sortNode(tempList);
        resultList.addAll(tempList);
        return resultList;
    }

    private void sortNode(List<CheckDevNode> nodes) {
        Collections.sort(nodes, new ScoreCompare());
    }

    private List<CategoryDataset> createBarDataset(List<CheckDevNode> devList, int specifaction) {
        int len = devList.size();
        ArrayList<CategoryDataset> categortys = new ArrayList<CategoryDataset>();
        int i = 0;
        while (i < len) {
            List<CheckDevNode> devs = null;
            int toIndex = i + specifaction;
            devs = toIndex < len ? devList.subList(i, toIndex) : devList.subList(i, len);
            i = toIndex;
            categortys.add(this.createBarDataset(devs));
        }
        return categortys;
    }

    private CategoryDataset createBarDataset(List<CheckDevNode> allDevs) {
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        for (CheckDevNode dev : allDevs) {
            categoryDataset.addValue((double)dev.getPassRate(), (Comparable)((Object)""), (Comparable)((Object)InspectUtils.getDevNodeIpInReport(dev)));
        }
        return categoryDataset;
    }

    private List<AssortTypeEntry> assortByType(Map<String, List<CheckDevNode>> checkDevs) {
        HashMap<String, List<CheckDevNode>> actualCheckDevs = new HashMap<String, List<CheckDevNode>>(checkDevs);
        ArrayList keys = new ArrayList(actualCheckDevs.keySet());
        for (String key : keys) {
            List devs = (List)actualCheckDevs.get(key);
            if (!((CheckDevNode)devs.get(0)).isIntegration()) continue;
            actualCheckDevs.remove(key);
            for (CheckDevNode checkdev : devs) {
                actualCheckDevs.put(checkdev.getNodeName(), checkdev.getChildrens());
            }
        }
        Set<Map.Entry<String, List<CheckDevNode>>> set = actualCheckDevs.entrySet();
        ArrayList<AssortTypeEntry> ret = new ArrayList<AssortTypeEntry>();
        this.traversalDevAndAddAssprtType(set, ret);
        return ret;
    }

    private void traversalDevAndAddAssprtType(Set<Map.Entry<String, List<CheckDevNode>>> set, List<AssortTypeEntry> ret) {
        for (Map.Entry<String, List<CheckDevNode>> entry : set) {
            List<CheckDevNode> devs = entry.getValue();
            String devType = "";
            if (!devs.isEmpty()) {
                devType = devs.get(0).getDevNode().getDeviceType().toString();
            }
            int passedSize = 0;
            for (CheckDevNode dev : devs) {
                if (!dev.inspectPassed()) continue;
                ++passedSize;
            }
            int allSize = devs.size();
            int notPassedSize = allSize - passedSize;
            AssortTypeEntry assortType = new AssortTypeEntry();
            assortType.setAllDevNum(allSize);
            assortType.setDevType(devType);
            assortType.setNotPassedFNum(notPassedSize);
            assortType.setPassedNum(passedSize);
            ret.add(assortType);
        }
    }

    @Generated
    public TreeViewResultBuilder() {
    }

    static class ScoreCompare
    implements Comparator<CheckDevNode>,
    Serializable {
        private static final long serialVersionUID = 5089678251203251830L;

        ScoreCompare() {
        }

        @Override
        public int compare(CheckDevNode node1, CheckDevNode node2) {
            if (node1.getDevNode() == null) {
                return -1;
            }
            if (node2.getDevNode() == null) {
                return 1;
            }
            Integer score1 = node1.getScore();
            Integer score2 = node2.getScore();
            if (score1 == null) {
                score1 = Integer.MAX_VALUE;
            }
            if (score2 == null) {
                score2 = Integer.MAX_VALUE;
            }
            return score1.compareTo(score2);
        }
    }
}

