/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.tool.ToolStartItem;
import com.huawei.ism.tool.framework.platform.common.tool.ToolType;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchUpgradeConfigCheck
extends AbstractTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchUpgradeConfigCheck.class);
    private static final Map<String, List<String>> FILTER_NODES = new HashMap<String, List<String>>();

    public boolean init() {
        if (InspectUtils.isBatchUpgradeScene()) {
            BatchUpgradeConfigCheck.initUpgradeConfig();
        }
        return true;
    }

    public ToolType getType() {
        return null;
    }

    public ToolStartItem getStartItem() {
        return null;
    }

    protected AbstractContext getContext() {
        return null;
    }

    public static List<String> getSelectedDpcIps(DevNode devNode) {
        return FILTER_NODES.getOrDefault(devNode.getIp() + devNode.getDeviceSerialNumber(), Collections.emptyList());
    }

    private static void initUpgradeConfig() {
        JSONArray objects;
        String confiFile = String.join((CharSequence)File.separator, ContextUtil.getToolBoxPath(), "temp", "sceneTemplates", "upgradeConfigDevice.json");
        File file = new File(confiFile);
        if (!file.exists()) {
            return;
        }
        String json = StreamUtils.readStringFormFile((File)file);
        try {
            objects = JSON.parseArray((String)json);
        }
        catch (JSONException e) {
            log.error("dpc config parse abnormal", (Throwable)e);
            return;
        }
        for (int i = 0; i < objects.size(); ++i) {
            JSONObject jsonObject = objects.getJSONObject(i);
            String deviceId = jsonObject.getString("id");
            JSONArray dpcList = jsonObject.getJSONArray("selectDpcList");
            if (StringUtils.isEmpty((CharSequence)deviceId) || Objects.isNull(dpcList)) {
                log.warn("device init selected upgrade node failed :{}", (Object)deviceId);
                continue;
            }
            FILTER_NODES.put(deviceId, BatchUpgradeConfigCheck.getSelectDpcNodes(dpcList));
        }
    }

    private static List<String> getSelectDpcNodes(JSONArray dpcList) {
        ArrayList<String> selectDpcIpList = new ArrayList<String>();
        for (int j = 0; j < dpcList.size(); ++j) {
            JSONObject dpcNode = dpcList.getJSONObject(j);
            if (!dpcNode.getBoolean("selected").booleanValue()) continue;
            selectDpcIpList.add(dpcNode.getString("ip"));
        }
        return selectDpcIpList;
    }
}

