/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.utils.FileHostUtils;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.InspectUserOpData;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.ui.action.StartInspectorAction;
import com.huawei.ism.tool.inspect.ui.dialogs.ExitDialog;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.Jump2InfoCollUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.json.JSONUtils;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseObserver
implements IWizardClosingObserver {
    private static final long serialVersionUID = -6430387090241396515L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseObserver.class);
    private static final String DEVICELIST_PATH = ContextUtil.getToolBoxPath() + File.separator + "temp" + File.separator + "sceneTemplates";
    private static final String INSPECT_RESULT_FILE_NAME = "upgradeBatchPreInspect.json";
    private ToolWizardDialog wizardDialog;
    private String[] jumpParams = null;

    public CloseObserver(ToolWizardDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public void onClose() {
        this.doCloseWizard();
    }

    private void doCloseWizard() {
        WarningDialog dialog;
        LOGGER.info("click closeButton to close tool");
        if (InspectUIUtil.getCardIndex(CardModelEnum.PERFORMINSPECT) == this.wizardDialog.getCurrentCard().getStep() && 0 != (dialog = DialogUtils.showYesNoDialog((Window)this.wizardDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.cancelconfirm"))).getValue()) {
            InspectContext.getInstance().getMainDialog().setDefaultCloseOperation(0);
            return;
        }
        try {
            if (!InspectContext.getInstance().isBackgroundMode()) {
                this.callbackScene();
            }
            this.callbackUserData();
            this.closeWizard();
        }
        finally {
            Runtime.getRuntime().halt(0);
        }
    }

    private void removeAllDstorageInspectPatch() {
        try {
            DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(DevNode::isDsStorage).forEach(devNode -> Context.INS.uninstallAutoImportPatch(devNode, DstoragePatchInfo.Type.INSPECT, null));
        }
        catch (Throwable e) {
            LOGGER.error("Remove All Dstorage InspectPatch error.", e);
        }
    }

    private void callbackUserData() {
        List<InspectUserOpData> userList = InspectContext.getInstance().getUseropList();
        boolean openFile = InspectContext.getInstance().isOpenHelpFile();
        if (!userList.isEmpty()) {
            for (InspectUserOpData inspectUserOpData : userList) {
                Long taskEndTime = inspectUserOpData.getTaskEndTime();
                if (taskEndTime == 0L) {
                    inspectUserOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis((Date)new Date()));
                }
                inspectUserOpData.setOpenHelpFile(openFile);
            }
        }
        UserOpDataSaveUtil.batchSaveUserOpdata(userList);
    }

    private void closeWizard() {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        AsyncExcutor.execute((ProgressDialog)new ProgressDialog((Window)mainDialog, ResourceUtil.getString((String)"inspect.closeobs.clearenv"), 220), (boolean)true, (long)60000L, (Callable[])new Callable[]{() -> {
            this.removeAllDstorageInspectPatch();
            InspectContext.getInstance().destroyContext();
            DefaultNodeProviderImpl.getInstance().removeNodeObserver(SelectDeviceCard.class);
            return true;
        }});
        mainDialog.dispose();
    }

    private void writeHostToXml() {
        try {
            List hostdevs;
            String sceneInfo = System.getenv("jsonScene");
            if (SceneUtils.isSpecialScence((String)sceneInfo, (String[])InspectConstans.mainScene()) && !(hostdevs = DefaultNodeProviderImpl.getInstance().getHostNodeList()).isEmpty()) {
                List devs = EntityUtils.toNewDevList((List)hostdevs);
                FileHostUtils.writeDevNodeToSceneFile((List)devs);
            }
        }
        catch (Exception e) {
            LOGGER.error("write host file Error!");
        }
    }

    public void onComplete() {
        LOGGER.info("click onComplete to close tool");
        try {
            if (this.checkScene()) {
                if (InspectUtils.callPatch()) {
                    this.secondPatch();
                } else {
                    this.secondInfoColl();
                }
            }
            if (!InspectContext.getInstance().isBackgroundMode()) {
                this.callbackScene();
            }
            this.callbackUserData();
            this.writeHostToXml();
            this.closeWizard();
        }
        finally {
            Runtime.getRuntime().halt(0);
        }
    }

    private boolean checkScene() {
        return !SceneUtils.isScene() && !InspectContext.getInstance().getSelectInspectType().contains("T3000") && !InspectContext.getInstance().getSelectInspectType().contains("UltraPath");
    }

    private void secondPatch() {
        WarningDialog wdlg2;
        JDialog currDialog = InspectContext.getInstance().getMainDialog();
        Jump2InfoCollUtils jumpUtil = new Jump2InfoCollUtils();
        this.jumpParams = new String[]{jumpUtil.buildSetEnvString(InspectContext.getInstance().getHotPatchVersionWarningDevs())};
        WarningDialog wdlg1 = DialogUtils.showYesNoDialog((Window)currDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.choose.patch.1"), (String)ResourceUtil.getString((String)"inspsctor.wizard.selectitem.debugset.btnok"), (String)ResourceUtil.getString((String)"inspsctor.wizard.selectitem.debugset.btncan"), (int)80, (int)80, (int)34);
        if (0 == wdlg1.getValue() && 0 == (wdlg2 = DialogUtils.showYesNoDialog((Window)currDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.performinspect.choose.patch.2"), (String)ResourceUtil.getString((String)"inspsctor.wizard.selectitem.debugset.btnok"), (String)ResourceUtil.getString((String)"inspsctor.wizard.selectitem.debugset.btncan"), (int)40, (int)40)).getValue()) {
            currDialog.setVisible(false);
            this.buildJumpPathInfo("inspector-patch", this.jumpParams);
        }
    }

    private void secondPatchInScene(List<Map<String, String>> resultList) {
        this.secondPatch();
        this.buildSceneJumpInfo(this.jumpParams, resultList);
    }

    private void buildSceneJumpInfo(String[] params, List<Map<String, String>> resultList) {
        ApplicationContext appContext = ApplicationContext.getInstance();
        String sceneDataPathFile = appContext.getWorkPath().substring(0, appContext.getWorkPath().lastIndexOf("tools")) + File.separator + "temp" + File.separator + "sceneTemplates" + File.separator + "devicedatafile";
        this.saveAnotherToolLabel(sceneDataPathFile, params);
        HashMap<String, String> dynamicStepMap = new HashMap<String, String>();
        dynamicStepMap.put("toolShowInfo", "installPath");
        dynamicStepMap.put("infoUrl_id", "patch");
        dynamicStepMap.put("type", "tool");
        dynamicStepMap.put("title_en", "Install Patch");
        dynamicStepMap.put("title_zh", "\u5b89\u88c5\u8865\u4e01");
        resultList.add(dynamicStepMap);
    }

    private void buildJumpPathInfo(String jumpTool, String[] params) {
        try {
            String jumpFilePath = StartInspectorAction.FILEPATH + File.separator + "anothertool";
            String devDataPathFile = StartInspectorAction.FILEPATH + File.separator + "devicedatafile";
            this.saveAnotherToolLabel(jumpFilePath, jumpTool);
            this.saveAnotherToolLabel(devDataPathFile, params);
        }
        catch (RuntimeException e) {
            LOGGER.error("start inspector-patch error.", (Throwable)e);
        }
    }

    private void secondInfoColl() {
        List<CheckDevNode> devs = this.getTransmissionDevs();
        if (devs.isEmpty()) {
            return;
        }
        if (!InspectUtils.existTool("collect")) {
            return;
        }
        JDialog currDialog = InspectContext.getInstance().getMainDialog();
        ExitDialog wdlg = ExitDialog.showExitDialog(currDialog, ResourceUtil.getString((String)"inspsctor.wizard.performinspect.info"), ResourceUtil.getString((String)"inspsctor.wizard.performinspect.choose"));
        if (0 == wdlg.getValue()) {
            currDialog.setVisible(false);
            ArrayList<DevNode> failDevNodes = new ArrayList<DevNode>();
            for (CheckDevNode dev : devs) {
                failDevNodes.add(dev.getDevNode());
            }
            Jump2InfoCollUtils jumpUtil = new Jump2InfoCollUtils();
            this.jumpParams = new String[]{jumpUtil.buildSetEnvString(failDevNodes)};
            this.buildJumpPathInfo("inspector-collect", this.jumpParams);
            this.saveSceneFileToInfoCollectTool();
        }
    }

    private void saveSceneFileToInfoCollectTool() {
        String filePath = String.join((CharSequence)File.separator, com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getCurrWorkPath(), "tools", "collect", "temp");
        File tempDir = new File(filePath);
        if (!tempDir.exists()) {
            FileUtils.createDir((String)filePath);
        }
        this.saveAnotherToolLabel(String.join((CharSequence)File.separator, filePath, "anothertool"), "inspector-collect");
    }

    private void saveAnotherToolLabel(String path, String ... params) {
        File file = new File(path);
        if (!this.mkDir(path, file)) {
            return;
        }
        try (FileOutputStream fileout = new FileOutputStream(file);
             OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)fileout, Charset.forName("utf-8"));
             BufferedWriter writer = new BufferedWriter(outWriter);){
            for (String str : params) {
                writer.write(str.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error("write file error.", (Throwable)e);
        }
    }

    private boolean mkDir(String path, File file) {
        try {
            if (!file.exists() && !file.createNewFile()) {
                LOGGER.error("create file error." + path);
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error("create file error." + path, (Throwable)e);
            return false;
        }
        return true;
    }

    private synchronized List<CheckDevNode> getTransmissionDevs() {
        InspectWorktaker worktaker = InspectContext.getInstance().getInspectWorktaker();
        ArrayList<CheckDevNode> checkNotPassedDevs = new ArrayList<CheckDevNode>();
        List checkDevs = (List)worktaker.get("check_dev_nodes");
        ArrayList<CheckDevNode> checkDevsPassedHost = new ArrayList<CheckDevNode>();
        DevNode node = null;
        for (CheckDevNode checkDev : checkDevs) {
            node = checkDev.getDevNode();
            if (!this.isNeedFilterDev(node, checkDev)) continue;
            checkDevsPassedHost.add(checkDev);
        }
        this.dealCheckNotPassedDevs(worktaker, checkNotPassedDevs, checkDevsPassedHost);
        return checkNotPassedDevs;
    }

    boolean isNeedFilterDev(DevNode node, CheckDevNode checkDev) {
        return node != null && !ItDeviceType.Host.equals((Object)node.getItDeviceType()) && !ItDeviceType.Switch.equals((Object)node.getItDeviceType()) && !node.isFusionCube() && !node.isA3000() && !InspectUtils.isCyberEngineDev(checkDev);
    }

    private void dealCheckNotPassedDevs(InspectWorktaker worktaker, List<CheckDevNode> checkNotPassedDevsDevs, List<CheckDevNode> checkDevs) {
        for (CheckDevNode checkDevNode : checkDevs) {
            this.loopDealCheckNotPassedDevsDevs(worktaker, checkNotPassedDevsDevs, checkDevNode);
        }
    }

    private void loopDealCheckNotPassedDevsDevs(InspectWorktaker worktaker, List<CheckDevNode> checkNotPassedDevsDevs, CheckDevNode checkDevNode) {
        if (!this.checkCanFarword(worktaker, checkDevNode)) {
            LOGGER.error(checkDevNode.toString() + " can't forword.");
            return;
        }
        this.setCheckNotPassedDevsDevs(checkNotPassedDevsDevs, checkDevNode);
    }

    private void setCheckNotPassedDevsDevs(List<CheckDevNode> checkNotPassedDevsDevs, CheckDevNode checkDevNode) {
        int faultNum = 0;
        for (CheckDevNode dev : checkDevNode.getAllCheckNode()) {
            faultNum += InspectUtils.checkFaultItemNum(dev);
        }
        if (faultNum > 0) {
            this.addCheckNotPassedDevsDevs(checkNotPassedDevsDevs, checkDevNode);
        }
    }

    private void addCheckNotPassedDevsDevs(List<CheckDevNode> checkNotPassedDevsDevs, CheckDevNode checkDevNode) {
        if (checkDevNode.isIntegration()) {
            checkNotPassedDevsDevs.add(checkDevNode.getAllCheckNode().get(0));
        } else {
            checkNotPassedDevsDevs.add(checkDevNode);
        }
    }

    private boolean checkCanFarword(InspectWorktaker worktaker, CheckDevNode checkDevNode) {
        List<CheckDevNode> canFarwordDevs = worktaker.getCanFarwordDevs();
        return this.loopCheckCanFarword(checkDevNode, canFarwordDevs);
    }

    private boolean loopCheckCanFarword(CheckDevNode checkDevNode, List<CheckDevNode> canFarwordDevs) {
        for (CheckDevNode canFarwordCheckDevNode : canFarwordDevs) {
            if (!checkDevNode.equals(canFarwordCheckDevNode)) continue;
            return true;
        }
        return false;
    }

    public String getListenerName() {
        return "closeInspectWizardListener";
    }

    private void callbackScene() {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        InspectWorktaker worktaker = InspectContext.getInstance().getInspectWorktaker();
        List checkDevs = (List)worktaker.get("check_dev_nodes");
        if (checkDevs == null || 0 == checkDevs.size()) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("toolId", "Inspect");
            result.put("status", "");
            result.put("SN", "");
            result.put("IP", "");
            result.put("fileName", "");
            resultList.add(result);
            InspectContext.getInstance().finishedSceneTask(resultList);
            return;
        }
        this.setResultList(resultList, checkDevs);
        this.recordInspectResult(checkDevs);
        if ((SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Daily Checks"}) || SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"Expansion Evaluation"}) || SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{"FRU Replacement"})) && InspectUtils.callPatch()) {
            this.secondPatchInScene(resultList);
        }
        InspectContext.getInstance().finishedSceneTask(resultList);
    }

    private void recordInspectResult(List<CheckDevNode> checkDevNodes) {
        if (!InspectUtils.isBatchUpgradeScene()) {
            return;
        }
        Map<String, String> map = checkDevNodes.stream().collect(Collectors.toMap(checkDevNode -> checkDevNode.getDevNode().getIp() + checkDevNode.getDevNode().getDeviceSerialNumber(), this::getInsepctRes, (res1, res2) -> res2));
        StreamUtils.writeStringFormFile(Collections.singletonList(JSONUtils.toJson(map)), (String)DEVICELIST_PATH, (String)INSPECT_RESULT_FILE_NAME);
    }

    private void setResultList(List<Map<String, String>> resultList, List<CheckDevNode> checkDevs) {
        for (CheckDevNode checkDevNode : checkDevs) {
            HashMap<String, String> result = new HashMap<String, String>();
            DevNode devNode = checkDevNode.getDevNode();
            if (checkDevNode.isIntegration()) {
                devNode = checkDevNode.getAllCheckNode().get(0).getDevNode();
            }
            if (devNode == null || ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
            String insepctRes = this.getInsepctRes(checkDevNode);
            if (checkDevNode.isIntegration()) {
                insepctRes = this.getInsepctResByN8000(checkDevNode);
            }
            String scene = InspectContext.getInstance().getExtendInspectScene();
            String msg = "insepctRes is %s . getExtendInspectScene is %s";
            LOGGER.info(String.format(Locale.ROOT, msg, insepctRes, scene));
            if (null != scene && insepctRes.equals(String.valueOf(TaskResult.Result.FAILED))) {
                this.buildResultInExpScene(result, checkDevNode);
            }
            if (InspectUtils.isDistributedFrw() && String.valueOf(TaskResult.Result.FAILED).equals(insepctRes)) {
                result.put("executeType", "0");
            }
            String ip = devNode.getIp();
            String sn = StringUtils.equalsIgnoreCase((CharSequence)devNode.getProductModel(), (CharSequence)"cdm") ? devNode.getIp() : devNode.getDeviceSerialNumber();
            result.put("status", insepctRes);
            result.put("fileName", "");
            result.put("SN", sn);
            result.put("IP", InspectUtils.dealWriteIpForCancelNode(insepctRes, ip));
            result.put("toolId", "Inspect");
            resultList.add(result);
        }
    }

    private void buildResultInExpScene(Map<String, String> result, CheckDevNode checkDevNode) {
        if (this.checkWhiteItems(checkDevNode)) {
            result.put("executeType", "0");
        } else {
            String sceneType = InspectContext.getInstance().getExpScene();
            if ("expCtrl".equals(sceneType)) {
                result.put("disabledStepList", "CheckHostStatus,Expansion,StorageDeploy,PostInspector");
            } else if ("expDisk".equals(sceneType)) {
                result.put("disabledStepList", "Expansion,PostInspector");
            } else if ("expLink".equals(sceneType)) {
                result.put("disabledStepList", "Expansion,PostInspector");
            } else if ("expDD".equals(sceneType)) {
                result.put("disabledStepList", "Expansion,PostInspector");
            } else if ("expScm".equals(sceneType)) {
                result.put("disabledStepList", "Expansion,PostInspector");
            }
        }
    }

    private String getInsepctRes(CheckDevNode checkDevNode) {
        String insepctRes = "";
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDevNode);
        if (null != ui && InspectStatus.EXEFALID.equals((Object)ui.getInspectStatus())) {
            return String.valueOf(TaskResult.Result.FAILED);
        }
        insepctRes = checkDevNode.isStop() ? String.valueOf(TaskResult.Result.FAILED) : (InspectUtils.haveNoCheckdItem(checkDevNode) > 0 ? String.valueOf(TaskResult.Result.CANCELED) : (InspectUtils.checkFaultItemNum(checkDevNode) == 0 ? String.valueOf(TaskResult.Result.SUCCESS) : String.valueOf(TaskResult.Result.FAILED)));
        return insepctRes;
    }

    private String getInsepctResByN8000(CheckDevNode checkDevNode) {
        ArrayList<String> insepctResList = new ArrayList<String>();
        this.getCheckDevNodeResByN8000(checkDevNode, insepctResList);
        int canceledNum = 0;
        int failedNum = 0;
        for (String insepctRes : insepctResList) {
            if (String.valueOf(TaskResult.Result.CANCELED).equals(insepctRes)) {
                ++canceledNum;
                continue;
            }
            if (!String.valueOf(TaskResult.Result.FAILED).equals(insepctRes)) continue;
            ++failedNum;
        }
        if (canceledNum > 0) {
            return String.valueOf(TaskResult.Result.CANCELED);
        }
        if (failedNum > 0) {
            return String.valueOf(TaskResult.Result.FAILED);
        }
        return String.valueOf(TaskResult.Result.SUCCESS);
    }

    private void getCheckDevNodeResByN8000(CheckDevNode checkDevNode, List<String> insepctResList) {
        List<CheckDevNode> childrens = checkDevNode.getChildrens();
        if (!InspectUtils.getAllCheckItem(checkDevNode).isEmpty()) {
            insepctResList.add(this.getInsepctRes(checkDevNode));
        }
        if (!childrens.isEmpty()) {
            for (CheckDevNode children : childrens) {
                this.getCheckDevNodeResByN8000(children, insepctResList);
            }
        }
    }

    private boolean checkWhiteItems(CheckDevNode checkDevNode) {
        if (InspectUtils.haveNoCheckdItem(checkDevNode) > 0) {
            return true;
        }
        List<CheckItem> items = InspectUtils.getAllCheckItem(checkDevNode);
        ArrayList<String> whiteItemList = InspectContext.getInstance().getDevInfo().getWhiteItemList();
        for (CheckItem item : items) {
            String itemId = item.getItemId();
            if (!whiteItemList.contains(itemId) || !item.getCheckResult().isFailed()) continue;
            return false;
        }
        return true;
    }
}

