/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DumpItemEntity;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.entity.TaskExecutResult;
import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.config.TagCondition;
import com.huawei.ism.tool.inspect.logic.inspector.InspectExecuter;
import com.huawei.ism.tool.inspect.service.implement.PreInspectCheck;
import com.huawei.ism.tool.inspect.service.implement.TaskBase;
import com.huawei.ism.tool.inspect.ui.dialogs.HeadLessJudgeProgressDialog;
import com.huawei.ism.tool.inspect.ui.logic.ExecuteTaskProgressObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.PatchImport;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.patch.dstorage.service.BatchPatchImportImp;
import com.huawei.ism.util.Pair;
import com.huawei.json.JSONUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTask
extends TaskBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteTask.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExecuteTask.class);
    private static final String REPORT_PREFIX = "InspectResult_";
    private static final String REPORT_POSTFIX = ".zip";
    private static final String BACK_SENCE = "sence";
    private static final String BACK_SENCE_BASIC_CONFIG = "basicConfig";
    private List<CheckDevNode> allCheckNodes = new ArrayList<CheckDevNode>();
    private String status = "waiting";
    private int currentProgress;
    private TaskExecutResult executResult = new TaskExecutResult();
    private List<CheckDevNode> finishedCheckNode = new ArrayList<CheckDevNode>();
    private List<DevNode> devNodes = new ArrayList<DevNode>();
    private ExecuteTaskProgressObserver uiObserver = new ExecuteTaskProgressObserver(this);

    public ExecuteTask() {
    }

    public ExecuteTask(TaskParams params) {
        super.setParams(params);
    }

    @Override
    public void run() {
        InspectContext.getInstance().setBackProcessRunning(true);
        try {
            this.execute();
        }
        catch (Exception e) {
            LOGGER.error("Run execInspectTask task failed.", (Throwable)e);
        }
        finally {
            InspectContext.getInstance().setBackProcessRunning(false);
            InspectContext.getInstance().setAllSilentTaskOver(true);
        }
    }

    private void prepare() {
        LOGGER.info("prepare before inspect...");
        this.initInspectScene();
        this.initReportFile();
        this.initDevNodes();
        this.initCheckDevNodes();
        this.preCheck();
        this.importPatch();
        this.uiObserver.updateFiledDev((List)this.worktaker.get("exception_dev_nodes"), ResourceUtil.getString((String)"start.inspection.failed.jsonerror"));
    }

    private void initReportFile() {
        this.worktaker.put("check_savepath", this.params.getWorkPath());
        String reportName = REPORT_PREFIX + StringUtils.formatDate((Object)Calendar.getInstance().getTime(), (String)"yyyyMMddHHmmss") + REPORT_POSTFIX;
        this.worktaker.put("check_savepath_filename", reportName);
    }

    private void initInspectScene() {
        this.context.getIsScenesInspect().put("realTimed_check", true);
        this.context.getInspectWorktaker().put("select_sceneId", "realTimed_check");
    }

    private void initDevNodes() {
        this.devNodes = this.getDevListFromParams();
        this.uiObserver.init(this.devNodes);
        this.excludeUnsupportDevs(this.devNodes);
        this.worktaker.put("select_dev_nodes", this.devNodes);
    }

    private void importPatch() {
        List<TaskResult> taskResults = PatchImport.builder().checkDevNodes(this.allCheckNodes).build().autoImport();
        if (BatchPatchImportImp.isUploadFailed(taskResults)) {
            List failResults = taskResults.stream().filter(result -> !result.isTaskSuccess()).map(result -> {
                if (result.getResultObject() instanceof Pair) {
                    DevNode devNode = (DevNode)((Pair)result.getResultObject()).getKey();
                    return "ip:" + devNode.getIp() + ";desc:" + result.getErrorLocaleDescription();
                }
                DevNode devNode = (DevNode)result.getResultObject();
                return "ip:" + devNode.getIp() + ";desc:" + result.getErrorLocaleDescription();
            }).collect(Collectors.toList());
            LOGGER.warn("Some device import patch failed as follows:{}", failResults);
        }
    }

    private void initCheckDevNodes() {
        try {
            this.allCheckNodes = this.worktaker.loadProductConfigByDevNode();
            LOGGER.info("the backScene:{}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)System.getenv(BACK_SENCE)));
            this.allCheckNodes.forEach(checkDevNode -> {
                if (BACK_SENCE_BASIC_CONFIG.equals(System.getenv(BACK_SENCE))) {
                    String type = checkDevNode.getDevNode().isDsStorage() ? "distributedCheckItem" : "concentratedCheckItem";
                    this.filterConfigCheckItemFromCheckDevNode((CheckDevNode)checkDevNode, type);
                }
                LOGGER.info("remained checkItem:{}", (Object)checkDevNode.getCheckItems().toString());
            });
            LOGGER.info("Inspect checkdev size : {},report path : {} ", (Object)this.allCheckNodes.size(), (Object)this.params.getWorkPath());
        }
        catch (ToolException e) {
            LOGGER.error("Unexpected error...", (Throwable)e);
        }
        this.filterCheckItems();
        this.worktaker.put("check_dev_nodes", this.allCheckNodes);
        this.worktaker.initDebugPwdDevsForNullReturn();
    }

    private void filterConfigCheckItemFromCheckDevNode(CheckDevNode checkDevNode, String type) {
        List<String> notMatchingCheckItemId;
        Map<String, List<CheckItem>> checkItemsId = checkDevNode.getCheckItems();
        List<String> checkItemsList = FusionStorageConfig.getTimingTaskCheckItemIdsMap().get(type);
        LOGGER.info("{} xml checkItemId:{}", (Object)type, (Object)checkItemsList.toString());
        this.removeSpecifiedCheckItemFromAllCheckItems(checkItemsId, checkItemsList);
        if (checkItemsId.isEmpty()) {
            LOGGER.info("float ip:{}all configurated checkItem in timing-task_check_item.xml are not matching, please check and retry!", (Object)checkDevNode.getDevNode().getIp());
        }
        if (!(notMatchingCheckItemId = this.findNotMatchingCheckItemId(checkItemsId, checkItemsList)).isEmpty()) {
            LOGGER.info("float ip:{}these configurated checkItem in timing-task_check_item.xml are not matching as follows:{}, please check!", (Object)checkDevNode.getDevNode().getIp(), (Object)String.join((CharSequence)",", notMatchingCheckItemId));
        }
    }

    private List<String> findNotMatchingCheckItemId(Map<String, List<CheckItem>> checkItemsId, List<String> concentratedCheckItemsList) {
        ArrayList<String> notMatchingCheckItemIds = new ArrayList<String>();
        concentratedCheckItemsList.forEach(concentratedCheckItem -> checkItemsId.keySet().forEach(checkItemType -> {
            if (((List)checkItemsId.get(checkItemType)).contains(concentratedCheckItem)) {
                notMatchingCheckItemIds.add((String)concentratedCheckItem);
            }
        }));
        return notMatchingCheckItemIds;
    }

    private void removeSpecifiedCheckItemFromAllCheckItems(Map<String, List<CheckItem>> checkItemsId, List<String> concentratedCheckItemsList) {
        checkItemsId.entrySet().forEach(entry -> {
            Iterator iter = ((List)entry.getValue()).iterator();
            while (iter.hasNext()) {
                CheckItem item = (CheckItem)iter.next();
                boolean hasSpecifiedCheckItemId = concentratedCheckItemsList.contains(item.getItemId());
                if (hasSpecifiedCheckItemId) continue;
                iter.remove();
                LOGGER.info("checkItemId remove a item,item id is {}.", (Object)item.getItemId());
            }
        });
    }

    private void preCheck() {
        try {
            PreInspectCheck preCheck = new PreInspectCheck(this.devNodes, this.devNodes, new HeadLessJudgeProgressDialog(null, 0));
            Object result = preCheck.call();
            LOGGER.info("PreInspectCheck result:{} ", result);
        }
        catch (Exception e) {
            LOGGER.error("PreInspectCheck call failed", (Throwable)e);
        }
    }

    private void updateAllCheckNodes() {
        List checkDevs = (List)this.getWorktaker().get("check_dev_nodes");
        for (CheckDevNode checkDevNode : checkDevs) {
            String sn;
            DevNode devNode = checkDevNode.getDevNode();
            if (!devNode.isDsStorage()) {
                return;
            }
            Map<String, String> nodesInfoMap = this.getParams().getNodesInfoMap();
            if (!nodesInfoMap.containsKey(sn = devNode.getDeviceSerialNumber())) continue;
            String nodes = nodesInfoMap.get(sn);
            List clusterNodes = devNode.getClusterNodes();
            LOGGER.info("Task select nodes is {}", (Object)nodes);
            if (StringUtils.isNULLStr((String)nodes) || clusterNodes == null || clusterNodes.isEmpty()) {
                return;
            }
            String[] nodeList = nodes.split(",");
            for (ClusterNode clusterNode : clusterNodes) {
                clusterNode.setSelected(false);
                for (String string : nodeList) {
                    if (!string.equals(clusterNode.getId() + "")) continue;
                    clusterNode.setSelected(true);
                }
            }
        }
    }

    private boolean execute() {
        List<CheckItem> expCheckItems;
        this.prepare();
        LOGGER.info("inspect task execute start!");
        InspectExecuter executor = new InspectExecuter(this.worktaker, this.uiObserver, this.params.getSelectItemsMap());
        this.updateAllCheckNodes();
        executor.startInspect();
        this.uiObserver.startScheduleUpdate();
        executor.waitResult(false);
        LOGGER.info("inspect task execute over!");
        if (executor.isRetFilewhether()) {
            this.executResult.setSuccess(false);
            this.executResult.setErrorMsg("performinspect.diskfull.view.res");
        } else if (executor.isConnectedDevEmpty()) {
            this.executResult.setSuccess(false);
            this.executResult.setErrorMsg("performinspect.noconnect.res");
        } else {
            this.executResult.setSuccess(true);
        }
        String sence = InspectContext.getInstance().getExtendInspectScene();
        if (sence != null && sence.equals("exInspect") && (expCheckItems = InspectContext.getInstance().getSilenceCallCheckItems()) != null && !expCheckItems.isEmpty()) {
            this.createResultFile(InspectContext.getInstance().getSilentWorkPath(), expCheckItems);
        }
        return true;
    }

    private void excludeUnsupportDevs(List<DevNode> devNodes) {
        ArrayList<DevNode> unSupportDevs = new ArrayList<DevNode>();
        Iterator<DevNode> iter = devNodes.iterator();
        while (iter.hasNext()) {
            DevNode dev = iter.next();
            boolean isSupport = this.context.isSupportDev(dev);
            if (isSupport) continue;
            iter.remove();
            unSupportDevs.add(dev);
            LOGGER.info("Device [{}] is not support inspection", (Object)dev.getIp());
        }
        this.uiObserver.updateFiledDev(unSupportDevs, ResourceUtil.getString((String)"silent.errmsg.unsupport"));
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCurrentProgress() {
        return String.valueOf(this.currentProgress);
    }

    public void setCurrentProgress(int currentProgress) {
        this.currentProgress = currentProgress;
    }

    private void filterCheckItems() {
        String scence = InspectContext.getInstance().getExtendInspectScene();
        if (scence != null && scence.equals("exInspect")) {
            this.filterExpCheckItems();
            return;
        }
        File file = new File(super.getParams().getTaskFile());
        if (!file.exists()) {
            LOGGER.info("No inspect task file exist...");
            return;
        }
        try {
            Document doc = XmlUtils.getSaxReader().read(file);
            Element root = doc.getRootElement();
            this.parseInspectItemsFile(root);
        }
        catch (Exception e) {
            LOGGER.error("Parse inspect task file error...", (Throwable)e);
        }
    }

    private void filterExpCheckItems() {
        List<CheckItem> expCheckItems = InspectContext.getInstance().getSilenceCallCheckItems();
        if (expCheckItems == null || expCheckItems.isEmpty()) {
            return;
        }
        for (CheckDevNode checkDevNode : this.allCheckNodes) {
            Map<String, List<CheckItem>> itemsMap = checkDevNode.getCheckItems();
            for (CheckItem checkItem : expCheckItems) {
                for (List<CheckItem> checkItems : itemsMap.values()) {
                    this.removeItem(checkItems, checkItem.getItemId());
                }
            }
        }
    }

    private void createResultFile(String filePath, List<CheckItem> expCheckItems) {
        String fileName = "checkItemResult.json";
        File resultFile = new File(filePath + File.separator + fileName);
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (resultFile.exists()) {
            resultFile.delete();
        }
        try {
            if (!resultFile.createNewFile()) {
                LOGGER.error("create new file error : " + resultFile.getName());
                return;
            }
        }
        catch (IOException ioe) {
            LOGGER.error("create result file failed", (Throwable)ioe);
        }
        JSONObject result = this.generateCheckResult(expCheckItems);
        this.writeResult(resultFile, result);
    }

    private void writeResult(File resultFile, JSONObject result) {
        try (FileOutputStream fos = new FileOutputStream(resultFile);
             OutputStreamWriter write = new OutputStreamWriter((OutputStream)fos, "UTF-8");){
            write.write(result.toJSONString());
            ((Writer)write).flush();
        }
        catch (Exception e) {
            LOGGER.error("write result json error :", (Throwable)e);
        }
    }

    private JSONObject generateCheckResult(List<CheckItem> expCheckItems) {
        JSONObject result = new JSONObject();
        try {
            for (CheckDevNode checkDevNode : this.allCheckNodes) {
                Map<String, List<CheckItem>> itemsMap = checkDevNode.getCheckItems();
                for (CheckItem expCheckItem : expCheckItems) {
                    for (List<CheckItem> checkItems : itemsMap.values()) {
                        this.setResult(checkItems, expCheckItem, result);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Read task queue file failed...", (Throwable)e);
        }
        return result;
    }

    private void setResult(List<CheckItem> checkItems, CheckItem expCheckItem, JSONObject resultItem) {
        for (CheckItem checkItem : checkItems) {
            if (!expCheckItem.getItemId().equals(checkItem.getItemId())) continue;
            JSONObject checkResult = new JSONObject();
            checkResult.put("name", (Object)checkItem.getName());
            checkResult.put("result", (Object)this.parseResult(checkItem.getCheckResult()));
            checkResult.put("expResult", (Object)expCheckItem.getExpResult());
            resultItem.put(checkItem.getItemId(), (Object)checkResult);
        }
    }

    private String parseResult(ResultItem resultItem) {
        String result = "";
        if (resultItem == null) {
            return result;
        }
        if (resultItem.isNoCheck()) {
            result = "2";
        } else if (resultItem.isNotPass()) {
            result = "1";
        } else if (resultItem.isNoSupport()) {
            result = "3";
        } else if (resultItem.isWarning()) {
            result = "4";
        } else if (resultItem.isManualConfirmation()) {
            result = "5";
        } else if (resultItem.isResultPass() && !resultItem.isNoSupport()) {
            result = "0";
        }
        return result;
    }

    private void removeItem(List<CheckItem> checkItems, String itemID) {
        Iterator<CheckItem> it = checkItems.iterator();
        while (it.hasNext()) {
            CheckItem checkItem = it.next();
            if (itemID.equals(checkItem.getItemId())) continue;
            it.remove();
        }
    }

    public void parseInspectItemsFile(Element ele) {
        Iterator itr = ele.elementIterator();
        while (itr.hasNext()) {
            Element deviceGroup = (Element)itr.next();
            Element subGroup = deviceGroup.element("deviceGroup");
            if (null != subGroup) {
                this.parseInspectItemsFile(deviceGroup);
                continue;
            }
            this.parseCheckItemsForDevice(deviceGroup);
        }
    }

    public void parseCheckItemsForDevice(Element ele) {
        Iterator devices;
        Iterator iterator = devices = ele.elementIterator("device");
        while (iterator.hasNext()) {
            Element device = (Element)iterator.next();
            String deviceIP = device.attributeValue("ip");
            CheckDevNode cdNode = this.getCheckNodeByIP(deviceIP);
            if (null == cdNode) continue;
            this.checkItemsOfDevNode(device, cdNode);
        }
    }

    private CheckDevNode getCheckNodeByIP(String ip) {
        for (CheckDevNode checkDevNode : this.allCheckNodes) {
            if (checkDevNode.isIntegration()) {
                CheckDevNode cdNode = this.getCheckNodeWhenIntegration(ip, checkDevNode);
                if (cdNode == null) continue;
                return cdNode;
            }
            if (!ip.equals(checkDevNode.getDevNode().getIp())) continue;
            return checkDevNode;
        }
        return null;
    }

    private CheckDevNode getCheckNodeWhenIntegration(String ip, CheckDevNode checkDevNode) {
        for (CheckDevNode cdNode : checkDevNode.getAllCheckNode()) {
            if (!ip.equals(cdNode.getDevNode().getIp())) continue;
            return cdNode;
        }
        return null;
    }

    private void checkItemsOfDevNode(Element device, CheckDevNode cdNode) {
        Map<String, List<CheckItem>> itemsMap = cdNode.getCheckItems();
        this.disableAllCheckItems(itemsMap.values());
        Iterator itr = device.elementIterator();
        while (itr.hasNext()) {
            Element itemGroup = (Element)itr.next();
            Iterator ite = itemGroup.elementIterator();
            while (ite.hasNext()) {
                Element item = (Element)ite.next();
                String itemName = item.attributeValue("name");
                String itemID = item.attributeValue("id");
                for (List<CheckItem> checkItems : itemsMap.values()) {
                    this.enableSelectedItem(itemName, itemID, checkItems);
                }
            }
        }
    }

    private void disableAllCheckItems(Collection<List<CheckItem>> itemsList) {
        for (List<CheckItem> items : itemsList) {
            for (CheckItem checkItem : items) {
                checkItem.setEnable(false);
            }
        }
    }

    private void enableSelectedItem(String itemName, String itemID, List<CheckItem> items) {
        for (CheckItem checkItem : items) {
            LOGGER.info("checkItem name: {}__xml checkItem name:", (Object)checkItem.getName(), (Object)itemName);
            if (!checkItem.getItemId().equals(itemID)) continue;
            checkItem.setEnable(true);
            break;
        }
    }

    @Override
    public void executeNormalTask() {
    }

    public void setAllFinished(boolean isAllFinished) {
    }

    public List<CheckDevNode> getFinishedCheckNode() {
        return this.finishedCheckNode;
    }

    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }

    public String buildItemJson() {
        this.initCheckNode();
        return JSONUtils.toJson(this.allCheckNodes.stream().peek(this::updateDumpResult).collect(Collectors.toMap(node -> node.getDevNode().getDeviceSerialNumber(), this::buildItemsFromNode, (node, repeatNode) -> node)));
    }

    private void updateDumpResult(CheckDevNode checkDevNode) {
        SilentProcessData silentProcessData = new SilentProcessData();
        silentProcessData.setProcess("100");
        silentProcessData.setStatus("finished");
        silentProcessData.setDevNode(EntityUtils.toNewDev((DevNode)checkDevNode.getDevNode()));
        this.uiObserver.updateSilentResult(silentProcessData);
    }

    private void initCheckNode() {
        this.initInspectScene();
        this.initDevNodes();
        this.initCheckDevNodes();
        this.uiObserver.updateFiledDev((List)this.worktaker.get("exception_dev_nodes"), ResourceUtil.getString((String)"dump.inspection.failed.jsonerror"));
    }

    private List<DumpItemEntity> buildItemsFromNode(CheckDevNode node) {
        if (node.isDistributed()) {
            String sceneId = this.context.getInspectWorktaker().getOrDefault("select_sceneId", "realTimed_check").toString();
            return this.buildDumpItems(node.getDstorageCheckItemsByScene(sceneId));
        }
        return this.buildDumpItems(node.getCheckItems());
    }

    private List<DumpItemEntity> buildDumpItems(Map<String, List<CheckItem>> checkItems) {
        return checkItems.keySet().stream().map(parent -> this.buildDumpEntity(checkItems, (String)parent)).collect(Collectors.toList());
    }

    private DumpItemEntity buildDumpEntity(Map<String, List<CheckItem>> checkItems, String parent) {
        return DumpItemEntity.builder().name(parent).children(this.buildChildren(checkItems.get(parent))).build();
    }

    private List<DumpItemEntity> buildChildren(List<CheckItem> checkItems) {
        return checkItems.stream().filter(item -> !TagCondition.hasTag(item.getTag(), "HIDDEN")).map(item -> DumpItemEntity.builder().checkItemId(item.getItemId()).name(item.getName()).build()).collect(Collectors.toList());
    }
}

