/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.devicemanager.service.dev.infoqry.FusionCubeInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionCubeAuthTask
extends ServiceTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionCubeAuthTask.class);
    private ProgressNumDialog progressDialog;
    private List<DevNode> devNodes;
    private User fusionCubeUser;
    private IDeviceOperaObserver deviceModifyObserver = null;
    private DefaultTableRow<String, String> tableRow;

    public FusionCubeAuthTask(ProgressNumDialog progressDialog, List<DevNode> devNodes, User fusionCubeUser, DefaultTableRow<String, String> tableRow) {
        this.progressDialog = progressDialog;
        this.devNodes = devNodes;
        this.fusionCubeUser = fusionCubeUser;
        this.tableRow = tableRow;
    }

    protected TaskResult doTask() {
        TaskResult ret = null;
        int count = 0;
        for (DevNode devNode : this.devNodes) {
            devNode.setFusionCubeUser(this.fusionCubeUser);
            this.updateRow(devNode, ResourceUtil.getString((String)"check.need.fusioncube.auth.status.authing"));
            ret = new FusionCubeInfoQryServiceImpl().queryBmcInfo(devNode);
            count = this.refreshProgress(count);
            this.deviceModifyObserver.observe(ret, devNode.getIp());
            if (Objects.nonNull(ret) && ret.getResult() == TaskResult.Result.SUCCESS) {
                this.updateRow(devNode, ResourceUtil.getString((String)"check.need.fusioncube.auth.status.authed"));
                continue;
            }
            this.updateRow(devNode, ResourceUtil.getString((String)"check.need.fusioncube.auth.status.auth.failed"));
        }
        return ret;
    }

    private void updateRow(DevNode devNode, String status) {
        if (this.tableRow == null) {
            return;
        }
        List<Object> row = this.buildData(devNode, status);
        this.tableRow.setValues(row);
    }

    private Object getFusionCubeAuthCell(DefaultTableRow<String, String> tableRow) {
        String operation = ResourceUtil.getString((String)"check.need.fusioncube.auth.button");
        return new IsmTableCell.HyperlinkCell(operation, ((IsmTableCell.HyperlinkCell)tableRow.getValueAt(tableRow.getColumnCount() - 1)).getAction());
    }

    private List<Object> buildData(DevNode dev, String status) {
        ArrayList<Object> row = new ArrayList<Object>();
        row.add(dev.getIp());
        row.add(dev.getDeviceSerialNumber());
        row.add(status);
        row.add(this.getFusionCubeAuthCell(this.tableRow));
        return row;
    }

    private int refreshProgress(int count) {
        int progressCount = count + 1;
        int progress = progressCount * 100 / this.devNodes.size();
        this.progressDialog.updateProgress(progress);
        return progressCount;
    }

    @Generated
    public ProgressNumDialog getProgressDialog() {
        return this.progressDialog;
    }

    @Generated
    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }

    @Generated
    public User getFusionCubeUser() {
        return this.fusionCubeUser;
    }

    @Generated
    public IDeviceOperaObserver getDeviceModifyObserver() {
        return this.deviceModifyObserver;
    }

    @Generated
    public DefaultTableRow<String, String> getTableRow() {
        return this.tableRow;
    }

    @Generated
    public void setProgressDialog(ProgressNumDialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    @Generated
    public void setDevNodes(List<DevNode> devNodes) {
        this.devNodes = devNodes;
    }

    @Generated
    public void setFusionCubeUser(User fusionCubeUser) {
        this.fusionCubeUser = fusionCubeUser;
    }

    @Generated
    public void setDeviceModifyObserver(IDeviceOperaObserver deviceModifyObserver) {
        this.deviceModifyObserver = deviceModifyObserver;
    }

    @Generated
    public void setTableRow(DefaultTableRow<String, String> tableRow) {
        this.tableRow = tableRow;
    }
}

