/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.listener.HookHandler;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.inspect.ui.action.StartInspectorAction;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.common.ToolThreadFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class InitInspect
extends HookHandler {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(InitInspect.class);
    private Thread initThread = null;

    public void initialization() {
        try {
            String sceneArg = SceneUtils.getParamFormArgList((String)"toolScene");
            if (sceneArg.equals("expansion_zk")) {
                LOGGER.info("zk expansion scene break initInspect");
                return;
            }
            ApplicationContext.getInstance().init();
            StartInspectorAction action = new StartInspectorAction();
            action.iniCustomizedResource();
            InspectConstans.getInstance().setStartInspectorAction(action);
            this.initThread = ToolThreadFactory.newDefaultThread((Runnable)new Thread((Runnable)action, "prepareInspect"));
            this.initThread.setPriority(10);
            this.initThread.start();
        }
        catch (Exception e) {
            LOGGER.error("Init inspect error. ", (Throwable)e);
            DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)ResourceUtil.getString((String)"inspsctor.hook.init.failed"));
            Runtime.getRuntime().halt(3);
        }
    }

    public void whenCheckPass() {
        LOGGER.info("Common basic bundle checkd pass.");
        InspectConstans.getInstance().getStartInspectStatus().set(1);
    }

    public void whenCheckNoPass(String faildDesc) {
        try {
            LOGGER.info("Common basic bundle not checkd pass. faild info :{}", (Object)faildDesc);
            InspectConstans.getInstance().setCbbCheckStr(faildDesc);
            InspectConstans.getInstance().getStartInspectStatus().set(2);
            if (this.initThread != null) {
                this.initThread.join();
            }
        }
        catch (Exception e) {
            LOGGER.error("Some thing is woring.", (Throwable)e);
            DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)ResourceUtil.getString((String)"inspsctor.hook.init.failed"));
            Runtime.getRuntime().halt(3);
        }
    }

    public void seriveFinish() {
        LOGGER.info("All commons serives are completed.");
        InspectConstans.getInstance().getStartInspectStatus().set(3);
    }
}

