/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import utils.Products;

public class InspectINodeSupport
implements INodeSupport {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(InspectContext.class);

    public boolean isNodeSupport(DevNode dev) {
        List<DeviceType> supportDevTypes;
        List<DeviceType> excludeDevTypes;
        Map<DeviceType, String> checkMap;
        boolean isSupport;
        boolean isT3000OrMutiPath;
        HashMap<String, Boolean> selectsecene = new HashMap<String, Boolean>();
        boolean bl = isT3000OrMutiPath = this.isT3000Device(dev) || this.isMutiPathDevice(dev);
        if (ItDeviceType.Host.equals((Object)dev.getItDeviceType())) {
            return this.isSupportHostDev(dev);
        }
        if (ItDeviceType.DStorage.equals((Object)dev.getItDeviceType()) || dev.isFusionCube() || dev.isA3000()) {
            return InspectContext.getInstance().isSupportDev(EntityUtils.toOldDev((DevNode)dev));
        }
        if (InspectUtils.isFsExInspect()) {
            LOGGER.info("This is FS expansion scene, {} not support.", (Object)dev.getIp());
            return false;
        }
        if (isT3000OrMutiPath) {
            selectsecene.putAll(InspectContext.getInstance().getIsScenesInspect());
            InspectContext.getInstance().getIsScenesInspect().put("realTimed_check " + dev.getItDeviceType().getName(), true);
            InspectContext.getInstance().getIsScenesInspect().put("realTimed_check", false);
        }
        if (!(isSupport = this.isDeviceTypeSupport(dev, checkMap = InspectContext.getInstance().getSupportModelVersions(), excludeDevTypes = InspectContext.getInstance().getExcludeTypes(), supportDevTypes = InspectContext.getInstance().getSupportTypes())) && isT3000OrMutiPath) {
            InspectContext.getInstance().getIsScenesInspect().clear();
            InspectContext.getInstance().getIsScenesInspect().putAll(selectsecene);
        }
        return isSupport;
    }

    private String checkSpace(String model) {
        byte[] tempByte = new byte[model.length()];
        int i = 0;
        int findCount = 0;
        int modelLen = model.getBytes(Charset.defaultCharset()).length;
        for (int index = 0; index < modelLen; ++index) {
            byte b = model.getBytes(Charset.defaultCharset())[index];
            if (b != 92) {
                tempByte[i] = b;
            } else if (index < modelLen && 115 == model.getBytes(Charset.defaultCharset())[index + 1]) {
                tempByte[i] = 32;
                ++index;
                ++findCount;
            }
            ++i;
        }
        return new String(tempByte, 0, tempByte.length - findCount, Charset.defaultCharset());
    }

    private boolean isDeviceTypeSupport(DevNode dev, Map<DeviceType, String> checkMap, List<DeviceType> excludeDevTypes, List<DeviceType> supportDevTypes) {
        boolean isSupport = true;
        if (!(isSupport = this.checkT3000ByScript(dev, checkMap, isSupport))) {
            return isSupport;
        }
        String tmpType = this.toLowerCaseWhenT3000(dev, dev.getDeviceType() + " " + dev.getProductVersion());
        Set<Map.Entry<DeviceType, String>> entrys = checkMap.entrySet();
        for (Map.Entry<DeviceType, String> entry : entrys) {
            if (!tmpType.contains(this.toLowerCaseWhenT3000(dev, entry.getKey().toString()))) continue;
            isSupport = this.checkStorageVersionByScript(dev, entry.getValue());
            break;
        }
        if (!isSupport) {
            return isSupport;
        }
        for (DeviceType devTpye : excludeDevTypes) {
            if (!tmpType.contains(this.toLowerCaseWhenT3000(dev, devTpye.toString().trim()))) continue;
            return false;
        }
        for (DeviceType devTpye : supportDevTypes) {
            String temp = this.checkSpace(devTpye.toString());
            if (!Products.contains((String)tmpType, (String)this.toLowerCaseWhenT3000(dev, temp.trim()))) continue;
            if (InspectContext.getInstance().getSelectSeceneInSecondCard().equals("") && InspectContext.getInstance().getSelectInspectType().contains("realTimed_check")) {
                InspectContext.getInstance().setSelectSeceneInSecondCard(InspectContext.getInstance().getSelectInspectType());
            }
            return true;
        }
        return false;
    }

    public boolean checkStorageVersionByScript(DevNode dev, String scriptPath) {
        HashMap<String, DevNode> paramMap = new HashMap<String, DevNode>();
        paramMap.put("dev", dev);
        File pyFile = new File(scriptPath);
        try {
            JythonExecuter jythonExecuter = new JythonExecuter();
            jythonExecuter.compileScript(pyFile);
            Object ret = jythonExecuter.simpleInvokeFunction("execute", paramMap);
            return (Boolean)ret;
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Check version error. py file {} not found.", (Object)pyFile.getName());
            return true;
        }
        catch (ToolException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.", (Throwable)e);
            return true;
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.", (Throwable)e);
            return true;
        }
    }

    private boolean checkT3000ByScript(DevNode dev, Map<DeviceType, String> checkMap, boolean isSupport) {
        if (this.isT3000Device(dev)) {
            String tmpType = (dev.getDeviceName() + " " + dev.getDeviceType()).toLowerCase(Locale.US);
            String script = null;
            Set<Map.Entry<DeviceType, String>> entrys = checkMap.entrySet();
            List<Object> pyInfo = null;
            for (Map.Entry<DeviceType, String> entry : entrys) {
                if (!tmpType.contains(entry.getKey().toString().toLowerCase(Locale.US))) continue;
                script = tmpType;
                pyInfo = this.checkVersionByScript(dev, entry.getValue());
                break;
            }
            if (script == null) {
                ToolLoggerFactory.getLogger(this.getClass()).info("supportloic script is null.devide type is:" + dev.getDeviceType());
            }
            return this.analysePyInfo(dev, isSupport, pyInfo);
        }
        return isSupport;
    }

    private boolean analysePyInfo(DevNode dev, boolean isSupport, List<Object> pyInfo) {
        boolean isSupportResult = isSupport;
        if (pyInfo != null) {
            isSupportResult = (Boolean)pyInfo.get(0);
            if (isSupportResult) {
                InspectContext.DEVNODE_TYPE.put(EntityUtils.toOldDev((DevNode)dev), (String)pyInfo.get(1));
            } else if (pyInfo.size() > 1) {
                dev.setErrorDecs((String)pyInfo.get(1));
            }
        }
        return isSupportResult;
    }

    public List<Object> checkVersionByScript(DevNode dev, String scriptPath) {
        try {
            ICliConnection con = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)dev), null, (boolean)true, (boolean)true);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
            paramMap.put("lang", language);
            paramMap.put("dev", (String)dev);
            paramMap.put("ssh", (String)con);
            File pyFile = new File(scriptPath);
            try {
                JythonExecuter jythonExecuter = new JythonExecuter();
                jythonExecuter.compileScript(pyFile);
                List ret = (List)jythonExecuter.simpleInvokeFunction("execute", paramMap);
                return ret;
            }
            catch (FileNotFoundException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Check version error. py file {} not found.", (Object)pyFile.getName());
                return null;
            }
            catch (ToolException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.", (Throwable)e);
                return null;
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Check version error.", (Throwable)e);
                return null;
            }
        }
        catch (ToolException e1) {
            ToolLoggerFactory.getLogger(this.getClass()).error("DefaultNodeTypeQuery.queryNodeInfo() error normal", (Throwable)e1);
            return null;
        }
    }

    private String toLowerCaseWhenT3000(DevNode dev, String str) {
        String temp = str;
        if (this.isT3000Device(dev)) {
            temp = temp.toLowerCase(Locale.US);
        }
        return temp;
    }

    public boolean isSupportHostDev(DevNode dev) {
        if (InspectContext.getInstance().isSupportHostDev(EntityUtils.toOldDev((DevNode)dev))) {
            if (!this.checkHostAllSupport(dev) && !InspectUtils.isDpaInspectScene()) {
                dev.setAddConfirmInfo(ResourceUtil.getString((String)"add.device.partialsupport.msg"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHostAllSupport(DevNode dev) {
        HashMap<String, String> envTemp = new HashMap<String, String>();
        String language = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        envTemp.put("lang", language);
        envTemp.put("logger", (String)LOGGER);
        envTemp.put("devInfo", (String)dev);
        String name = "execute";
        StringBuilder stringBuilder = new StringBuilder();
        InspectContext.getInstance();
        String pakagePath = stringBuilder.append(InspectContext.INSPECT_CONFPATH).append(File.separator).append("products").append(File.separator).append("HOST_Common").toString();
        String mergePyScriptPath = pakagePath + File.separator + "add_device_check.py";
        File mergePyScript = new File(mergePyScriptPath);
        File pakage = new File(pakagePath);
        if (!pakage.exists() || !mergePyScript.exists()) {
            return true;
        }
        JythonExecuter executor = new JythonExecuter(pakage);
        ICliConnection sshConnection = null;
        boolean poolhasSSH = SshConnectionManager.hasConnection((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)dev));
        try {
            sshConnection = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)EntityUtils.toOldDev((DevNode)dev));
            envTemp.put("ssh", (String)sshConnection);
            executor.compileScript(mergePyScript);
            List pyResult = executor.invokeFunction(name, envTemp);
            String executeRet = pyResult.get(0).toString();
            boolean bl = Boolean.valueOf(executeRet);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Execut whiteListCheck.py execute is error.", (Throwable)e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (!poolhasSSH) {
                SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
            }
        }
    }

    private boolean isT3000Device(DevNode dev) {
        return ItDeviceType.T3000.equals((Object)dev.getItDeviceType());
    }

    private boolean isMutiPathDevice(DevNode dev) {
        return ItDeviceType.UltraPath.equals((Object)dev.getItDeviceType());
    }
}

