/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.inspect.entity.HostInfo;
import com.huawei.ism.tool.inspect.entity.InspectPreCheckFailedInfo;
import com.huawei.ism.tool.inspect.entity.PyExecuteInfo;
import com.huawei.ism.tool.inspect.entity.StorageInfo;
import com.huawei.ism.tool.inspect.ui.componet.observer.ProcessStepObserver;
import com.huawei.ism.tool.inspect.ui.logic.AdanceCompileRemotePyScript;
import com.huawei.ism.tool.inspect.utils.InspectAsyncThreadFactory;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreInspectCheck
implements Callable<Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PreInspectCheck.class);
    private final InspectPreCheckFailedInfo inspectResult = new InspectPreCheckFailedInfo();
    private final List<DevNode> selectedDevNodeList;
    private final List<DevNode> allDevNodeList;
    private final ProcessStepObserver progressDialog;
    private final Map<File, List<DevNode>> requirePyDevNodeListMap = new HashMap<File, List<DevNode>>();
    ExecutorService taskExecutor = ThreadPoolHelper.getFixedNumThreadPool((int)2, (String)"queryRemoteDevice");
    private final String priorityUseFilePath = "V3V300R003C00" + File.separator + "sh" + File.separator + "requireCheck.py";

    public PreInspectCheck(List<DevNode> selectedDevNodeList, List<DevNode> allDevNodeList, ProcessStepObserver progressDialog) {
        this.progressDialog = progressDialog;
        this.allDevNodeList = allDevNodeList;
        this.selectedDevNodeList = selectedDevNodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() {
        log.info("queryRemoteDevice start");
        try {
            long startTime = System.currentTimeMillis();
            this.devNodeList2RequirePyDevNodeListMap();
            this.queryRemoteDevice();
            long executeTime = System.currentTimeMillis() - startTime;
            log.info("Query remote info use {} millis.", (Object)executeTime);
        }
        finally {
            this.taskExecutor.shutdown();
        }
        return this.inspectResult;
    }

    private void queryRemoteDevice() {
        List<Future<Object>> futureList = this.submitQueryTask();
        this.handleResult(futureList);
    }

    private void handleResult(List<Future<Object>> futureList) {
        for (Future<Object> future : futureList) {
            List<List<List<Object>>> listListObject = PreInspectCheck.getResult(future);
            if (CollectionUtil.isEmpty(listListObject)) continue;
            this.handleStorageResult(listListObject.get(0));
            this.handleHostResult(listListObject.get(1));
        }
    }

    @Nullable
    private static List<List<List<Object>>> getResult(Future<Object> future) {
        try {
            return (List)future.get();
        }
        catch (Exception e) {
            log.error("require check appear exception or return invalid data ", (Throwable)e);
            return null;
        }
    }

    private void handleHostResult(List<List<Object>> listListObject) {
        for (List<Object> listObject : listListObject) {
            try {
                if (listObject == null || listObject.size() <= 2) continue;
                HostInfo result = HostInfo.builder().hostName(listObject.get(0).toString()).starter(listObject.get(1).toString()).sn(listObject.get(2).toString()).build();
                this.inspectResult.getHostInfos().add(result);
            }
            catch (Exception e) {
                log.error("require check return invalid data ", (Throwable)e);
            }
        }
    }

    private void handleStorageResult(List<List<Object>> listListObject) {
        for (List<Object> listObject : listListObject) {
            try {
                if (listObject == null || listObject.size() <= 3) continue;
                StorageInfo result = StorageInfo.builder().name(listObject.get(0).toString()).ipAddress(listObject.get(1).toString()).sn(listObject.get(2).toString()).desc(listObject.get(3).toString()).build();
                this.inspectResult.getStorageInfos().add(result);
            }
            catch (Exception e) {
                log.error("require check return invalid data ", (Throwable)e);
            }
        }
    }

    @NotNull
    private List<Future<Object>> submitQueryTask() {
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
        for (Map.Entry<File, List<DevNode>> entry : this.requirePyDevNodeListMap.entrySet()) {
            Future<Object> future = this.taskExecutor.submit(this.buildCallable(entry.getValue(), entry.getKey()));
            futureList.add(future);
        }
        return futureList;
    }

    @NotNull
    private Callable<Object> buildCallable(List<DevNode> sameScriptDevNodes, File requirePyScriptFile) {
        PyExecuteInfo pyInfo = PyExecuteInfo.builder().params(Arrays.asList(sameScriptDevNodes, this.selectedDevNodeList, this.allDevNodeList, this.progressDialog)).pyFile(requirePyScriptFile).executeMethod("execute").build();
        return InspectAsyncThreadFactory.buildRuqireCheckPyScriptCallable(pyInfo);
    }

    private void devNodeList2RequirePyDevNodeListMap() {
        this.selectedDevNodeList.stream().filter(node -> !node.isDsStorage()).forEach(this::findPyScriptFile);
    }

    private void findPyScriptFile(DevNode node) {
        try {
            String pyScriptFilePath = InspectContext.getInstance().getProductByDevNode(node).getRequireCheckFile();
            if (StringUtils.isNULLStr((String)pyScriptFilePath)) {
                return;
            }
            File pyScriptFile = new File(this.getPyPathInBasePath(this.priorityUseFilePath));
            if (node.getProductModel().equalsIgnoreCase("cdm")) {
                pyScriptFile = new File(this.getPyPathInBasePath(pyScriptFilePath));
            }
            if (!pyScriptFile.exists()) {
                pyScriptFile = new File(this.getPyPathInBasePath(pyScriptFilePath));
            }
            if (pyScriptFile.isFile()) {
                this.requirePyDevNodeListMap.computeIfAbsent(pyScriptFile, k -> new ArrayList()).add(node);
            }
        }
        catch (ToolException e) {
            log.error("get configDir from devNode error", (Throwable)e);
        }
    }

    @NotNull
    private String getPyPathInBasePath(String pyPath) {
        return String.join((CharSequence)File.separator, AdanceCompileRemotePyScript.BASE_PATH, pyPath);
    }
}

