/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.service.implement.TaskBase;
import com.huawei.ism.tool.inspect.service.implement.TaskParamsUtils;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class QueryItems
extends TaskBase {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QueryItems.class);
    private static final String OUTPUT_FILE_NAME = "InspectItems.xml";

    public QueryItems() {
    }

    public QueryItems(Document doc) {
        this(TaskParamsUtils.getInstance().parseTaskParams(doc));
    }

    public QueryItems(TaskParams params) {
        super.setParams(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeNormalTask() {
        LOGGER.info("Begin to run QueryInspectItems task...");
        SysConfiguration.getInstance().initSysconf();
        this.getContext().getIsScenesInspect().put("realTimed_check", true);
        try {
            List<DevNode> devNodes = this.parseJson2DevNode();
            this.getWorktaker().put("select_dev_nodes", devNodes);
            List<CheckDevNode> checkNodes = this.getWorktaker().loadProductConfigByDevNode();
            ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes = InspectUtils.classifyDevs(checkNodes);
            Document doc = this.createReusultXML(checkTypeNodes);
            this.writeFile2Path(doc, OUTPUT_FILE_NAME);
        }
        catch (ToolException e) {
            LOGGER.error("Run query inspect items task failed...", (Throwable)e);
        }
        finally {
            this.getContext().getIsScenesInspect().clear();
        }
    }

    public Document createReusultXML(ListOrderedMap<String, List<CheckDevNode>> checkTypeNodes) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("itemsConfig");
        List keys = checkTypeNodes.keyList();
        for (String key : keys) {
            List checkDevs = (List)checkTypeNodes.get((Object)key);
            this.createDeviceGroup(root, key, checkDevs);
        }
        return doc;
    }

    private void createIntergrationDeviceGroup(Element root, CheckDevNode checkDevNode) {
        Element deviceGroup = root.addElement("deviceGroup");
        deviceGroup.addAttribute("name", checkDevNode.getNodeName());
        for (CheckDevNode checkNode : checkDevNode.getChildrens()) {
            this.createDevice(deviceGroup, checkNode);
        }
    }

    private void createDeviceGroup(Element root, String group, List<CheckDevNode> checkDevs) {
        Element deviceGroup = root.addElement("deviceGroup");
        deviceGroup.addAttribute("name", group);
        for (CheckDevNode checkDevNode : checkDevs) {
            if (checkDevNode.isIntegration()) {
                this.createIntergrationDeviceGroup(deviceGroup, checkDevNode);
                continue;
            }
            this.createDevice(deviceGroup, checkDevNode);
        }
    }

    private void createDevice(Element deviceGroup, CheckDevNode checkDevNode) {
        Element device = deviceGroup.addElement("device");
        device.addAttribute("ip", checkDevNode.getDevNode().getIp());
        String packgname = checkDevNode.getProduct().getConfigDir().getName();
        device.addAttribute("packageName", packgname);
        this.createItemGroup(device, checkDevNode);
    }

    private void createItemGroup(Element device, CheckDevNode checkDevNode) {
        Element itemGroup = null;
        Map<String, List<CheckItem>> itemsMap = checkDevNode.getCheckItems();
        ArrayList<String> keys = new ArrayList<String>(itemsMap.keySet());
        for (String groupName : keys) {
            itemGroup = device.addElement("itemGroup");
            itemGroup.addAttribute("name", groupName);
            itemGroup.addAttribute("id", "");
            List<CheckItem> items = itemsMap.get(groupName);
            this.createItems(itemGroup, items);
        }
    }

    private void createItems(Element itemGroup, List<CheckItem> items) {
        Element item = null;
        for (CheckItem checkItem : items) {
            item = itemGroup.addElement("item");
            item.addAttribute("name", checkItem.getName());
            item.addAttribute("id", checkItem.getItemId());
        }
    }
}

