/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.service.implement.TaskBase;
import com.huawei.ism.tool.inspect.service.implement.TaskParamsUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class QuerySupportDevList
extends TaskBase {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QuerySupportDevList.class);
    private static final String OUTPUT_FILE_NAME = "SupportDeviceList.xml";

    public QuerySupportDevList() {
    }

    public QuerySupportDevList(Document doc) {
        this(TaskParamsUtils.getInstance().parseTaskParams(doc));
    }

    public QuerySupportDevList(TaskParams params) {
        super.setParams(params);
    }

    @Override
    public void executeNormalTask() {
        LOGGER.info("Begin to run QueryInspectDevList task...");
        this.getContext().getIsScenesInspect().put("realTimed_check", true);
        SysConfiguration.getInstance().initSysconf();
        try {
            List<DevNode> devNodes = this.parseJson2DevNode();
            Document doc = this.createDeviceListFile(devNodes);
            this.writeFile2Path(doc, OUTPUT_FILE_NAME);
        }
        catch (RuntimeException e) {
            LOGGER.error("Run querySupportDevList task failed...", (Throwable)e);
        }
        this.getContext().getIsScenesInspect().clear();
    }

    public Document createDeviceListFile(List<DevNode> devNodes) {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("devices");
        for (DevNode dev : devNodes) {
            boolean isSupport = this.getContext().isSupportDev(dev);
            Element device = root.addElement("device");
            device.addAttribute("ip", dev.getIp());
            device.addAttribute("isSupport", String.valueOf(isSupport));
            device.addAttribute("isNeedDebugPwd", String.valueOf(this.isNeedDebugPWD(dev)));
        }
        return doc;
    }

    public boolean isNeedDebugPWD(DevNode dev) {
        try {
            Product pro = InspectContext.getInstance().getProductByDevNode(dev);
            String debugPwd = dev.getDeveloperPwd();
            if (!pro.getAttus().isEmpty() && StringUtils.isNULLStr((String)debugPwd)) {
                return true;
            }
        }
        catch (ToolException e) {
            LOGGER.error("get product failed...", (Throwable)e);
        }
        return false;
    }
}

