/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.logic.config.SupportVersion;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.service.implement.TaskBase;
import com.huawei.ism.tool.inspect.service.implement.TaskParamsUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class QuerySupportVersionInfo
extends TaskBase {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(QuerySupportVersionInfo.class);
    private static final String OUTPUT_FILE_NAME_OTHER = "AllSupportDevice.xml";
    private static final String VER_REGEX = "V\\d{3}R\\d{3}";

    public QuerySupportVersionInfo() {
    }

    public QuerySupportVersionInfo(Document doc) {
        this(TaskParamsUtils.getInstance().parseTaskParams(doc));
    }

    public QuerySupportVersionInfo(TaskParams params) {
        super.setParams(params);
    }

    @Override
    public void executeNormalTask() {
        LOGGER.info("Begin to run QuerySupportVersionInfo task...");
        this.getContext().getIsScenesInspect().put("realTimed_check", true);
        SysConfiguration.getInstance().initSysconf();
        try {
            Document doc = this.createSupportDeviceDetailFile();
            this.writeFile2Path(doc, OUTPUT_FILE_NAME_OTHER);
            this.deleteTaskFile(this.getParams().getParamFile());
        }
        catch (RuntimeException e) {
            LOGGER.error("Run QuerySupportVersionInfo task failed...", (Throwable)e);
        }
        this.getContext().getIsScenesInspect().clear();
    }

    public Document createSupportDeviceDetailFile() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("supportDevices");
        Set<String> modelVersions = this.getContext().getSupportVers();
        Map<String, List<String>> modelVersionMap = this.splitModelVerion(modelVersions);
        for (Map.Entry<String, List<String>> modelEntry : modelVersionMap.entrySet()) {
            String model = modelEntry.getKey();
            Element device = root.addElement("supportDevice");
            device.addAttribute("type", model);
            this.createVersionDetail(device, model, modelVersionMap.get(model));
        }
        return doc;
    }

    private void createVersionDetail(Element device, String model, List<String> versions) {
        for (String ver : versions) {
            Element ele = device.addElement("version");
            ele.addAttribute("name", ver);
            this.fillSupportDetails(ele, model, ver);
            this.fillUnsupportDetails(ele, model, ver);
        }
    }

    private void fillSupportDetails(Element ele, String model, String version) {
        List<SupportVersion> configedDetail = this.getContext().getSupportVersions();
        StringBuilder des = new StringBuilder(version);
        String modelVersion = model + " " + version;
        for (SupportVersion detail : configedDetail) {
            if (!modelVersion.contains(detail.getModelVersion())) continue;
            des.append("," + detail.getDescZh());
            break;
        }
        ele.addAttribute("supportDetails", des.toString());
    }

    private void fillUnsupportDetails(Element ele, String model, String version) {
        Set<String> configedDetail = this.getContext().getExcludeVers();
        StringBuilder des = new StringBuilder();
        String modelVersion = model + " " + version;
        for (String detail : configedDetail) {
            if (!detail.contains(modelVersion)) continue;
            des.append(detail);
            break;
        }
        ele.addAttribute("unsupportDetails", des.toString());
    }

    private Map<String, List<String>> splitModelVerion(Set<String> modelVers) {
        HashMap<String, List<String>> modelVersionMap = new HashMap<String, List<String>>();
        if (null == modelVers || modelVers.isEmpty()) {
            return modelVersionMap;
        }
        for (String ver : modelVers) {
            String matchStr;
            String version;
            String model = ver.replace(version = ver.substring(ver.indexOf(matchStr = StringUtils.findMatchStr((String)ver, (String)VER_REGEX, (int)0))).trim(), "").trim();
            if (modelVersionMap.containsKey(model)) {
                ((List)modelVersionMap.get(model)).add(version);
                continue;
            }
            ArrayList<String> verions = new ArrayList<String>();
            verions.add(version);
            modelVersionMap.put(model, verions);
        }
        return modelVersionMap;
    }
}

