/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskBase
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskBase.class);
    protected TaskParams params = null;
    protected InspectContext context = InspectContext.getInstance();
    protected InspectWorktaker worktaker = this.context.getInspectWorktaker();

    public TaskParams getParams() {
        return this.params;
    }

    public void setParams(TaskParams params) {
        this.params = params;
    }

    public abstract void executeNormalTask();

    @Override
    public void run() {
    }

    protected List<DevNode> getDevListFromParams() {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        for (DevNode dev : this.params.getDevList()) {
            String ips = dev.getIp();
            String[] ipList = ips.split(";");
            if (0 != ipList.length) {
                for (int i = 0; i < ipList.length; ++i) {
                    dev.addIp(ipList[i]);
                }
                dev.setIp(ipList[0]);
            } else {
                dev.setIp(dev.getIp());
                dev.addIp(ips);
            }
            LOGGER.info("get node from params: {}", (Object)dev.toString());
            devs.add(dev);
        }
        LOGGER.info("dev node size: {}", (Object)devs.size());
        return devs;
    }

    protected List<DevNode> parseJson2DevNode() {
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        for (String jsonStr : this.params.getJsonDevs()) {
            DevNode devNode = new DevNode();
            JSONObject dev = new JSONObject(jsonStr);
            devNode.setIp(dev.getString("devIp"));
            devNode.setDeviceName(dev.getString("devName"));
            devNode.setProductVersion(dev.getString("devVersion"));
            try {
                devNode.setPort(dev.getInt("port"));
            }
            catch (JSONException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("Toolkit Frame is old", (Throwable)e);
            }
            devNode.setDeviceType(DeviceType.valueOf((String)dev.getString("devType")));
            devNode.setDeviceSerialNumber(dev.getString("serialNo"));
            String jsonPWD = dev.getString("password");
            devNode.setLoginUser(new User(dev.getString("username"), this.decryptPassword(jsonPWD)));
            devNode.setDeveloperPwd(dev.getString("developerPwd"));
            devNodes.add(devNode);
        }
        return devNodes;
    }

    private String decryptPassword(String passwd) {
        return AESEncrypt.decrypt((String)passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean writeFile2Path(Document doc, File file) {
        Class<TaskBase> clazz = TaskBase.class;
        synchronized (TaskBase.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return TaskBase.executeWriteFile2Path(doc, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeWriteFile2Path(Document doc, File file) {
        XMLWriter output = null;
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setSuppressDeclaration(false);
        format.setIndent(true);
        format.setIndent("    ");
        format.setNewlines(true);
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            output = new XMLWriter((Writer)osw, format);
            output.write(doc);
            output.flush();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(TaskBase.class).error("writeFile2Path error!", (Throwable)e);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    output = null;
                }
            }
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    osw = null;
                }
            }
            StreamUtils.closeStream((OutputStream)fos, null);
        }
        return true;
    }

    protected boolean writeFile2Path(Document doc, String outputFileName) {
        ToolLoggerFactory.getLogger(TaskBase.class).info("write file: " + outputFileName);
        File file = new File(outputFileName);
        return TaskBase.writeFile2Path(doc, file);
    }

    protected void deleteTaskFile(String filePath) {
        ToolLoggerFactory.getLogger(TaskBase.class).info("delete task file: " + filePath);
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            LoggerFactory.getLogger(TaskBase.class).error("delete taskFile failed...");
        }
    }

    public InspectWorktaker getWorktaker() {
        return this.worktaker;
    }

    public void setWorktaker(InspectWorktaker worktaker) {
        this.worktaker = worktaker;
    }

    public InspectContext getContext() {
        return this.context;
    }

    public void setContext(InspectContext context) {
        this.context = context;
    }
}

