/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessData;
import com.huawei.ism.tool.framework.pubservice.silentprocess.SilentProcessToFile;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.ExtendModel;
import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.service.implement.ExecuteTask;
import com.huawei.ism.tool.inspect.service.implement.TaskBase;
import com.huawei.ism.tool.inspect.ui.action.StartInspectorAction;
import com.huawei.ism.tool.inspect.ui.logic.Strategy;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import utils.FilesUtil;

public class TaskChecker
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TaskChecker.class);
    private static final String TASK_QUEUE_FILE_NAME = "taskQueue.xml";
    private static final String INSPECT_TOOL_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String TASK_TEMP_PATH = INSPECT_TOOL_PATH + File.separator + "taskQueue";
    private static final String ATT_PARAMS = "params";
    private static final int MAGICNUMBER3000 = 3000;
    private static List<String> supportDstorageType = new ArrayList<String>();

    @Override
    public void run() {
        LOGGER.info("Task checker start.");
        InspectContext.getInstance().setAllSilentTaskOver(false);
        TaskBase task = this.getTaskFromQueue();
        if (null == task) {
            LOGGER.info("task is null, taskChecker thread over!");
            this.exitSysAndSetExitcode(20);
            return;
        }
        try {
            this.createProgressFile();
            this.executeTask(task);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error: ", (Throwable)e);
        }
        finally {
            this.waitForExited();
        }
    }

    protected void executeTask(TaskBase task) {
        AsyncExcutor.submit((Runnable)task);
    }

    private void waitForExited() {
        int count = 0;
        InspectContext context = InspectContext.getInstance();
        block2: while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                    if (context.isAllSilentTaskOver()) {
                        this.finishTotalStatus();
                        context.destroyContext();
                        this.exitSys();
                        break block2;
                    }
                    if (count > 200) {
                        count = 0;
                    }
                    ++count;
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Exception happened in :", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void exitSys() {
        this.releaseBlock();
        this.exitSysAndSetExitcode(0);
    }

    private void releaseBlock() {
        try {
            FileLock lock = StartInspectorAction.getFileLock();
            if (lock != null) {
                lock.release();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Release backLock failed.");
        }
        try {
            FileChannel fileChannel = StartInspectorAction.getBackFlagChannel();
            if (Objects.nonNull(fileChannel)) {
                fileChannel.close();
            }
        }
        catch (IOException exception) {
            LOGGER.error("close channel failed..", (Throwable)exception);
        }
    }

    private void exitSysAndSetExitcode(int exitcode) {
        LOGGER.info("All task finished, close background process.exitcode->{}", (Object)exitcode);
        Runtime runtime = Runtime.getRuntime();
        runtime.exit(exitcode);
    }

    private TaskBase getTaskFromQueue() {
        File taskQueueFile = new File(TASK_TEMP_PATH + File.separator + TASK_QUEUE_FILE_NAME);
        if (InspectUtils.isToolKitDC()) {
            String silenceCallPid = System.getenv("silenceCallPid");
            taskQueueFile = new File(FilePathUtils.checkFile((String)(TASK_TEMP_PATH + "_" + silenceCallPid + File.separator + TASK_QUEUE_FILE_NAME)));
        }
        if (!taskQueueFile.exists() || taskQueueFile.isDirectory()) {
            LOGGER.error("No task queue file exist...");
            return null;
        }
        TaskBase taskBase = null;
        try {
            taskBase = this.executeParseTask(taskQueueFile);
        }
        catch (Exception e) {
            LOGGER.error("" + e);
        }
        return taskBase;
    }

    private Document parseXML2Doc(File xmlFile) {
        Document doc;
        try {
            doc = XmlUtils.getSaxReader().read(xmlFile);
        }
        catch (Exception e) {
            LOGGER.error("Read task queue file failed...", (Throwable)e);
            doc = DocumentHelper.createDocument();
        }
        return doc;
    }

    private TaskBase executeParseTask(File queFile) {
        LOGGER.info("start to parse task file: {}", (Object)FilesUtil.getCanonicalPath((File)queFile));
        Document doc = this.parseXML2Doc(queFile);
        Element root = doc.getRootElement();
        List elems = root.elements();
        if (elems.isEmpty()) {
            LOGGER.info("No Task in taskQueue file.");
            return null;
        }
        TaskParams params = new TaskParams();
        LinkedList<Element> eleToRemove = new LinkedList<Element>();
        for (Element taskEle : elems) {
            File paramsFile = new File(taskEle.attributeValue(ATT_PARAMS));
            String path = FilesUtil.getCanonicalPath((File)paramsFile);
            LOGGER.info("get param file : {}", (Object)path);
            DevNode dev = this.parseTaskFile(paramsFile, params);
            params.setDevList(dev);
            params.setParamFile(path);
            LOGGER.info("add device ip: {}, SN: {}", (Object)dev.getIp(), (Object)dev.getDeviceSerialNumber());
            LOGGER.info("write change to task file.");
            eleToRemove.add(taskEle);
        }
        if (InspectUtils.isToolKitDC()) {
            String taskqueuePath = ApplicationContext.getInstance().getWorkPath();
            taskqueuePath = FilePathUtils.checkFile((String)(taskqueuePath + File.separator + "taskQueue_" + System.getenv("silenceCallPid")));
            FileUtils.deleteFile((File)new File(taskqueuePath));
        } else {
            this.removeEle(elems, root);
            TaskBase.writeFile2Path(doc, queFile);
        }
        return new ExecuteTask(params);
    }

    private void removeEle(List<Element> elems, Element root) {
        for (Element ele : elems) {
            if (root.remove(ele)) continue;
            LOGGER.error("remove taskElement failed. return null.");
        }
    }

    private DevNode parseTaskFile(File paramfile, TaskParams params) {
        String path = FilesUtil.getCanonicalPath((File)paramfile);
        LOGGER.info("Start to get dev params from : {}", (Object)path);
        DevNode dev = new DevNode();
        String devNodes = "";
        try {
            Document document = XmlUtils.getSaxReader().read(paramfile);
            Element root = document.getRootElement();
            List param = root.elements();
            User loginUser = new User(null, null);
            dev.setLoginUser(loginUser);
            HashMap<String, String> attMap = new HashMap<String, String>();
            for (Element paramTmp : param) {
                attMap.put(paramTmp.attribute("id").getText(), paramTmp.attribute("value").getText());
                if (paramTmp.attribute("expMode") != null) {
                    LOGGER.info("set exInfo");
                    this.setExInfo(paramTmp);
                    InspectContext.getInstance().setExtendInspectScene("exInspect");
                    continue;
                }
                if (paramTmp.getName().equals("checkItems")) {
                    this.setCheckItems(paramTmp);
                    continue;
                }
                devNodes = this.setValueByTaskParams(params, dev, devNodes, loginUser, paramTmp);
                this.setSShParamsByTask(dev, paramTmp);
            }
            this.setComputerStorageInfo(dev, attMap);
            this.cacheDevNodeInfo(params, dev, devNodes, attMap);
            LOGGER.info("dev parsed from params: {}", (Object)dev.toString());
            LOGGER.info("param workPath: {}, param language: {}", (Object)params.getWorkPath(), (Object)params.getLang());
            InspectContext.getInstance().setSilentWorkPath(params.getWorkPath());
            LOGGER.info("delete task file : {}", (Object)path);
            if (!paramfile.delete()) {
                LOGGER.error("delete task file : " + path + " failed!");
            }
        }
        catch (Exception e1) {
            LOGGER.error("Parse taskFile fail." + e1);
        }
        return dev;
    }

    private void cacheDevNodeInfo(TaskParams params, DevNode dev, String devNodes, Map<String, String> attMap) {
        String sn = dev.getDeviceSerialNumber();
        if (!StringUtils.isNULLStr((String)sn)) {
            params.getNodesInfoMap().put(sn, devNodes);
        }
        for (String supportType : supportDstorageType) {
            if (!supportType.equalsIgnoreCase(dev.getDeviceType().toString())) continue;
            dev.setItDeviceType(ItDeviceType.DStorage);
        }
        String checkItem = attMap.getOrDefault("checkItem", "");
        if (!StringUtils.isNULLStr((String)sn) && !StringUtils.isNULLStr((String)checkItem)) {
            params.getSelectItemsMap().put(sn, Arrays.asList(checkItem.split(",")));
        }
    }

    private String setValueByTaskParams(TaskParams params, DevNode dev, String devNodes, User loginUser, Element paramTmp) {
        String resultDevNodes = devNodes;
        switch (paramTmp.attribute("id").getText()) {
            case "devIp": {
                dev.setIp(paramTmp.attribute("value").getText());
                break;
            }
            case "password": {
                loginUser.setPassword(AESEncrypt.decrypt((String)paramTmp.attributeValue("value")));
                break;
            }
            case "username": {
                loginUser.setUserName(AESEncrypt.decrypt((String)paramTmp.attribute("value").getText()));
                break;
            }
            case "developerPwd": {
                dev.setDeveloperPwd(AESEncrypt.decrypt((String)paramTmp.attribute("value").getText()));
                break;
            }
            case "devVersion": {
                dev.setProductVersion(paramTmp.attribute("value").getText());
                break;
            }
            case "deviceName": {
                dev.setDeviceName(paramTmp.attribute("value").getText());
                break;
            }
            case "deviceType": {
                dev.setDeviceType(DeviceType.valueOf((String)paramTmp.attribute("value").getText()));
                break;
            }
            case "serialNo": {
                dev.setDeviceSerialNumber(paramTmp.attribute("value").getText());
                break;
            }
            case "workPath": {
                params.setWorkPath(paramTmp.attribute("value").getText());
                break;
            }
            case "language": {
                params.setLang(paramTmp.attribute("value").getText());
                break;
            }
            case "port": {
                dev.setPort(Integer.parseInt(paramTmp.attribute("value").getText()));
                break;
            }
            case "devNodes": {
                resultDevNodes = this.getDevNodes(paramTmp);
                break;
            }
            case "csPriKey": {
                dev.setPriKey(this.getPriKeyInfo(paramTmp));
                break;
            }
            case "highDevSVPModuleInfo": {
                dev.setHighDevSVPModuleInfo(paramTmp.attribute("value").getText());
                break;
            }
            case "sshForward": {
                dev.setSshForwardList(this.getSshForwardList(paramTmp));
                break;
            }
            case "sock5": {
                dev.setSocks5Proxy(this.getSocks5Proxy(paramTmp));
                break;
            }
            case "priKey": {
                dev.setPriKey(this.getPriKeyInfo(paramTmp));
                break;
            }
            case "isVerifyCertificate": {
                dev.setVerifyCertificate(Boolean.parseBoolean(AESEncrypt.decrypt((String)paramTmp.attribute("value").getText())));
                break;
            }
        }
        return resultDevNodes;
    }

    private void setSShParamsByTask(DevNode dev, Element paramTmp) {
        switch (paramTmp.attribute("id").getText()) {
            case "sshHostKey": {
                dev.setSshHostKey(AESEncrypt.decrypt((String)paramTmp.attributeValue("value")));
                break;
            }
            case "isVerifySshHostKey": {
                dev.setVerifySshHostKey(Boolean.valueOf(AESEncrypt.decrypt((String)paramTmp.attribute("value").getText())).booleanValue());
                break;
            }
        }
    }

    private void setComputerStorageInfo(DevNode dev, Map<String, String> attMap) {
        if (StringUtils.isNULLStr((String)attMap.get("computeStorageInfoList"))) {
            return;
        }
        if (!StringUtils.isNULLStr((String)attMap.get("computeStorageInfoFcvIp"))) {
            dev.setStorageDeviceType(ItDeviceType.COMPUTE_STORAGE);
            ComputeStorageDevNode csDevNode = new ComputeStorageDevNode();
            User user = new User();
            user.setUserName(Base64EncodeUtils.decode((String)attMap.get("computeStorageInfoFcvOpenApiUserName")));
            user.setPassword(AESEncrypt.decrypt((String)attMap.get("computeStorageInfoFcvOpenApiUserPwd")));
            csDevNode.setOpenapiUser(user);
            csDevNode.setFcvIp(attMap.get("computeStorageInfoFcvIp"));
            csDevNode.setFcvPort(Integer.parseInt(attMap.getOrDefault("computeStorageInfoFcvPort", "443")));
            csDevNode.setComputeStorageFcvDeviceId(attMap.get("computeStorageInfoFcvDeviceId"));
            csDevNode.setChassisNum(attMap.get("computeStorageInfoChassisNum"));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("computeStorageInfoList", (Object)new JSONArray(attMap.get("computeStorageInfoList")));
            csDevNode.setStorageNodesInfo(EntityUtils.jsonToListHashMap((JSONObject)jsonObject, (String)"computeStorageInfoList"));
            dev.setComputeStorageDevNode(csDevNode);
        }
    }

    private PriKeyInfo getPriKeyInfo(Element paramTmp) {
        return EntityUtils.jsonToPriKey((String)paramTmp.attribute("value").getText());
    }

    private Socks5Proxy getSocks5Proxy(Element paramTmp) {
        return EntityUtils.cvtJsonToOldS5Peoxy((String)paramTmp.attribute("value").getText(), (String)System.getenv("securityKey"));
    }

    private List<MultiRouteNode> getSshForwardList(Element paramTmp) {
        return EntityUtils.cvtJsonToNewForwardList((String)paramTmp.attribute("value").getText(), (String)System.getenv("securityKey"));
    }

    private String getDevNodes(Element paramTmp) {
        String devNodes = paramTmp.attribute("value") == null ? "" : paramTmp.attribute("value").getText();
        return devNodes;
    }

    private void setCheckItems(Element ele) {
        ArrayList<CheckItem> itemList = new ArrayList<CheckItem>();
        if (ele == null) {
            return;
        }
        List items = ele.elements();
        for (Element item : items) {
            String itemId = item.attributeValue("id");
            String name = item.attributeValue("name");
            String expResult = item.attributeValue("expResult");
            CheckItem checkItem = new CheckItem();
            checkItem.setItemId(itemId);
            checkItem.setName(name);
            checkItem.setExpResult(expResult);
            itemList.add(checkItem);
        }
        InspectContext.getInstance().setSilenceCallCheckItems(itemList);
    }

    private void setExInfo(Element ele) {
        InspectContext context = InspectContext.getInstance();
        String expMode = ele.attributeValue("expMode");
        String exConfigInfo = ele.getTextTrim();
        ArrayList<HashMap<String, String>> expDiskListEnv = new ArrayList<HashMap<String, String>>();
        ArrayList<Strategy> expStrategyList = new ArrayList<Strategy>();
        context.setExpCtrlOri(0);
        context.setExpCtrlEnv(null);
        if (!StringUtils.isNULLStr((String)exConfigInfo)) {
            this.setExConfigInfo(exConfigInfo, expDiskListEnv, expStrategyList);
        }
        ExtendModel model = null;
        if (expMode.equalsIgnoreCase("EXTEND_CTRL")) {
            model = ExtendModel.CTRL_EXP_INSPECT;
            String expCtrlEnv = ele.attributeValue("expCtrlNew");
            String expCtrlOri = ele.attributeValue("expCtrlOri", "0");
            String hasVeritas = ele.attributeValue("hasVeritas", "false");
            String hasInnerMetro = ele.attributeValue("hasInnerMetro", "false");
            String expBom = ele.attributeValue("expBom", "");
            String ctrlBom = ele.attributeValue("ctrlBom", "");
            String interfaceBom = ele.attributeValue("interfaceBom", "");
            context.setEncBom(expBom);
            context.setCtrlBom(ctrlBom);
            context.setInterfaceBom(interfaceBom);
            context.setExpCtrlEnv(expCtrlEnv);
            context.setExpCtrlOri(Integer.parseInt(expCtrlOri));
            context.setRequireInnerMetro(Boolean.parseBoolean(hasInnerMetro));
            context.setCheckVeritasEnv(Boolean.parseBoolean(hasVeritas));
        } else if (expMode.equalsIgnoreCase("EXTEND_DISK")) {
            model = ExtendModel.DISK_EXP_INSPECT;
            String interfaceBom = ele.attributeValue("interfaceBom", "");
            context.setInterfaceBom(interfaceBom);
        } else {
            model = ExtendModel.LINK_EXP_INSPECT;
        }
        context.setExpMode(expMode);
        context.setExpDiskListEnv(expDiskListEnv);
        context.setExpModeOri(model.toString());
        context.setExpStrategyList(expStrategyList);
        InspectUtils.setIsPreExpEvaluation(true);
        LOGGER.info("exp mode {}", (Object)expMode);
    }

    private void setExConfigInfo(String exConfigInfo, ArrayList<HashMap<String, String>> expDiskListEnv, ArrayList<Strategy> expStrategyList) {
        JSONArray exInfo = new JSONArray(exConfigInfo);
        for (int i = 0; i < exInfo.length(); ++i) {
            Strategy strategy = new Strategy();
            JSONObject obj = exInfo.getJSONObject(i);
            strategy.setExpDiskMode(obj.getString("diskModel"));
            strategy.setDiskModel(obj.getString("diskModel"));
            strategy.setEng(obj.getString("eng"));
            strategy.setDiskDomain(obj.getString("diskDomain"));
            strategy.setDiskCapacity(obj.getString("diskCapacity"));
            strategy.setUnit(Strategy.Unit.valueOf(obj.getString("unit")));
            strategy.setDiskNum(obj.getString("diskNum"));
            strategy.setLogicEng(obj.getString("logicEng"));
            strategy.setDiskModelDisplay(obj.getString("diskModel"));
            expDiskListEnv.add(strategy.toMap());
            expStrategyList.add(strategy);
            LOGGER.info("add exp strategy : {}", (Object)strategy);
        }
    }

    private void createProgressFile() {
        SilentProcessData processData = new SilentProcessData(String.valueOf(0));
        processData.setStatus("running");
        processData.setProcess(String.valueOf(0));
        SilentProcessToFile.createProgressData((SilentProcessData)processData, (String)InspectContext.getInstance().getSilentWorkPath());
    }

    private void finishTotalStatus() {
        SilentProcessData processData = new SilentProcessData(String.valueOf(0));
        processData.setStatus("finished");
        processData.setProcess(String.valueOf(100));
        SilentProcessToFile.updateProcessData((SilentProcessData)processData, (String)InspectContext.getInstance().getSilentWorkPath());
    }

    static {
        ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
        String supportTypeStr = "";
        try {
            String[] supportTypes;
            supportTypeStr = sysBundle.getString("supportdstoragetype");
            for (String supportType : supportTypes = supportTypeStr.split(",")) {
                supportDstorageType.add(supportType.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error("init ds support type error.", (Throwable)e);
        }
    }
}

