/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.service.implement;

import com.huawei.ism.tool.inspect.entity.TaskParams;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.LoggerFactory;

public final class TaskParamsUtils {
    private static final String ATT_ID = "id";
    private static final String ATT_VALUE = "value";
    private static final String CMD_TYPE = "cmdType";
    private static final String WORK_PATH = "workPath";
    private static final String JSON_DEV_X = "jsonDevEncode_";
    private static final String LANGUAGE = "language";
    private static final TaskParamsUtils INSTANCE = new TaskParamsUtils();
    private String filePath = null;

    private TaskParamsUtils() {
    }

    public static TaskParamsUtils getInstance() {
        return INSTANCE;
    }

    public TaskParams parseTaskParams(Document doc) {
        Element root;
        TaskParams tp = new TaskParams();
        if (null != this.filePath) {
            tp.setParamFile(this.filePath);
        }
        if (null == (root = doc.getRootElement()) || root.elements().isEmpty()) {
            LoggerFactory.getLogger(TaskParamsUtils.class).info("task file is not exist.");
            return tp;
        }
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element param = (Element)it.next();
            String id = param.attributeValue(ATT_ID);
            this.classificationElement(tp, param, id);
        }
        return tp;
    }

    private void classificationElement(TaskParams tp, Element param, String id) {
        if (CMD_TYPE.equals(id)) {
            tp.setCmdType(param.attributeValue(ATT_VALUE));
        } else if (WORK_PATH.equals(id)) {
            tp.setWorkPath(param.attributeValue(ATT_VALUE));
        } else if (id.startsWith(JSON_DEV_X)) {
            tp.getJsonDevs().add(param.attributeValue(ATT_VALUE));
        } else if (LANGUAGE.equals(id)) {
            String lan = param.attributeValue(ATT_VALUE);
            tp.setLang(lan);
            this.setLanguageEnv(lan);
        }
    }

    private void setLanguageEnv(String lan) {
        Locale language = null;
        language = Locale.SIMPLIFIED_CHINESE.getLanguage().equals(lan) ? Locale.SIMPLIFIED_CHINESE : Locale.ENGLISH;
        InspectContext.getInstance().setLoc(language);
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

