/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.action;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.inspect.service.implement.InspectINodeSupport;
import com.huawei.ism.tool.inspect.ui.wizard.SelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.SettingType;
import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JDialog;
import org.apache.commons.collections4.CollectionUtils;

public class AddDeviceAction
extends ToolAction {
    private static final long serialVersionUID = -7209575836882453530L;
    private SelectDeviceCard card;
    private static Map<ItDeviceType, List<String>> deviceTypeModel = new HashMap<ItDeviceType, List<String>>();
    private static List<String> ultraPathTypeL2 = new ArrayList<String>();
    private static List<String> hostTypeL2 = new ArrayList<String>();
    private static List<String> switchTypeL2 = new ArrayList<String>();

    public AddDeviceAction(SelectDeviceCard selectDeviceCard) {
        this.card = selectDeviceCard;
    }

    public void actionPerformed(ActionEvent e) {
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(InspectContext.getInstance().getSupportTypes(), (INodeSupport)new InspectINodeSupport(), ShowSysConstans.getShowSysCmds());
        nodeTypeQuery.setExcludeDevTypes(InspectContext.getInstance().getExcludeTypes());
        nodeTypeQuery.setCheckMap(InspectContext.getInstance().getSupportModelVersions());
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicatebyupgrade");
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        DeviceManageSetting setting = new DeviceManageSetting(true, true, true);
        DeviceAddDialog dialog = null;
        String inspectType = InspectContext.getInstance().getSelectInspectType();
        LinkedList<ItDeviceType> deviceTypeList = new LinkedList<ItDeviceType>();
        HashMap<ItDeviceType, List<String>> deviceTypeView = new HashMap<ItDeviceType, List<String>>();
        String sceneInfo = System.getenv("jsonScene");
        if (SceneUtils.isSpecialScence((String)sceneInfo, (String[])new String[]{"Switch Inspector", "Switch Quality Checks"}) && !InspectContext.getInstance().isOemOutTool()) {
            this.initDeviceTypeView(deviceTypeList, deviceTypeView, setting, ItDeviceType.Switch, ItDeviceType.Storage, ItDeviceType.Host);
            dialog = new DeviceAddDialog((Window)mainDialog, (INodeTypeQuery)nodeTypeQuery, tips, setting, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        } else if (SceneUtils.isSpecialScence((String)sceneInfo, (String[])new String[]{"DPA Inspector"}) && !InspectContext.getInstance().isOemOutTool()) {
            this.initDeviceTypeView(deviceTypeList, deviceTypeView, setting, ItDeviceType.DPA, ItDeviceType.Storage, ItDeviceType.Host);
            dialog = new DeviceAddDialog((Window)mainDialog, (INodeTypeQuery)nodeTypeQuery, tips, setting, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        } else if (inspectType.contains("realTimed_check") && !InspectContext.getInstance().isOemOutTool()) {
            dialog = this.createDialog(nodeTypeQuery, tips, mainDialog, setting, deviceTypeList, deviceTypeView);
        } else if (inspectType.contains("bureau_check") && !InspectContext.getInstance().isOemOutTool()) {
            sceneInfo = System.getenv("jsonScene");
            if (SceneUtils.isSpecialScence((String)sceneInfo, (String[])InspectConstans.mainScene()) && !SceneUtils.isSpecialScence((String)sceneInfo, (String[])new String[]{"Switch Inspector"})) {
                this.initDeviceTypeView(deviceTypeList, deviceTypeView, setting, ItDeviceType.Host, ItDeviceType.Switch);
            } else {
                this.initDeviceTypeView(deviceTypeList, deviceTypeView, setting, ItDeviceType.Storage, ItDeviceType.Host, ItDeviceType.Switch, ItDeviceType.FUSIONCUBE);
            }
            dialog = new DeviceAddDialog((Window)mainDialog, (INodeTypeQuery)nodeTypeQuery, tips, setting, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        } else {
            dialog = new DeviceAddDialog((Window)mainDialog, (INodeTypeQuery)nodeTypeQuery, tips, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        }
        dialog.setForceRootOnHost(true);
        dialog.setVisible(true);
        this.card.refreshDevTable();
    }

    private DeviceAddDialog createDialog(DefaultNodeTypeQuery nodeTypeQuery, DeviceAddDialog.InfoTips tips, JDialog mainDialog, DeviceManageSetting setting, List<ItDeviceType> itDeviceList, Map<ItDeviceType, List<String>> deviceTypeView) {
        List devNode = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (!ApplicationContext.getInstance().isWindowsOS()) {
            this.initDeviceTypeView(itDeviceList, deviceTypeView, setting, ItDeviceType.Storage);
        } else if (this.havingSpeciallyDeviceType((List<DevNode>)devNode, ItDeviceType.UltraPath)) {
            this.initDeviceTypeView(itDeviceList, deviceTypeView, setting, ItDeviceType.UltraPath);
        } else if (this.havingSpeciallyDeviceType((List<DevNode>)devNode, Arrays.asList(ItDeviceType.Host, ItDeviceType.Storage, ItDeviceType.FUSIONCUBE, ItDeviceType.A3000))) {
            String scenceInfo = System.getenv("jsonScene");
            if (SceneUtils.isSpecialScence((String)scenceInfo, (String[])InspectConstans.mainScene()) && !SceneUtils.isSpecialScence((String)scenceInfo, (String[])new String[]{"Switch Inspector"})) {
                this.initDeviceTypeView(itDeviceList, deviceTypeView, setting, ItDeviceType.Host, ItDeviceType.Switch);
            } else {
                this.initDeviceTypeView(itDeviceList, deviceTypeView, setting, ItDeviceType.Storage, ItDeviceType.Host, ItDeviceType.Switch, ItDeviceType.FUSIONCUBE, ItDeviceType.A3000);
            }
        } else {
            this.initDeviceTypeView(itDeviceList, deviceTypeView, setting, ItDeviceType.Storage, ItDeviceType.Host, ItDeviceType.UltraPath, ItDeviceType.Switch, ItDeviceType.FUSIONCUBE, ItDeviceType.A3000);
        }
        DeviceAddDialog dialog = new DeviceAddDialog((Window)mainDialog, (INodeTypeQuery)nodeTypeQuery, tips, setting, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        return dialog;
    }

    public void initDeviceTypeView(List<ItDeviceType> itDeviceList, Map<ItDeviceType, List<String>> deviceTypeView, DeviceManageSetting setting, ItDeviceType ... deviceTypes) {
        for (ItDeviceType deviceType : deviceTypes) {
            itDeviceList.add(deviceType);
            deviceTypeView.put(deviceType, deviceTypeModel.get(deviceType));
            setting.setItDeviceList(itDeviceList);
            if (ItDeviceType.Storage.equals((Object)deviceType) || ItDeviceType.DPA.equals((Object)deviceType)) continue;
            setting.setDeviceTypel2(deviceTypeView);
        }
    }

    private boolean havingSpeciallyDeviceType(List<DevNode> devNodes, List<ItDeviceType> exTypes) {
        if (CollectionUtils.isEmpty(devNodes) || CollectionUtils.isEmpty(exTypes)) {
            return false;
        }
        return exTypes.stream().filter(Objects::nonNull).anyMatch(exType -> this.havingSpeciallyDeviceType(devNodes, (ItDeviceType)exType));
    }

    private boolean havingSpeciallyDeviceType(List<DevNode> devNodes, ItDeviceType exType) {
        if (CollectionUtils.isEmpty(devNodes) || Objects.isNull(exType)) {
            return false;
        }
        return devNodes.stream().filter(Objects::nonNull).anyMatch(devNode -> exType.equals((Object)devNode.getItDeviceType()));
    }

    static {
        ultraPathTypeL2.add("Linux");
        ultraPathTypeL2.add("Solaris");
        ultraPathTypeL2.add("VMware");
        ultraPathTypeL2.add("AIX");
        hostTypeL2.add("Linux");
        hostTypeL2.add("Solaris");
        hostTypeL2.add("VMware");
        hostTypeL2.add("AIX");
        hostTypeL2.add("HP-UX");
        hostTypeL2.add("Windows");
        hostTypeL2.add("FusionSphere");
        switchTypeL2.add("OceanStor SNS");
        deviceTypeModel.put(ItDeviceType.UltraPath, ultraPathTypeL2);
        deviceTypeModel.put(ItDeviceType.Host, hostTypeL2);
        deviceTypeModel.put(ItDeviceType.Switch, switchTypeL2);
    }
}

