/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.action;

import com.huawei.ism.tool.inspect.ui.dialogs.BmcNodeAuthDialog;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;

public class BmcNodeAuthAction
implements ActionListener {
    private List<ClusterNode> selectedNodes = new ArrayList<ClusterNode>();
    private IsmTable clusterNodesTbl;
    private static final String[] TABLE_HEADERS = new String[]{ResourceUtil.getString((String)"bmc.auth.action.check.selectnode.manageip"), ResourceUtil.getString((String)"bmc.auth.action.check.selectnode.bmcip")};

    public BmcNodeAuthAction(ClusterNode nodes) {
        this.selectedNodes.add(nodes);
    }

    public BmcNodeAuthAction(IsmTable clusterNodesTbl) {
        this.clusterNodesTbl = clusterNodesTbl;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        this.initSelectedNodes();
        if (this.selectedNodes == null || this.selectedNodes.isEmpty()) {
            String errMsg = ResourceUtil.getString((String)"bmc.auth.action.selectnodevice");
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return;
        }
        this.showBmcNodeAuthDialog(mainDialog);
    }

    private void showBmcNodeAuthDialog(JDialog mainDialog) {
        BmcNodeAuthDialog addDialog;
        if (this.selectedNodes.size() > 1) {
            if (!BmcNodeAuthAction.checkBmcIp(mainDialog, this.selectedNodes)) {
                return;
            }
            addDialog = new BmcNodeAuthDialog(this.selectedNodes);
        } else {
            ClusterNode node = this.selectedNodes.get(0);
            addDialog = new BmcNodeAuthDialog(node);
        }
        String title = this.getTitle();
        addDialog.setTitle(title);
        addDialog.setVisible(true);
    }

    private void initSelectedNodes() {
        if (Objects.isNull(this.clusterNodesTbl)) {
            return;
        }
        this.selectedNodes = this.clusterNodesTbl.getMarkedRows().stream().map(row -> (ClusterNode)row.getUserObject()).filter(this::supportBmcAuth).collect(Collectors.toList());
    }

    private boolean supportBmcAuth(ClusterNode clusterNode) {
        return clusterNode.includedStorageService() && !clusterNode.isHGNode();
    }

    private String getTitle() {
        String title = ResourceUtil.getString((String)"bmc.auth.layout.title.auth");
        if (this.selectedNodes.size() > 1) {
            title = ResourceUtil.getString((String)"bmc.auth.layout.title.batch.auth");
        }
        if (this.selectedNodes.stream().anyMatch(node -> node.getBmcNode() != null && node.getBmcNode().getLoginUser() != null)) {
            title = ResourceUtil.getString((String)"bmc.auth.layout.title.modifyDev.auth");
        }
        return title;
    }

    public static boolean checkBmcIp(Dialog parentDialog, List<ClusterNode> selectedNodes) {
        Map<String, List<String>> bmcAndmanageIPMap = BmcNodeAuthAction.getDuplicateOrNullBMCIpInfo(selectedNodes);
        if (bmcAndmanageIPMap.containsKey("")) {
            BmcNodeAuthAction.showNullIpFailedTips(parentDialog, bmcAndmanageIPMap);
            return false;
        }
        for (List<String> values : bmcAndmanageIPMap.values()) {
            if (values.size() <= 1) continue;
            BmcNodeAuthAction.showduplicateIpFailedTips(parentDialog, bmcAndmanageIPMap);
            return false;
        }
        return true;
    }

    public static Map<String, List<String>> getDuplicateOrNullBMCIpInfo(List<ClusterNode> selectedNodes) {
        Map<String, List<String>> bmcAndmanageIPMap = BmcNodeAuthAction.getBmcAndmanageIPMap(selectedNodes);
        HashMap<String, List<String>> bmcAndmanageIPMapTemp = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : bmcAndmanageIPMap.entrySet()) {
            if (entry.getValue().size() <= 1 && !entry.getKey().equalsIgnoreCase("")) continue;
            bmcAndmanageIPMapTemp.put(entry.getKey(), entry.getValue());
        }
        return bmcAndmanageIPMapTemp;
    }

    private static Map<String, List<String>> getBmcAndmanageIPMap(List<ClusterNode> selectedNodes) {
        HashMap<String, List<String>> bmcAndmanageIPMap = new HashMap<String, List<String>>();
        for (ClusterNode clusterNode : selectedNodes) {
            String bmcIP = clusterNode.getBmcNode() == null ? "" : clusterNode.getBmcNode().getIp();
            if (StringUtils.isNULLStr((String)bmcIP)) {
                bmcIP = "";
            }
            if (bmcAndmanageIPMap.containsKey(bmcIP)) {
                ((List)bmcAndmanageIPMap.get(bmcIP)).add(clusterNode.getManagementIp());
                continue;
            }
            ArrayList<String> ipList = new ArrayList<String>();
            ipList.add(clusterNode.getManagementIp());
            bmcAndmanageIPMap.put(bmcIP, ipList);
        }
        return bmcAndmanageIPMap;
    }

    private static void showNullIpFailedTips(Dialog parentDialog, Map<String, List<String>> bmcAndmanageIPMap) {
        List<ArrayList<Object>> failedIpList = BmcNodeAuthAction.parseFailedIpInfo(bmcAndmanageIPMap.get(""), "");
        String nullIPErrMsg = ResourceUtil.getString((String)"bmc.auth.action.check.bmcip.null.node");
        DialogUtils.showMultiErrorDialog((Window)parentDialog, (String)nullIPErrMsg, (String[])TABLE_HEADERS, failedIpList);
    }

    private static void showduplicateIpFailedTips(Dialog parentDialog, Map<String, List<String>> bmcAndmanageIPMap) {
        ArrayList failedIpList = new ArrayList();
        bmcAndmanageIPMap.keySet().forEach(bmcIp -> {
            List manageIpList = (List)bmcAndmanageIPMap.get(bmcIp);
            failedIpList.addAll(BmcNodeAuthAction.parseFailedIpInfo(manageIpList, bmcIp));
        });
        String duplicateErrMsg = ResourceUtil.getString((String)"bmc.auth.action.check.bmcip.duplicate.node");
        DialogUtils.showMultiErrorDialog((Window)parentDialog, (String)duplicateErrMsg, (String[])TABLE_HEADERS, failedIpList);
    }

    private static List<ArrayList<Object>> parseFailedIpInfo(List<String> manageIpList, String bmcIp) {
        return manageIpList.stream().map(manageIp -> {
            ArrayList<String> ipList = new ArrayList<String>();
            ipList.add((String)manageIp);
            ipList.add(bmcIp);
            return ipList;
        }).collect(Collectors.toList());
    }
}

