/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.action;

import com.huawei.ism.tool.inspect.entity.FsNodeExpansionInfo;
import com.huawei.ism.tool.inspect.ui.action.ChangeDiskTypeAction;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStoragePoolExpansionDialog;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.text.IsmTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class ChangeCapacityUnitAction
implements ActionListener {
    private static final int CAPACITY_MAX_LENGTH = 20;
    private static final int CAPACITY_MAX_REDUCED_LENGTH = 3;
    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow;
    private static final String DISK_CAPACITY_TIPS_MSG = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.disk.capacity.default.msg");
    private FusionStoragePoolExpansionDialog dialog;
    private String last;

    public ChangeCapacityUnitAction(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow, FusionStoragePoolExpansionDialog dialog) {
        this.subRow = subRow;
        this.dialog = dialog;
        this.last = FusionStoragePoolExpansionDialog.DISK_CUSTOM_ROW_DISK_CAPACITY[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(this.subRow.getValue(4) instanceof IsmTableCell.ComboBoxCell) || !(this.subRow.getValue(3) instanceof IsmTableCell.MsgTextCell)) {
            return;
        }
        String[] items = FusionStoragePoolExpansionDialog.DISK_CUSTOM_ROW_DISK_CAPACITY;
        IsmTableCell.ComboBoxCell capacityUnitCell = (IsmTableCell.ComboBoxCell)this.subRow.getValue(4);
        String unitStr = capacityUnitCell.getEditor().getCellEditorValue().toString();
        if (items[0].equals(unitStr)) {
            if (((FsNodeExpansionInfo)this.subRow.getUserObject()).isSelect()) {
                capacityUnitCell.setSelectedItem((Object)this.last);
            }
            return;
        }
        IsmTableCell.MsgTextCell capacityCell = (IsmTableCell.MsgTextCell)this.subRow.getValue(3);
        int select = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(unitStr)) continue;
            select = i;
            break;
        }
        if (select == 0) {
            return;
        }
        int lengthRule = 20 - select * 3;
        String diskCapacityRegex = this.getRegex(select, lengthRule);
        IsmTableCell.MsgTextCell newCell = new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)diskCapacityRegex, (String)"", (int)(lengthRule + 1), (int)0), "", DISK_CAPACITY_TIPS_MSG);
        String value = capacityCell.getEditor().getCellEditorValue().toString();
        if (!StringUtils.isNULLStr((String)value)) {
            newCell.setText(value);
        }
        this.subRow.setValue(3, (Object)newCell);
        ChangeDiskTypeAction.checkDuplicateCapacity(unitStr, this.last, this.subRow, this.dialog);
        this.last = unitStr;
    }

    private String getRegex(int select, int lengthRule) {
        String diskCapacityRegex = select == 1 ? "^[1-9][0-9]{0," + lengthRule + "}$" : "^[1-9][0-9]{0," + lengthRule + "}.{0,1}[0-9]{0," + 2 + "}$";
        return diskCapacityRegex;
    }
}

