/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.action;

import com.huawei.ism.tool.inspect.entity.FsNodeExpansionInfo;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStoragePoolExpansionDialog;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;

public class ChangeDiskTypeAction
implements ActionListener {
    private static final String MAIN_STORAGE_DISK = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.type.1");
    private static final String CACHE_DISK = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.type.2");
    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow;
    private FusionStorStoragePool storagePool;
    private int sbindex;
    private FusionStoragePoolExpansionDialog dialog;
    private String last;

    public ChangeDiskTypeAction(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow, FusionStorStoragePool storagePool, int sbindex, FusionStoragePoolExpansionDialog dialog) {
        this.subRow = subRow;
        this.storagePool = storagePool;
        this.sbindex = sbindex;
        this.dialog = dialog;
        this.last = MAIN_STORAGE_DISK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.subRow.getValue(this.sbindex) instanceof IsmTableCell.ComboBoxCell) {
            IsmTableCell.ComboBoxCell cell = (IsmTableCell.ComboBoxCell)this.subRow.getValue(this.sbindex);
            String type = cell.getEditor().getCellEditorValue().toString();
            if (MAIN_STORAGE_DISK.equals(type)) {
                ((FsNodeExpansionInfo)this.subRow.getUserObject()).getChildrenConfigDisk().setType(this.storagePool.getMainStorageDiskType());
                ((FsNodeExpansionInfo)this.subRow.getUserObject()).setChildrenType(FsNodeExpansionInfo.ChildrenType.MAIN_STORAGE);
            }
            if (CACHE_DISK.equals(type)) {
                ((FsNodeExpansionInfo)this.subRow.getUserObject()).getChildrenConfigDisk().setType(this.storagePool.getCacheDiskType());
                ((FsNodeExpansionInfo)this.subRow.getUserObject()).setChildrenType(FsNodeExpansionInfo.ChildrenType.CACHE);
            }
            if (type.equals(this.last)) {
                return;
            }
            ChangeDiskTypeAction.checkDuplicateCapacity(type, this.last, this.subRow, this.dialog);
            this.last = type;
        }
    }

    public static void checkDuplicateCapacity(String type, String last, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow, FusionStoragePoolExpansionDialog dialog) {
        if (type.equals(last) || !((FsNodeExpansionInfo)subRow.getUserObject()).isSelect()) {
            return;
        }
        String erroMsg = FusionStoragePoolExpansionDialog.checkCustomRowFinish(subRow);
        if (ResourceUtil.getString((String)"inspsctor.fs.expansion.disk.custom.capacity.exist.msg").equals(erroMsg)) {
            dialog.getFsLayout().getTable().getTreeTableModel().getAllItemList().forEach(subRowItem -> {
                if (subRowItem.getTableRow() == subRow) {
                    subRowItem.setSelectType(TreeTableModel.SelectType.UNSELECT);
                    ((FsNodeExpansionInfo)subRow.getUserObject()).setSelectType(TreeTableModel.SelectType.UNSELECT);
                    FusionStoragePoolExpansionDialog.updateParentRowSelectType((FsNodeExpansionInfo)subRow.getParentRow().getUserObject());
                    subRowItem.getParent().setSelectType(((FsNodeExpansionInfo)subRow.getParentRow().getUserObject()).getSelectType());
                }
            });
            DialogUtils.showInfoDialog((JDialog)dialog, (String)erroMsg);
        }
    }
}

