/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.action;

import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.inspect.ui.wizard.FsExpansionSelectDeviceCard;
import com.huawei.ism.tool.inspect.ui.wizard.FsExpansionSelectDeviceCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelFsExpansionNodeAction
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelFsExpansionNodeAction.class);
    private DevNode node;
    private FsExpansionSelectDeviceCard parentCard;
    private TableRow<DevNode, DevNode> parentRow;
    private FsExpansionSelectDeviceCardLayout layout;

    public DelFsExpansionNodeAction(DevNode node, FsExpansionSelectDeviceCardLayout layout, TableRow<DevNode, DevNode> parentRow, FsExpansionSelectDeviceCard parentCard) {
        this.node = node;
        this.parentCard = parentCard;
        this.parentRow = parentRow;
        this.layout = layout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WarningDialog dialog = DialogUtils.showYesNoDialog((Window)FusionStorageEvalContext.getInstance().getMainDialog(), (String)String.format(Locale.ENGLISH, ResourceUtil.getStringWithParams((String)"inspsctor.wizard.fs.expansion.config.delete.warning", (Object[])new Object[]{this.node.getIp()}), new Object[0]));
        if (dialog.getValue() != 0) {
            return;
        }
        try {
            DefaultNodeProviderImpl.getInstance().removeNode(this.node);
            this.layout.getNodeRowList().remove(this.parentRow);
            InspectContext.getInstance().getNewExpansionNode().remove(this.node);
            DelFsExpansionNodeAction delFsExpansionNodeAction = this;
            List<DevNode> nodeList = delFsExpansionNodeAction.parentCard.getDevManagerList();
            this.removeNodeFromStoragePool(nodeList);
        }
        catch (ToolException toolException) {
            LOGGER.error("delete node failed,", (Throwable)toolException);
        }
        this.parentCard.refreshNodeTable();
        this.layout.updateAndShowStorageTable();
        this.layout.updateAndShowNodeTable();
    }

    private void removeNodeFromStoragePool(List<DevNode> nodeList) {
        block0: for (DevNode devNode : nodeList) {
            List pools = devNode.getStoragePools();
            for (FusionStorStoragePool pool : pools) {
                if (!pool.getExpansionNodeList().contains(this.node)) continue;
                pool.getExpansionNodeList().remove(this.node);
                continue block0;
            }
        }
    }
}

