/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.service.EvalCloseObserver;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.card.GetFusionUpdateToolDialog;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.entity.SupportScenes;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.logic.result.DetailEntry;
import com.huawei.ism.tool.inspect.service.implement.CloseObserver;
import com.huawei.ism.tool.inspect.service.implement.InspectorTaskSchedule;
import com.huawei.ism.tool.inspect.service.implement.OpenHelpCallBack;
import com.huawei.ism.tool.inspect.ui.logic.AdanceCompileRemotePyScript;
import com.huawei.ism.tool.inspect.ui.logic.AutoInitInspectCardTask;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.ui.logic.SilentUpdateHelpFileRunnable;
import com.huawei.ism.tool.inspect.ui.wizard.FirstCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.OemUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.CustMsgProgressDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartInspectorAction
implements IStartAction,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartInspectorAction.class);
    private static final String START_MODE = "startMode";
    private static final String BACK_MODE = "1";
    private static final String BACKEND_FLAG = "backFlag";
    private static final String TOOL_RUNNING_FLAG = "runningFlag";
    private static final String BACK_SENCE = "sence";
    private static final String MEMORY_INSPECT = "memoryInspect";
    public static final String ANOTHERTOOLFILE = "anothertool";
    public static final String DEVICEDATAFILE = "devicedatafile";
    public static final String SCENE_SN = "SN";
    public static final String SCENE_IP = "IP";
    public static final String SCENE_DEV_STATUS = "status";
    public static final String SCENE_FILE_NAME = "fileName";
    public static final String SCENE_TOOL_ID = "toolId";
    public static final String INSPECT_TOOL_ID = "Inspect";
    public static final String FUSION_STORAGE_EVAL_TOOL_ID = "FusionStorageUpdateEval";
    public static final String FUSION_STORAGE_UPDATE_TOOL_LAUNCHER_ID = "toUpdateTool";
    public static final String FILEPATH = ApplicationContext.getInstance().getThirdPartyRuntimePath() + File.separator + "data";
    private static FileLock fileLock = null;
    private static FileChannel backFlagChannel = null;
    private ToolWizardDialog wizardDialog = null;
    private CustMsgProgressDialog progressDialog = null;

    public static FileChannel getBackFlagChannel() {
        return backFlagChannel;
    }

    public static FileLock getFileLock() {
        return fileLock;
    }

    public static void setFileLock(FileLock fileLock) {
        StartInspectorAction.fileLock = fileLock;
    }

    @Override
    public void run() {
        String mode = System.getenv(START_MODE);
        LOGGER.debug("The start mode is: {}", (Object)StringUtils.getCleanMessage((String)mode));
        System.setProperty("VENDER", OemUtils.getVender());
        if (!BACK_MODE.equals(mode)) {
            try {
                InspectContext.getInstance().setForeground(true);
                this.startForegroundProcess(null);
            }
            catch (Throwable e) {
                LOGGER.error("Start inspect failed!", e);
                DialogUtils.showInfoDialog((JDialog)new JDialog(), (String)ResourceUtil.getString((String)"inspsctor.hook.init.failed"));
                Runtime.getRuntime().halt(3);
            }
        } else {
            AsyncExcutor.submit((Runnable)new SilentUpdateHelpFileRunnable());
        }
    }

    public void actionPerformed(Window parent, ActionEvent actionEvent) {
        String mode = System.getenv(START_MODE);
        InspectContext.getInstance().setForeground(!BACK_MODE.equals(mode));
        InspectContext.getInstance().setInMemoryInspectionSence(MEMORY_INSPECT.equals(System.getenv(BACK_SENCE)));
        if (!InspectContext.getInstance().isForeground()) {
            this.startBackgroundProcess();
        }
    }

    private void waitCBBCheckRunEnv() {
        while (InspectConstans.getInstance().getStartInspectStatus().get() == 0) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (InspectConstans.getInstance().getStartInspectStatus().get() == 2) {
            DialogUtils.showInfoDialog((JDialog)this.wizardDialog, (String)InspectConstans.getInstance().getCbbCheckStr());
            Runtime.getRuntime().halt(1);
        }
    }

    private void checkRunEnvSelf() {
        File file = new File(BACKEND_FLAG);
        if (!file.exists() || file.exists() && file.delete()) {
            List<SupportScenes> scenelist = SysConfiguration.getInstance().createdSceneList();
            if (scenelist.isEmpty()) {
                DialogUtils.showInfoDialog((JDialog)this.wizardDialog, (String)ResourceUtil.getString((String)"inspector.message.no.package"));
                InspectContext.getInstance().fireToolStopped();
            }
        } else {
            LOGGER.debug("Backgound process is running, cannot start the tool");
            DialogUtils.showInfoDialog((JDialog)this.wizardDialog, (String)ResourceUtil.getString((String)"inspector.background.process.running"));
            InspectContext.getInstance().fireToolStopped();
        }
        if (SceneUtils.isScene() && InspectContext.getInstance().getInspectSceneValue() == null) {
            DialogUtils.showErrorDialog((JDialog)this.wizardDialog, (String)ResourceUtil.getString((String)"inspsctor.wizard.importpackage.errorcode.7"));
            return;
        }
    }

    public void startForegroundProcess(Window parent) {
        String en;
        String zh;
        String keysPath;
        if (InspectUtils.isFusionStorage2Update()) {
            this.waitCBBCheckRunEnv();
            GetFusionUpdateToolDialog dialog = new GetFusionUpdateToolDialog();
            dialog.setVisible(true);
            return;
        }
        if (InspectUtils.isFusionInspect()) {
            keysPath = "fusionInspect" + File.separator + "fusion_inspect_reslist.xml";
            zh = "fusionInspect" + File.separator + "fusion_inspect_zh.properties";
            en = "fusionInspect" + File.separator + "fusion_inspect_en.properties";
            ResourceUtil.initCustomizedResource((String)keysPath, (String)zh, (String)en);
        }
        if (InspectUtils.isFusionCubeEval()) {
            keysPath = "fusioncubeEval" + File.separator + "fusioncube_eval_reslist.xml";
            zh = "fusioncubeEval" + File.separator + "fusioncube_eval_zh.properties";
            en = "fusioncubeEval" + File.separator + "fusioncube_eval_en.properties";
            ResourceUtil.initCustomizedResource((String)keysPath, (String)zh, (String)en);
        }
        this.wizardDialog = this.openInitUI(null);
        if (InspectUtils.isFusionEval() || InspectUtils.isFusionInspect() || InspectUtils.isFusionCubeEval()) {
            this.waitCBBCheckRunEnv();
            this.initFustorageEval();
        } else {
            this.initInspect();
        }
    }

    public void iniCustomizedResource() {
        InspectUtils.initSceneData();
        InspectContext.getInstance().initToolScene();
        if (InspectUtils.isFsExInspect()) {
            String keysPath = "fsexpansion" + File.separator + "fusion_expansion_reslist.xml";
            String zh = "fsexpansion" + File.separator + "fusion_expansion_inspect_zh.properties";
            String en = "fsexpansion" + File.separator + "fusion_expansion_inspect_en.properties";
            ResourceUtil.initCustomizedResource((String)keysPath, (String)zh, (String)en);
        }
    }

    private void initInspect() {
        this.progressDialog = new CustMsgProgressDialog((Window)this.wizardDialog, "", 300);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StartInspectorAction.this.wizardDialog.setVisible(true);
            }
        });
        LOGGER.debug("wizardDialog set visible");
        SysConfiguration.getInstance().initSysconf();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StartInspectorAction.this.progressDialog.setCustMizeMsg(ResourceUtil.getString((String)"inspsctor.wizard.step0.checkRunEnv"));
                StartInspectorAction.this.progressDialog.setVisible(true);
                StartInspectorAction.this.progressDialog.toFront();
            }
        });
        this.waitCBBCheckRunEnv();
        this.checkRunEnvSelf();
        this.loadInfo();
        this.progressDialog.setCustMizeMsg(ResourceUtil.getString((String)"inspsctor.wizard.step0.Fresh"));
        this.buildInspectUI();
        AsyncExcutor.submit((Runnable)new SilentUpdateHelpFileRunnable());
        AsyncExcutor.submit((Runnable)new AdanceCompileRemotePyScript());
        this.progressDialog.setVisible(false);
        this.progressDialog.dispose();
    }

    private void initFustorageEval() {
        this.buildFustorageEvalUI();
    }

    private void buildFustorageEvalUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StartInspectorAction.this.wizardDialog.setVisible(true);
            }
        });
        this.wizardDialog.setHelpActionCallBack((IHelpActionCallBack)new OpenHelpCallBack((JDialog)this.wizardDialog){

            @Override
            public void doHelpActionWork() {
                FusionStorageEvalContext.getInstance().setOpenHelpFile(true);
                String fileName = "";
                fileName = InspectUtils.isFusionEval() ? StartInspectorAction.INSPECT_TOOL_ID + File.separator + "FusionStorage" : (InspectUtils.isFusionCubeEval() ? StartInspectorAction.INSPECT_TOOL_ID + File.separator + "FusionCube" : StartInspectorAction.INSPECT_TOOL_ID + File.separator + "FusionStorage_Inspect");
                FileUtils.openHelpFile((String)fileName, (Window)StartInspectorAction.this.wizardDialog, (String)".chm");
            }
        });
        EvalCloseObserver closeObserver = new EvalCloseObserver(this.wizardDialog);
        this.wizardDialog.setObserver((IWizardClosingObserver)closeObserver);
        FusionStorageEvalContext.getInstance().setMainDialog((JDialog)this.wizardDialog);
        InspectContext.getInstance().setMainDialog((JDialog)this.wizardDialog);
        this.invokeAutoTask();
        Class<? extends InspectCard> clazz = InspectUIUtil.getFirstCard().getCardClazz();
        InspectCard card = InspectUIUtil.getCardInstance(clazz, null, InspectUIUtil.getCardNavs(clazz));
        this.wizardDialog.setFirstCard((ToolWizardDialog.Card)card);
        InspectContext.getInstance().updateStep(InspectUIUtil.getStepsViewInfo());
        card.initData();
    }

    private void initPanle(ToolWizardDialog swizardDialog, List<String[]> steps) {
        if (swizardDialog.getUserContentPane() != null) {
            swizardDialog.getUserContentPane().removeAll();
            FirstCardLayout layout = (FirstCardLayout)InspectUIUtil.getFirstCardLayoutInstance();
            swizardDialog.getUserContentPane().add(UiMethod.buildFrameSpace((JComponent)layout.getDescPanel(), (int)20));
            String wizardName = ResourceUtil.getStringWithParams((String)"inspsctor.wizard.title", (Object[])new Object[]{InspectContext.getInstance().getTitle(), steps.size()});
            swizardDialog.setWizardName(wizardName);
            swizardDialog.setTitle(wizardName + 1 + "\uff1a" + layout.getTittle());
        }
    }

    public ToolWizardDialog openInitUI(Window parent) {
        List<String[]> steps = InspectUIUtil.getStepsViewInfo();
        if (SceneUtils.isScene() && CardModelEnum.SCENEWELCOME.equals((Object)InspectUIUtil.getFirstCard())) {
            steps = new ArrayList<String[]>();
            steps.add(InspectUIUtil.getFirstCard().getDes());
        }
        ToolWizardDialog toolWizardDialog = null;
        toolWizardDialog = InspectUtils.isFsExInspect() ? new ToolWizardDialog(parent, steps, ResourceUtil.getImage((String)"inspector.png").getImage(), false, 1080, 650) : new ToolWizardDialog(parent, steps, ResourceUtil.getImage((String)"inspector.png").getImage(), this.isNeedHelp());
        toolWizardDialog.setResizable(false);
        UiMethod.setComponentSize((Dimension)InspectConstans.MAINDIALOG_SIZE, (Component[])new Component[]{toolWizardDialog});
        this.initPanle(toolWizardDialog, steps);
        SwingUtil.putScreenCenter((Window)toolWizardDialog);
        return toolWizardDialog;
    }

    boolean isNeedHelp() {
        return !SceneUtils.isScene() || InspectUtils.isFusionEval() || InspectUtils.isFusionInspect() || InspectUtils.isFusionCubeEval() || SceneUtils.isDpaInspect() || SceneUtils.isA800SceneInTool();
    }

    private void buildInspectUI() {
        BureauDocuService.INS.initConfig();
        this.wizardDialog.setHelpActionCallBack((IHelpActionCallBack)new OpenHelpCallBack((JDialog)this.wizardDialog));
        CloseObserver closeObserver = new CloseObserver(this.wizardDialog);
        this.wizardDialog.setObserver((IWizardClosingObserver)closeObserver);
        InspectContext.getInstance().setCloseObserver(closeObserver);
        InspectContext.getInstance().setMainDialog((JDialog)this.wizardDialog);
        this.invokeAutoTask();
        if (!InspectUtils.isSupportNfv()) {
            InspectUIUtil.removeStepCard(CardModelEnum.SCENEWELCOME);
        }
        Class<? extends InspectCard> clazz = InspectUIUtil.getFirstCard().getCardClazz();
        InspectCard card = InspectUIUtil.getCardInstance(clazz, null, InspectUIUtil.getCardNavs(clazz));
        this.wizardDialog.setFirstCard((ToolWizardDialog.Card)card);
        InspectContext.getInstance().updateStep(InspectUIUtil.getStepsViewInfo());
        String sceneType = InspectContext.getArgsParamFormSceneConfig("sceneType");
        String expCtrlErr = ResourceUtil.getString((String)"inspect.wizard.startinpectoraction.expctrl.error");
        if (InspectUtils.isPreExpEvaluation().booleanValue() && null != InspectContext.getInstance().getDevInfo() && null != InspectContext.getInstance().getDevInfo().getErrMsg()) {
            if (expCtrlErr.equals(InspectContext.getInstance().getDevInfo().getErrMsg())) {
                if ("expCtrl".equalsIgnoreCase(sceneType)) {
                    LOGGER.error("error happened for pre expansion querying device info.");
                    DialogUtils.showErrorDialog((JDialog)this.wizardDialog, (String)InspectContext.getInstance().getDevInfo().getErrMsg());
                }
            } else {
                LOGGER.error("error happened for pre expansion querying device info.");
                DialogUtils.showErrorDialog((JDialog)this.wizardDialog, (String)InspectContext.getInstance().getDevInfo().getErrMsg());
            }
        }
        card.initData();
    }

    private void invokeAutoTask() {
        List<Future<Object>> autoTask;
        AutoInitInspectCardTask.setProgressDialog(this.progressDialog);
        try {
            autoTask = AutoInitInspectCardTask.autoInvokeInit();
        }
        catch (Exception e) {
            LOGGER.error("get auto task failed.", (Throwable)e);
            return;
        }
        for (Future<Object> future : autoTask) {
            try {
                future.get();
            }
            catch (Exception e) {
                LOGGER.error("auto invoke task failed.", (Throwable)e);
            }
        }
    }

    public void startBackgroundProcess() {
        try {
            LOGGER.debug("Start the backgound process...");
            this.releaseForegroundLock();
            this.addBackgroundLock();
            LOGGER.info("before initSysConf user.dir is : {}", (Object)System.getProperty("user.dir"));
            SysConfiguration.getInstance().initSysconf();
            new AdanceCompileRemotePyScript().run();
            InspectorTaskSchedule schedule = new InspectorTaskSchedule();
            schedule.startSchedule();
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            Runtime.getRuntime().exit(20);
        }
    }

    public void addBackgroundLock() {
        String flagName = BACKEND_FLAG;
        if (InspectUtils.isToolKitDC()) {
            flagName = FilePathUtils.checkFile((String)System.getenv("flagName"));
        }
        FileChannel channel = null;
        try {
            channel = new RandomAccessFile(new File(flagName), "rw").getChannel();
            while (null == fileLock) {
                StartInspectorAction.setFileLock(channel.tryLock());
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            backFlagChannel = channel;
            this.writePidToBackFlagFile(backFlagChannel);
            LOGGER.info("Obtained back lock success: {}", (Object)fileLock);
        }
        catch (IOException e1) {
            LOGGER.error("Obtained back lock failed...");
            if (null != channel) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LOGGER.error("Close FileOutputStream of lock file failed...");
                }
            }
        }
        catch (InterruptedException e1) {
            LOGGER.error("Obtained back lock failed...", (Throwable)e1);
        }
    }

    public void writePidToBackFlagFile(FileChannel backFlagChannel) throws IOException {
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return;
        }
        String pid = ApplicationContext.getInstance().getCurrentProcessPid();
        String parentPid = this.getParentPid(pid);
        byte[] bytes = parentPid.getBytes(StandardCharsets.UTF_8);
        backFlagChannel.write(ByteBuffer.wrap(bytes));
    }

    private String getParentPid(String pid) throws IOException {
        Process proc = Runtime.getRuntime().exec("ps -o pid,ppid -p " + pid);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.info("ps -o -pid,ppid -p res :{}", (Object)line);
                if (!line.contains(pid)) continue;
                String string = line.trim().split("\\s+")[1];
                return string;
            }
        }
        return "";
    }

    public void releaseForegroundLock() {
        File file;
        FileOutputStream fos = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getToolLockStream();
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException e) {
                fos = null;
            }
        }
        if ((file = new File(TOOL_RUNNING_FLAG)).exists()) {
            boolean result = file.delete();
            LOGGER.debug("Release front lock {}", (Object)result);
        }
    }

    private void loadInfo() {
        InspectContext context = InspectContext.getInstance();
        context.setToolkitZhCn(Boolean.valueOf(System.getenv("toolkit.app.zh.version")));
        context.setSupportItems(UserOpDataSaveUtil.getToolIniProp((String)"tool.supportItemsInSVP"));
        if (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isOEM()) {
            context.setOemOutTool(true);
            DetailEntry.setOemOutTool(true);
            context.setSupportItems(UserOpDataSaveUtil.getToolIniProp((String)"tool.supportItemsInOEM"));
        }
        context.setHavingRightPatchTool(InspectUtils.existTool("patch") && InspectUtils.checkToolVersion("patch", "tool.version"));
    }
}

