/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.componet.jlist;

import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.ui.componet.jlist.ProgressBar;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.UI;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class InspectListCellRenderer
extends DefaultListCellRenderer {
    protected static final Dimension DESC_LABEL_SIZE = new Dimension(370, 18);
    private static final ImageIcon SUCCESS_IMAGE = ResourceUtil.getImage((String)"success.png");
    private static final ImageIcon FAILED_IMAGE = ResourceUtil.getImage((String)"failed.png");
    private static final ImageIcon NOSUPPORT_IMAGE = ResourceUtil.getImage((String)"nosupport.png");
    private static final ImageIcon NOCHECK_IMAGE = ResourceUtil.getImage((String)"nocheck.png");
    private static final ImageIcon WARNING_IMAGE = ResourceUtil.getImage((String)"warning.png");
    private static final ImageIcon MANUAL_CONFIRMATION_IMAGE = ResourceUtil.getImage((String)"warning.png");
    private static final ImageIcon RUNNING_IAMGE = ResourceUtil.getImage((String)"running.gif");
    protected static final Color COLOR_BEFORE_CLICK = new Color(4359891);
    private static final long serialVersionUID = -4250510788896266297L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        boolean isComponentSelected = isSelected;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isComponentSelected = true;
        }
        JPanel viewPan = new JPanel();
        if (value instanceof Record) {
            this.handleRecord(value, viewPan);
        }
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isComponentSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    protected void handleRecord(Object value, JPanel viewPan) {
        Record rec = (Record)value;
        JLabel statusLabel = this.initstatusLabel(rec);
        String date = StringUtils.formatDate((Object)rec.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
        JLabel descLabel = new JLabel(rec.getMessage());
        if (rec.getStatus() == RecordStatus.INFO) {
            descLabel.setForeground(COLOR_BEFORE_CLICK);
        }
        viewPan.setToolTipText(InspectContext.getInstance().getToolTip(rec.getMessage()));
        UiMethod.setComponentSize((Dimension)DESC_LABEL_SIZE, (Component[])new Component[]{descLabel});
        JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(date)});
        JComponent view = null;
        if (rec.getStatus() == RecordStatus.PROCESSING || rec.getStatus() == RecordStatus.RUNNING || rec.getStatus() == RecordStatus.RETRY) {
            ProgressBar bar = new ProgressBar(null, rec.getProgress(), dateComp, descLabel, statusLabel, Box.createGlue());
            if (0 != rec.getProgress()) {
                statusLabel.setText(statusLabel.getText() + " " + rec.getProgress() + "%");
            }
            view = bar;
        } else {
            statusLabel.setForeground(COLOR_BEFORE_CLICK);
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, descLabel, statusLabel, Box.createGlue()});
        }
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
    }

    private JLabel initstatusLabel(Record rec) {
        JLabel statusLabel = this.getStatusLabelByRecord(rec);
        if (StringUtils.isNULLStr((String)statusLabel.getText())) {
            RItem retItem = rec.getItem();
            statusLabel = this.getStatusLabelByRItem(retItem);
        }
        return statusLabel;
    }

    private JLabel getStatusLabelByRecord(Record rec) {
        JLabel statusLabel = new JLabel("");
        if (rec.getStatus() == RecordStatus.INTERRUPPED) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.execfaild.item");
            statusLabel.setIcon(FAILED_IMAGE);
        } else if (rec.getStatus() == RecordStatus.STOPPED) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.stopped");
            statusLabel.setIcon(NOCHECK_IMAGE);
        } else if (rec.getStatus() == RecordStatus.FAILED) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.execwarning");
            statusLabel.setIcon(WARNING_IMAGE);
        } else if (rec.getStatus() == RecordStatus.RUNNING) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.execing");
            statusLabel.setIcon(RUNNING_IAMGE);
        } else if (rec.getStatus() == RecordStatus.RETRY) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.retry");
            statusLabel.setIcon(RUNNING_IAMGE);
        } else if (rec.getStatus() == RecordStatus.PROCESSING) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.processing");
            statusLabel.setIcon(RUNNING_IAMGE);
        }
        return statusLabel;
    }

    private JLabel getStatusLabelByRItem(RItem retItem) {
        JLabel statusLabel = new JLabel("");
        if (null != retItem && retItem.isNormal()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.success");
            statusLabel.setIcon(SUCCESS_IMAGE);
        } else if (null != retItem && retItem.isFailed()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.failed");
            statusLabel.setIcon(FAILED_IMAGE);
        } else if (null != retItem && retItem.isNoSupport()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.nosupport");
            statusLabel.setIcon(NOSUPPORT_IMAGE);
        } else if (null != retItem && retItem.isNoCheck()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.nocheck");
            statusLabel.setIcon(NOCHECK_IMAGE);
        } else if (null != retItem && retItem.isWarning()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.warning");
            statusLabel.setIcon(WARNING_IMAGE);
        } else if (null != retItem && retItem.isManualConfirmation()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.manualconfirmation");
            statusLabel.setIcon(MANUAL_CONFIRMATION_IMAGE);
        } else if (retItem != null && retItem.isStop()) {
            statusLabel = UI.buildLabel("inspsctor.wizard.performinspect.stopped");
            statusLabel.setIcon(NOCHECK_IMAGE);
        }
        return statusLabel;
    }

    static {
        RUNNING_IAMGE.setImageObserver(InspectContext.getInstance().getMainDialog());
    }
}

