/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.componet.jlist;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Box;

public class ProgressBar
extends Box {
    private static final Color DEFAULT = new Color(125, 173, 225);
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private double progress = 0.0;
    private Color color = DEFAULT;
    private Color backColor = null;

    public ProgressBar(Color color, int progress, Component ... components) {
        super(0);
        this.color = color == null ? DEFAULT : color;
        this.progress = this.getValidProgress(progress);
        this.addComs(components);
    }

    public ProgressBar(Color proColor, Color backColor, int progress, Component ... components) {
        this(proColor, progress, components);
        this.backColor = backColor;
    }

    @Override
    public void paintComponent(Graphics gra) {
        super.paintComponent(gra);
        if (null != this.backColor) {
            gra.setColor(this.backColor);
            gra.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.progress != 0.0) {
            gra.setColor(this.color);
            gra.fillRect(0, 0, (int)((double)this.getWidth() * this.progress / 100.0), this.getHeight());
            gra.setColor(Color.GRAY);
            if (gra instanceof Graphics2D) {
                ((Graphics2D)gra).setStroke(STROKE);
                ((Graphics2D)gra).drawRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }

    private void addComs(Component ... components) {
        if (null == components || components.length == 0) {
            return;
        }
        this.add(components[0]);
        for (int index = 1; index < components.length; ++index) {
            this.add(Box.createHorizontalStrut(12));
            this.add(components[index]);
        }
    }

    public double getValidProgress(double pro) {
        return Math.min(100.0, Math.max(0.0, pro));
    }

    public void setProgress(double progress) {
        if (progress < 0.0) {
            return;
        }
        this.progress = this.getValidProgress(progress);
    }

    public double getProgress() {
        return this.progress;
    }
}

