/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.service.DeviceControl;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.devicecenter.ui.dialog.BatchImportInfoDialog;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.devicecenter.utils.SmartkitUtils;
import com.huawei.ism.tool.inspect.ui.dialogs.BmcNodeAuthLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcNodeAuthDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BmcNodeAuthDialog.class);
    private List<ClusterNode> selectedNodes;
    private BmcNodeAuthLayout layout;
    private TaskResult exportResult = null;
    private List<IImportListener> listenerTables = (List)DeviceCenterContext.getInstance().getDeviceTables().get("deviceTables");

    public BmcNodeAuthDialog(List<ClusterNode> selectedNodes) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.selectedNodes = selectedNodes;
        this.initUI();
        this.initListener();
    }

    public BmcNodeAuthDialog(ClusterNode selectedNode) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.selectedNodes = new ArrayList<ClusterNode>();
        this.selectedNodes.add(selectedNode);
        this.initUI(selectedNode);
        this.initListener();
    }

    private void initUI(ClusterNode selectedNode) {
        this.layout = new BmcNodeAuthLayout(true);
        DevNode ibmcNode = selectedNode.getBmcNode();
        if (ibmcNode == null) {
            return;
        }
        this.layout.getBmcIpField().setText(ibmcNode.getIp());
        User loginUser = ibmcNode.getLoginUser();
        if (loginUser != null) {
            this.layout.getUserNameField().setText(loginUser.getUserName());
            this.layout.getKeypwdField().setText(LayUtil.filterItemInfo((String)loginUser.getPassword()));
        }
        this.showLayout();
    }

    private void initUI() {
        this.layout = new BmcNodeAuthLayout(false);
        this.showLayout();
    }

    private void showLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void initListener() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BmcNodeAuthDialog.this.cancelAction();
            }
        });
        this.layout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String errorMsg = BmcNodeAuthDialog.this.checkFieldValue();
                if (!StringUtils.isNULLStr((String)errorMsg)) {
                    this.showErrorTipLabel(errorMsg);
                    return;
                }
                List changeNodes = BmcNodeAuthDialog.this.findChangeNodes();
                if (changeNodes.isEmpty()) {
                    this.showErrorTipLabel(ResourceUtil.getString((String)"auth.info.not.change"));
                    return;
                }
                BmcNodeAuthDialog.this.excutBmcAuth(changeNodes);
                BmcNodeAuthDialog.this.cancelAction();
            }

            private void showErrorTipLabel(String errorMsg) {
                BmcNodeAuthDialog.this.layout.getErrorTipLabel().setText(errorMsg);
                BmcNodeAuthDialog.this.layout.getErrorTipLabel().setForeground(Color.RED);
                BmcNodeAuthDialog.this.layout.repaint();
            }
        });
    }

    private List<ClusterNode> findChangeNodes() {
        List<Object> changeNodes = new ArrayList<ClusterNode>();
        if (this.selectedNodes.size() == 1) {
            this.initChangeNodesByListSizeIsOne(changeNodes);
        } else {
            changeNodes = this.selectedNodes.stream().filter(node -> this.checkBmcInfohasChange(node.getBmcNode())).collect(Collectors.toList());
        }
        return changeNodes;
    }

    private void initChangeNodesByListSizeIsOne(List<ClusterNode> changeNodes) {
        ClusterNode clusterNode = this.selectedNodes.get(0);
        DevNode bmcNode = clusterNode.getBmcNode();
        if (bmcNode == null) {
            bmcNode = new DevNode();
            clusterNode.setBmcNode(bmcNode);
            changeNodes.add(clusterNode);
        } else if (!this.layout.getBmcIpField().getText().equals(clusterNode.getBmcNode().getIp()) || this.checkBmcInfohasChange(clusterNode.getBmcNode())) {
            changeNodes.add(clusterNode);
        }
    }

    private void cancelAction() {
        this.setVisible(false);
        this.dispose();
    }

    private String checkFieldValue() {
        String mustMessage = this.checkNullField();
        if (!StringUtils.isNULLStr((String)mustMessage)) {
            return mustMessage;
        }
        String ip = this.layout.getBmcIpField().getText();
        if (!StringUtils.isValidIPV4((String)ip) && !StringUtils.isIpv6Address((String)ip) && this.selectedNodes.size() < 2) {
            return ResourceUtil.getString((String)"bmc.auth.layout.addDev.advanced.ipaddresserror");
        }
        String sshPort = this.layout.getSshAndSftpPotField().getText();
        String redfishPort = this.layout.getRedfishPortField().getText();
        if (this.checkPort(sshPort)) {
            return ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo");
        }
        if (this.checkPort(redfishPort)) {
            return ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo");
        }
        return "";
    }

    private boolean checkPort(String port) {
        return Integer.parseInt(port) > 65535 || Integer.parseInt(port) <= 0;
    }

    private String checkNullField() {
        String nullCheckTips = "";
        if (StringUtils.isNULLStr((String)this.layout.getBmcIpField().getText()) && this.selectedNodes.size() < 2) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"bmc.auth.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"bmc.auth.action.check.selectnode.bmcip")});
            return nullCheckTips;
        }
        if (StringUtils.isNULLStr((String)this.layout.getUserNameField().getText())) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"bmc.auth.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"inspect.modify.userName")});
            return nullCheckTips;
        }
        String pwd = String.valueOf(this.layout.getKeypwdField().getPassword());
        if (null == pwd || "".equals(pwd)) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"bmc.auth.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"inspect.modify.pwd")});
            return nullCheckTips;
        }
        return this.checkPorField();
    }

    private String checkPorField() {
        String nullCheckTips = "";
        if (StringUtils.isNULLStr((String)this.layout.getSshAndSftpPotField().getText())) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"bmc.auth.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"bmc.auth.layout.ssh.sftp.prot.label")});
            return nullCheckTips;
        }
        if (StringUtils.isNULLStr((String)this.layout.getRedfishPortField().getText())) {
            nullCheckTips = ResourceUtil.getStringWithParams((String)"bmc.auth.layout.addDev.mustfill", (Object[])new Object[]{ResourceUtil.getString((String)"bmc.auth.layout.redfish.port.label")});
            return nullCheckTips;
        }
        return nullCheckTips;
    }

    private void excutBmcAuth(List<ClusterNode> changeNodes) {
        this.setVisible(false);
        this.dispose();
        final ArrayList<Object> hwServerDevs = new ArrayList<Object>();
        if (changeNodes.size() > 1) {
            List tempDevs = changeNodes.stream().map(node -> this.createHwServerDevice(node.getBmcNode().getIp(), node.getBmcNode().getIp())).collect(Collectors.toList());
            hwServerDevs.addAll(tempDevs);
        } else {
            HwServerDevice serverDev = this.createHwServerDevice();
            hwServerDevs.add(serverDev);
        }
        hwServerDevs.stream().filter(HwServerDevice.class::isInstance).map(HwServerDevice.class::cast).forEach(dev -> LOGGER.info("BMC IP:{},sshPort:{},redFishPort:{},start BmcAuth", new Object[]{dev.getStartIPAddress(), dev.getSshPort(), dev.getRedFishPort()}));
        BatchImportInfoDialog importDialog = null;
        importDialog = new BatchImportInfoDialog((Window)DeviceCenterContext.getInstance().getParent(), this.getTitle());
        if (null != importDialog) {
            SmartkitUtils.addBatchImportDialog((BatchImportInfoDialog)importDialog, this.listenerTables);
        }
        Runnable findIbmc = new Runnable(){

            @Override
            public void run() {
                DeviceControl.getInstance().initDriverFile();
                BmcNodeAuthDialog.this.exportResult = DeviceControl.getInstance().importDevices(hwServerDevs, BmcNodeAuthDialog.this.listenerTables);
                DeviceControl.getInstance().refreshFile();
                if (TaskResult.Result.SUCCESS.equals((Object)BmcNodeAuthDialog.this.exportResult.getResult())) {
                    LOGGER.info("find the device success.");
                } else {
                    LOGGER.info("find the device failed.");
                }
            }
        };
        Future<?> future = Executors.newSingleThreadExecutor().submit(findIbmc);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("the result of the task is: " + future.isDone());
        }
    }

    private boolean checkBmcInfohasChange(DevNode node) {
        if (node.getLoginUser() == null) {
            return true;
        }
        String userPwd = String.valueOf(this.layout.getKeypwdField().getPassword());
        String userName = this.layout.getUserNameField().getText();
        int port = Integer.valueOf(this.layout.getSshAndSftpPotField().getText());
        String redfishPort = this.layout.getRedfishPortField().getText();
        return !userName.equals(node.getLoginUser().getUserName()) || !userPwd.equals(node.getLoginUser().getPassword()) || port != node.getPort() || !redfishPort.equals(node.getRedFishPort());
    }

    private HwServerDevice createHwServerDevice() {
        String ip = this.layout.getBmcIpField().getText();
        return this.createHwServerDevice(ip, ip);
    }

    private HwServerDevice createHwServerDevice(String startIp, String endIp) {
        HwServerDevice serverDev = new HwServerDevice();
        serverDev.setStartIPAddress(startIp);
        serverDev.setEndIPAddress(endIp);
        serverDev.setUserName(this.layout.getUserNameField().getText());
        String userPwd = String.valueOf(this.layout.getKeypwdField().getPassword());
        serverDev.setUserPwd(userPwd);
        serverDev.setSshPort(Integer.valueOf(this.layout.getSshAndSftpPotField().getText()).intValue());
        serverDev.setRedFishPort(this.layout.getRedfishPortField().getText());
        serverDev.setItDeviceType(ITDeviceType.SERVER_IBMC);
        return serverDev;
    }
}

