/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevicesModifyDialog
extends JDialog {
    public static final int RETURN_CODE = 0;
    public static final int NEXT_CODE = 1;
    private static final InspectWorktaker WORK_TAKER = InspectContext.getInstance().getInspectWorktaker();
    private static final Logger LOGGER = LoggerFactory.getLogger(DevicesModifyDialog.class);
    private static final int MAX_PORT_NUM = 65535;
    private static final String ROOT = "root";
    private static String[] tableHeader = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devmodel"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devversion"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress"), ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.step")};
    private Window parent = null;
    private List<DevNode> devices = null;
    private boolean hasRoot = false;
    private String topInfo = "";
    private JLabel topLabel;
    private DefaultTableModel model = new DefaultTableModel(tableHeader, new int[0]);
    private IsmTable table = new IsmTable((TableModel)this.model);
    private TableScrollPane tableScrollPane = new TableScrollPane(false, false, false, this.table);
    private ToolHyperLinkLabel modifyLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.modify"));
    private JButton nextButton = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.modify.button.next"));
    private JButton returnButton = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.modify.button.return"));
    private int existCode = 0;

    public DevicesModifyDialog(Window parent, List<DevNode> devices, boolean hasRoot) {
        this(parent, "", devices, hasRoot);
    }

    public DevicesModifyDialog(Window parent, String topInfo, List<DevNode> devices, boolean hasRoot) {
        super(parent);
        this.parent = parent;
        this.devices = devices;
        this.hasRoot = hasRoot;
        this.topInfo = topInfo;
        this.initUI();
    }

    private void initUI() {
        if (null == this.devices || this.devices.isEmpty()) {
            LOGGER.warn("Modify devices is empty.");
            return;
        }
        this.initDevicesModifyDialog();
    }

    private void initModifyDialog(DevNode node) {
        ModifyDialog dialog = new ModifyDialog(node);
        dialog.initData();
        dialog.setVisible(true);
    }

    private void initDevicesModifyDialog() {
        this.tableScrollPane.setPreferredSize(new Dimension(400, 200));
        JComponent component = null;
        if (!StringUtils.isNULLStr((String)this.topInfo)) {
            this.topLabel = new JLabel(this.topInfo);
            component = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.topLabel}), Box.createVerticalStrut(12), UCD.buildHBoxLeft((Component[])new Component[]{this.tableScrollPane}), UCD.buildHBoxRight((Component[])new Component[]{this.returnButton, this.nextButton})});
        } else {
            component = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.tableScrollPane}), UCD.buildHBoxRight((Component[])new Component[]{this.returnButton, this.nextButton})});
        }
        this.setTitle(ResourceUtil.getString((String)"inspect.modify.enterlogininformation"));
        this.add(UiMethod.buildFrameSpace((JComponent)component, (int)12));
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
        this.setModal(true);
        this.initData();
        this.initListener();
        this.setVisible(true);
    }

    private void initData() {
        this.updateTable(this.devices);
    }

    private void initListener() {
        this.returnButton.addActionListener(e -> {
            this.existCode = 0;
            this.dispose();
        });
        this.nextButton.addActionListener(e -> {
            this.existCode = 1;
            this.dispose();
        });
        this.modifyLink.addClickListener((ToolHyperLinkLabel.ClickListener & Serializable)me -> this.initModifyDialog((DevNode)this.table.getMarkedRow().getUserObject()));
    }

    private void updateTable(List<DevNode> nodes) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (DevNode node : nodes) {
            rows.add(this.createRow(node));
        }
        this.model.addRows(rows);
    }

    private TableRow createRow(DevNode node) {
        DefaultTableRow row = new DefaultTableRow(tableHeader.length, (Object)node, (Object)node);
        row.setValueAt(0, (Object)node.getDeviceType().toString());
        row.setValueAt(1, (Object)node.getProductVersion());
        row.setValueAt(2, (Object)node.getIp());
        Map map = (Map)InspectContext.getInstance().getInspectWorktaker().get("ssh_root_devs");
        String description = null != map && null != map.get(node.getDeviceSerialNumber()) ? ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.modify") : ResourceUtil.getString((String)"inspect.modify.enterlogininformation");
        row.setValueAt(3, (Object)new IsmTableCell.HyperlinkCell(description, me -> this.initModifyDialog((DevNode)this.table.getMarkedRow().getUserObject())));
        return row;
    }

    private void updateRow(DevNode node) {
        TableRow row = this.model.getTableRowBy((Object)node);
        if (row != null) {
            IsmTableCell.HyperlinkCell cell = (IsmTableCell.HyperlinkCell)row.getValueAt(3);
            cell.setDescription(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.modify"));
        } else {
            LOGGER.error("row is null!");
        }
        if (this.model.getAllRows().isEmpty()) {
            this.existCode = 1;
            this.dispose();
        }
    }

    public int getExistCode() {
        return this.existCode;
    }

    class ModifyDialog
    extends JDialog {
        private NotEmptyInputValidator notEmptyValidator;
        private JLabel deviceTypeLabel;
        private JLabel deviceType;
        private JLabel deviceNameLable;
        private JLabel deviceName;
        private JLabel ipAddrLable;
        private JLabel ipAddr;
        private JLabel snLable;
        private JLabel sn;
        private JLabel userNameLable;
        private IsmTextField userName;
        private JLabel passwordLable;
        private IsmPasswordField password;
        private JLabel rootPwdLable;
        private IsmPasswordField rootPwd;
        private JLabel portLabel;
        private IsmTextField port;
        private JButton comfirm;
        private JButton cancel;
        private DevNode node;

        private ModifyDialog(DevNode node) {
            super(DevicesModifyDialog.this.parent);
            this.notEmptyValidator = new NotEmptyInputValidator();
            this.deviceTypeLabel = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devmodel") + ":");
            this.deviceType = new JLabel("");
            this.deviceNameLable = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devname") + ":");
            this.deviceName = new JLabel("");
            this.ipAddrLable = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.devipaddress") + ":");
            this.ipAddr = new JLabel("");
            this.snLable = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.sn") + ":");
            this.sn = new JLabel("");
            this.userNameLable = new JLabel(ResourceUtil.getString((String)"inspect.modify.userName") + ":");
            this.userName = UiMethod.getUsernameFiled();
            this.passwordLable = new JLabel(ResourceUtil.getString((String)"inspect.modify.pwd") + ":");
            this.password = UiMethod.getPasswordFiled();
            this.rootPwdLable = new JLabel(ResourceUtil.getString((String)"inspect.modify.root.pwd") + ":");
            this.rootPwd = UiMethod.getPasswordFiled();
            this.portLabel = new JLabel(ResourceUtil.getString((String)"inspect.modify.port") + ":");
            this.port = UiMethod.getSshPortFiled();
            this.comfirm = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.modify.button.comfirm"));
            this.cancel = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.modify.button.cancel"));
            this.node = null;
            this.node = node;
            this.initUI();
            this.bindChecker();
            this.initListener();
            this.setResizable(false);
            this.pack();
            SwingUtil.putScreenCenter((Window)this);
            UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
            this.setModal(true);
        }

        private void initUI() {
            JComponent top = null;
            top = DevicesModifyDialog.this.hasRoot ? UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.deviceTypeLabel, this.deviceType}), UCD.buildHBoxLeft((Component[])new Component[]{this.deviceNameLable, this.deviceName}), UCD.buildHBoxLeft((Component[])new Component[]{this.ipAddrLable, this.ipAddr}), UCD.buildHBoxLeft((Component[])new Component[]{this.snLable, this.sn}), UCD.buildHBoxLeft((Component[])new Component[]{this.userNameLable, this.userName}), UCD.buildHBoxLeft((Component[])new Component[]{this.passwordLable, this.password}), UCD.buildHBoxLeft((Component[])new Component[]{this.portLabel, this.port}), UCD.buildHBoxLeft((Component[])new Component[]{this.rootPwdLable, this.rootPwd}), Box.createVerticalStrut(12)}) : UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.deviceTypeLabel, this.deviceType}), UCD.buildHBoxLeft((Component[])new Component[]{this.deviceNameLable, this.deviceName}), UCD.buildHBoxLeft((Component[])new Component[]{this.ipAddrLable, this.ipAddr}), UCD.buildHBoxLeft((Component[])new Component[]{this.snLable, this.sn}), UCD.buildHBoxLeft((Component[])new Component[]{this.userNameLable, this.userName}), UCD.buildHBoxLeft((Component[])new Component[]{this.passwordLable, this.password}), UCD.buildHBoxLeft((Component[])new Component[]{this.portLabel, this.port}), Box.createVerticalStrut(12)});
            Box buttons = UCD.buildHBoxRight((Component[])new Component[]{this.comfirm, this.cancel});
            this.setComponentSize();
            this.setMinimumSize(new Dimension(320, 350));
            this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.selectdevice.table.modify"));
            this.add(UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{top, buttons}), (int)12));
        }

        private void initListener() {
            this.comfirm.addActionListener(e -> {
                if (!this.verifyInput()) {
                    LOGGER.warn("Input feild is empty");
                    return;
                }
                this.syncInputInfo();
                List result = AsyncExcutor.execute((ProgressDialog)new ProgressDialog((Window)this, ResourceUtil.getString((String)"inspect.modify.connecting"), 220), (boolean)true, (long)60000L, (Callable[])new Callable[]{() -> {
                    try {
                        SshConnectionManager.getSshConnection((DevNode)this.node);
                    }
                    catch (Exception e1) {
                        LOGGER.error("Connect dev failed.");
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        SshConnectionManager.releaseConnection((DevNode)this.node);
                    }
                    HashMap<String, DevNode> nodes = (HashMap<String, DevNode>)WORK_TAKER.get("ssh_root_devs");
                    if (null == nodes) {
                        nodes = new HashMap<String, DevNode>();
                        WORK_TAKER.put("ssh_root_devs", nodes);
                    }
                    nodes.put(this.node.getDeviceSerialNumber(), this.node);
                    return true;
                }});
                if (null != result && !result.isEmpty()) {
                    Object obj = result.get(0);
                    if (obj instanceof Boolean) {
                        Boolean success = (Boolean)obj;
                        if (Boolean.TRUE.equals(success)) {
                            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspect.modify.login.success"));
                            this.dispose();
                            DevicesModifyDialog.this.updateRow(this.node);
                        } else {
                            DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", (Object[])new Object[]{this.node.getIp()}));
                        }
                    }
                } else {
                    DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.deviceconnecterror", (Object[])new Object[]{this.node.getIp()}));
                }
            });
            this.cancel.addActionListener(e -> this.dispose());
        }

        private void bindChecker() {
            this.userName.setInputValueName(ResourceUtil.getString((String)"inspect.modify.userName"));
            this.userName.addInputValidator((InputValidator)this.notEmptyValidator);
            this.password.setInputValueName(ResourceUtil.getString((String)"inspect.modify.pwd"));
            this.password.addInputValidator((InputValidator)this.notEmptyValidator);
            this.port.setInputValueName(ResourceUtil.getString((String)"inspect.modify.port"));
            this.port.addInputValidator((InputValidator)this.notEmptyValidator);
            if (DevicesModifyDialog.this.hasRoot) {
                this.rootPwd.setInputValueName(ResourceUtil.getString((String)"inspect.modify.root.pwd"));
                this.rootPwd.addInputValidator((InputValidator)this.notEmptyValidator);
            }
        }

        private boolean verifyInput() {
            ArrayList<IsmTextField> textInputs = new ArrayList<IsmTextField>();
            textInputs.add(this.userName);
            textInputs.add(this.port);
            if (!SwingUtil.validateInput(textInputs, (Window)this)) {
                return false;
            }
            ArrayList<IsmPasswordField> pwdInputs = new ArrayList<IsmPasswordField>();
            pwdInputs.add(this.password);
            if (DevicesModifyDialog.this.hasRoot) {
                pwdInputs.add(this.rootPwd);
            }
            if (!SwingUtil.validatePwdInput(pwdInputs, (Window)this)) {
                return false;
            }
            int portNum = Integer.valueOf(this.port.getText());
            if (portNum > 65535 || portNum == 0) {
                DialogUtils.showErrorDialog((JDialog)this, (String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.devicePortInfo"));
                return false;
            }
            return true;
        }

        private void syncInputInfo() {
            String uName = this.userName.getText();
            String uPwd = new String(this.password.getPassword());
            String connPort = this.port.getText();
            String rPwd = new String(this.rootPwd.getPassword());
            User user = new User(uName, uPwd);
            if (DevicesModifyDialog.this.hasRoot) {
                User rUser = new User(DevicesModifyDialog.ROOT, Base64EncodeUtils.encode((String)rPwd));
                this.node.setRootUser(rUser);
            }
            this.node.setLoginUser(user);
            this.node.setPort(Integer.valueOf(connPort).intValue());
        }

        private void initData() {
            User rootUser;
            this.deviceType.setText(this.node.getDeviceType().toString());
            this.deviceName.setText(this.node.getDeviceName());
            this.ipAddr.setText(this.node.getIp());
            this.sn.setText(this.node.getDeviceSerialNumber());
            this.port.setText(this.node.getPort() + "");
            User loginUser = this.node.getLoginUser();
            if (null != loginUser) {
                this.userName.setText(loginUser.getUserName());
                this.password.setText(loginUser.getPassword());
            }
            if (DevicesModifyDialog.this.hasRoot && null != (rootUser = this.node.getRootUser())) {
                this.rootPwd.setText(Base64EncodeUtils.decode((String)rootUser.getPassword()));
            }
        }

        private void setComponentSize() {
            UiMethod.setComponentSize((Dimension)new Dimension(150, 21), (Component[])new Component[]{this.userName, this.password, this.port, this.rootPwd});
            if (DevicesModifyDialog.this.hasRoot) {
                UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.deviceNameLable, this.deviceTypeLabel, this.ipAddrLable, this.snLable, this.userNameLable, this.passwordLable, this.portLabel, this.rootPwdLable});
            } else {
                UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.deviceNameLable, this.deviceTypeLabel, this.ipAddrLable, this.snLable, this.userNameLable, this.passwordLable, this.portLabel});
            }
        }
    }
}

