/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import lombok.Generated;

public class DistributedBatchInputBox {
    private JTextPane batchStrategyTitle = UiMethod.createTextPaneWithDefaultLeftIdent((String)this.getBatchTitle());
    private JLabel batchInputDesc = new JLabel(this.getBatchDesc());
    private IsmTextField storageInputField = IsmTextField.getNameTextField((String)"[0-9]{1,2}", (String)"", (int)2, (int)0);
    private IsmTextField computeInputField = IsmTextField.getNameTextField((String)"[0-9]{1,3}", (String)"", (int)3, (int)0);
    private JTextField timeResultField = new JTextField();
    private Box storageInputBox = Box.createHorizontalBox();
    private Box computeInputBox = Box.createHorizontalBox();
    private Box timeResultBox = Box.createHorizontalBox();
    private JLabel storageErrorLabel = new JLabel(ResourceUtil.getStringWithParams((String)"number.input.out.of.range.tip", (Object[])new Object[]{InspectConstans.MAX_ONCE_STORAGE_NUM}));
    private JLabel computeErrorLabel = new JLabel(ResourceUtil.getStringWithParams((String)"number.input.out.of.range.tip", (Object[])new Object[]{InspectConstans.MAX_ONCE_COMPUTE_NUM}));

    public DistributedBatchInputBox() {
        this.initComponentProperty();
        this.handleInputeBox();
    }

    public Component getComponent() {
        JComponent component = UCD.buildVerticalBox(null, (Component[])this.getBoxComponentArray());
        component.setVisible(this.isNeedNodeBatchInput());
        return component;
    }

    private Component[] getBoxComponentArray() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(this.batchStrategyTitle);
        components.add(UCD.buildHorizontalBoxLeft((Component)this.batchInputDesc));
        components.add(this.getStorageInputBox());
        components.add(this.getComputeInputBox());
        if (!ApplicationContext.getInstance().isEnglishEnv()) {
            components.add(Box.createVerticalStrut(10));
        }
        components.add(this.timeResultBox);
        return components.toArray(new Component[0]);
    }

    private void initComponentProperty() {
        this.storageInputField.setText(this.getBundleString("ds.inspect.once.storage.node.number.default"));
        this.computeInputField.setText(this.getBundleString("ds.inspect.once.compute.node.number.default"));
        this.timeResultField.setText("");
        this.storageErrorLabel.setForeground(Color.RED);
        this.computeErrorLabel.setForeground(Color.RED);
        UiMethod.setComponentSize((Dimension)new Dimension(100, 22), (Component[])new Component[]{this.storageInputField});
        UiMethod.setComponentSize((Dimension)new Dimension(100, 22), (Component[])new Component[]{this.computeInputField});
        UiMethod.setComponentSize((Dimension)new Dimension(100, 22), (Component[])new Component[]{this.timeResultField});
        this.batchStrategyTitle.setPreferredSize(new Dimension(100, 24));
        this.timeResultField.setEditable(false);
        this.storageErrorLabel.setVisible(false);
        this.computeErrorLabel.setVisible(false);
    }

    private void handleInputeBox() {
        String storageMaxInput = this.getBundleString("ds.inspect.once.storage.node.number.max");
        String computeMaxInput = this.getBundleString("ds.inspect.once.compute.node.number.max");
        this.storageInputBox.add(Box.createHorizontalStrut(10));
        this.computeInputBox.add(Box.createHorizontalStrut(10));
        this.handleBatchNodeBox(this.storageInputBox, ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.once.storage.node.input.msg", (Object[])new Object[]{storageMaxInput}), (JTextField)this.storageInputField, this.storageErrorLabel);
        this.handleBatchNodeBox(this.computeInputBox, ResourceUtil.getStringWithParams((String)"dsstorage.batch.inspect.once.compute.node.input.msg", (Object[])new Object[]{computeMaxInput}), (JTextField)this.computeInputField, this.computeErrorLabel);
        this.mergeTitleAndText(this.timeResultBox, ResourceUtil.getString((String)"dsstorage.batch.inspect.cost.time.title"), this.timeResultField);
        this.timeResultBox.add(Box.createHorizontalGlue());
    }

    private void mergeTitleAndText(Box box, String title, JTextField field) {
        box.add(new JLabel(title));
        Box fieldBox = Box.createHorizontalBox();
        fieldBox.add(field);
        box.add(fieldBox);
    }

    private void handleBatchNodeBox(Box box, String title, JTextField field, JLabel errorDesc) {
        this.mergeTitleAndText(box, title, field);
        box.add(Box.createHorizontalStrut(10));
        box.add(errorDesc);
        box.add(Box.createHorizontalGlue());
    }

    private boolean isNeedNodeBatchInput() {
        return InspectContext.getInstance().getInspectWorktaker().getCheckDevNodes().stream().anyMatch(CheckDevNode::isNeedBatchInspect);
    }

    private String getBundleString(String key) {
        return ResourceBundle.getBundle("config.inspect").getString(key);
    }

    private List<ClusterNode> getAllSelectedClusterNodes() {
        return InspectContext.getInstance().getInspectWorktaker().getCheckDevNodes().stream().filter(CheckDevNode::isNeedBatchInspect).map(CheckDevNode::getDevNode).map(DevNode::getClusterNodes).flatMap(Collection::stream).filter(ClusterNode::isSelected).collect(Collectors.toList());
    }

    private Box getStorageInputBox() {
        return this.getAllSelectedClusterNodes().stream().anyMatch(ClusterNode::isStorageNode) ? this.storageInputBox : Box.createHorizontalBox();
    }

    private Box getComputeInputBox() {
        return this.getAllSelectedClusterNodes().stream().anyMatch(clusterNode -> !clusterNode.isStorageNode()) ? this.computeInputBox : Box.createHorizontalBox();
    }

    private String getBatchTitle() {
        return SceneUtils.isA800SceneInTool() ? ResourceUtil.getString((String)"dsstorage.batch.inspect.strategy.a800.title") : ResourceUtil.getString((String)"dsstorage.batch.inspect.strategy.ds.title");
    }

    private String getBatchDesc() {
        return SceneUtils.isA800SceneInTool() ? ResourceUtil.getString((String)"dsstorage.batch.inspect.once.node.input.a800.msg") : ResourceUtil.getString((String)"dsstorage.batch.inspect.once.node.input.ds.msg");
    }

    @Generated
    public IsmTextField getStorageInputField() {
        return this.storageInputField;
    }

    @Generated
    public IsmTextField getComputeInputField() {
        return this.computeInputField;
    }

    @Generated
    public JTextField getTimeResultField() {
        return this.timeResultField;
    }

    @Generated
    public JLabel getStorageErrorLabel() {
        return this.storageErrorLabel;
    }

    @Generated
    public JLabel getComputeErrorLabel() {
        return this.computeErrorLabel;
    }
}

