/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class ExitDialog
extends JDialog
implements ActionListener {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private static final long serialVersionUID = -2430990484757341104L;
    private static final int DIALOG_WEIGHT = 350;
    private static final int DIALOG_HEIGHT = 180;
    private static final int COLOCE_NUMBER = 0xD6D6D6;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextArea textMsg;
    private String message;
    private String title;
    private int selectValue = -1;

    public ExitDialog(JFrame parent, String title, String message) {
        super(parent);
        this.title = title;
        this.message = message;
        this.initComponent();
        this.initUI();
        this.setSize(350, 180);
        this.addListener();
        this.setResizable(false);
    }

    public ExitDialog(JDialog parent, String title, String message) {
        super(parent);
        this.title = title;
        this.message = message;
        this.initComponent();
        this.initUI();
        this.setSize(350, 180);
        this.addListener();
        this.setResizable(false);
    }

    public ExitDialog(JDialog parent, String title, String message, int weight, int height) {
        super(parent);
        this.title = title;
        this.message = message;
        this.initComponent();
        this.initUI();
        this.setSize(weight, height);
        this.addListener();
        this.setResizable(false);
    }

    private void addListener() {
        this.cancelBtn.addActionListener(this);
        this.okBtn.addActionListener(this);
    }

    private void initComponent() {
        this.okBtn = new JButton(ResourceUtil.getString((String)"toolbox.layout.exit.ok"));
        this.cancelBtn = new JButton(ResourceUtil.getString((String)"toolbox.layout.exit.cancel"));
        this.textMsg = UCD.createTextArea((String)this.message);
        ToolUCD.setStandardFont((JComponent[])new JComponent[]{this.textMsg});
        this.setTitle(this.title);
        ToolUCD.setStandardFont((JComponent[])new JComponent[]{this.okBtn, this.cancelBtn});
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.okBtn, this.cancelBtn});
    }

    private void initUI() {
        JComponent btnBox = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{this.okBtn, Box.createHorizontalStrut(15), this.cancelBtn});
        InnerJpanel buttonPanel = new InnerJpanel();
        int margin = 15;
        JComponent textInfo = UiMethod.buildFrameSpace((JComponent)this.textMsg, (int)margin);
        JComponent allBox = UCD.buildVerticalBox(null, (Component[])new Component[]{textInfo, new JSeparator(), btnBox, buttonPanel});
        this.setLayout(new BorderLayout());
        this.add((Component)allBox, "Center");
    }

    public int getValue() {
        return this.selectValue;
    }

    public static ExitDialog showExitDialog(JFrame parent, String title, String message) {
        ExitDialog dia = new ExitDialog(parent, title, message);
        dia.setModal(true);
        dia.toFront();
        SwingUtil.putScreenCenter((Window)dia);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)dia);
        dia.setVisible(true);
        return dia;
    }

    public static ExitDialog showExitDialog(JDialog parent, String title, String message) {
        ExitDialog dia = new ExitDialog(parent, title, message);
        dia.setModal(true);
        dia.toFront();
        SwingUtil.putScreenCenter((Window)dia);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)dia);
        dia.setVisible(true);
        return dia;
    }

    public static ExitDialog showExitDialog(JDialog parent, String title, String message, int diaWeight, int diaHeight) {
        ExitDialog dia = new ExitDialog(parent, title, message, diaWeight, diaHeight);
        dia.setModal(true);
        dia.toFront();
        SwingUtil.putScreenCenter((Window)dia);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)dia);
        dia.setVisible(true);
        return dia;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okBtn) {
            this.selectValue = 0;
        } else if (source == this.cancelBtn) {
            this.selectValue = 1;
        }
        this.dispose();
    }

    private static class InnerJpanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private InnerJpanel() {
        }

        @Override
        public void paint(Graphics arg0) {
            Color oldColor = arg0.getColor();
            arg0.setColor(new Color(0xD6D6D6));
            arg0.fillRect(0, this.getHeight() - 4, this.getWidth(), 4);
            arg0.setColor(oldColor);
            super.paint(arg0);
        }
    }
}

