/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.devicemanager.service.task.DevResultDisplayer;
import com.huawei.ism.tool.devicemanager.service.task.DeviceModifyObserver;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.inspect.service.implement.FusionCubeAuthTask;
import com.huawei.ism.tool.inspect.ui.dialogs.ProgressStepDialog;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.dialogs.ProgressNumDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.text.HintTextField;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.ui.swing.text.validator.NotEmptyInputValidator;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionCubeAuthDialog
extends JDialog
implements ActionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionCubeAuthDialog.class);
    private static final int USERNAME_DEFAUL_LEN = 16;
    private static final int PWD_DEFAUL_LEN = 20;
    private static final int BOX_DEFAULT_WIDTH = 450;
    private static final int BOX_DEFAULT_HIGTH = 90;
    private static final int FIELD_WIDTH_LENGTH = 0;
    private static final int MAX_INPUT_CONTENT_LENGTH = 60;
    private static final String ADMIN_USER = "admin";
    private static final int FUSION_CUBE_PORT = 443;
    private JButton confirm;
    private JButton cancel;
    private JLabel fusionCubeUsernameLabel = new JLabel(ResourceUtil.getString((String)"inspsctor.layout.fusioncubeauthdialog.fusioncube.loginname"));
    private HintTextField fusionCubeUsername = HintTextField.getNameTextField((String)".*", (String)"admin", (int)60, (int)0);
    private JLabel fusionCubePasswordLabel = new JLabel(ResourceUtil.getString((String)"inspsctor.layout.fusioncubeauthdialog.fusioncube.password"));
    private IsmPasswordField fusionCubePassword = UiMethod.getPasswordFiled();
    private NotEmptyInputValidator notEmptyInputValidator = new NotEmptyInputValidator();
    private JLabel errorTipLabel = new JLabel();
    private List<HintTextField> hintTextCheckInputs = new ArrayList<HintTextField>();
    private List<IsmPasswordField> passwordCheckInputs = new ArrayList<IsmPasswordField>();
    private List<DevNode> devNodes = new ArrayList<DevNode>();
    private TaskResult exportResult = null;
    private boolean showFusionCubeIp = true;
    private DefaultTableRow<String, String> tableRow;

    public FusionCubeAuthDialog(DevNode devNode, DefaultTableRow<String, String> tableRow) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.devNodes.add(devNode);
        this.tableRow = tableRow;
        this.init();
        this.initListener();
        this.setResizable(false);
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.confirm});
        UiMethod.setCloseWhenEscKeyPressed((JDialog)this);
        this.setModal(true);
    }

    private void initListener() {
        this.confirm.addActionListener(this);
        this.cancel.addActionListener(this);
    }

    private void init() {
        this.setMinimumSize(new Dimension(350, 200));
        this.initComponent();
        this.initInputValidator();
        this.initUi();
    }

    private void initUi() {
        this.setTitle(ResourceUtil.getString((String)"check.need.fusioncube.auth.button"));
        this.setLayout(new BorderLayout());
        this.add(UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (Component[])new Component[]{this.createComponent(), UCD.buildHBoxRight((Component[])new Component[]{this.confirm, this.cancel})}), (int)12));
    }

    private void initInputValidator() {
        this.fusionCubeUsername.setInputValueName(ResourceUtil.getString((String)"inspsctor.layout.fusioncubeauthdialog.fusioncube.loginname"));
        this.fusionCubeUsername.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.fusionCubePassword.setInputValueName(ResourceUtil.getString((String)"inspsctor.layout.fusioncubeauthdialog.fusioncube.password"));
        this.fusionCubePassword.addInputValidator((InputValidator)this.notEmptyInputValidator);
        this.hintTextCheckInputs.clear();
        this.hintTextCheckInputs.addAll(Collections.singletonList(this.fusionCubeUsername));
        this.passwordCheckInputs.clear();
        this.passwordCheckInputs.addAll(Collections.singletonList(this.fusionCubePassword));
    }

    private void initComponent() {
        this.confirm = new JButton(ResourceUtil.getString((String)"fusioncube.auth.layout.btnok"));
        this.cancel = new JButton(ResourceUtil.getString((String)"fusioncube.auth.layout.btncan"));
        UiMethod.setComponentSize((Dimension)new Dimension(150, 21), (Component[])new Component[]{this.fusionCubeUsername, this.fusionCubePassword});
        this.getRootPane().setDefaultButton(this.confirm);
        UiMethod.setBatchButtonMnemonic((JButton[])new JButton[]{this.confirm, this.cancel});
    }

    private JComponent createComponent() {
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{this.fusionCubeUsernameLabel, this.fusionCubePasswordLabel});
        Box fusionCubeUsernameComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.fusionCubeUsernameLabel, this.fusionCubeUsername});
        Box fusionCubePasswordComponent = UCD.buildHBoxLeft((Component[])new Component[]{this.fusionCubePasswordLabel, this.fusionCubePassword});
        return UCD.buildVerticalBox(null, (Component[])new Component[]{fusionCubeUsernameComponent, fusionCubePasswordComponent, Box.createVerticalStrut(12)});
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Objects.nonNull(actionEvent)) {
            Object source = actionEvent.getSource();
            if (source == this.confirm) {
                this.fusionCubeAuth();
            } else if (source == this.cancel) {
                this.setVisible(false);
                this.dispose();
            }
        }
    }

    private void fusionCubeAuth() {
        if (!this.validFusionCubeInput()) {
            return;
        }
        ProgressStepDialog progressDialog = this.initProcessDialog();
        String uname = this.fusionCubeUsername.getText();
        String pwd = new String(this.fusionCubePassword.getPassword());
        User user = new User(uname, pwd, 443);
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor((ProgressNumDialog)progressDialog);
        FusionCubeAuthTask task = new FusionCubeAuthTask(progressDialog, this.devNodes, user, this.tableRow);
        DevResultDisplayer displayer = new DevResultDisplayer();
        task.setDeviceModifyObserver((IDeviceOperaObserver)new DeviceModifyObserver(displayer));
        this.setVisible(false);
        TaskResult result = taskExecutor.execute((ServiceTask)task);
        result = DeviceQueryErrorParser.parseErrorInfo((TaskResult)result);
        this.handleResult(result);
    }

    private void handleResult(TaskResult result) {
        if (Objects.nonNull(result) && result.getResult() == TaskResult.Result.FAILED) {
            this.dispose();
            DialogUtils.showInfoDialog((JDialog)this, (String)result.getErrorLocaleDescription());
            this.setVisible(true);
        }
    }

    private boolean validFusionCubeInput() {
        boolean validEmptyInputRet;
        boolean bl = validEmptyInputRet = SwingUtil.validateHintTextInput(this.hintTextCheckInputs, (Window)this) && SwingUtil.validatePwdInput(this.passwordCheckInputs, (Window)this);
        return validEmptyInputRet;
    }

    private ProgressStepDialog initProcessDialog() {
        return new ProgressStepDialog(InspectContext.getInstance().getMainDialog(), this.devNodes.size());
    }

    @Generated
    public JButton getConfirm() {
        return this.confirm;
    }

    @Generated
    public JButton getCancel() {
        return this.cancel;
    }

    @Generated
    public JLabel getFusionCubeUsernameLabel() {
        return this.fusionCubeUsernameLabel;
    }

    @Generated
    public HintTextField getFusionCubeUsername() {
        return this.fusionCubeUsername;
    }

    @Generated
    public JLabel getFusionCubePasswordLabel() {
        return this.fusionCubePasswordLabel;
    }

    @Generated
    public IsmPasswordField getFusionCubePassword() {
        return this.fusionCubePassword;
    }

    @Generated
    public NotEmptyInputValidator getNotEmptyInputValidator() {
        return this.notEmptyInputValidator;
    }

    @Generated
    public JLabel getErrorTipLabel() {
        return this.errorTipLabel;
    }

    @Generated
    public List<HintTextField> getHintTextCheckInputs() {
        return this.hintTextCheckInputs;
    }

    @Generated
    public List<IsmPasswordField> getPasswordCheckInputs() {
        return this.passwordCheckInputs;
    }

    @Generated
    public List<DevNode> getDevNodes() {
        return this.devNodes;
    }

    @Generated
    public TaskResult getExportResult() {
        return this.exportResult;
    }

    @Generated
    public boolean isShowFusionCubeIp() {
        return this.showFusionCubeIp;
    }

    @Generated
    public DefaultTableRow<String, String> getTableRow() {
        return this.tableRow;
    }

    @Generated
    public void setConfirm(JButton confirm) {
        this.confirm = confirm;
    }

    @Generated
    public void setCancel(JButton cancel) {
        this.cancel = cancel;
    }

    @Generated
    public void setFusionCubeUsernameLabel(JLabel fusionCubeUsernameLabel) {
        this.fusionCubeUsernameLabel = fusionCubeUsernameLabel;
    }

    @Generated
    public void setFusionCubeUsername(HintTextField fusionCubeUsername) {
        this.fusionCubeUsername = fusionCubeUsername;
    }

    @Generated
    public void setFusionCubePasswordLabel(JLabel fusionCubePasswordLabel) {
        this.fusionCubePasswordLabel = fusionCubePasswordLabel;
    }

    @Generated
    public void setFusionCubePassword(IsmPasswordField fusionCubePassword) {
        this.fusionCubePassword = fusionCubePassword;
    }

    @Generated
    public void setNotEmptyInputValidator(NotEmptyInputValidator notEmptyInputValidator) {
        this.notEmptyInputValidator = notEmptyInputValidator;
    }

    @Generated
    public void setErrorTipLabel(JLabel errorTipLabel) {
        this.errorTipLabel = errorTipLabel;
    }

    @Generated
    public void setHintTextCheckInputs(List<HintTextField> hintTextCheckInputs) {
        this.hintTextCheckInputs = hintTextCheckInputs;
    }

    @Generated
    public void setPasswordCheckInputs(List<IsmPasswordField> passwordCheckInputs) {
        this.passwordCheckInputs = passwordCheckInputs;
    }

    @Generated
    public void setDevNodes(List<DevNode> devNodes) {
        this.devNodes = devNodes;
    }

    @Generated
    public void setExportResult(TaskResult exportResult) {
        this.exportResult = exportResult;
    }

    @Generated
    public void setShowFusionCubeIp(boolean showFusionCubeIp) {
        this.showFusionCubeIp = showFusionCubeIp;
    }

    @Generated
    public void setTableRow(DefaultTableRow<String, String> tableRow) {
        this.tableRow = tableRow;
    }
}

