/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.FsNodeExpansionInfo;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStorageExpansionConfigDialog;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStoragePoolExpansionDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.combo.IsmComboBox;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FusionStorageCreatStoragePoolDialog
extends FusionStoragePoolExpansionDialog {
    private static final String SSD_STRING = DiskTypeEnum.SSD.toString();
    private static final String SSD_CARD_AND_NVME_SSD_STRING = DiskTypeEnum.SSD_CARD_AND_NVME_SSD.toString();
    private static final String NOT_NEED = ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.please.select.cache.not");
    private static final int MINIMUM_NODE_NUMBER_BY_CAREAT_STORAGE_POOL = 3;
    private static final int MINIMUM_MAIN_DISK_NUMBER_BY_CAREAT_STORAGE_POOL = 4;
    private static final int MINIMUM_CACHE_DISK_NUMBER_BY_CAREAT_STORAGE_POOL = 1;
    private static final int PACIFIC_NODE_MINIMUM_CACHE_DISK_NUMBER = 4;
    public static final String N_A = "N/A";
    private ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> parentRow;

    public FusionStorageCreatStoragePoolDialog(FusionStorageExpansionConfigDialog parentDialog, DevNode devNode, List<DevNode> newExpansionNodeList, FusionStorStoragePool pool, ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> parentRow) {
        super(parentDialog, pool, devNode, newExpansionNodeList, null);
        if (pool.isDiskPool()) {
            this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.creat.disk.pool"));
            if (!pool.isBlock()) {
                this.initCreatListener();
            }
            this.parentRow = parentRow;
        } else {
            this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.creat.storagepool"));
            this.initCreatListener();
        }
    }

    private void initCreatListener() {
        IsmComboBox selectMainStorageDiskType = super.getStoragePoolLayout().getSelectMainStorageDiskType();
        selectMainStorageDiskType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.updateBySelsectMainStroageDiskType();
                this.updateTreeTableBySelect();
            }
        });
        IsmComboBox selectCacheDiskType = super.getStoragePoolLayout().getSelectCacheDiskType();
        selectCacheDiskType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.updateBySelsectCacheDiskType();
                this.updateTreeTableBySelect();
            }
        });
    }

    private void updateBySelsectCacheDiskType() {
        super.getStoragePool().setCacheDiskType(DiskTypeEnum.getDiskTypeEnum((String)super.getStoragePoolLayout().getSelectCacheDiskType().getSelectedItem().toString()));
    }

    private void updateBySelsectMainStroageDiskType() {
        IsmComboBox selectCacheDiskType = super.getStoragePoolLayout().getSelectCacheDiskType();
        selectCacheDiskType.removeAllItems();
        IsmComboBox selectMainStorageDiskType = super.getStoragePoolLayout().getSelectMainStorageDiskType();
        String selsectMainStorageDisk = selectMainStorageDiskType.getSelectedItem().toString();
        FusionStorStoragePool storagePool = super.getStoragePool();
        if (SSD_STRING.equals(selsectMainStorageDisk) || SSD_CARD_AND_NVME_SSD_STRING.equals(selsectMainStorageDisk)) {
            selectCacheDiskType.addItem((Object)NOT_NEED);
            storagePool.setCacheDiskType(null);
        } else {
            selectCacheDiskType.addItem((Object)SSD_CARD_AND_NVME_SSD_STRING);
            selectCacheDiskType.addItem((Object)SSD_STRING);
            storagePool.setCacheDiskType(DiskTypeEnum.SSD_CARD_AND_NVME_SSD);
        }
        selectCacheDiskType.setSelectedIndex(0);
        storagePool.setMainStorageDiskType(DiskTypeEnum.getDiskTypeEnum((String)selsectMainStorageDisk));
    }

    private void updateTreeTableBySelect() {
        List<Object> rowList = new ArrayList<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>>();
        super.initFreeNodeTreeTable(rowList);
        rowList = rowList.stream().sorted(this.comparatorRowByIP).collect(Collectors.toList());
        super.setThisDialogConfig(rowList.stream().map(row -> (FsNodeExpansionInfo)row.getUserObject()).collect(Collectors.toList()));
        super.getStoragePoolLayout().getTreeTableModel().setRows(false, rowList.toArray(new ITreeTableRow[rowList.size()]));
        this.updateNodeStatisticsView();
    }

    @Override
    protected void updateParent() {
        super.getStoragePool().setName(super.getFsLayout().getUserNameField().getText());
        ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row = super.getParentDialog().creatRow(super.getStoragePool());
        if (this.parentRow != null) {
            this.parentRow.addSubRow(row);
            super.getParentDialog().getExpansionConfigLayout().getStoragePoolTableModel().updateTabelView(false);
        } else {
            super.getParentDialog().getExpansionConfigLayout().getStoragePoolTableModel().addOneRow(row);
        }
        super.updateFreeCapacity(row);
        super.getFsLayout().finishCreatStoragePool();
    }

    @Override
    protected List<FusionStorDiskInfo> getfreeMainStorageDiskList(List<FusionStorDiskInfo> freeDiskList, FsNodeExpansionInfo nodeInfo) {
        if (super.getStoragePool().getMainStorageDiskType() == null) {
            return freeDiskList;
        }
        return super.getfreeMainStorageDiskList(freeDiskList, nodeInfo);
    }

    @Override
    protected String getSubRowDiskTypeMsg(FsNodeExpansionInfo child) {
        if (super.getStoragePool().getMainStorageDiskType() == null) {
            return child.getChildrenConfigDisk().getType().toString();
        }
        return super.getSubRowDiskTypeMsg(child);
    }

    @Override
    protected boolean foolProofByConfirmBtn() {
        this.updateConfigToCache();
        if (this.insufficientMinimumConfiguration()) {
            return false;
        }
        return super.foolProofByConfirmBtn();
    }

    private boolean insufficientMinimumConfiguration() {
        ArrayList<ArrayList<Object>> erroMsgList = new ArrayList<ArrayList<Object>>();
        List allRow = super.getFsLayout().getTable().getTreeTableModel().getAllTableRows();
        if (StringUtils.isNULLStr((String)super.getFsLayout().getUserNameField().getText())) {
            erroMsgList.add(this.buildErroMsg(ResourceUtil.getStringWithParams((String)"inspsctor.fs.expansion.storage.pool.name.nul.error", (Object[])new Object[]{super.getStoragePool().getPoolTypeName()}), N_A));
        }
        this.getNodeNumberErrorMsg(erroMsgList, allRow);
        if (this.isSelectPacificNode() || this.storagePoolHasPacificNode() || this.isSelectEastOceanNode()) {
            this.checkDiskNumByDiskZoneAndCacheGroup(erroMsgList, allRow);
        } else {
            this.checkDiskNumByDiskRow(erroMsgList, allRow);
        }
        if (!erroMsgList.isEmpty()) {
            String[] headers = new String[]{ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.erro.1"), ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.erro.2")};
            DialogUtils.showMultiErrorDialog((Window)this, (String)ResourceUtil.getStringWithParams((String)"inspsctor.fs.expansion.storage.pool.config.erro", (Object[])new Object[]{super.getStoragePool().getPoolTypeName()}), (String[])headers, erroMsgList);
            return true;
        }
        return false;
    }

    private void checkDiskNumByDiskZoneAndCacheGroup(List<ArrayList<Object>> erroMsgList, List<ITreeTableRow<?, ?>> allRow) {
        HashSet<Integer> diskZoneDiskNumSet = new HashSet<Integer>();
        HashSet<Integer> cacheGroupDiskNumSet = new HashSet<Integer>();
        allRow.forEach(row -> {
            FsNodeExpansionInfo parent = (FsNodeExpansionInfo)row.getUserObject();
            if (parent.isDiskZone() && !((FsNodeExpansionInfo)row.getParentRow().getUserObject()).isUnSelect()) {
                diskZoneDiskNumSet.add(this.getAllSelectDiskNumber(parent));
            } else if (parent.isCacheGroup() && !((FsNodeExpansionInfo)row.getParentRow().getUserObject()).isUnSelect()) {
                cacheGroupDiskNumSet.add(this.getAllSelectDiskNumber(parent));
            }
        });
        this.buildDiskZoneAndCacheGroupMsg(erroMsgList, diskZoneDiskNumSet, cacheGroupDiskNumSet);
    }

    private void buildDiskZoneAndCacheGroupMsg(List<ArrayList<Object>> erroMsgList, Set<Integer> diskZoneDiskNumSet, Set<Integer> cacheGroupDiskNumSet) {
        if (diskZoneDiskNumSet.stream().anyMatch(num -> num < 4)) {
            erroMsgList.add(this.buildErroMsg(ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.creat.disk.zone"), N_A));
        }
        if (!this.isSelectPacificNode() && !this.storagePoolHasPacificNode()) {
            return;
        }
        if (cacheGroupDiskNumSet.size() > 1) {
            erroMsgList.add(this.buildErroMsg(ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.cache.group"), N_A));
        }
        if (cacheGroupDiskNumSet.size() == 1 && new ArrayList<Integer>(cacheGroupDiskNumSet).get(0) < 4) {
            erroMsgList.add(this.buildErroMsg(ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.cache.group.min"), N_A));
        }
    }

    private int getAllSelectDiskNumber(FsNodeExpansionInfo parent) {
        int[] summarize = new int[]{0};
        parent.getAllDiskChildren().forEach(subConfig -> {
            summarize[0] = summarize[0] + subConfig.getChildDiskNumberBySelectType();
        });
        return summarize[0];
    }

    private void getNodeNumberErrorMsg(List<ArrayList<Object>> erroMsgList, List<ITreeTableRow<?, ?>> allRow) {
        Long select = allRow.stream().filter(row -> row.getParentRow() == null && !((FsNodeExpansionInfo)row.getUserObject()).isUnSelect()).count();
        if (select < 3L) {
            String msg = ResourceUtil.getStringWithParams((String)"inspsctor.fs.expansion.creat.storage.pool.node.rule.msg", (Object[])new Object[]{super.getStoragePool().getPoolTypeName()});
            erroMsgList.add(this.buildErroMsg(msg, N_A));
        }
    }

    private void checkDiskNumByDiskRow(List<ArrayList<Object>> erroMsgList, List<ITreeTableRow<?, ?>> allRow) {
        ArrayList<String> mainIpList = new ArrayList<String>();
        ArrayList<String> cacheIpList = new ArrayList<String>();
        allRow.stream().forEach(row -> {
            if (row.getParentRow() != null) {
                return;
            }
            ITreeTableRow parent = row;
            if (((FsNodeExpansionInfo)parent.getUserObject()).isUnSelect()) {
                return;
            }
            int[] summarize = new int[]{0, 0};
            ((FsNodeExpansionInfo)parent.getUserObject()).getAllDiskChildren().forEach(subConfig -> {
                if (subConfig.isMainStorageChild()) {
                    summarize[0] = summarize[0] + subConfig.getChildDiskNumberBySelectType();
                } else {
                    summarize[1] = summarize[1] + subConfig.getChildDiskNumberBySelectType();
                }
            });
            if (summarize[0] < 4) {
                mainIpList.add(((FsNodeExpansionInfo)parent.getUserObject()).getIp());
            }
            if (summarize[1] < 1) {
                cacheIpList.add(((FsNodeExpansionInfo)parent.getUserObject()).getIp());
            }
        });
        this.checkSelectNode(erroMsgList, mainIpList, cacheIpList);
    }

    private void checkSelectNode(List<ArrayList<Object>> erroMsgList, List<String> mainIpList, List<String> cacheIpList) {
        DiskTypeEnum mainStorageDiskType = super.getStoragePool().getMainStorageDiskType();
        String splitStr = ResourceUtil.getString((String)"check.need.bmc.auth.massege.splitStr");
        if (!mainIpList.isEmpty()) {
            erroMsgList.add(this.buildErroMsg(ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.main.disk.rule.msg"), String.join((CharSequence)splitStr, mainIpList)));
        }
        if (!cacheIpList.isEmpty() && mainStorageDiskType != DiskTypeEnum.SSD && mainStorageDiskType != DiskTypeEnum.SSD_CARD_AND_NVME_SSD) {
            erroMsgList.add(this.buildErroMsg(ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.cache.disk.rule.msg"), String.join((CharSequence)splitStr, cacheIpList)));
        }
    }

    private ArrayList<Object> buildErroMsg(String description, String nodeInfo) {
        ArrayList<Object> erroMsg = new ArrayList<Object>();
        erroMsg.add(description);
        erroMsg.add(nodeInfo);
        return erroMsg;
    }
}

