/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.ui.dialogs.FusionStorageCreatStoragePoolRowLayout;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStorageExpansionConfigDialog;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.combo.IsmComboBox;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JDialog;

public class FusionStorageCreatStoragePoolRowDialog
extends JDialog {
    private static final String SSD_STRING = DiskTypeEnum.SSD.toString();
    private static final String SSD_CARD_AND_NVME_SSD_STRING = DiskTypeEnum.SSD_CARD_AND_NVME_SSD.toString();
    private static final String NOT_NEED = ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.please.select.cache.not");
    private FusionStorageCreatStoragePoolRowLayout layout;
    private FusionStorStoragePool storagePool;
    private FusionStorageExpansionConfigDialog parentDialog;

    public FusionStorageCreatStoragePoolRowDialog(FusionStorageExpansionConfigDialog parentDialog, FusionStorStoragePool storagePool) {
        super((Dialog)parentDialog, true);
        this.parentDialog = parentDialog;
        this.storagePool = storagePool;
        this.layout = new FusionStorageCreatStoragePoolRowLayout(storagePool, parentDialog);
        this.showLayout();
        this.initSelectDistTypeListener();
        this.initButtonListener();
    }

    private void showLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.creat.storagepool"));
    }

    private void initButtonListener() {
        this.layout.getCancelBtn().addActionListener(event -> {
            if (!this.foolProofByCancelBtn()) {
                return;
            }
            this.dispose();
        });
        this.layout.getConfirmBtn().addActionListener(event -> {
            if (!this.check()) {
                return;
            }
            this.storagePool.setName(this.layout.getUserNameField().getText());
            this.storagePool.setServiceType(FusionStorStoragePool.ServiceType.mappingEnumByToString((String)this.layout.getSelectServiceType().getSelectedItem().toString()));
            ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row = this.parentDialog.creatRow(this.storagePool);
            this.parentDialog.getExpansionConfigLayout().getStoragePoolTableModel().addOneRow(row);
            this.parentDialog.getCacheStoragePoolExpansionInfo().put(this.storagePool, new ArrayList());
            this.dispose();
            if (!this.storagePool.isBlock()) {
                this.parentDialog.getExpansionConfigLayout().getCreatStoragePoolBtn().setEnabled(false);
            }
            this.layout.finishCreatStoragePool();
        });
    }

    private boolean check() {
        if (StringUtils.isNULLStr((String)this.layout.getUserNameField().getText())) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"inspsctor.fs.expansion.storage.pool.name.nul.error", (Object[])new Object[]{this.storagePool.getPoolTypeName()}));
            return false;
        }
        if (this.storagePool.getMainStorageDiskType() == null) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.no.select.disk.type.msg"));
            return false;
        }
        return true;
    }

    private boolean foolProofByCancelBtn() {
        String msg = ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.cancels.msg");
        WarningDialog warn = DialogUtils.showYesNoDialog((Window)this, (String)msg);
        return 0 == warn.getValue();
    }

    private void initSelectDistTypeListener() {
        IsmComboBox selectMainStorageDiskType = this.layout.getSelectMainStorageDiskType();
        selectMainStorageDiskType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.updateBySelsectMainStroageDiskType();
            }
        });
        IsmComboBox selectCacheDiskType = this.layout.getSelectCacheDiskType();
        selectCacheDiskType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.storagePool.setCacheDiskType(DiskTypeEnum.getDiskTypeEnum((String)this.layout.getSelectCacheDiskType().getSelectedItem().toString()));
            }
        });
    }

    private void updateBySelsectMainStroageDiskType() {
        IsmComboBox selectCacheDiskType = this.layout.getSelectCacheDiskType();
        selectCacheDiskType.removeAllItems();
        IsmComboBox selectMainStorageDiskType = this.layout.getSelectMainStorageDiskType();
        String selsectMainStorageDisk = selectMainStorageDiskType.getSelectedItem().toString();
        if (SSD_STRING.equals(selsectMainStorageDisk) || SSD_CARD_AND_NVME_SSD_STRING.equals(selsectMainStorageDisk)) {
            selectCacheDiskType.addItem((Object)NOT_NEED);
            this.storagePool.setCacheDiskType(null);
        } else {
            selectCacheDiskType.addItem((Object)SSD_CARD_AND_NVME_SSD_STRING);
            selectCacheDiskType.addItem((Object)SSD_STRING);
            this.storagePool.setCacheDiskType(DiskTypeEnum.SSD_CARD_AND_NVME_SSD);
        }
        selectCacheDiskType.setSelectedIndex(0);
        this.storagePool.setMainStorageDiskType(DiskTypeEnum.getDiskTypeEnum((String)selsectMainStorageDisk));
    }
}

