/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.FsNodeExpansionInfo;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.ui.action.CreatDiskPoolAction;
import com.huawei.ism.tool.inspect.ui.action.CreatStoragePoolAction;
import com.huawei.ism.tool.inspect.ui.action.DeleteStoragePoolAction;
import com.huawei.ism.tool.inspect.ui.action.StoragePoolExpansionConfigAction;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStorageExpansionConfigLayout;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStoragePoolExpansionDialog;
import com.huawei.ism.tool.inspect.ui.wizard.FsExpansionSelectDeviceCard;
import com.huawei.ism.tool.inspect.utils.FsExpansionUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.ui.component.treetable.DefaultTreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.MutliHyperLinkCell;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;

public class FusionStorageExpansionConfigDialog
extends JDialog {
    private String expansionConfigRs = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config");
    private String creatDiskPoolRs = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.creat.disk.pool");
    private String modifyExpansionConfigRs = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.modify");
    private String expansionConfigDeleteRs = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.delete");
    private FusionStorageExpansionConfigLayout layout;
    private DevNode devNode;
    private List<DevNode> newExpansionNode;
    private Map<FusionStorStoragePool, List<FsNodeExpansionInfo>> cacheStoragePoolExpansionInfo = new HashMap<FusionStorStoragePool, List<FsNodeExpansionInfo>>();
    private Map<String, FsNodeExpansionInfo> cacheFreeNodeExpansionInfo;
    private List<FusionStorStoragePool> cacheDeleteStorageList = new ArrayList<FusionStorStoragePool>();
    private TableRow<DevNode, DevNode> parentRow;
    private FsExpansionSelectDeviceCard parentCard;
    private String directlyExpandingStoragePool = FusionStorageConfig.getNfvVersion("directlyExpandingStoragePool");
    private Comparator<FusionStorStoragePool> storagePoolSortRule = (pool1, pool2) -> {
        if (pool1.isExisted() && pool2.isExisted()) {
            return pool1.getId().compareTo(pool2.getId());
        }
        return pool1.getCreatDate().compareTo(pool2.getCreatDate());
    };

    public FusionStorageExpansionConfigDialog(DevNode devNode, List<DevNode> newExpansionNode, TableRow<DevNode, DevNode> parentRow, FsExpansionSelectDeviceCard parentCard) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.devNode = devNode;
        this.newExpansionNode = newExpansionNode;
        this.parentRow = parentRow;
        this.parentCard = parentCard;
        this.layout = new FusionStorageExpansionConfigLayout(devNode);
        this.showLayout();
        this.initListener();
        this.initTable();
    }

    private void showLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.storage.title"));
    }

    private void initListener() {
        this.layout.getCreatStoragePoolBtn().addActionListener(new CreatStoragePoolAction(this, this.devNode, this.newExpansionNode));
        if (!this.devNode.getStoragePools().isEmpty() && !((FusionStorStoragePool)this.devNode.getStoragePools().get(0)).isBlock()) {
            this.layout.getCreatStoragePoolBtn().setEnabled(false);
        }
        this.initButten();
    }

    private void initTable() {
        List<ITreeTableRow> rowList = this.devNode.getStoragePools().stream().sorted(this.storagePoolSortRule).map(storagePool -> this.creatRow((FusionStorStoragePool)storagePool)).collect(Collectors.toList());
        this.layout.getStoragePoolTableModel().setRows(false, rowList.toArray(new ITreeTableRow[rowList.size()]));
        this.layout.getStoragePoolTableModel().updateTabelView(false);
    }

    public ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> creatRow(FusionStorStoragePool storagePool) {
        DefaultTreeTableRow row = new DefaultTreeTableRow(this.layout.getStoragePoolTableHeader().length, (Object)storagePool, (Object)storagePool);
        this.updateRow((ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool>)row, storagePool);
        this.buildDiskPoolRows((ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool>)row, storagePool);
        return row;
    }

    public void updateRow(ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row, FusionStorStoragePool storagePool) {
        int index = 0;
        row.setValueAt(index++, (Object)storagePool.getName());
        row.setValueAt(index++, (Object)storagePool.getId());
        row.setValueAt(index++, (Object)this.getPoolStatus(storagePool.getStatus()));
        if (storagePool.isDiskPool()) {
            row.setValueAt(index++, (Object)"");
        } else {
            row.setValueAt(index++, (Object)FsExpansionUtils.getFreeCapacityByString(storagePool));
        }
        this.buildStepCell(row, storagePool, index);
    }

    private void buildStepCell(ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row, FusionStorStoragePool storagePool, int index) {
        if (storagePool.isExisted()) {
            if (!this.isDirectlyExpandingStoragePoolDev() && !storagePool.isDiskPool()) {
                row.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(this.creatDiskPoolRs, (ActionListener)new CreatDiskPoolAction(this, this.devNode, this.newExpansionNode, row)));
            } else {
                row.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(this.expansionConfigRs, (ActionListener)new StoragePoolExpansionConfigAction(this, storagePool, this.devNode, this.newExpansionNode, row)));
            }
        } else {
            MutliHyperLinkCell call = new MutliHyperLinkCell();
            if (!this.isDirectlyExpandingStoragePoolDev() && !storagePool.isDiskPool()) {
                call.addHyperLinkCell(this.creatDiskPoolRs, (ActionListener)new CreatDiskPoolAction(this, this.devNode, this.newExpansionNode, row));
            } else {
                call.addHyperLinkCell(this.modifyExpansionConfigRs, (ActionListener)new StoragePoolExpansionConfigAction(this, storagePool, this.devNode, this.newExpansionNode, row));
            }
            call.addHyperLinkCell(this.expansionConfigDeleteRs, (ActionListener)new DeleteStoragePoolAction(this, row));
            row.setValueAt(index, (Object)call);
        }
    }

    private void buildDiskPoolRows(ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row, FusionStorStoragePool storagePool) {
        if (storagePool.getDiskPools().isEmpty()) {
            return;
        }
        storagePool.getDiskPools().stream().sorted(this.storagePoolSortRule).forEachOrdered(diskPool -> row.addSubRow(this.creatDiskPoolRow((FusionStorStoragePool)diskPool)));
    }

    private ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> creatDiskPoolRow(FusionStorStoragePool storagePool) {
        DefaultTreeTableRow row = new DefaultTreeTableRow(this.layout.getStoragePoolTableHeader().length, (Object)storagePool, (Object)storagePool);
        this.updateRow((ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool>)row, storagePool);
        return row;
    }

    public boolean isDirectlyExpandingStoragePoolDev() {
        return this.devNode.getProductVersion().startsWith(this.directlyExpandingStoragePool);
    }

    private String getPoolStatus(String status) {
        if (status.equals("N/A")) {
            return status;
        }
        return ResourceUtil.getString((String)("inspsctor.pool.status." + status));
    }

    public Map<FusionStorStoragePool, List<FsNodeExpansionInfo>> getCacheStoragePoolExpansionInfo() {
        return this.cacheStoragePoolExpansionInfo;
    }

    public Map<String, FsNodeExpansionInfo> getCacheFreeNodeExpansionInfo() {
        return this.cacheFreeNodeExpansionInfo;
    }

    public void setCacheFreeNodeExpansionInfo(Map<String, FsNodeExpansionInfo> cacheFreeNodeExpansionInfo) {
        this.cacheFreeNodeExpansionInfo = cacheFreeNodeExpansionInfo;
    }

    private void initButten() {
        this.initCancelButten();
        this.initConfirmButten();
    }

    private void initConfirmButten() {
        this.layout.getConfirmBtn().addActionListener(event -> {
            if (!this.foolProofByConfirmBtn()) {
                return;
            }
            this.delsetStorageAndDisassociated();
            this.updateConfigToDev();
            this.updateDiskPool();
            this.dispose();
            if (this.parentCard.hasExpansionConfig(this.devNode)) {
                this.parentCard.updateRowByUpdateExpansionConfig(this.parentRow, this.devNode);
            }
            this.parentCard.updateNavigationBar();
        });
    }

    private void updateDiskPool() {
        this.layout.getStoragePoolTableModel().getAllTableRows().stream().filter(rowtemp -> !rowtemp.getSubRowList().isEmpty()).forEach(rowtemp -> {
            ITreeTableRow row = rowtemp;
            FusionStorStoragePool storagePool = (FusionStorStoragePool)row.getUserObject();
            storagePool.getDiskPools().clear();
            storagePool.getDiskPools().addAll(row.getSubRowList().stream().map(diskPoolRow -> (FusionStorStoragePool)diskPoolRow.getUserObject()).collect(Collectors.toList()));
        });
    }

    private boolean foolProofByConfirmBtn() {
        if (this.configNoFinish()) {
            return false;
        }
        WarningDialog warn = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.config.confirm.msg"));
        return 0 == warn.getValue();
    }

    private boolean configNoFinish() {
        List erroStoragePool;
        if (!this.isDirectlyExpandingStoragePoolDev() && !(erroStoragePool = this.layout.getStoragePoolTableModel().getAllTableRows().stream().filter(rowtemp -> rowtemp.getParentRow() == null && rowtemp.getSubRowList().isEmpty()).map(row -> ((FusionStorStoragePool)row.getUserObject()).getName()).collect(Collectors.toList())).isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"inspsctor.fs.expansion.creat.storage.pool.no.disk.pool.msg", (Object[])new Object[]{String.join((CharSequence)ResourceUtil.getString((String)"check.need.bmc.auth.massege.splitStr"), erroStoragePool)}));
            return true;
        }
        return false;
    }

    private void delsetStorageAndDisassociated() {
        this.cacheDeleteStorageList.forEach(needDeleteStoragePool -> {
            if (this.devNode.getStoragePools().contains(needDeleteStoragePool)) {
                this.disassociatePoolFromNode((FusionStorStoragePool)needDeleteStoragePool);
                this.devNode.getStoragePools().remove(needDeleteStoragePool);
                needDeleteStoragePool.getDiskPools().forEach(diskPool -> this.disassociatePoolFromNode((FusionStorStoragePool)diskPool));
            }
            if (needDeleteStoragePool.isDiskPool()) {
                this.disassociatePoolFromNode((FusionStorStoragePool)needDeleteStoragePool);
            }
        });
    }

    private void disassociatePoolFromNode(FusionStorStoragePool needDeleteStoragePool) {
        needDeleteStoragePool.getExpansionClusterNode().forEach(node -> FsExpansionUtils.cleanExpansionConfig(node));
        needDeleteStoragePool.getExpansionNodeList().forEach(node -> FsExpansionUtils.cleanExpansionConfig(node));
        FsExpansionUtils.cleanPoolAllNode(needDeleteStoragePool);
    }

    private void updateConfigToDev() {
        this.cacheStoragePoolExpansionInfo.keySet().forEach(storagePool -> {
            FsExpansionUtils.cleanExpansionClusterNodeList(storagePool);
            FsExpansionUtils.cleanExpansionNodeList(storagePool);
        });
        this.cacheStoragePoolExpansionInfo.keySet().stream().forEach(storagePool -> {
            List<String> joinedClusterNode = storagePool.getJoinedClusterNode().stream().map(node -> node.getManagementIp()).collect(Collectors.toList());
            this.updateConfigToStoragePoll((FusionStorStoragePool)storagePool, joinedClusterNode);
            if (storagePool.isExpansionCreate() && !storagePool.isDiskPool() && !this.devNode.getStoragePools().contains(storagePool)) {
                this.devNode.getStoragePools().add(storagePool);
            }
        });
        if (this.cacheFreeNodeExpansionInfo != null) {
            this.cacheFreeNodeExpansionInfo.values().forEach(node -> node.cleanAndUpdateConfigToNode());
        }
    }

    private void updateConfigToStoragePoll(FusionStorStoragePool storagePool, List<String> joinedClusterNode) {
        this.cacheStoragePoolExpansionInfo.get(storagePool).forEach(nodeExpansionInfo -> {
            nodeExpansionInfo.cleanAndUpdateConfigToNode();
            String configIP = nodeExpansionInfo.getIp();
            if (!joinedClusterNode.contains(configIP) && !nodeExpansionInfo.isUnSelect()) {
                if (nodeExpansionInfo.nodeIsExist()) {
                    InspectContext.getInstance().getFsExpansionConfig(nodeExpansionInfo.getExistNode()).setExpansionJoinStoragePool(storagePool);
                    storagePool.getExpansionClusterNode().add(nodeExpansionInfo.getExistNode());
                }
                if (nodeExpansionInfo.nodeIsNewExpansion()) {
                    InspectContext.getInstance().getFsExpansionConfig(nodeExpansionInfo.getNewNode()).setExpansionJoinStoragePool(storagePool);
                    storagePool.getExpansionNodeList().add(nodeExpansionInfo.getNewNode());
                }
            }
        });
    }

    private void initCancelButten() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FusionStorageExpansionConfigDialog.this.foolProofByCancelBtn()) {
                    return;
                }
                FusionStorageExpansionConfigDialog.this.dispose();
            }
        });
    }

    private boolean foolProofByCancelBtn() {
        String msg = ResourceUtil.getString((String)"inspsctor.fs.expansion.config.cancels.msg");
        WarningDialog warn = DialogUtils.showYesNoDialog((Window)this, (String)msg);
        return 0 == warn.getValue();
    }

    public FusionStorageExpansionConfigLayout getExpansionConfigLayout() {
        return this.layout;
    }

    public void addDeleteStorage(ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row) {
        FusionStorStoragePool needDeleteStoragePool = (FusionStorStoragePool)row.getUserObject();
        List<FusionStorStoragePool> needDeleteDiskPools = row.getSubRowList().stream().map(diskRow -> (FusionStorStoragePool)diskRow.getUserObject()).collect(Collectors.toList());
        this.cacheDeleteStorageList.add(needDeleteStoragePool);
        this.layout.getStoragePoolTableModel().deleteRowByUpdate(row);
        this.layout.getTreeTable().selectAll();
        this.layout.getTreeTable().clearSelection();
        if (this.cacheStoragePoolExpansionInfo.containsKey(needDeleteStoragePool)) {
            List<FsNodeExpansionInfo> needFreeNodeList = this.cacheStoragePoolExpansionInfo.get(needDeleteStoragePool);
            needDeleteDiskPools.forEach(diskPool -> {
                if (this.cacheStoragePoolExpansionInfo.containsKey(diskPool)) {
                    needFreeNodeList.addAll((Collection)this.cacheStoragePoolExpansionInfo.get(diskPool));
                }
            });
            this.nodeToFree(needFreeNodeList);
            this.cacheStoragePoolExpansionInfo.remove(needDeleteStoragePool);
            return;
        }
        this.initCacheFreeNodeExpansionInfo();
        this.nodeToFree(needDeleteStoragePool);
        needDeleteDiskPools.forEach(diskPool -> this.nodeToFree((FusionStorStoragePool)diskPool));
    }

    private void nodeToFree(List<FsNodeExpansionInfo> needFreeNodeList) {
        needFreeNodeList.forEach(config -> {
            if (config.isUnSelect()) {
                return;
            }
            if (config.nodeIsExist()) {
                this.cacheFreeNodeExpansionInfo.put(config.getIp(), new FsNodeExpansionInfo(config.getExistNode()));
            } else {
                this.cacheFreeNodeExpansionInfo.put(config.getIp(), new FsNodeExpansionInfo(config.getNewNode()));
            }
        });
    }

    private void nodeToFree(FusionStorStoragePool needDeleteStoragePool) {
        needDeleteStoragePool.getExpansionClusterNode().stream().forEach(node -> this.cacheFreeNodeExpansionInfo.put(node.getManagementIp(), new FsNodeExpansionInfo((ClusterNode)node)));
        needDeleteStoragePool.getExpansionNodeList().forEach(node -> this.cacheFreeNodeExpansionInfo.put(node.getIp(), new FsNodeExpansionInfo((DevNode)node)));
    }

    private void initCacheFreeNodeExpansionInfo() {
        if (this.cacheFreeNodeExpansionInfo == null) {
            this.cacheFreeNodeExpansionInfo = new HashMap<String, FsNodeExpansionInfo>();
            this.devNode.getClusterNodes().stream().filter(clusterNode -> FusionStoragePoolExpansionDialog.hasStorageService(clusterNode)).filter(clusterNode -> clusterNode.getJoinedStoragePool() == null && FsExpansionUtils.isFreeNode(clusterNode)).forEach(node -> this.cacheFreeNodeExpansionInfo.put(node.getManagementIp(), new FsNodeExpansionInfo((ClusterNode)node)));
            this.newExpansionNode.stream().filter(newExpansionNode -> FsExpansionUtils.isFreeNode(newExpansionNode)).forEach(node -> this.cacheFreeNodeExpansionInfo.put(node.getIp(), new FsNodeExpansionInfo((DevNode)node)));
        }
    }

    public DevNode getDevNode() {
        return this.devNode;
    }
}

