/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.FsNodeExpansionInfo;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.ui.action.ChangeCapacityUnitAction;
import com.huawei.ism.tool.inspect.ui.action.ChangeDiskTypeAction;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStorageExpansionConfigDialog;
import com.huawei.ism.tool.inspect.ui.dialogs.FusionStoragePoolExpansionLayout;
import com.huawei.ism.tool.inspect.ui.logic.FsStoragePoolConfigTreeMouseListener;
import com.huawei.ism.tool.inspect.ui.wizard.PerformInspectCard;
import com.huawei.ism.tool.inspect.utils.FsExpansionUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.ui.component.treetable.DefaultTreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStoragePoolExpansionDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformInspectCard.class);
    private static final String STORAGE_SERVICE_KEY = "storage";
    private static final String ADD_CUSTOM_DISK = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.node.add.disk.custom");
    private static final String TIPS_ROW_MSG = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.node.add.tips.row.msg");
    private static final String NO_CACHE_DISK_ROW_TIPS_MSG = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.node.no.cache.disk.tips.msg");
    private static final String NO_DATA = ResourceUtil.getString((String)"inspsctor.fs.expansion.no.disk.data.msg");
    private static final String DISK_NUMBER_REGEX = "^[1-9][0-9]{0,9}$";
    public static final int MAX_DECIMAL_PLACES = 2;
    private static final String DISK_CAPACITY_REGEX = "^[1-9][0-9]{0,17}.{0,1}[0-9]{0,2}$";
    private static final String DISK_CAPACITY_TIPS_MSG = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.disk.capacity.default.msg");
    private static final String DISK_NUMBER_TIPS_MSG = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.disk.number.default.msg");
    private static final String DISK_DELETE_RS = ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.delete");
    public static final String[] DISK_CUSTOM_ROW_DISK_TYPE = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.type.1"), ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.type.2")};
    public static final String[] DISK_CUSTOM_ROW_DISK_CAPACITY = new String[]{ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.capacity.unit.0"), FusionStorDiskInfo.CapacityUnit.BYTE.getDescription(), FusionStorDiskInfo.CapacityUnit.KB.getDescription(), FusionStorDiskInfo.CapacityUnit.MB.getDescription(), FusionStorDiskInfo.CapacityUnit.GB.getDescription(), FusionStorDiskInfo.CapacityUnit.TB.getDescription()};
    private static final int TIPS_CELL_INDEX = 1;
    private static final int CUSTOM_ROW_DISK_TYPE_INDEX = 1;
    private static final int CUSTOM_ROW_DISK_SOURCE_INDEX = 2;
    public static final int CUSTOM_ROW_DISK_CAPACITY_INDEX = 3;
    public static final int CUSTOM_ROW_DISK_CAPACITY_UNIT_INDEX = 4;
    public static final int DISK_ZONE_NUM = 4;
    private static final String CACHE_GROUP_NAME = ResourceUtil.getString((String)"fs.node.expansion.info.children.type.CACHE");
    private static final int CUSTOM_ROW_DIKS_NUMBER_INDEX = 5;
    private static final int CUSTOM_ROW_DELETE_INDEX = 6;
    private static final String DISK_ZONE_DEFAULT_NAME = "disk_zone";
    private static final int ADD_CUSTOM_ROW_INDEX = 7;
    private FusionStoragePoolExpansionLayout layout;
    private FusionStorStoragePool storagePool;
    private ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> storagePoolRow;
    private DevNode devNode;
    private List<DevNode> newExpansionNodeList;
    private Map<FusionStorStoragePool, List<FsNodeExpansionInfo>> parentCacheExpansionInfo;
    private Map<String, FsNodeExpansionInfo> cacheFreeNodeExpansionInfo;
    private List<FsNodeExpansionInfo> thisDialogConfig;
    private FusionStorageExpansionConfigDialog parentDialog;
    private Comparator<FusionStorDiskInfo> comparatorDisk = new Comparator<FusionStorDiskInfo>(){

        @Override
        public int compare(FusionStorDiskInfo disk1, FusionStorDiskInfo disk2) {
            return disk1.getCapacityByLong().compareTo(disk2.getCapacityByLong());
        }
    };
    public Comparator<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> comparatorRowByIP = new Comparator<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>>(){

        @Override
        public int compare(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row1, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row2) {
            return ((FsNodeExpansionInfo)row1.getUserObject()).getIp().compareTo(((FsNodeExpansionInfo)row2.getUserObject()).getIp());
        }
    };

    public FusionStoragePoolExpansionDialog(FusionStorageExpansionConfigDialog parentDialog, FusionStorStoragePool storagePool, DevNode devNode, List<DevNode> newExpansionNodeList, ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> storagePoolRow) {
        super((Dialog)parentDialog, true);
        this.storagePool = storagePool;
        this.storagePoolRow = storagePoolRow;
        this.devNode = devNode;
        this.parentDialog = parentDialog;
        this.newExpansionNodeList = newExpansionNodeList;
        this.parentCacheExpansionInfo = parentDialog.getCacheStoragePoolExpansionInfo();
        this.cacheFreeNodeExpansionInfo = this.copyCacheFreeNode(parentDialog.getCacheFreeNodeExpansionInfo());
        this.layout = new FusionStoragePoolExpansionLayout(storagePool);
        this.initTreeTableData();
        this.showLayout();
        this.initListener();
        this.updateNodeStatisticsView();
        this.updateSelectAllCheckBox();
    }

    private Map<String, FsNodeExpansionInfo> copyCacheFreeNode(Map<String, FsNodeExpansionInfo> parentCache) {
        if (parentCache == null) {
            return parentCache;
        }
        HashMap<String, FsNodeExpansionInfo> copy = new HashMap<String, FsNodeExpansionInfo>();
        parentCache.keySet().forEach(ip -> {
            try {
                copy.put((String)ip, (FsNodeExpansionInfo)((FsNodeExpansionInfo)parentCache.get(ip)).clone());
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("Copy Free FsNodeExpansionInfo Error.", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Copy Free FsNodeExpansionInfo Error.", (Throwable)e);
            }
        });
        return copy;
    }

    private void initListener() {
        this.layout.getTable().addMouseListener((MouseListener)new FsStoragePoolConfigTreeMouseListener(this));
        this.initButten();
    }

    private void showLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.tittle"));
        if (this.storagePool == null) {
            this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.creat.storagepool"));
        }
    }

    private void initTreeTableData() {
        if (this.parentCacheExpansionInfo.containsKey(this.storagePool)) {
            this.thisDialogConfig = this.copyConfigList(this.parentCacheExpansionInfo.get(this.storagePool));
            this.initTreeTableDataByCache();
        } else {
            this.initTreeTableDataByStroage();
        }
        this.updateTreeSelectStatus();
    }

    private void updateTreeSelectStatus() {
        this.layout.getTreeTableModel().getAllItemList().forEach(item -> {
            ITreeTableRow fsRow = item.getTableRow();
            item.setSelectType(((FsNodeExpansionInfo)fsRow.getUserObject()).getSelectType());
            if (((FsNodeExpansionInfo)fsRow.getUserObject()).isNodeRow()) {
                FsStoragePoolConfigTreeMouseListener.updateDiskNumberByParentRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow);
            }
        });
    }

    private void initTreeTableDataByStroage() {
        ArrayList rowList = new ArrayList();
        List expansionNodeRowList = this.storagePool.getExpansionNodeList().stream().map(node -> this.createRowByNewExpansionNode(new FsNodeExpansionInfo((DevNode)node))).collect(Collectors.toList());
        List expansionClusterNodeRowList = this.storagePool.getExpansionClusterNode().stream().map(node -> this.createRowByNode(new FsNodeExpansionInfo((ClusterNode)node))).collect(Collectors.toList());
        ArrayList expansionRowList = new ArrayList();
        expansionRowList.addAll(expansionNodeRowList);
        expansionRowList.addAll(expansionClusterNodeRowList);
        rowList.addAll(expansionRowList.stream().sorted(this.comparatorRowByIP).collect(Collectors.toList()));
        List storageRowList = this.storagePool.getJoinedClusterNode().stream().map(node -> this.createRowByNode(new FsNodeExpansionInfo((ClusterNode)node))).sorted(this.comparatorRowByIP).collect(Collectors.toList());
        rowList.addAll(storageRowList);
        ArrayList<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> freeNodeRowList = new ArrayList<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>>();
        this.initFreeNodeTreeTable(freeNodeRowList);
        rowList.addAll(freeNodeRowList.stream().sorted(this.comparatorRowByIP).collect(Collectors.toList()));
        this.thisDialogConfig = rowList.stream().map(row -> (FsNodeExpansionInfo)row.getUserObject()).collect(Collectors.toList());
        this.layout.getTreeTableModel().setRows(false, rowList.toArray(new ITreeTableRow[rowList.size()]));
    }

    public void initFreeNodeTreeTable(List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> rowList) {
        if (this.cacheFreeNodeExpansionInfo == null) {
            this.cacheFreeNodeExpansionInfo = new HashMap<String, FsNodeExpansionInfo>();
            this.initAllFreeNode(rowList);
        } else {
            this.initFreeNodeByCache(rowList);
        }
    }

    private void initAllFreeNode(List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> rowList) {
        List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> freeNodeRowList = this.devNode.getClusterNodes().stream().filter(clusterNode -> FusionStoragePoolExpansionDialog.hasStorageService(clusterNode)).filter(clusterNode -> clusterNode.getJoinedStoragePool() == null && FsExpansionUtils.isFreeNode(clusterNode)).map(node -> this.createRowByNode(new FsNodeExpansionInfo((ClusterNode)node))).collect(Collectors.toList());
        this.cacheFreeNodeExpansionInfoAddInfo(freeNodeRowList);
        rowList.addAll(freeNodeRowList);
        List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> freeNewExpansionNodeRowList = this.newExpansionNodeList.stream().filter(newExpansionNode -> FsExpansionUtils.isFreeNode(newExpansionNode)).map(node -> this.createRowByNewExpansionNode(new FsNodeExpansionInfo((DevNode)node))).collect(Collectors.toList());
        this.cacheFreeNodeExpansionInfoAddInfo(freeNewExpansionNodeRowList);
        rowList.addAll(freeNewExpansionNodeRowList);
    }

    private void initFreeNodeByCache(List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> rowList) {
        List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> freeNodeRowList = this.devNode.getClusterNodes().stream().filter(clusterNode -> FusionStoragePoolExpansionDialog.hasStorageService(clusterNode)).filter(node -> this.cacheFreeNodeExpansionInfo.containsKey(node.getManagementIp())).map(node -> this.createRowByNode(new FsNodeExpansionInfo((ClusterNode)node))).collect(Collectors.toList());
        this.cacheFreeNodeExpansionInfoAddInfo(freeNodeRowList);
        rowList.addAll(freeNodeRowList);
        List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> freeNewExpansionNodeRowList = this.newExpansionNodeList.stream().filter(node -> this.cacheFreeNodeExpansionInfo.containsKey(node.getIp())).map(node -> this.createRowByNewExpansionNode(new FsNodeExpansionInfo((DevNode)node))).collect(Collectors.toList());
        this.cacheFreeNodeExpansionInfoAddInfo(freeNewExpansionNodeRowList);
        rowList.addAll(freeNewExpansionNodeRowList);
    }

    private void cacheFreeNodeExpansionInfoAddInfo(List<ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>> freeNodeRowList) {
        freeNodeRowList.forEach(row -> this.cacheFreeNodeExpansionInfo.put(((FsNodeExpansionInfo)row.getUserObject()).getIp(), (FsNodeExpansionInfo)row.getUserObject()));
    }

    private void initTreeTableDataByCache() {
        List<ITreeTableRow> rowList = this.thisDialogConfig.stream().map(nodeExpansionInfo -> this.createRow((FsNodeExpansionInfo)nodeExpansionInfo)).collect(Collectors.toList());
        List freeNodeRowList = this.cacheFreeNodeExpansionInfo.values().stream().map(nodeExpansionInfo -> this.createRow((FsNodeExpansionInfo)nodeExpansionInfo)).collect(Collectors.toList());
        rowList.addAll(freeNodeRowList);
        this.thisDialogConfig.addAll(this.cacheFreeNodeExpansionInfo.values());
        this.layout.getTreeTableModel().setRows(false, rowList.toArray(new ITreeTableRow[rowList.size()]));
    }

    public static boolean hasStorageService(ClusterNode clusterNode) {
        return clusterNode.getRoles().stream().anyMatch(service -> service.toLowerCase().contains(STORAGE_SERVICE_KEY));
    }

    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> createRow(FsNodeExpansionInfo nodeInfo) {
        if (nodeInfo.nodeIsExist()) {
            return this.createRowByNode(nodeInfo);
        }
        return this.createRowByNewExpansionNode(nodeInfo);
    }

    public ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> createRowByNode(FsNodeExpansionInfo nodeInfo) {
        ClusterNode node = nodeInfo.getExistNode();
        DefaultTreeTableRow row = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)nodeInfo, (Object)nodeInfo);
        int index = 1;
        row.setValue(index++, (Object)node.getManagementIp());
        row.setValue(index++, (Object)node.getName());
        row.setValue(index++, (Object)(node.getBmcNode() == null ? "--" : node.getBmcNode().getProductModel()));
        row.setValue(index++, (Object)nodeInfo.getNodeType().toString());
        this.buildRowByDiskInfo(nodeInfo, node.getAllDiskInfo(), (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)row, index);
        FusionStoragePoolExpansionDialog.updateParentRowSelectType(nodeInfo);
        return row;
    }

    public static void updateParentRowSelectType(FsNodeExpansionInfo nodeInfo) {
        if (nodeInfo.getChildren().isEmpty()) {
            return;
        }
        List<FsNodeExpansionInfo> children = nodeInfo.getChildren();
        children.forEach(child -> FusionStoragePoolExpansionDialog.updateParentRowSelectType(child));
        long selectSubRows = children.stream().filter(child -> child.isSelect()).count();
        long unSelectRows = children.stream().filter(child -> child.isUnSelect()).count();
        long allRowSize = children.size();
        if (unSelectRows == allRowSize) {
            nodeInfo.setSelectType(TreeTableModel.SelectType.UNSELECT);
        } else if (selectSubRows == allRowSize) {
            nodeInfo.setSelectType(TreeTableModel.SelectType.SELECT);
        } else {
            nodeInfo.setSelectType(TreeTableModel.SelectType.HALF);
        }
    }

    public ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> createRowByNewExpansionNode(FsNodeExpansionInfo nodeInfo) {
        DevNode node = nodeInfo.getNewNode();
        DefaultTreeTableRow row = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)nodeInfo, (Object)nodeInfo);
        int index = 1;
        row.setValue(index++, (Object)node.getIp());
        row.setValue(index++, (Object)node.getDeviceName());
        row.setValue(index++, (Object)node.getProductModel());
        row.setValue(index++, (Object)nodeInfo.getNodeType().toString());
        this.buildRowByDiskInfo(nodeInfo, node.getAllDiskInfo(), (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)row, index);
        FusionStoragePoolExpansionDialog.updateParentRowSelectType(nodeInfo);
        return row;
    }

    private void buildRowByDiskInfo(FsNodeExpansionInfo nodeInfo, List<FusionStorDiskInfo> allDiskInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, int index) {
        List<FusionStorDiskInfo> freeDiskList = this.getFreeDiskList(nodeInfo, allDiskInfo);
        List<FusionStorDiskInfo> freeMainStorageDiskList = this.getfreeMainStorageDiskList(freeDiskList, nodeInfo);
        List<FusionStorDiskInfo> freeCacheDiskList = this.getFreeCacheDiskList(freeDiskList);
        int actualIndex = index;
        nodeInfo.setMainStorageMaxNumber(freeMainStorageDiskList.size());
        nodeInfo.setCacheMaxNumber(freeCacheDiskList.size());
        row.setValue(actualIndex++, (Object)("0/" + freeMainStorageDiskList.size()));
        row.setValue(actualIndex++, (Object)("0/" + freeCacheDiskList.size()));
        if (!nodeInfo.involveDiskZone()) {
            this.buildCustomButton(row, actualIndex);
        }
        this.initSubRows(nodeInfo, row, freeMainStorageDiskList, freeCacheDiskList);
    }

    private List<FusionStorDiskInfo> getFreeCacheDiskList(List<FusionStorDiskInfo> freeDiskList) {
        return freeDiskList.stream().filter(disk -> disk.getType() == this.storagePool.getCacheDiskType()).collect(Collectors.toList());
    }

    private Map<String, List<FusionStorDiskInfo>> getDiskZoneListMap(List<FusionStorDiskInfo> allDiskInfo) {
        HashMap<String, List<FusionStorDiskInfo>> diskZoneListMap = new HashMap<String, List<FusionStorDiskInfo>>();
        allDiskInfo.forEach(disk -> {
            String diskZoneId = disk.getDiskZoneId();
            if (StringUtils.isNULLStr((String)diskZoneId)) {
                return;
            }
            if (disk.getType() == this.storagePool.getCacheDiskType()) {
                return;
            }
            if (disk.getType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD) {
                return;
            }
            if (diskZoneListMap.containsKey(diskZoneId)) {
                ((List)diskZoneListMap.get(diskZoneId)).add(disk);
            } else {
                ArrayList<FusionStorDiskInfo> diskList = new ArrayList<FusionStorDiskInfo>();
                diskList.add((FusionStorDiskInfo)disk);
                diskZoneListMap.put(diskZoneId, diskList);
            }
        });
        return diskZoneListMap;
    }

    private void buildCustomButton(final ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, int index) {
        row.setValueAt(index, (Object)new IsmTableCell.HyperlinkCell(ADD_CUSTOM_DISK, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FusionStoragePoolExpansionDialog.this.storagePool.getMainStorageDiskType() == null) {
                    DialogUtils.showInfoDialog((JDialog)FusionStoragePoolExpansionDialog.this, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.no.select.disk.type.msg"));
                    return;
                }
                List<ITreeTableRow> tipsRow = row.getSubRowList().stream().filter(subRow -> ((FsNodeExpansionInfo)subRow.getUserObject()).isTips()).collect(Collectors.toList());
                tipsRow.forEach(subRow -> {
                    ((FsNodeExpansionInfo)row.getUserObject()).getChildren().remove(subRow.getUserObject());
                    FusionStoragePoolExpansionDialog.this.layout.getTable().getTreeTableModel().deleteRowByUpdate(subRow, false);
                });
                if (!tipsRow.isEmpty()) {
                    row.setValue(1, (Object)FusionStoragePoolExpansionDialog.this.getTipsBoxMsg((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)row));
                }
                FusionStorDiskInfo disk = new FusionStorDiskInfo();
                disk.setCustomConfig(true);
                disk.setType(FusionStoragePoolExpansionDialog.this.storagePool.getMainStorageDiskType());
                disk.setDiskZoneId(((FsNodeExpansionInfo)row.getUserObject()).getDiskZoneId());
                FsNodeExpansionInfo child = new FsNodeExpansionInfo(disk);
                ITreeTableRow customRow = FusionStoragePoolExpansionDialog.this.createCustomRow(child, (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)row);
                ((FsNodeExpansionInfo)row.getUserObject()).getChildren().add(child);
                row.addSubRow(customRow);
                FusionStoragePoolExpansionDialog.this.layout.getTable().getTreeTableModel().updateTabelView(false);
                if (((FsNodeExpansionInfo)row.getUserObject()).isNodeRow()) {
                    FusionStoragePoolExpansionDialog.updateParentRowSelectType((FsNodeExpansionInfo)row.getUserObject());
                } else {
                    FusionStoragePoolExpansionDialog.updateParentRowSelectType((FsNodeExpansionInfo)row.getParentRow().getUserObject());
                }
                FusionStoragePoolExpansionDialog.this.updateTreeSelectStatus();
                FusionStoragePoolExpansionDialog.this.updateNodeStatisticsView();
            }
        }));
    }

    private String getTipsBoxMsg(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row) {
        Object oldMsgCell;
        String msg = ((FsNodeExpansionInfo)row.getUserObject()).isNodeRow() ? ((FsNodeExpansionInfo)row.getUserObject()).getIp() : ((oldMsgCell = row.getValue(1)) == null ? "" : oldMsgCell.toString());
        return msg;
    }

    private List<FusionStorDiskInfo> getFreeDiskList(FsNodeExpansionInfo nodeInfo, List<FusionStorDiskInfo> allDiskInfo) {
        if (this.cacheFreeNodeExpansionInfo != null && this.cacheFreeNodeExpansionInfo.containsKey(nodeInfo.getIp())) {
            return allDiskInfo;
        }
        return allDiskInfo.stream().filter(disk -> disk.isFree() && disk.getType() != null).collect(Collectors.toList());
    }

    protected List<FusionStorDiskInfo> getfreeMainStorageDiskList(List<FusionStorDiskInfo> freeDiskList, FsNodeExpansionInfo nodeInfo) {
        if (nodeInfo.nodeIsNewExpansion()) {
            if (this.storagePool.getMainStorageDiskType() == DiskTypeEnum.SAS_ENCRYPTED) {
                return freeDiskList.stream().filter(disk -> disk.getType() == DiskTypeEnum.SAS_ENCRYPTED || disk.getType() == DiskTypeEnum.SAS).collect(Collectors.toList());
            }
            if (this.storagePool.getMainStorageDiskType() == DiskTypeEnum.SATA_ENCRYPTED) {
                return freeDiskList.stream().filter(disk -> disk.getType() == DiskTypeEnum.SATA_ENCRYPTED || disk.getType() == DiskTypeEnum.SATA).collect(Collectors.toList());
            }
        }
        return freeDiskList.stream().filter(disk -> disk.getType() == this.storagePool.getMainStorageDiskType()).collect(Collectors.toList());
    }

    private void initRowsByBuild(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<FusionStorDiskInfo> freeMainStorageDiskList, List<FusionStorDiskInfo> freeCacheDiskList) {
        if (!nodeInfo.involveDiskZone() && freeMainStorageDiskList.isEmpty() && freeCacheDiskList.isEmpty() && (nodeInfo.getExpansionCacheDisk().isEmpty() && nodeInfo.getExpansionMainStorageDisk().isEmpty() || this.cacheFreeNodeExpansionInfo != null && this.cacheFreeNodeExpansionInfo.containsKey(nodeInfo.getIp()))) {
            FsNodeExpansionInfo tipsChild = new FsNodeExpansionInfo();
            ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> tipsSubRow = this.buildSubRowByTips(tipsChild, row);
            nodeInfo.getChildren().add(tipsChild);
            row.addSubRow(tipsSubRow);
        } else {
            this.buildSubRows(nodeInfo, row, freeMainStorageDiskList, freeCacheDiskList);
        }
    }

    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> buildSubRowByTips(FsNodeExpansionInfo tipsChild, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parentRow) {
        DefaultTreeTableRow tipsSubRow = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)tipsChild, (Object)tipsChild);
        IsmTableCell.TextIconCell cell = new IsmTableCell.TextIconCell(this.getTipsBoxMsg(parentRow), (Icon)ResourceUtil.getImage((String)"no_disk.png"), 4);
        cell.setTips(TIPS_ROW_MSG);
        parentRow.setValue(1, (Object)cell);
        tipsSubRow.setValue(1, (Object)NO_DATA);
        return tipsSubRow;
    }

    private void initDizkZoneRows(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<FusionStorDiskInfo> freeMainStorageDiskList, List<FusionStorDiskInfo> freeCacheDiskList) {
    }

    private void initSubRows(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<FusionStorDiskInfo> freeMainStorageDiskList, List<FusionStorDiskInfo> freeCacheDiskList) {
        if (!nodeInfo.getChildren().isEmpty()) {
            this.buildGrupRow(nodeInfo, row);
        } else {
            this.initRowsByBuild(nodeInfo, row, freeMainStorageDiskList, freeCacheDiskList);
        }
        this.buildRowTips(nodeInfo, row);
    }

    private void buildGrupRow(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parentRow) {
        nodeInfo.getChildren().forEach(child -> {
            if (child.isDiskZone()) {
                ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> diskZoneRow = this.initDiskZone((FsNodeExpansionInfo)child);
                this.buildGrupRow((FsNodeExpansionInfo)child, diskZoneRow);
                this.buildRowTips((FsNodeExpansionInfo)child, diskZoneRow);
                parentRow.addSubRow(diskZoneRow);
            } else if (child.isCacheGroup()) {
                ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> cacheGroupRow = this.initBuildCacheGroupRow((FsNodeExpansionInfo)child);
                this.buildGrupRow((FsNodeExpansionInfo)child, cacheGroupRow);
                this.buildRowTips((FsNodeExpansionInfo)child, cacheGroupRow);
                parentRow.addSubRow(cacheGroupRow);
            } else {
                ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow = !child.isTips() && child.isCustomConfig() ? this.createCustomRow((FsNodeExpansionInfo)child, parentRow) : this.builedSubRowByExpansionInfo((FsNodeExpansionInfo)child, parentRow);
                parentRow.addSubRow(subRow);
            }
        });
    }

    private void buildRowTips(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row) {
        if (nodeInfo.getChildren().isEmpty()) {
            FsNodeExpansionInfo tipsChild = new FsNodeExpansionInfo();
            ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> tipsSubRow = this.buildSubRowByTips(tipsChild, row);
            nodeInfo.getChildren().add(tipsChild);
            row.addSubRow(tipsSubRow);
        }
    }

    private boolean needNoCacheDiskTips(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row) {
        return !(row.getValue(1) instanceof IsmTableCell.TextIconCell) && nodeInfo.nodeIsNewExpansion() && this.storagePool.getCacheDiskType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD && this.isX86Server(nodeInfo) && !((FsNodeExpansionInfo)row.getUserObject()).getChildren().stream().anyMatch(children -> children.isCacheChild());
    }

    private boolean isX86Server(FsNodeExpansionInfo nodeInfo) {
        String model = nodeInfo.getModel().trim();
        if (model.contains("TaiShan")) {
            return false;
        }
        return !model.startsWith("OceanStor 100D") || !model.endsWith("00");
    }

    private void buildSubRows(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<FusionStorDiskInfo> freeMainStorageDiskList, List<FusionStorDiskInfo> freeCacheDiskList) {
        if (nodeInfo.involveDiskZone()) {
            List<FusionStorDiskInfo> allDiskInfo = nodeInfo.getAllDiskInfo();
            Map<String, List<FusionStorDiskInfo>> diskZoneListMap = this.getDiskZoneListMap(allDiskInfo);
            if (diskZoneListMap.size() < nodeInfo.getDiskZoneNum()) {
                int needCreat = nodeInfo.getDiskZoneNum() - diskZoneListMap.size();
                for (int i = 0; i < needCreat; ++i) {
                    diskZoneListMap.put(DISK_ZONE_DEFAULT_NAME + i, new ArrayList());
                }
            }
            diskZoneListMap.keySet().forEach(diskZoneId -> this.buildDiskZoneRow(nodeInfo, row, diskZoneListMap, (String)diskZoneId));
            if (this.storagePool.getMainStorageDiskType() == null) {
                this.buildCacheGroupRow(nodeInfo, row, allDiskInfo.stream().filter(diskInfo -> diskInfo.getType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD).collect(Collectors.toList()));
            } else {
                if (this.storagePool.getMainStorageDiskType() == DiskTypeEnum.SSD_CARD_AND_NVME_SSD || this.storagePool.getMainStorageDiskType() == DiskTypeEnum.SSD) {
                    return;
                }
                this.buildCacheGroupRow(nodeInfo, row, freeCacheDiskList);
            }
        } else {
            this.buildSubRowsByDiskList(nodeInfo, row, freeMainStorageDiskList, FsNodeExpansionInfo.ChildrenType.MAIN_STORAGE, this.storagePool.getMainStorageDiskType());
            this.buildSubRowsByDiskList(nodeInfo, row, freeCacheDiskList, FsNodeExpansionInfo.ChildrenType.CACHE, this.storagePool.getCacheDiskType());
        }
    }

    private void buildSubRowsByDiskZoneList(FsNodeExpansionInfo nodeInfo, List<FusionStorDiskInfo> freeDiskList, FsNodeExpansionInfo.ChildrenType childrenType, DiskTypeEnum diskType, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> groupRow, Map<FusionStorDiskInfo, Integer> expansionDisk) {
        Map<Long, List<FusionStorDiskInfo>> freeDiskMap = this.getCapacityAndDisksMap(freeDiskList);
        if (this.notHasExpansionConfig(nodeInfo, expansionDisk)) {
            this.buildSubRowsByFreeDiskList((FsNodeExpansionInfo)groupRow.getUserObject(), groupRow, freeDiskMap, childrenType, diskType);
        } else {
            this.buildSubRowsByExpansionDisk((FsNodeExpansionInfo)groupRow.getUserObject(), groupRow, childrenType, expansionDisk, freeDiskMap, diskType);
        }
    }

    private boolean notHasExpansionConfig(FsNodeExpansionInfo nodeInfo, Map<FusionStorDiskInfo, Integer> expansionDisk) {
        return expansionDisk.isEmpty() || expansionDisk.values().stream().allMatch(numb -> numb == 0) || this.cacheFreeNodeExpansionInfo != null && this.cacheFreeNodeExpansionInfo.containsKey(nodeInfo.getIp());
    }

    private void buildDiskZoneRow(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, Map<String, List<FusionStorDiskInfo>> diskZoneListMap, String diskZoneId) {
        FsNodeExpansionInfo diskZoneInfo = new FsNodeExpansionInfo(FsNodeExpansionInfo.ConfigType.DISK_ZONE_ROW, diskZoneId);
        ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> diskZoneRow = this.initDiskZone(diskZoneInfo);
        List<FusionStorDiskInfo> freeDiskList = this.getFreeDiskList(nodeInfo, diskZoneListMap.get(diskZoneId));
        List<FusionStorDiskInfo> freeMainStorageDiskListInDiskZone = this.getfreeMainStorageDiskList(freeDiskList, nodeInfo);
        this.buildSubRowsByDiskZoneList(nodeInfo, freeMainStorageDiskListInDiskZone, FsNodeExpansionInfo.ChildrenType.MAIN_STORAGE, this.storagePool.getMainStorageDiskType(), diskZoneRow, this.filterDiskMapByDiskZoneId(nodeInfo.getExpansionDisk(FsNodeExpansionInfo.ChildrenType.MAIN_STORAGE), diskZoneId));
        nodeInfo.getChildren().add(diskZoneInfo);
        this.buildRowTips(diskZoneInfo, diskZoneRow);
        row.addSubRow(diskZoneRow);
    }

    private Map<FusionStorDiskInfo, Integer> filterDiskMapByDiskZoneId(Map<FusionStorDiskInfo, Integer> expansionDisk, String diskZoneId) {
        return expansionDisk.keySet().stream().filter(diskInfo -> diskZoneId.equals(diskInfo.getDiskZoneId())).collect(Collectors.toMap(diskInfo -> diskInfo, diskInfo -> (Integer)expansionDisk.get(diskInfo), (oldRow, newRow) -> newRow));
    }

    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> initDiskZone(FsNodeExpansionInfo diskZoneInfo) {
        DefaultTreeTableRow diskZoneRow = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)diskZoneInfo, (Object)diskZoneInfo);
        diskZoneRow.setValue(1, (Object)DISK_ZONE_DEFAULT_NAME);
        this.buildCustomButton((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)diskZoneRow, 7);
        return diskZoneRow;
    }

    private void buildCacheGroupRow(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<FusionStorDiskInfo> freeCacheDiskList) {
        FsNodeExpansionInfo cacheGroup = new FsNodeExpansionInfo(FsNodeExpansionInfo.ConfigType.CACHE_GROUP_ROW);
        ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> cacheGroupRow = this.initBuildCacheGroupRow(cacheGroup);
        this.buildSubRowsByDiskZoneList(nodeInfo, freeCacheDiskList, FsNodeExpansionInfo.ChildrenType.CACHE, this.storagePool.getCacheDiskType(), cacheGroupRow, nodeInfo.getExpansionDisk(FsNodeExpansionInfo.ChildrenType.CACHE));
        nodeInfo.getChildren().add(cacheGroup);
        row.addSubRow(cacheGroupRow);
        this.buildRowTips(cacheGroup, cacheGroupRow);
    }

    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> initBuildCacheGroupRow(FsNodeExpansionInfo cacheGroup) {
        DefaultTreeTableRow cacheGroupRow = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)cacheGroup, (Object)cacheGroup);
        cacheGroupRow.setValue(1, (Object)CACHE_GROUP_NAME);
        this.buildCustomButton((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)cacheGroupRow, 7);
        return cacheGroupRow;
    }

    private void buildSubRowsByDiskList(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, List<FusionStorDiskInfo> freeDiskList, FsNodeExpansionInfo.ChildrenType childrenType, DiskTypeEnum diskType) {
        Map<FusionStorDiskInfo, Integer> expansionDisk = nodeInfo.getExpansionDisk(childrenType);
        Map<Long, List<FusionStorDiskInfo>> freeDiskMap = this.getCapacityAndDisksMap(freeDiskList);
        if (this.notHasExpansionConfig(nodeInfo, expansionDisk)) {
            this.buildSubRowsByFreeDiskList(nodeInfo, row, freeDiskMap, childrenType, diskType);
        } else {
            this.buildSubRowsByExpansionDisk(nodeInfo, row, childrenType, expansionDisk, freeDiskMap, diskType);
        }
    }

    private void buildSubRowsByExpansionDisk(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, FsNodeExpansionInfo.ChildrenType childrenType, Map<FusionStorDiskInfo, Integer> expansionDisk, Map<Long, List<FusionStorDiskInfo>> freeDiskMap, DiskTypeEnum diskType) {
        expansionDisk.keySet().stream().sorted(this.comparatorDisk).forEach(disk -> {
            int maxFreeDiskSize = this.getMaxFreeDiskSize((FusionStorDiskInfo)disk, freeDiskMap, nodeInfo.nodeIsNewExpansion());
            if (maxFreeDiskSize == 0) {
                if (diskType != null) {
                    FsNodeExpansionInfo child = this.buildchild(disk.getOriginalCapacity(), disk.getCapacityUnit(), diskType, childrenType, maxFreeDiskSize, (Integer)expansionDisk.get(disk), disk.getDiskZoneId());
                    child.getChildrenConfigDisk().setCustomConfig(true);
                    nodeInfo.getChildren().add(child);
                    row.addSubRow(this.createCustomRow(child, row));
                }
            } else {
                FsNodeExpansionInfo child = diskType == null ? this.buildchild((FusionStorDiskInfo)disk, childrenType, maxFreeDiskSize, (Integer)expansionDisk.get(disk)) : this.buildchild(disk.getOriginalCapacity(), disk.getCapacityUnit(), diskType, childrenType, maxFreeDiskSize, (Integer)expansionDisk.get(disk), disk.getDiskZoneId());
                nodeInfo.getChildren().add(child);
                ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow = this.builedSubRowByExpansionInfo(child, row);
                row.addSubRow(subRow);
            }
        });
    }

    private void buildSubRowsByFreeDiskList(FsNodeExpansionInfo nodeInfo, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> row, Map<Long, List<FusionStorDiskInfo>> freeDiskMap, FsNodeExpansionInfo.ChildrenType childrenType, DiskTypeEnum diskType) {
        freeDiskMap.keySet().stream().sorted().forEach(capacity -> {
            FsNodeExpansionInfo child = diskType == null ? this.buildchild((FusionStorDiskInfo)((List)freeDiskMap.get(capacity)).get(0), childrenType, ((List)freeDiskMap.get(capacity)).size(), 0) : this.buildchild(((FusionStorDiskInfo)((List)freeDiskMap.get(capacity)).get(0)).getOriginalCapacity(), ((FusionStorDiskInfo)((List)freeDiskMap.get(capacity)).get(0)).getCapacityUnit(), diskType, childrenType, ((List)freeDiskMap.get(capacity)).size(), 0, ((FusionStorDiskInfo)((List)freeDiskMap.get(capacity)).get(0)).getDiskZoneId());
            nodeInfo.getChildren().add(child);
            ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow = this.builedSubRowByExpansionInfo(child, row);
            row.addSubRow(subRow);
        });
    }

    private int getMaxFreeDiskSize(FusionStorDiskInfo disk, Map<Long, List<FusionStorDiskInfo>> freeDiskMap, boolean nodeIsNewExpansion) {
        for (Long capacity : freeDiskMap.keySet()) {
            List<FusionStorDiskInfo> freeDiskList = freeDiskMap.get(capacity);
            if (freeDiskList.isEmpty()) {
                return 0;
            }
            if (!this.diskTypeSame(nodeIsNewExpansion, disk.getType(), freeDiskList.get(0).getType()) || !capacity.equals(disk.getCapacityByLong())) continue;
            return freeDiskList.size();
        }
        return 0;
    }

    private boolean diskTypeSame(boolean nodeIsNewExpansion, DiskTypeEnum type1, DiskTypeEnum type2) {
        if (nodeIsNewExpansion) {
            if (type1 == DiskTypeEnum.SAS_ENCRYPTED && (type2 == DiskTypeEnum.SAS_ENCRYPTED || type2 == DiskTypeEnum.SAS)) {
                return true;
            }
            if (type1 == DiskTypeEnum.SATA_ENCRYPTED && (type2 == DiskTypeEnum.SATA_ENCRYPTED || type2 == DiskTypeEnum.SATA)) {
                return true;
            }
        }
        return type1 == type2;
    }

    private FsNodeExpansionInfo buildchild(FusionStorDiskInfo oldDisk, FsNodeExpansionInfo.ChildrenType childrenType, int diskMaxNumber, int diskNumber) {
        return this.buildchild(oldDisk.getOriginalCapacity(), oldDisk.getCapacityUnit(), oldDisk.getType(), childrenType, diskMaxNumber, diskNumber, oldDisk.getDiskZoneId());
    }

    private FsNodeExpansionInfo buildchild(String capacity, FusionStorDiskInfo.CapacityUnit capacityUnit, DiskTypeEnum diskType, FsNodeExpansionInfo.ChildrenType childrenType, int diskMaxNumber, int diskNumber, String diskZoneId) {
        FusionStorDiskInfo newDisk = new FusionStorDiskInfo();
        newDisk.setCapacityAndUnit(capacity, capacityUnit);
        newDisk.setType(diskType);
        newDisk.setDiskZoneId(diskZoneId);
        FsNodeExpansionInfo child = new FsNodeExpansionInfo(newDisk, diskMaxNumber, diskNumber, childrenType);
        return child;
    }

    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> createCustomRow(FsNodeExpansionInfo child, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parentRow) {
        DefaultTreeTableRow subRow = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)child, (Object)child);
        this.buildDiskTypeCustomRow(child, (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, parentRow);
        subRow.setValue(2, (Object)ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.sources.custom"));
        this.buildDiskCapacity((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, child);
        IsmTableCell.MsgTextCell cell = new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)DISK_NUMBER_REGEX, (String)"", (int)3, (int)0), "", DISK_NUMBER_TIPS_MSG);
        if (child.getChildDiskNumber() != 0) {
            cell.setText(child.getChildDiskNumber() + "");
        }
        subRow.setValue(5, (Object)cell);
        this.buildDeleteCustomButton((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)subRow, parentRow);
        return subRow;
    }

    private void buildDiskCapacity(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow, FsNodeExpansionInfo child) {
        IsmTableCell.MsgTextCell cell = new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)DISK_CAPACITY_REGEX, (String)"", (int)18, (int)0), "", DISK_CAPACITY_TIPS_MSG);
        String capacity = child.getChildrenConfigDisk().getOriginalCapacity();
        cell.setText(capacity);
        subRow.setValue(3, (Object)cell);
        int comboBoxIndex = 0;
        if (!StringUtils.isNULLStr((String)capacity)) {
            comboBoxIndex = child.getChildrenConfigDisk().getCapacityUnit().getMultiples();
        }
        IsmTableCell.ComboBoxCell comboBox = new IsmTableCell.ComboBoxCell((Object[])DISK_CUSTOM_ROW_DISK_CAPACITY, (Object)DISK_CUSTOM_ROW_DISK_CAPACITY[comboBoxIndex]);
        comboBox.setActionListener((ActionListener)new ChangeCapacityUnitAction(subRow, this));
        subRow.setValue(4, (Object)comboBox);
    }

    private static long equation(long digitNumber, long corner) {
        long value = digitNumber;
        int i = 1;
        while ((long)i < corner) {
            value *= digitNumber;
            ++i;
        }
        return value;
    }

    private void buildDiskTypeCustomRow(FsNodeExpansionInfo child, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parentRow) {
        DiskTypeEnum type = child.getChildrenConfigDisk().getType();
        if (this.storagePool.getCacheDiskType() == null || ((FsNodeExpansionInfo)parentRow.getUserObject()).isDiskZone()) {
            subRow.setValue(1, (Object)this.getSubRowDiskTypeMsg(child));
            return;
        }
        if (((FsNodeExpansionInfo)parentRow.getUserObject()).isCacheGroup()) {
            child.getChildrenConfigDisk().setType(this.storagePool.getCacheDiskType());
            child.setChildrenType(FsNodeExpansionInfo.ChildrenType.CACHE);
            subRow.setValue(1, (Object)this.getSubRowDiskTypeMsg(child));
            return;
        }
        int select = 0;
        if (this.storagePool.getCacheDiskType() == type) {
            select = 1;
        }
        IsmTableCell.ComboBoxCell comboBox = new IsmTableCell.ComboBoxCell((Object[])DISK_CUSTOM_ROW_DISK_TYPE, (Object)DISK_CUSTOM_ROW_DISK_TYPE[select]);
        comboBox.setActionListener((ActionListener)new ChangeDiskTypeAction(subRow, this.storagePool, 1, this));
        subRow.setValue(1, (Object)comboBox);
    }

    private void buildDeleteCustomButton(final ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow, final ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parentRow) {
        subRow.setValue(6, (Object)new IsmTableCell.HyperlinkCell(DISK_DELETE_RS, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WarningDialog dialog = DialogUtils.showYesNoDialog((Window)FusionStoragePoolExpansionDialog.this, (String)ResourceUtil.getStringWithParams((String)"inspsctor.wizard.fs.expansion.config.delete.custom.disk.config", (Object[])new Object[0]));
                if (dialog.getValue() != 0) {
                    return;
                }
                ((FsNodeExpansionInfo)parentRow.getUserObject()).getChildren().remove(subRow.getUserObject());
                FusionStoragePoolExpansionDialog.this.layout.getTable().getTreeTableModel().deleteRowByUpdate(subRow, false);
                if (((FsNodeExpansionInfo)parentRow.getUserObject()).getChildren().isEmpty()) {
                    FsNodeExpansionInfo tipsChild = new FsNodeExpansionInfo();
                    ITreeTableRow tipsSubRow = FusionStoragePoolExpansionDialog.this.buildSubRowByTips(tipsChild, (ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)parentRow);
                    ((FsNodeExpansionInfo)parentRow.getUserObject()).getChildren().add(tipsChild);
                    parentRow.addSubRow(tipsSubRow);
                    FusionStoragePoolExpansionDialog.this.layout.getTable().getTreeTableModel().updateTabelView(false);
                }
                FusionStoragePoolExpansionDialog.updateParentRowSelectType((FsNodeExpansionInfo)parentRow.getUserObject());
                FusionStoragePoolExpansionDialog.this.updateTreeSelectStatus();
                FusionStoragePoolExpansionDialog.this.updateNodeStatisticsView();
            }
        }));
    }

    public static String checkCustomRowFinish(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> subRow) {
        IsmTableCell.MsgTextCell cell;
        String value;
        if (subRow.getValue(4) instanceof IsmTableCell.ComboBoxCell && subRow.getValue(3) instanceof IsmTableCell.MsgTextCell) {
            IsmTableCell.ComboBoxCell capacityUnitCell = (IsmTableCell.ComboBoxCell)subRow.getValue(4);
            String unitStr = capacityUnitCell.getEditor().getCellEditorValue().toString();
            if (DISK_CUSTOM_ROW_DISK_CAPACITY[0].equals(unitStr)) {
                return ResourceUtil.getString((String)"inspsctor.fs.expansion.disk.custom.none.capacity.unit");
            }
            IsmTableCell.MsgTextCell capacityCell = (IsmTableCell.MsgTextCell)subRow.getValue(3);
            String value2 = capacityCell.getEditor().getCellEditorValue().toString();
            if (StringUtils.isNULLStr((String)value2)) {
                return ResourceUtil.getString((String)"inspsctor.fs.expansion.disk.custom.none.capacity");
            }
            DiskTypeEnum type = ((FsNodeExpansionInfo)subRow.getUserObject()).getChildrenConfigDisk().getType();
            long capacity = FusionStoragePoolExpansionDialog.getCapacityByCustomConfig(type, unitStr, value2);
            List capacityList = subRow.getParentRow().getSubRowList().stream().filter(tempSubRow -> ((FsNodeExpansionInfo)tempSubRow.getUserObject()).isSelect() && ((FsNodeExpansionInfo)tempSubRow.getUserObject()).getChildrenConfigDisk().getType() == type && subRow != tempSubRow).map(tempSubRow -> ((FsNodeExpansionInfo)tempSubRow.getUserObject()).getChildrenConfigDisk().getCapacityByLong()).collect(Collectors.toList());
            if (capacityList.contains(capacity)) {
                return ResourceUtil.getString((String)"inspsctor.fs.expansion.disk.custom.capacity.exist.msg");
            }
        }
        if (subRow.getValue(5) instanceof IsmTableCell.MsgTextCell && StringUtils.isNULLStr((String)(value = (cell = (IsmTableCell.MsgTextCell)subRow.getValue(5)).getEditor().getCellEditorValue().toString()))) {
            return ResourceUtil.getString((String)"inspsctor.fs.expansion.disk.custom.none.disk.number");
        }
        return "";
    }

    public static long getCapacityByCustomConfig(DiskTypeEnum type, String unitStr, String value) {
        long digitNumber = FusionStoragePoolExpansionDialog.getDigitNumber(type);
        long unitIndex = FusionStoragePoolExpansionDialog.getDiskCapacityUnitIndex(unitStr);
        if (unitIndex == 0L) {
            return 0L;
        }
        if (unitIndex == 1L) {
            return Long.valueOf(value);
        }
        return (long)(Double.valueOf(value) * (double)FusionStoragePoolExpansionDialog.equation(digitNumber, unitIndex - 1L));
    }

    private static long getDigitNumber(DiskTypeEnum type) {
        if (DiskTypeEnum.SSD_CARD_AND_NVME_SSD == type) {
            return 1000L;
        }
        return 1024L;
    }

    private static int getDiskCapacityUnitIndex(String unitStr) {
        for (int i = 0; i < 6; ++i) {
            if (!DISK_CUSTOM_ROW_DISK_CAPACITY[i].equals(unitStr)) continue;
            return i;
        }
        return 0;
    }

    private ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> builedSubRowByExpansionInfo(FsNodeExpansionInfo child, ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> parentRow) {
        if (child.isTips()) {
            return this.buildSubRowByTips(child, parentRow);
        }
        DefaultTreeTableRow subRow = new DefaultTreeTableRow(this.layout.getTableHeader().length, (Object)child, (Object)child);
        int sbindex = 1;
        subRow.setValue(sbindex++, (Object)this.getSubRowDiskTypeMsg(child));
        subRow.setValue(sbindex++, (Object)ResourceUtil.getString((String)"inspsctor.wizard.fs.expansion.config.custom.disk.sources.dev"));
        subRow.setValue(sbindex++, (Object)child.getChildrenConfigDisk().getCapacityByUnit());
        IsmTableCell.MsgTextCell cell = new IsmTableCell.MsgTextCell((JTextField)IsmTextField.getNameLengthTextField((String)DISK_NUMBER_REGEX, (String)"", (int)3, (int)0), "", ResourceUtil.getStringWithParams((String)"inspsctor.wizard.fs.expansion.config.disk.number.msg", (Object[])new Object[]{child.getChildDiskMaxNumber() + ""}));
        if (child.getChildDiskNumber() != 0) {
            cell.setText(child.getChildDiskNumber() + "");
        }
        subRow.setValue(sbindex++, (Object)cell);
        return subRow;
    }

    protected String getSubRowDiskTypeMsg(FsNodeExpansionInfo child) {
        return child.getChildrenType().toString() + ": " + child.getChildrenConfigDisk().getType().toString();
    }

    private Map<Long, List<FusionStorDiskInfo>> getCapacityAndDisksMap(List<FusionStorDiskInfo> diskList) {
        HashMap<Long, List<FusionStorDiskInfo>> map = new HashMap<Long, List<FusionStorDiskInfo>>();
        diskList.forEach(disk -> {
            Long capacity = disk.getCapacityByLong();
            if (map.containsKey(capacity)) {
                ((List)map.get(capacity)).add(disk);
            } else {
                ArrayList<FusionStorDiskInfo> disks = new ArrayList<FusionStorDiskInfo>();
                disks.add((FusionStorDiskInfo)disk);
                map.put(capacity, disks);
            }
        });
        return map;
    }

    public FusionStoragePoolExpansionLayout getFsLayout() {
        return this.layout;
    }

    private List<FsNodeExpansionInfo> copyConfigList(List<FsNodeExpansionInfo> configList) {
        return configList.stream().map(config -> {
            try {
                return (FsNodeExpansionInfo)config.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("Copy FsNodeExpansionInfo Error.", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Copy FsNodeExpansionInfo Error.", (Throwable)e);
            }
            return null;
        }).filter(config -> config != null).collect(Collectors.toList());
    }

    private void initButten() {
        this.layout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FusionStoragePoolExpansionDialog.this.foolProofByCancelBtn()) {
                    return;
                }
                FusionStoragePoolExpansionDialog.this.dispose();
            }
        });
        this.layout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FusionStoragePoolExpansionDialog.this.updateConfigToCache();
                if (!FusionStoragePoolExpansionDialog.this.foolProofByConfirmBtn()) {
                    return;
                }
                FusionStoragePoolExpansionDialog.this.cleanByFreedNodeConfig();
                FusionStoragePoolExpansionDialog.this.parentCacheExpansionInfo.put(FusionStoragePoolExpansionDialog.this.storagePool, FusionStoragePoolExpansionDialog.this.thisDialogConfig);
                FusionStoragePoolExpansionDialog.this.parentDialog.setCacheFreeNodeExpansionInfo(FusionStoragePoolExpansionDialog.this.cacheFreeNodeExpansionInfo);
                FusionStoragePoolExpansionDialog.this.dispose();
                FusionStoragePoolExpansionDialog.this.updateParent();
            }
        });
        this.initSelectAllButten();
    }

    public void updateSelectAllCheckBox() {
        boolean poolNodeTypeIsPacific = this.poolNodeTypeIsPacific();
        List selectableSubRowItemList = this.layout.getTreeTableModel().getAllItemList().stream().filter(rowItem -> this.isSelectableSubRows((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)rowItem.getTableRow(), (TreeTableModel.RowItem)rowItem, poolNodeTypeIsPacific)).collect(Collectors.toList());
        this.layout.getSelectAllCheckBox().setEnabled(!selectableSubRowItemList.isEmpty());
        if (!selectableSubRowItemList.isEmpty()) {
            this.layout.getSelectAllCheckBox().setSelected(selectableSubRowItemList.stream().allMatch(row -> row.getSelectType() == TreeTableModel.SelectType.SELECT));
        }
    }

    private void initSelectAllButten() {
        this.layout.getSelectAllCheckBox().addActionListener(event -> {
            if (this.storagePool.getMainStorageDiskType() == null) {
                this.layout.getSelectAllCheckBox().setSelected(false);
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.creat.storage.pool.no.select.disk.type.msg"));
                return;
            }
            TreeTableModel.SelectType selectType = this.layout.getSelectAllCheckBox().isSelected() ? TreeTableModel.SelectType.SELECT : TreeTableModel.SelectType.UNSELECT;
            this.updateSubRowItemBySelsectCheckBox(selectType);
            this.updateParentRowItemBySelsectCheckBox();
            this.layout.getTable().getTreeTableModel().updateTabelView(false);
            this.updateTreeSelectStatus();
            this.updateNodeStatisticsView();
        });
    }

    private void updateParentRowItemBySelsectCheckBox() {
        List<TreeTableModel.RowItem> groupItemList = this.layout.getTreeTableModel().getAllItemList().stream().filter(rowItem -> {
            FsNodeExpansionInfo rowInfo = (FsNodeExpansionInfo)rowItem.getTableRow().getUserObject();
            return rowInfo.isDiskZone() || rowInfo.isCacheGroup();
        }).collect(Collectors.toList());
        this.updateParentRowSelectType(groupItemList);
        List<TreeTableModel.RowItem> nodeItemList = this.layout.getTreeTableModel().getAllItemList().stream().filter(rowItem -> ((FsNodeExpansionInfo)rowItem.getTableRow().getUserObject()).isNodeRow()).collect(Collectors.toList());
        this.updateParentRowSelectType(nodeItemList);
    }

    private void updateParentRowSelectType(List<TreeTableModel.RowItem> nodeItemList) {
        nodeItemList.forEach(rowItem -> {
            ITreeTableRow fsRow = rowItem.getTableRow();
            FusionStoragePoolExpansionDialog.updateParentRowSelectType((FsNodeExpansionInfo)fsRow.getUserObject());
            rowItem.setSelectType(((FsNodeExpansionInfo)fsRow.getUserObject()).getSelectType());
            if (((FsNodeExpansionInfo)fsRow.getUserObject()).isNodeRow()) {
                FsStoragePoolConfigTreeMouseListener.updateDiskNumberByParentRow((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow);
            }
        });
    }

    private void updateSubRowItemBySelsectCheckBox(TreeTableModel.SelectType selectType) {
        boolean poolNodeTypeIsPacific = this.poolNodeTypeIsPacific();
        this.layout.getTreeTableModel().getAllItemList().stream().forEach(rowItem -> {
            ITreeTableRow fsRow = rowItem.getTableRow();
            if (!this.isSelectableSubRows((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow, (TreeTableModel.RowItem)rowItem, poolNodeTypeIsPacific)) {
                return;
            }
            rowItem.setSelectType(selectType);
            FsStoragePoolConfigTreeMouseListener.updateSubRowDiskNumber((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow, selectType);
        });
    }

    public boolean isPacificNodeByDiskRow(TreeTableModel.RowItem rowItem) {
        if (rowItem.getParent().getParent() == null) {
            return ((FsNodeExpansionInfo)rowItem.getParent().getTableRow().getUserObject()).isPacificNode();
        }
        return ((FsNodeExpansionInfo)rowItem.getParent().getParent().getTableRow().getUserObject()).isPacificNode();
    }

    public boolean poolNodeTypeIsPacific() {
        boolean selectAllPacificNode = false;
        if (this.storagePool.isNullPool()) {
            Optional<TreeTableModel.RowItem> firstSelectRow = this.layout.getTreeTableModel().getAllItemList().stream().filter(rowItem -> {
                FsNodeExpansionInfo fsInfo = (FsNodeExpansionInfo)rowItem.getTableRow().getUserObject();
                return fsInfo.isNodeRow() && !fsInfo.isUnSelect();
            }).findFirst();
            if (firstSelectRow.isPresent()) {
                selectAllPacificNode = ((FsNodeExpansionInfo)firstSelectRow.get().getTableRow().getUserObject()).isPacificNode();
            } else if (!this.layout.getTreeTableModel().getAllItemList().isEmpty()) {
                selectAllPacificNode = ((FsNodeExpansionInfo)((TreeTableModel.RowItem)this.layout.getTreeTableModel().getAllItemList().get(0)).getTableRow().getUserObject()).isPacificNode();
            }
        } else {
            selectAllPacificNode = this.storagePoolHasPacificNode();
        }
        return selectAllPacificNode;
    }

    private Optional<TreeTableModel.RowItem> getFirstRow() {
        return this.layout.getTreeTableModel().getAllItemList().stream().filter(rowItem -> {
            FsNodeExpansionInfo fsInfo = (FsNodeExpansionInfo)rowItem.getTableRow().getUserObject();
            return fsInfo.isNodeRow() && !fsInfo.isUnSelect();
        }).findFirst();
    }

    public boolean poolNodeTypeIsEastOcean(boolean isSingle) {
        if (this.storagePool.isNullPool()) {
            Optional<TreeTableModel.RowItem> firstSelectRow = this.getFirstRow();
            if (firstSelectRow.isPresent()) {
                FsNodeExpansionInfo expan = (FsNodeExpansionInfo)firstSelectRow.get().getTableRow().getUserObject();
                return isSingle ? expan.isEastOceanSingle() : expan.isEastOceanDouble();
            }
            if (!this.layout.getTreeTableModel().getAllItemList().isEmpty()) {
                FsNodeExpansionInfo expansionInfo = (FsNodeExpansionInfo)((TreeTableModel.RowItem)this.layout.getTreeTableModel().getAllItemList().get(0)).getTableRow().getUserObject();
                return isSingle ? expansionInfo.isEastOceanSingle() : expansionInfo.isEastOceanDouble();
            }
            return false;
        }
        return isSingle ? this.storagePoolHasEastOceanSingle() : this.storagePoolHasEastOceanDouble();
    }

    private boolean isSelectableSubRows(ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo> fsRow, TreeTableModel.RowItem rowItem, boolean poolNodeTypeIsPacific) {
        if (!((FsNodeExpansionInfo)fsRow.getUserObject()).isDiskInfoRow()) {
            return false;
        }
        if (poolNodeTypeIsPacific != this.isPacificNodeByDiskRow(rowItem)) {
            return false;
        }
        return !((FsNodeExpansionInfo)fsRow.getUserObject()).isCustomConfig() || StringUtils.isNULLStr((String)FusionStoragePoolExpansionDialog.checkCustomRowFinish(fsRow));
    }

    private boolean hasTipsSubRow(FsNodeExpansionInfo parentConfig) {
        return parentConfig.getChildren().stream().anyMatch(FsNodeExpansionInfo::isTips);
    }

    private boolean foolProofByCancelBtn() {
        String msg = ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.cancels.msg");
        WarningDialog warn = DialogUtils.showYesNoDialog((Window)this, (String)msg);
        return 0 == warn.getValue();
    }

    private boolean isOldDiskZoneRuleInvolveVersion() {
        String patchVersion = this.devNode.getHotPatchVersion();
        String productVersionWithPatch = this.devNode.getProductVersion() + (StringUtils.isNULLStr((String)patchVersion) ? "" : "." + patchVersion);
        return FusionStorageConfig.getDiskZoneOldRulesVersions().stream().anyMatch(productVersionWithPatch::equals);
    }

    protected boolean foolProofByConfirmBtn() {
        List<String> ipList;
        if (this.isOldDiskZoneRuleInvolveVersion()) {
            if (!this.isAllDiskZoneContainsSameDiskNum()) {
                DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.confirm.disk.zone.num.msg"));
                return false;
            }
        } else if (!this.isNodeDiskZoneHasDiskNumDiffInRange()) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"inspsctor.fs.expansion.storage.pool.config.confirm.disk.zone.num.diff.msg"));
            return false;
        }
        if ((ipList = this.getMsgIpList()).isEmpty()) {
            return true;
        }
        String splitStr = ResourceUtil.getString((String)"check.need.bmc.auth.massege.splitStr");
        String msg = ResourceUtil.getStringWithParams((String)"inspsctor.fs.expansion.storage.pool.config.confirm.msg", (Object[])new Object[]{String.join((CharSequence)splitStr, ipList)});
        WarningDialog warn = DialogUtils.showYesNoDialog((Window)this, (String)msg);
        return 0 == warn.getValue();
    }

    private Integer getDiskZoneDiskTotalNum(FsNodeExpansionInfo diskZoneInfo, FsNodeExpansionInfo nodeInfo) {
        int inputTotalNum = diskZoneInfo.getAllDiskChildren().stream().mapToInt(FsNodeExpansionInfo::getChildDiskNumberBySelectType).sum();
        int diskZoneOriNum = (int)nodeInfo.getMainStorageDisk().stream().filter(disk -> disk.getDiskZoneId().equals(diskZoneInfo.getDiskZoneId())).count();
        return inputTotalNum + diskZoneOriNum;
    }

    private boolean isNodeDiskZoneDiffInRange(FsNodeExpansionInfo nodeInfo, int diffValue) {
        List numList = nodeInfo.getChildren().stream().filter(FsNodeExpansionInfo::isDiskZone).map(diskZone -> this.getDiskZoneDiskTotalNum((FsNodeExpansionInfo)diskZone, nodeInfo)).collect(Collectors.toList());
        return numList.stream().mapToInt(Integer::valueOf).max().orElse(0) - numList.stream().mapToInt(Integer::valueOf).min().orElse(0) <= diffValue;
    }

    private boolean isNodeInStoragePool(FsNodeExpansionInfo nodeInfo) {
        return this.storagePool.getJoinedClusterNode().stream().map(ClusterNode::getManagementIp).anyMatch(nodeInfo.getIp()::equals);
    }

    private boolean isNodeDiskZoneHasDiskNumDiffInRange() {
        if (!(this.storagePoolHasPacificNode() || this.isSelectPacificNode() || this.isSelectEastOceanNode())) {
            return true;
        }
        return this.layout.getTable().getTreeTableModel().getAllTableRows().stream().map(row -> (FsNodeExpansionInfo)row.getUserObject()).filter(FsNodeExpansionInfo::isNodeRow).filter(nodeInfo -> this.isNodeInStoragePool((FsNodeExpansionInfo)nodeInfo) || !nodeInfo.isUnSelect()).allMatch(node -> this.isNodeDiskZoneDiffInRange((FsNodeExpansionInfo)node, 1));
    }

    private boolean isAllDiskZoneContainsSameDiskNum() {
        HashSet diskNum = new HashSet();
        if (!this.storagePoolHasPacificNode() && !this.isSelectPacificNode()) {
            return true;
        }
        Set joinedClusterNodeIpSet = this.storagePool.getJoinedClusterNode().stream().map(node -> node.getManagementIp()).collect(Collectors.toSet());
        this.layout.getTable().getTreeTableModel().getAllTableRows().forEach(row -> {
            FsNodeExpansionInfo diskZoneInfo = (FsNodeExpansionInfo)row.getUserObject();
            if (!diskZoneInfo.isDiskZone()) {
                return;
            }
            FsNodeExpansionInfo nodeInfo = (FsNodeExpansionInfo)row.getParentRow().getUserObject();
            boolean isJoined = joinedClusterNodeIpSet.contains(nodeInfo.getIp());
            if (nodeInfo.isUnSelect() && !isJoined) {
                return;
            }
            int[] summarize = new int[]{0};
            diskZoneInfo.getAllDiskChildren().forEach(subConfig -> {
                summarize[0] = summarize[0] + subConfig.getChildDiskNumberBySelectType();
            });
            if (isJoined) {
                summarize[0] = summarize[0] + nodeInfo.getMainStorageDisk().size() / nodeInfo.getDiskZoneNum();
            }
            diskNum.add(summarize[0]);
        });
        return diskNum.size() <= 1;
    }

    private List<String> getMsgIpList() {
        ArrayList<String> ipList = new ArrayList<String>();
        this.layout.getTable().getTreeTableModel().getAllTableRows().forEach(row -> {
            if (row.getParentRow() != null) {
                return;
            }
            ITreeTableRow parent = row;
            if (((FsNodeExpansionInfo)parent.getUserObject()).isUnSelect()) {
                return;
            }
            int[] summarize = new int[]{0, 0};
            ((FsNodeExpansionInfo)parent.getUserObject()).getAllDiskChildren().forEach(subConfig -> {
                if (subConfig.isCustomConfig()) {
                    return;
                }
                if (subConfig.isMainStorageChild()) {
                    summarize[0] = summarize[0] + subConfig.getChildDiskNumberBySelectType();
                } else {
                    summarize[1] = summarize[1] + subConfig.getChildDiskNumberBySelectType();
                }
            });
            FsNodeExpansionInfo parentConfig = (FsNodeExpansionInfo)parent.getUserObject();
            if (summarize[0] > parentConfig.getMainStorageMaxNumber() || summarize[1] > parentConfig.getCacheMaxNumber()) {
                ipList.add(parentConfig.getIp());
            }
        });
        return ipList;
    }

    protected void updateParent() {
        if (this.storagePoolRow != null) {
            this.updateFreeCapacity(this.storagePoolRow);
        }
    }

    public void updateFreeCapacity(ITreeTableRow<FusionStorStoragePool, FusionStorStoragePool> row) {
        ITreeTableRow actualRow = row;
        if (((FusionStorStoragePool)actualRow.getUserObject()).isDiskPool() && actualRow.getParentRow() != null) {
            actualRow = actualRow.getParentRow();
        }
        double[] freeCapacity = new double[]{0.0, 0.0};
        double nowDevFreeCapacity = ((FusionStorStoragePool)actualRow.getUserObject()).getDevFreeCapacity().longValue();
        if (DiskTypeEnum.SSD_CARD_AND_NVME_SSD.equals((Object)((FusionStorStoragePool)actualRow.getUserObject()).getMainStorageDiskType())) {
            freeCapacity[0] = freeCapacity[0] + nowDevFreeCapacity;
        } else {
            freeCapacity[1] = freeCapacity[1] + nowDevFreeCapacity;
        }
        this.thisDialogConfig.stream().forEach(config -> config.getAllDiskChildren().forEach(child -> {
            FusionStorDiskInfo childDisk = child.getChildrenConfigDisk();
            if (child.isCacheChild() || childDisk == null) {
                return;
            }
            FusionStorStoragePool.getCapacityByDisk((double[])freeCapacity, (FusionStorDiskInfo)childDisk, (Integer)child.getChildDiskNumberBySelectType());
        }));
        actualRow.setValueAt(3, (Object)FusionStorStoragePool.getCapacityByString((double[])freeCapacity));
    }

    private void cleanByFreedNodeConfig() {
        Iterator<FsNodeExpansionInfo> iterator = this.thisDialogConfig.iterator();
        while (iterator.hasNext()) {
            FsNodeExpansionInfo config = iterator.next();
            if (config.isUnSelect()) {
                if (!config.isFreeNode()) continue;
                iterator.remove();
                this.cacheFreeNodeExpansionInfo.put(config.getIp(), config);
                continue;
            }
            this.cacheFreeNodeExpansionInfo.remove(config.getIp());
        }
    }

    protected void updateConfigToCache() {
        this.layout.getTreeTableModel().getAllItemList().forEach(item -> {
            ITreeTableRow fsRow = item.getTableRow();
            if (((FsNodeExpansionInfo)fsRow.getUserObject()).isDiskInfoRow()) {
                FsStoragePoolConfigTreeMouseListener.updateSubRowDiskNumber((ITreeTableRow<FsNodeExpansionInfo, FsNodeExpansionInfo>)fsRow, item.getSelectType());
            }
        });
    }

    public FusionStoragePoolExpansionLayout getStoragePoolLayout() {
        return this.layout;
    }

    public FusionStorStoragePool getStoragePool() {
        return this.storagePool;
    }

    public void setThisDialogConfig(List<FsNodeExpansionInfo> thisDialogConfig) {
        this.thisDialogConfig = thisDialogConfig;
    }

    public FusionStorageExpansionConfigDialog getParentDialog() {
        return this.parentDialog;
    }

    public void updateNodeStatisticsView() {
        List parentRowList = this.layout.getTable().getTreeTableModel().getAllTableRows().stream().filter(tableRow -> tableRow.getParentRow() == null).collect(Collectors.toList());
        this.layout.getSelectedNodes().setText(parentRowList.stream().filter(tableRow -> !((FsNodeExpansionInfo)tableRow.getUserObject()).isUnSelect()).count() + "");
        this.layout.getTotalNodes().setText(parentRowList.size() + "");
    }

    public boolean isSelectPacificNode() {
        return this.layout.getTable().getTreeTableModel().getAllTableRows().stream().anyMatch(tableRow -> {
            FsNodeExpansionInfo nodeInfo = (FsNodeExpansionInfo)tableRow.getUserObject();
            return nodeInfo.isNodeRow() && nodeInfo.isPacificNode() && !nodeInfo.isUnSelect();
        });
    }

    public boolean isSelectEastOceanNode() {
        return this.layout.getTable().getTreeTableModel().getAllTableRows().stream().anyMatch(tableRow -> {
            FsNodeExpansionInfo nodeInfo = (FsNodeExpansionInfo)tableRow.getUserObject();
            return nodeInfo.isNodeRow() && nodeInfo.isEastOcean() && !nodeInfo.isUnSelect();
        });
    }

    public boolean storagePoolHasPacificNode() {
        return this.storagePool.getJoinedClusterNode().stream().anyMatch(node -> node.isPacificNode()) || this.storagePool.getExpansionClusterNode().stream().anyMatch(node -> node.isPacificNode()) || this.storagePool.getExpansionNodeList().stream().anyMatch(node -> node.isPacificNode());
    }

    public boolean storagePoolHasEastOceanSingle() {
        return this.storagePool.getJoinedClusterNode().stream().anyMatch(ClusterNode::isEastSeaSingleNode) || this.storagePool.getExpansionClusterNode().stream().anyMatch(ClusterNode::isEastSeaSingleNode) || this.storagePool.getExpansionNodeList().stream().anyMatch(DevNode::isEastSeaSingleNode);
    }

    public boolean storagePoolHasEastOceanDouble() {
        return this.storagePool.getJoinedClusterNode().stream().anyMatch(ClusterNode::isEastSeaDoubleNode) || this.storagePool.getExpansionClusterNode().stream().anyMatch(ClusterNode::isEastSeaDoubleNode) || this.storagePool.getExpansionNodeList().stream().anyMatch(DevNode::isEastSeaDoubleNode);
    }
}

