/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.ui.dialogs.HyperManualCheckBatchLayout;
import com.huawei.ism.tool.inspect.ui.wizard.HyperManualCheckCardLayout;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;

public class HyperManualCheckBatchDialog
extends JDialog {
    private HyperManualCheckBatchLayout layout;
    private HyperManualCheckCardLayout cardLayout;

    public HyperManualCheckBatchDialog(HyperManualCheckCardLayout hyperManualCheckCardLayout) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.initUI(hyperManualCheckCardLayout);
        this.initListener();
    }

    private void initUI(HyperManualCheckCardLayout hyperManualCheckCardLayout) {
        this.cardLayout = hyperManualCheckCardLayout;
        this.layout = new HyperManualCheckBatchLayout(hyperManualCheckCardLayout);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.setTitle(ResourceUtil.getString((String)"inspsctor.layout.hypermanualcheckbatch.title"));
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void initListener() {
        this.layout.getClose().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HyperManualCheckBatchDialog.this.dispose();
            }
        });
        this.layout.getApplicationBtn().addActionListener(new ApplicationListener(this.layout, this));
        this.layout.getSave().addActionListener(new SaveActionListener(this.layout, this, this.cardLayout));
    }

    private static class ApplicationListener
    implements ActionListener {
        private HyperManualCheckBatchLayout layout;
        private HyperManualCheckBatchDialog dialog;

        public ApplicationListener(HyperManualCheckBatchLayout layout, HyperManualCheckBatchDialog dialog) {
            this.layout = layout;
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selectedCheckItem = this.layout.getCheckItemBox().getSelectedItem().toString();
            String selectedOptionItem = this.layout.getOptionBox().getSelectedItem().toString();
            List rows = this.layout.getDeviceTable().getMarkedRows();
            if (rows.isEmpty()) {
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"inspsctor.layout.hypermanualcheckbatch.action"));
                return;
            }
            int index = Arrays.asList(HyperHostManualCheckItem.getTittle()).indexOf(selectedCheckItem);
            int checkItemNub = index != -1 ? index : 0;
            for (TableRow row : rows) {
                IsmTableCell.ComboBoxCell comboBoxCell = (IsmTableCell.ComboBoxCell)row.getValueAt(checkItemNub);
                comboBoxCell.setSelectedItem((Object)selectedOptionItem);
            }
            List rowsAll = this.layout.getTableModel().getAllRows();
            this.layout.getTableModel().removeAll();
            for (TableRow row : rowsAll) {
                this.layout.getTableModel().addRow(new TableRow[]{row});
            }
            for (TableRow row : rows) {
                this.layout.getDeviceTable().markTableRows(new Object[]{row.getValueAt(1).toString()});
            }
        }
    }

    private static class SaveActionListener
    implements ActionListener {
        private HyperManualCheckBatchLayout layout;
        private HyperManualCheckBatchDialog dialog;
        private HyperManualCheckCardLayout cardLayout;

        public SaveActionListener(HyperManualCheckBatchLayout layout, HyperManualCheckBatchDialog dialog, HyperManualCheckCardLayout hyperManualCheckCardLayout) {
            this.layout = layout;
            this.dialog = dialog;
            this.cardLayout = hyperManualCheckCardLayout;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List batchRows = this.layout.getDeviceTable().getAllRows();
            List cardRows = this.cardLayout.getRightTable().getAllRows();
            for (TableRow batchRow : batchRows) {
                for (TableRow cardRow : cardRows) {
                    String cardRowRowUniqueSign;
                    String batchRowUniqueSign = batchRow.getValueAt(1).toString();
                    if (!batchRowUniqueSign.equals(cardRowRowUniqueSign = cardRow.getValueAt(1).toString())) continue;
                    for (int index : HyperHostManualCheckItem.getEditItemIndex()) {
                        this.selectedCardRowsItem(index, batchRow, cardRow);
                    }
                }
            }
            this.dialog.dispose();
        }

        private void selectedCardRowsItem(int nub, TableRow batchRow, TableRow cardRow) {
            IsmTableCell.ComboBoxCell cardComboBoxCell = (IsmTableCell.ComboBoxCell)cardRow.getValueAt(nub);
            IsmTableCell.ComboBoxCell batchComboBoxCell = (IsmTableCell.ComboBoxCell)batchRow.getValueAt(nub);
            cardComboBoxCell.setSelectedItem(batchComboBoxCell.getSelectedItem());
        }
    }
}

