/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.entity.HyperHostManualCheckItem;
import com.huawei.ism.tool.inspect.ui.wizard.HyperManualCheckCardLayout;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class HyperManualCheckBatchLayout
extends JPanel {
    private List<HyperHostManualCheckItem> hostItemList = new ArrayList<HyperHostManualCheckItem>();
    private String hostType;
    private DefaultTableModel tableModel;
    private IsmTable deviceTable;
    private TableScrollPane tableScrollPane;
    private JButton applicationBtn;
    private JButton close = null;
    private JButton save = null;
    private JLabel descCheckItem;
    private JComboBox checkItemBox;
    private JLabel descOption;
    private JComboBox optionBox;

    public HyperManualCheckBatchLayout(HyperManualCheckCardLayout hyperManualCheckCardLayout) {
        this.hostItemList = hyperManualCheckCardLayout.getHostItemList();
        this.hostType = hyperManualCheckCardLayout.getSelectTreeNode();
        this.initUI();
        this.initTableDate();
        this.layoutUI();
    }

    private void initUI() {
        this.descCheckItem = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.checkbatch.desccheckitem.suggestion"));
        this.checkItemBox = new JComboBox<String>(HyperHostManualCheckItem.getEditItemsName());
        this.descOption = new JLabel(ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.checkbatch.descoption.suggestion"));
        String[] optionSet = new String[]{HyperHostManualCheckItem.CHECK_RESULT[1], HyperHostManualCheckItem.CHECK_RESULT[2]};
        this.optionBox = new JComboBox<String>(optionSet);
        this.tableModel = new DefaultTableModel(HyperHostManualCheckItem.getTittle(), HyperHostManualCheckItem.getVisibleColumnIds());
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        this.tableScrollPane = new TableScrollPane(this.deviceTable, true, true, true);
        this.applicationBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.hypermanualcheck.checkbatch.applicationbutton"));
        this.save = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.wizard.manuly.check.btn.save"));
        this.close = UiMethod.createButton((String)ResourceUtil.getString((String)"inspect.wizard.manuly.check.btn.close"));
    }

    private void initTableDate() {
        for (HyperHostManualCheckItem hostItem : this.hostItemList) {
            if (!hostItem.getHostType().equals(this.hostType)) continue;
            this.tableModel.addRow(new TableRow[]{HyperManualCheckBatchLayout.createHostTableRow(hostItem)});
        }
    }

    private static TableRow<String, String> createHostTableRow(HyperHostManualCheckItem hostItem) {
        DefaultTableRow row = new DefaultTableRow(HyperHostManualCheckItem.getTittleLength(), (Object)hostItem.getHostInitiator());
        int idx = 0;
        row.setValueAt(idx++, (Object)hostItem.getHostName());
        row.setValueAt(idx++, (Object)hostItem.getHostInitiator());
        row.setValueAt(idx++, (Object)hostItem.getArraySn());
        for (int i = 0; i < HyperHostManualCheckItem.getEditItemsName().length; ++i) {
            row.setValueAt(idx++, (Object)new IsmTableCell.ComboBoxCell((Object[])HyperHostManualCheckItem.CHECK_RESULT, (Object)HyperHostManualCheckItem.CHECK_RESULT[hostItem.getEditItemValue(i)]));
        }
        return row;
    }

    private void layoutUI() {
        UCD.buildHBoxLeft((Component[])new Component[]{this.descCheckItem, this.checkItemBox, this.descOption, this.optionBox, this.applicationBtn});
        JComponent content = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.descCheckItem, this.checkItemBox, this.descOption, this.optionBox, this.applicationBtn}), this.tableScrollPane, UCD.buildButtonBoxRight((JButton[][])new JButton[][]{{this.save, this.close}})});
        this.add((Component)UiMethod.buildFrameSpace((JComponent)content, (int)12), "Center");
    }

    public JButton getApplicationBtn() {
        return this.applicationBtn;
    }

    public void setApplicationBtn(JButton applicationBtn) {
        this.applicationBtn = applicationBtn;
    }

    public JButton getClose() {
        return this.close;
    }

    public void setClose(JButton close) {
        this.close = close;
    }

    public JButton getSave() {
        return this.save;
    }

    public void setSave(JButton save) {
        this.save = save;
    }

    public TableScrollPane getTableScrollPane() {
        return this.tableScrollPane;
    }

    public void setTableScrollPane(TableScrollPane tableScrollPane) {
        this.tableScrollPane = tableScrollPane;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    public JComboBox getCheckItemBox() {
        return this.checkItemBox;
    }

    public void setCheckItemBox(JComboBox checkItemBox) {
        this.checkItemBox = checkItemBox;
    }

    public JComboBox getOptionBox() {
        return this.optionBox;
    }

    public void setOptionBox(JComboBox optionBox) {
        this.optionBox = optionBox;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }
}

