/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.inspector.checkmodel.PyScriptCheckModel;
import com.huawei.ism.tool.inspect.ui.dialogs.InspectDetailLayout;
import com.huawei.ism.tool.inspect.ui.dialogs.ItemDetailInfoDialog;
import com.huawei.ism.tool.inspect.ui.dialogs.WarringDialogWithInputBox;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.swing.JDialog;

public class InspectDetailDialog
extends JDialog {
    private static final long serialVersionUID = -3013652237084133646L;
    private InspectDetailLayout detailLayout;

    public InspectDetailDialog(JDialog parent, Record rec) {
        super((Dialog)parent, true);
        this.detailLayout = new InspectDetailLayout(rec);
        this.setLayout(new BorderLayout());
        this.add((Component)this.detailLayout, "Center");
        this.setTitle(ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.title"));
        this.detailLayout.setValue(rec);
        this.pack();
        this.setResizable(true);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
        this.bindListener(this);
    }

    private void bindListener(InspectDetailDialog inspectDetailDialog) {
        this.detailLayout.getClose().addActionListener(e -> this.dispose());
        this.detailLayout.getRepair().addActionListener(event -> this.addRepairListener(inspectDetailDialog));
        this.detailLayout.getShowMore().addClickListener((ToolHyperLinkLabel.ClickListener & Serializable)e -> {
            ItemDetailInfoDialog detailInfoDialog = new ItemDetailInfoDialog(this.detailLayout.getShowMoreText(), this);
            detailInfoDialog.setVisible(true);
        });
    }

    private void addRepairListener(InspectDetailDialog inspectDetailDialog) {
        InspectContext.getInstance().setRepairInput("");
        String msg = this.getRepairInfo();
        WarringDialogWithInputBox wd = new WarringDialogWithInputBox(inspectDetailDialog, msg);
        wd.setVisible(true);
        if (wd.getDialogValue() != 0) {
            return;
        }
        String repairing = ResourceUtil.getString((String)"inspect.wizard.inspectDetailDialog.repairing");
        AsyncExcutor.execute((Window)this, (String)repairing, (int)220, (Callable[])new Callable[]{this::executedRepairTask});
    }

    private String getRepairInfo() {
        Record record = this.detailLayout.getRecord();
        String checkItemId = record.getCheckItem().getItemId();
        return ResourceUtil.getString((String)InspectContext.getInstance().getRepairInfoKey(checkItemId));
    }

    private boolean executedRepairTask() {
        Record record = this.detailLayout.getRecord();
        CheckDevNode checkDevNode = this.detailLayout.getRecord().getCheckDevNode();
        PyScriptCheckModel checkModel = new PyScriptCheckModel(checkDevNode, null, true);
        ResultItem resultItem = checkModel.executeRepairScript(record.getCheckItem());
        if (resultItem.isResultPass()) {
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.inspectDetailDialog.repair.success", (Object[])new Object[0]);
            DialogUtils.showSuccessDialog((JDialog)this, (String)errMsg);
            return true;
        }
        this.showRepairFailedTip(resultItem);
        return false;
    }

    private void showRepairFailedTip(ResultItem resultItem) {
        if (resultItem.isNoCheck()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)resultItem.getErrMsg());
        } else {
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.inspectDetailDialog.repair.failed", (Object[])new Object[0]);
            DialogUtils.showErrorDialog((JDialog)this, (String)errMsg);
        }
    }
}

