/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.HtmlEnums;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.HelpKey;
import com.huawei.ism.tool.inspect.entity.InspectUserOpData;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.logic.config.FusionStorageConfig;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ItemProgressResult;
import com.huawei.ism.tool.inspect.logic.result.TemplateFactory;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.utils.UI;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectDetailLayout
extends JPanel {
    private static String newline = ItemProgressResult.NEWLINE;
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectDetailLayout.class);
    private static final String NEWLINE = "\n";
    private static final int INFOSIZE = 1;
    private static final String NODENAME = ResourceUtil.getString((String)"dsnode.name");
    private static final long serialVersionUID = 1751259904082661407L;
    private static final int WIDTH = 450;
    private static final int REFPAN_HEIGHT = 150;
    private static final int RESULTPAN_HEIGHT = 60;
    private JButton close = UiMethod.createButton((String)UI.getProps("inspsctor.wizard.selectdevice.support.closebtn"));
    private JButton repair = UiMethod.createButton((String)UI.getProps("inspsctor.wizard.selectdevice.support.repairbtn"));
    private JEditorPane reference = new JEditorPane();
    private JEditorPane result = new JEditorPane();
    private JScrollPane refPan = new JScrollPane(this.reference);
    private JScrollPane resultPan = new JScrollPane(this.result);
    private ToolHyperLinkLabel showMore = new ToolHyperLinkLabel(ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.cli"));
    private static final List<String> INSPECTIONIDS = FusionStorageConfig.getInspectionIds();
    private String showMoreText = "";
    private Record record;

    public InspectDetailLayout(Record rec) {
        JLabel refLabel = UI.buildLabel("inspsctor.wizard.inspectdetail.reference");
        JLabel retLabel = UI.buildLabel("inspsctor.wizard.inspectdetail.ret");
        this.refPan = new JScrollPane(this.reference);
        this.resultPan = new JScrollPane(this.result);
        this.refPan.setPreferredSize(new Dimension(450, 150));
        this.resultPan.setPreferredSize(new Dimension(450, 60));
        this.refPan.setMinimumSize(new Dimension(450, 150));
        this.resultPan.setMinimumSize(new Dimension(450, 60));
        JComponent pan = EntityUtils.isComputeStorageDevLoginThroughFcv((DevNode)rec.getCheckDevNode().getDevNode()) ? UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)retLabel), this.resultPan, UCD.buildHorizontalBoxLeft((Component)this.showMore), UCD.buildHBoxRight((Component[])new Component[]{this.repair, this.close})}) : UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)refLabel), this.refPan, UCD.buildHorizontalBoxLeft((Component)retLabel), this.resultPan, UCD.buildHorizontalBoxLeft((Component)this.showMore), UCD.buildHBoxRight((Component[])new Component[]{this.repair, this.close})});
        this.reference.setEditable(false);
        this.reference.setMargin(this.getTextInset());
        this.result.setMargin(this.getTextInset());
        this.reference.setFocusable(true);
        this.result.setFocusable(true);
        this.result.setEditable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)pan, (int)12), "Center");
    }

    private void scorll2top() {
        this.reference.setCaretPosition(0);
        this.result.setCaretPosition(0);
    }

    private Insets getTextInset() {
        return new Insets(0, 5, 0, 0);
    }

    public void setValue(Record rec) {
        this.record = rec;
        CheckItem checkItem = rec.getCheckItem();
        this.hideRepairBtn(checkItem);
        String id = rec.getItemResourceId();
        StringBuffer context = new StringBuffer();
        RItem rItem = rec.getItem();
        this.buildUnitMsg(context, UI.getProps("inspsctor.wizard.inspectdetail.method"), rec.getMethod(), false);
        this.buildUnitMsg(context, UI.getProps("inspsctor.wizard.inspectdetail.critical"), rec.getCriterion());
        this.suggestShowHandle(rec, this.record.getSuggestion(), context, rItem);
        this.showImpact(rec, rItem, context, id);
        this.reference.setContentType("text/html;charset=\"UTF-8\"");
        this.reference.setText(this.getHtml(context.toString()));
        this.reference.setEditable(false);
        this.reference.addHyperlinkListener(this::doHyperLinkEvent);
        this.result.setContentType("text/html;charset=\"UTF-8\"");
        String ret = InspectDetailLayout.buildRetText(rec, checkItem);
        this.result.setText(this.getHtml(ret));
        this.originalInformation(rec, checkItem);
        this.scorll2top();
    }

    private void hideRepairBtn(CheckItem checkItem) {
        if (InspectContext.getInstance().isSupportRepairItem(checkItem.getItemId()) && !checkItem.isPassed()) {
            return;
        }
        this.repair.setEnabled(false);
        this.repair.setVisible(false);
    }

    private void showImpact(Record rec, RItem rItem, StringBuffer context, String id) {
        boolean notShow;
        String showImpact = rec.getCheckDevNode().showImpact();
        if (null == showImpact || null == rItem) {
            return;
        }
        boolean bl = notShow = rItem.isNormal() || rItem.isNoSupport() || rItem.isNoCheck();
        if ("notPass".equals(showImpact) && notShow) {
            return;
        }
        ResourceBundle bundle = rec.getCheckDevNode().getResourceBundle();
        String ignoreMsg = ResourceUtil.getString((ResourceBundle)bundle, (String)(id + ".impact.ignore"));
        this.buildUnitMsg(context, ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.impact.ignore"), ignoreMsg);
        String businessMsg = ResourceUtil.getString((ResourceBundle)bundle, (String)(id + ".impact.business"));
        this.buildUnitMsg(context, ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.impact.business"), businessMsg);
        String fixMsg = ResourceUtil.getString((ResourceBundle)bundle, (String)(id + ".impact.fix"));
        this.buildUnitMsg(context, ResourceUtil.getString((String)"inspsctor.wizard.inspectdetail.impact.fix"), fixMsg);
    }

    public static String suggestHandle(Record rec, CheckItem checkItem, String id, ResourceBundle bundle, ResourceBundle defaultBundle) {
        String orgSuggestion = InspectDetailLayout.getSuggestion(checkItem, id, bundle, defaultBundle, rec);
        Map<String, List<HelpKey>> helpKeys = InspectUtils.getHelpKeys(InspectDetailLayout.getHelpKey(id, bundle));
        return InspectUtils.replaceKeysByMap(orgSuggestion.replaceAll(NEWLINE, "<br>"), InspectDetailLayout.getScpritPath(rec), helpKeys);
    }

    private StringBuffer buildUnitMsg(StringBuffer context, String tittle, String unitMsg, boolean newLine) {
        if (newLine) {
            context.append(NEWLINE).append(NEWLINE);
        }
        return context.append("<div class=\"exp\">").append(tittle).append("</div>").append(this.htmlEncode(unitMsg));
    }

    private StringBuffer buildUnitMsg(StringBuffer context, String tittle, String unitMsg) {
        return this.buildUnitMsg(context, tittle, unitMsg, true);
    }

    private static String getScpritPath(Record rec) {
        String scriptPath = rec.getCheckDevNode().getScriptDir().getParent();
        int index = scriptPath.indexOf("packages");
        scriptPath = scriptPath.substring(index);
        return scriptPath;
    }

    public static String getSuggestion(CheckItem checkItem, String id, ResourceBundle bundle, ResourceBundle defaultBundle, Record rec) {
        String suggestion = checkItem.getSuggestionInfo();
        try {
            ResourceBundle expansionBundle;
            if ("NA".equals(suggestion)) {
                suggestion = checkItem.getSuggestion(bundle, defaultBundle, id);
            }
            if (null != (expansionBundle = rec.getCheckDevNode().getExpansionResource()) && suggestion.equals("--")) {
                suggestion = checkItem.getSuggestion(expansionBundle, defaultBundle, id);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("get suggestion faild", (Throwable)e);
        }
        return suggestion;
    }

    private static String getHelpKey(String id, ResourceBundle bundle) {
        String helpKey = "";
        String helpKeyKey = id + ".helphref";
        try {
            helpKey = bundle.getString(helpKeyKey);
        }
        catch (RuntimeException e) {
            LOGGER.error("get help faild for " + helpKeyKey + ".");
        }
        return helpKey;
    }

    private void suggestShowHandle(Record rec, String suggestion, StringBuffer context, RItem rItem) {
        if (InspectContext.getInstance().isOemOutTool()) {
            return;
        }
        if (!rec.getCheckDevNode().getProduct().isPassedNotShowSuggest() || !rItem.isNormal() && !rItem.isNoSupport()) {
            context.append(NEWLINE).append(NEWLINE);
            context.append("<div class=\"exp\">").append(UI.getProps("inspsctor.wizard.inspectdetail.suggestion")).append("</div>").append(suggestion);
        }
    }

    private void originalInformation(Record rec, CheckItem checkItem) {
        if (checkItem.getCheckResult().getItems().isEmpty()) {
            String sourceInfoPath = checkItem.getSourceInfoPath() == null ? "" : checkItem.getSourceInfoPath();
            this.showMoreText = this.processHtmlText(checkItem.getSourceInfo() + sourceInfoPath);
        } else if (checkItem.getCheckResult().getItems().get(0).isNoCheck() && checkItem.getSourceInfo().equals(ResourceUtil.getString((String)"inspect.undetected.timeout.msg"))) {
            this.showMoreText = this.processHtmlText(checkItem.getSourceInfo());
        } else {
            this.showMoreText = rec.getItem().getInfo2View();
            if (rec.getItem().isNoCheck() && !StringUtils.isNULLStr((String)rec.getItem().getCli())) {
                this.showMoreText = rec.getItem().getCli();
            }
        }
    }

    private static String buildRetText(Record rec, CheckItem checkItem) {
        String ret = "";
        if (rec.getStatus() == RecordStatus.STOPPED || rec.getItem() != null && rec.getItem().isStop()) {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.stopped");
        } else if (rec.getItem().isFailed()) {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.failed");
            ret = InspectDetailLayout.showErrorMsg(checkItem, ret);
        } else if (rec.getItem().isNoSupport()) {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.nosupport");
        } else if (rec.getItem().isNoCheck()) {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.nocheck");
            ret = InspectDetailLayout.showErrorMsg(checkItem, ret);
        } else if (rec.getItem().isWarning()) {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.warning");
            ret = InspectDetailLayout.showErrorMsg(checkItem, ret);
        } else if (rec.getItem().isManualConfirmation()) {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.manualconfirmation");
            ret = InspectDetailLayout.showErrorMsg(checkItem, ret);
        } else {
            ret = ResourceUtil.getString((String)"inspsctor.wizard.performinspect.success");
        }
        return ret;
    }

    public static String showErrorMsg(CheckItem checkItem, String ret) {
        if (!StringUtils.isNULLStr((String)checkItem.getErrorInfo())) {
            if (INSPECTIONIDS.contains(checkItem.getItemId()) && !StringUtils.isNULLStr((String)checkItem.getSourceInfo())) {
                return ret + NEWLINE + InspectDetailLayout.getErrorInfo(checkItem);
            }
            return ret + NEWLINE + checkItem.getErrorInfo();
        }
        return ret;
    }

    private static String getErrorInfo(CheckItem checkItem) {
        String[] errorInfos = checkItem.getErrorInfo().split(NEWLINE);
        String errorIps = "";
        String sourceInfo = checkItem.getSourceInfo();
        if (errorInfos.length > 1) {
            errorIps = errorInfos[errorInfos.length - 1];
        }
        if (!StringUtils.isNULLStr((String)errorIps)) {
            List<String> ips = Arrays.asList(errorIps).stream().filter(ip -> !StringUtils.isNULLStr((String)ip) && sourceInfo.contains((CharSequence)ip)).collect(Collectors.toList());
            return !ips.isEmpty() ? InspectDetailLayout.parseErrorInfo(sourceInfo, ips) : checkItem.getErrorInfo();
        }
        return checkItem.getErrorInfo();
    }

    @NotNull
    private static String parseErrorInfo(String sourceInfo, List<String> ips) {
        return newline + sourceInfo.split(NODENAME + ips.get(0) + newline)[1].split(newline + NODENAME)[0];
    }

    private String processHtmlText(String content) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("cli", this.htmlEncode(content));
        return TemplateFactory.processorFtl("sourceCliTemplate.html", data);
    }

    private String htmlEncode(String content) {
        return content.replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }

    public JButton getClose() {
        return this.close;
    }

    public ToolHyperLinkLabel getShowMore() {
        return this.showMore;
    }

    public String getShowMoreText() {
        return this.showMoreText;
    }

    private void doHyperLinkEvent(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
            try {
                boolean www;
                InspectContext.getInstance().waitDecompressHelpCaseFinish();
                this.recordCount();
                String url = e.getDescription();
                if (StringUtils.isNULLStr((String)url)) {
                    DialogUtils.showErrorDialog((JDialog)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspect.case.link"));
                    return;
                }
                boolean http = url.startsWith("http") || url.startsWith("HTTP");
                boolean bl = www = url.startsWith("www.") || url.startsWith("WWW.");
                if (http || www) {
                    FileUtils.openHtmlFile((String)url);
                    return;
                }
                String path = ApplicationContext.getInstance().getWorkPath() + File.separator + url;
                OSCmdUtils.explorerFile((String)path);
            }
            catch (RuntimeException ex) {
                ToolLoggerFactory.getLogger(this.getClass()).error("open the file failed", (Throwable)ex);
            }
        }
    }

    private void recordCount() {
        CheckDevNode node = this.record.getCheckDevNode();
        List<InspectUserOpData> userList = InspectContext.getInstance().getUseropList();
        if (!userList.isEmpty()) {
            for (InspectUserOpData inspectUserOpData : userList) {
                if (node == null || !inspectUserOpData.getDeviceSn().equals(node.getDevNode().getDeviceSerialNumber())) continue;
                inspectUserOpData.setItemClickNums(inspectUserOpData.getItemClickNums() + 1);
            }
        }
    }

    private String getHtml(String value) {
        StringBuffer refText = new StringBuffer();
        refText.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" ").append("\"").append(HtmlEnums.XHTML_TRANSITIONAL.getResourceValue()).append("\">").append(System.lineSeparator()).append("<html xmlns=\"").append(HtmlEnums.XHTML.getResourceValue()).append("\">").append(System.lineSeparator()).append("<head>").append(System.lineSeparator()).append("<style type= \"text/css\">").append("body{ font-size:9px;color:#464646;}").append(".exp{font-size:10px;color:#252525;font-weight:bold}").append(".link{color:#4286d3;}").append("selected::selection{color:#ffffff;background:#990000;}").append("selected::-moz-selection{background:#990000;}").append("</style>").append(System.lineSeparator()).append("</head>").append(System.lineSeparator()).append("<body>").append(System.lineSeparator());
        refText.append(value.replaceAll(NEWLINE, "<br>"));
        refText.append("</body>");
        refText.append("</html>");
        return refText.toString();
    }

    @Generated
    public JButton getRepair() {
        return this.repair;
    }

    @Generated
    public Record getRecord() {
        return this.record;
    }
}

