/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.inspect.ui.dialogs.ShowFailedHostDevDialog;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectMultiInfoDialog
extends IsmDialog {
    private static final Logger LOG = LoggerFactory.getLogger(InspectMultiInfoDialog.class);
    private static final long serialVersionUID = -2587908427263722274L;
    private DefaultTableModel topModel = null;
    private IsmTable topTable = null;
    private DefaultTableModel botModel = null;
    private IsmTable botTable = null;
    private JButton ignoreButton;
    private JButton backButton;
    private boolean okPerformed = false;
    private JComponent content;
    private JComponent botDescPane;
    private JComponent topDescPane;
    private TableScrollPane topScrollPane;
    private TableScrollPane botScrollPane;
    private boolean isHostQueryFailed = false;
    private List<DevNode> failedQueryInfoHosts = null;

    public InspectMultiInfoDialog(Window parent, String dlgTitle, String[] table1Titles, String[] table2Titles, String[] info1Msg, String[] info2Msg, String helpInfo, List<List<ArrayList<Object>>> result) {
        super(parent);
        this.setModal(true);
        this.setTitle(dlgTitle);
        this.doLayoutPane(table1Titles, table2Titles, info1Msg, info2Msg, helpInfo, result);
        this.addListener();
        this.toFront();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.pack();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
    }

    public InspectMultiInfoDialog(Window parent, String dlgTitle, String[] table1Titles, String[] table2Titles, String[] info1Msg, String[] info2Msg, String helpInfo, List<List<ArrayList<Object>>> result, List<DevNode> failedQueryInfoHosts) {
        super(parent);
        this.setModal(true);
        this.isHostQueryFailed = true;
        this.failedQueryInfoHosts = failedQueryInfoHosts;
        this.setTitle(dlgTitle);
        this.doLayoutPane(table1Titles, table2Titles, info1Msg, info2Msg, helpInfo, result);
        this.addListener();
        this.toFront();
        this.setResizable(false);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
        this.setIconImage(ResourceManager.DEFAULT_ICON.getImage());
        this.pack();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
    }

    private void addListener() {
        this.ignoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectMultiInfoDialog.this.okPerformed = true;
                InspectMultiInfoDialog.this.dispose();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectMultiInfoDialog.this.okPerformed = false;
                InspectMultiInfoDialog.this.dispose();
            }
        });
    }

    private JComponent buildDescArea(String[] errMsgs, Color color) {
        Box contentArea = Box.createVerticalBox();
        for (String msg : errMsgs) {
            Box line = Box.createHorizontalBox();
            JLabel text = new JLabel(msg);
            text.setForeground(color);
            line.add(text);
            line.add(Box.createHorizontalGlue());
            contentArea.add(line);
        }
        return contentArea;
    }

    private JComponent buildHostUnlinkArea(String[] errMsgs, Color color, List<DevNode> failedQueryInfoHosts2) {
        Box contentArea = Box.createVerticalBox();
        Box line = Box.createHorizontalBox();
        Box line2 = Box.createHorizontalBox();
        JLabel text = new JLabel(errMsgs[0]);
        text.setForeground(color);
        line.add(text);
        ToolHyperLinkLabel link = new ToolHyperLinkLabel(errMsgs[1]);
        HyperClickListener listener = new HyperClickListener();
        link.addClickListener((ToolHyperLinkLabel.ClickListener)listener);
        line.add((Component)link);
        JLabel text2 = new JLabel(errMsgs[2]);
        text2.setForeground(color);
        line.add(text2);
        line.add(Box.createHorizontalGlue());
        JLabel text3 = new JLabel(errMsgs[3]);
        text3.setForeground(color);
        line2.add(text3);
        line2.add(Box.createHorizontalGlue());
        contentArea.add(line);
        contentArea.add(line2);
        return contentArea;
    }

    private JComponent buildDescArea(String[] errMsgs) {
        Box contentArea = Box.createVerticalBox();
        for (String msg : errMsgs) {
            Box line = Box.createHorizontalBox();
            JLabel text = new JLabel(msg);
            line.add(text);
            line.add(Box.createHorizontalGlue());
            contentArea.add(line);
        }
        return contentArea;
    }

    private void doLayoutPane(String[] table1Titles, String[] table2Titles, String[] err1Msgs, String[] err2Msgs, String helpInfo, List<List<ArrayList<Object>>> result) {
        List<ArrayList<Object>> table1Data = result.get(0);
        List<ArrayList<Object>> table2Data = result.get(1);
        TitledBorder storageBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.storage.teamname"));
        TitledBorder hostBorder = BorderFactory.createTitledBorder(ResourceUtil.getString((String)"inspsctor.wizard.selectitem.host.teamname"));
        this.topModel = new DefaultTableModel(table1Titles, new int[0]);
        this.topTable = new IsmTable((TableModel)this.topModel);
        this.topScrollPane = TableScrollPane.createTablePane((IsmTable)this.topTable, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.NONE, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.NONE, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.topTable.getColumnModel().getColumn(0).setPreferredWidth(110);
        this.topTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.topTable.getColumnModel().getColumn(2).setPreferredWidth(175);
        this.topTable.getColumnModel().getColumn(3).setPreferredWidth(305);
        this.topScrollPane.setPreferredSize(new Dimension(650, 140));
        this.botModel = new DefaultTableModel(table2Titles, new int[0]);
        this.botTable = new IsmTable((TableModel)this.botModel);
        this.botScrollPane = TableScrollPane.createTablePane((IsmTable)this.botTable, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.NONE, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.NONE, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.NONE);
        this.botScrollPane.setPreferredSize(new Dimension(650, 180));
        this.setBotDescPane(err1Msgs, err2Msgs, helpInfo, table1Data, table2Data, storageBorder, hostBorder);
        this.content = UiMethod.buildFrameSpace((JComponent)this.content, (int)24);
        this.getContentPane().add(this.content);
        this.ignoreButton = UCD.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.selectitem.device.btnContinue"), (char)'I');
        this.backButton = UCD.createButton((String)ResourceUtil.getString((String)"inspsctor.wizard.selectitem.device.btnBack"), (char)'B');
        JComponent btnArea = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalGlue(), this.ignoreButton, this.backButton});
        this.getSouthBox().add(btnArea);
    }

    private void setBotDescPane(String[] err1Msgs, String[] err2Msgs, String helpInfo, List<ArrayList<Object>> table1Data, List<ArrayList<Object>> table2Data, TitledBorder storageBorder, TitledBorder hostBorder) {
        JComponent helpInfoPane = this.buildDescArea(new String[]{helpInfo});
        if (table1Data.isEmpty()) {
            this.botDescPane = this.isHostQueryFailed ? this.buildHostUnlinkArea(err2Msgs, Color.red, this.failedQueryInfoHosts) : this.buildDescArea(err2Msgs, Color.red);
            this.content = UCD.buildVerticalBox(null, (Component[])new Component[]{this.botDescPane, this.botScrollPane, helpInfoPane});
        } else if (table2Data.isEmpty()) {
            this.topDescPane = this.buildDescArea(err1Msgs, Color.red);
            this.content = UCD.buildVerticalBox(null, (Component[])new Component[]{this.topDescPane, this.topScrollPane, helpInfoPane});
        } else {
            this.topDescPane = this.buildDescArea(err1Msgs, Color.red);
            this.botDescPane = this.isHostQueryFailed ? this.buildHostUnlinkArea(err2Msgs, Color.red, this.failedQueryInfoHosts) : this.buildDescArea(err2Msgs, Color.red);
            this.topDescPane = UCD.buildVerticalBox(null, (Component[])new Component[]{this.topDescPane, this.topScrollPane});
            this.botDescPane = UCD.buildVerticalBox(null, (Component[])new Component[]{this.botDescPane, this.botScrollPane});
            this.topDescPane = UiMethod.buildFrameSpace((JComponent)this.topDescPane, (int)12);
            this.botDescPane = UiMethod.buildFrameSpace((JComponent)this.botDescPane, (int)12);
            this.topDescPane.setBorder(storageBorder);
            this.botDescPane.setBorder(hostBorder);
            this.content = UCD.buildVerticalBox(null, (Component[])new Component[]{this.topDescPane, this.botDescPane, helpInfoPane});
        }
    }

    public DefaultTableModel getTopModel() {
        return this.topModel;
    }

    public DefaultTableModel getBotModel() {
        return this.botModel;
    }

    public boolean isOkPerformed() {
        return this.okPerformed;
    }

    class HyperClickListener
    implements ToolHyperLinkLabel.ClickListener {
        private static final long serialVersionUID = -1149023898591992674L;

        public void clickLink(MouseEvent me) {
            ShowFailedHostDevDialog infoDialg = new ShowFailedHostDevDialog((Window)((Object)InspectMultiInfoDialog.this), InspectMultiInfoDialog.this.failedQueryInfoHosts);
            SwingUtil.putParentCenter((Window)infoDialg, (Window)((Object)InspectMultiInfoDialog.this));
            infoDialg.setVisible(true);
        }
    }
}

