/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.logic.config.SupportVersion;
import com.huawei.ism.tool.inspect.ui.dialogs.ShowSupportDevLayout;
import com.huawei.ism.tool.inspect.utils.UI;
import com.huawei.ism.tool.obase.entity.PlusPackageDesc;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import utils.FilesUtil;

public class InspectPackageDetailLayout
extends JPanel {
    private static final long serialVersionUID = 2170416059835215834L;
    private static final int WIDTH = 280;
    private static final int HEIGHT = 21;
    private static final int NUMBER_TWELVE = 12;
    private JLabel packagePathLabel = new JLabel();
    private JLabel packageVersionLabel = new JLabel();
    private JLabel packageDateLabel = new JLabel();
    private JLabel packageDescLabel = new JLabel();
    private JButton importPackageBtn = UiMethod.createButton((String)UI.getProps("inspsctor.wizard.importpackage.ui.importbtn"));
    private JButton cancelBtn = UiMethod.createButton((String)UI.getProps("inspsctor.wizard.importpackage.ui.cancelbtn"));
    private ShowSupportDevLayout devLayout = null;

    public InspectPackageDetailLayout(Set<String> supportVers) {
        this(supportVers, null, null);
    }

    public InspectPackageDetailLayout(Set<String> supportVers, Set<String> excludeVers, List<SupportVersion> supportList) {
        this.devLayout = new ShowSupportDevLayout(supportVers, excludeVers, supportList, null);
        this.initUI();
    }

    public void setData(PlusPackageDesc plusPackageDesc, File packageFile) {
        this.packagePathLabel.setText(FilesUtil.getCanonicalPath((File)packageFile));
        UiMethod.setComponentSize((Dimension)new Dimension(280, 21), (Component[])new Component[]{this.packagePathLabel, this.packageDescLabel});
        this.packageVersionLabel.setText(plusPackageDesc.getPackageVersion());
        this.packageDateLabel.setText(plusPackageDesc.getReleaseTime());
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            this.packageDescLabel.setText(plusPackageDesc.getPackageDescEn());
        } else {
            this.packageDescLabel.setText(plusPackageDesc.getPackageDescZh());
        }
        this.packagePathLabel.setToolTipText(UCD.wrapTextWithHTML((FontMetrics)this.getFontMetrics(this.packagePathLabel.getFont()), (String)this.packagePathLabel.getText(), (int)300));
        if (!StringUtils.isNULLStr((String)this.packageDescLabel.getText())) {
            this.packageDescLabel.setToolTipText(UCD.wrapTextWithHTML((FontMetrics)this.getFontMetrics(this.packageDescLabel.getFont()), (String)this.packageDescLabel.getText(), (int)300));
        }
    }

    private void initUI() {
        JLabel packageLabel = new JLabel(UI.getProps("inspsctor.wizard.importpackage.ui.pathlabel"));
        JLabel packageVersion = new JLabel(UI.getProps("inspsctor.wizard.importpackage.ui.packageversion"));
        JLabel packageDate = new JLabel(UI.getProps("inspsctor.wizard.importpackage.ui.releasedate"));
        JLabel packageDesc = new JLabel(UI.getProps("inspsctor.wizard.importpackage.ui.desc"));
        JLabel supportVers = new JLabel(UI.getProps("inspsctor.wizard.importpackage.ui.supportedver"));
        UiMethod.setComponentSameMaxWidthSize((JComponent[])new JComponent[]{packageLabel, packageVersion, packageDate, packageDesc});
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((Component[])new Component[]{packageLabel, this.packagePathLabel}), UiMethod.buildCompsLeft((Component[])new Component[]{packageVersion, this.packageVersionLabel}), UiMethod.buildCompsLeft((Component[])new Component[]{packageDate, this.packageDateLabel}), UiMethod.buildCompsLeft((Component[])new Component[]{packageDesc, this.packageDescLabel}), UiMethod.buildCompsLeft((Component[])new Component[]{supportVers, Box.createGlue()}), new JScrollPane((Component)this.devLayout.getDevListTable()), UiMethod.buildCompsRight((Component[])new Component[]{this.importPackageBtn, this.cancelBtn})});
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)view, (int)12), "Center");
    }

    public JButton getImportPackageBtn() {
        return this.importPackageBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }
}

