/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.ui.dialogs;

import com.huawei.ism.tool.inspect.ui.dialogs.ManulyCheckLayout;
import com.huawei.ism.tool.inspect.ui.logic.BureauDocuService;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import org.apache.commons.lang3.StringUtils;

public class ManulyCheckDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ManulyCheckLayout layout = null;
    private DevNode dev;

    public ManulyCheckDialog(DevNode dev) {
        super((Dialog)InspectContext.getInstance().getMainDialog(), true);
        this.dev = dev;
        this.initUI();
        this.initListener();
    }

    private void initUI() {
        this.layout = new ManulyCheckLayout(this.dev);
        this.setLayout(new BorderLayout());
        this.add((Component)this.layout, "Center");
        this.setTitle(ResourceUtil.getString((String)"inspect.wizard.manual.check.dialog.title"));
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void initListener() {
        this.layout.getClose().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManulyCheckDialog.this.dispose();
            }
        });
        this.layout.getSave().addActionListener(new SaveActionListener(this.layout, this, this.dev));
    }

    private static class SaveActionListener
    implements ActionListener {
        private ManulyCheckLayout layout;
        private ManulyCheckDialog dialog;
        private DevNode dev;

        public SaveActionListener(ManulyCheckLayout layout, ManulyCheckDialog dialog, DevNode dev) {
            this.layout = layout;
            this.dialog = dialog;
            this.dev = dev;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultTableModel tblModel = this.layout.getModel();
            int resultCol = tblModel.getColumnCount() - 1;
            ArrayList<String> checkRSList = new ArrayList<String>();
            for (TableRow row : tblModel.getRowList()) {
                Object rs = row.getValueAt(resultCol);
                if (rs instanceof IsmTableCell.ColorfulComboBoxCell) {
                    Object selectItemRs = ((IsmTableCell.ColorfulComboBoxCell)rs).getSelectedItem();
                    if (selectItemRs == null || selectItemRs.toString().equals(ResourceUtil.getString((String)"inspector.result.select")) || StringUtils.isEmpty((CharSequence)selectItemRs.toString())) {
                        DialogUtils.showErrorDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"inspect.wizard.manualcheck.dialog.msg.uncheck"));
                        return;
                    }
                    String checkRs = String.valueOf(selectItemRs);
                    checkRSList.add(checkRs);
                    continue;
                }
                checkRSList.add(null);
            }
            HashMap<String, ArrayList<String>> checkRSMap = BureauDocuService.INS.getCheckRSMap();
            checkRSMap.put(this.dev.getDeviceSerialNumber(), checkRSList);
            this.dialog.dispose();
        }
    }
}

